/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaElement_Mapper
extends ReferenceableMapper {
    private static final Logger log = LoggerFactory.getLogger(SchemaElement_Mapper.class);

    public static SchemaElement_Mapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    private SchemaElement_Mapper() {
        super("", "", "SchemaElement");
    }

    protected SchemaElement_Mapper(String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName, String prefix) {
        super(igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName, prefix);
        this.addSimplePropertyMapping("name", "displayName");
        this.addSimplePropertyMapping("short_description", "description");
        this.addComplexOmrsProperty("anchorGUID");
    }

    @Override
    protected InstanceProperties complexPropertyMappings(EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        instanceProperties = super.complexPropertyMappings(entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        Reference igcEntity = entityMap.getIgcEntity();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        IGCRepositoryHelper igcRepositoryHelper = ((IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection()).getIgcRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        Identity identity = igcEntity.getIdentity(igcRestClient);
        Identity parent = identity.getParentIdentity();
        if (parent != null) {
            IGCEntityGuid parentGuid = igcRepositoryHelper.getEntityGuid(parent.getAssetType(), null, parent.getRid());
            instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "anchorGUID", parentGuid.asGuid(), "complexPropertyMappings");
        }
        return instanceProperties;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, InstancePropertyValue value) throws FunctionNotSupportedException {
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, value);
        String methodName = "addComplexPropertySearchCriteria";
        if (!omrsPropertyName.equals("anchorGUID")) return;
        if (!value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE)) return;
        String guidString = value.valueAsString();
        String searchableGuid = repositoryHelper.getUnqualifiedLiteralString(guidString);
        String parentPropertyName = this.getParentPropertyName();
        if (parentPropertyName == null) {
            log.warn("Unable to add criteria for anchorGUID, type not known: {}", (Object)this.getIgcAssetType());
            return;
        }
        IGCEntityGuid guid = IGCEntityGuid.fromGuid(searchableGuid);
        if (guid == null) return;
        if (repositoryHelper.isExactMatchRegex(guidString)) {
            IGCSearchCondition exact = new IGCSearchCondition(parentPropertyName, "=", guid.getRid());
            igcSearchConditionSet.addCondition(exact);
            return;
        }
        IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.REGEX_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(repositoryName, guidString);
        throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addComplexPropertySearchCriteria", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    @Override
    public void addComplexStringSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String searchCriteria) throws FunctionNotSupportedException {
        String searchableAnchor = repositoryHelper.getUnqualifiedLiteralString(searchCriteria);
        if (repositoryHelper.isExactMatchRegex(searchCriteria)) {
            IGCEntityGuid guid = IGCEntityGuid.fromGuid(searchableAnchor);
            String parentPropertyName = this.getParentPropertyName();
            if (guid != null && parentPropertyName != null) {
                IGCSearchCondition byGuid = new IGCSearchCondition(parentPropertyName, "=", guid.getRid());
                igcSearchConditionSet.addCondition(byGuid);
            }
        }
    }

    protected String getParentPropertyName() {
        String parentPropertyName = null;
        switch (this.getIgcAssetType()) {
            case "database_column": {
                parentPropertyName = "database_table_or_view";
                break;
            }
            case "database_schema": {
                parentPropertyName = "database";
                break;
            }
            case "database_table": {
                parentPropertyName = "database_schema";
                break;
            }
            case "data_file_field": {
                parentPropertyName = "data_file_record";
                break;
            }
            case "data_file_record": {
                parentPropertyName = "data_file";
            }
        }
        return parentPropertyName;
    }

    private static class Singleton {
        private static final SchemaElement_Mapper INSTANCE = new SchemaElement_Mapper();

        private Singleton() {
        }
    }
}

