/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.DataClassAssignmentStatusMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClassAssignmentMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(DataClassAssignmentMapper.class);
    private static final String R_DATA_CLASS_ASSIGNMENT = "DataClassAssignment";
    private static final String P_THRESHOLD = "threshold";

    public static DataClassAssignmentMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    private DataClassAssignmentMapper() {
        super("main_object", "data_class", "detected_classifications", "classified_assets_detected", R_DATA_CLASS_ASSIGNMENT, "elementsAssignedToDataClass", "dataClassesAssignedToElement");
        this.setOptimalStart(RelationshipMapping.OptimalStart.CUSTOM);
        this.addAlternativePropertyFromOne("selected_classification");
        this.addAlternativePropertyFromTwo("classifications_selected");
        this.setRelationshipLevelIgcAsset("classification");
        this.addMappedOmrsProperty("confidence");
        this.addMappedOmrsProperty(P_THRESHOLD);
        this.addMappedOmrsProperty("partialMatch");
        this.addMappedOmrsProperty("valueFrequency");
        this.addMappedOmrsProperty("status");
        this.addLiteralPropertyMapping("method", null);
        this.addLiteralPropertyMapping("steward", null);
        this.addLiteralPropertyMapping("source", null);
    }

    @Override
    public List<Reference> getProxyOneAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient) {
        String otherAssetType = relationshipAsset.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (otherAssetType.equals("classification")) {
            Reference classifiedObj;
            Object co = igcRestClient.getPropertyByName(relationshipAsset, "classifies_asset");
            if (co == null || co.equals("") || co.equals("null")) {
                Reference classification = igcRestClient.getAssetById(relationshipAsset.getId());
                classifiedObj = (Reference)igcRestClient.getPropertyByName(classification, "classifies_asset");
            } else {
                classifiedObj = (Reference)co;
            }
            asList.add(classifiedObj);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Not a classification asset, just returning as-is: {} of type {}", (Object)relationshipAsset.getName(), (Object)relationshipAsset.getType());
            }
            asList.add(relationshipAsset);
        }
        return asList;
    }

    @Override
    public List<Reference> getProxyTwoAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient) {
        String otherAssetType = relationshipAsset.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (otherAssetType.equals("classification")) {
            Reference dataClass;
            Object dc = igcRestClient.getPropertyByName(relationshipAsset, "data_class");
            if (dc == null || dc.equals("") || dc.equals("null")) {
                Reference classification = igcRestClient.getAssetById(relationshipAsset.getId());
                dataClass = (Reference)igcRestClient.getPropertyByName(classification, "data_class");
            } else {
                dataClass = (Reference)dc;
            }
            asList.add(dataClass);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Not a classification asset, just returning as-is: {} of type {}", (Object)relationshipAsset.getName(), (Object)relationshipAsset.getType());
            }
            asList.add(relationshipAsset);
        }
        return asList;
    }

    @Override
    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, Reference toIgcObject, String userId) {
        String assetType = IGCRestConstants.getAssetTypeForSearch((String)fromIgcObject.getType());
        if (assetType.equals("data_class")) {
            this.mapDetectedClassifications_fromDataClass(igcomrsRepositoryConnector, relationships, fromIgcObject, userId);
            this.mapSelectedClassifications_fromDataClass(igcomrsRepositoryConnector, relationships, fromIgcObject, userId);
        } else {
            this.mapDetectedClassifications_toDataClass(igcomrsRepositoryConnector, relationships, fromIgcObject, userId);
            this.mapSelectedClassifications_toDataClass(igcomrsRepositoryConnector, relationships, fromIgcObject, userId);
        }
    }

    @Override
    public IGCSearch getComplexIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, InstanceProperties matchProperties, MatchCriteria matchCriteria) throws FunctionNotSupportedException {
        EnumPropertyValue statusEnum;
        if (matchProperties == null) {
            return this.getSimpleIGCSearchCriteria();
        }
        IGCSearch igcSearch = new IGCSearch();
        IGCSearchConditionSet conditions = new IGCSearchConditionSet();
        Map mapOfValues = matchProperties.getInstanceProperties();
        if (mapOfValues == null) {
            return this.getSimpleIGCSearchCriteria();
        }
        InstancePropertyValue status = mapOfValues.getOrDefault("status", null);
        String statusName = null;
        if (status != null && status.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.ENUM) && (statusName = (statusEnum = (EnumPropertyValue)status).getSymbolicName()) != null) {
            if (statusName.equals("Discovered")) {
                IGCSearchCondition discovered = new IGCSearchCondition("classified_assets_detected", "isNull", Boolean.valueOf(true));
                conditions.addCondition(discovered);
            } else if (statusName.equals("Proposed")) {
                IGCSearchCondition proposed = new IGCSearchCondition("classifications_selected", "isNull", Boolean.valueOf(true));
                conditions.addCondition(proposed);
            } else {
                conditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
            }
        }
        Set searchProperties = mapOfValues.keySet();
        Set<String> mappedOmrsProperties = this.getMappedOmrsPropertyNames();
        if (!mappedOmrsProperties.containsAll(searchProperties)) {
            conditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
        } else if (statusName == null || statusName.equals("Discovered")) {
            String rootOfProperties = "classified_assets_detected.";
            for (Map.Entry entry : mapOfValues.entrySet()) {
                String omrsPropertyName = (String)entry.getKey();
                InstancePropertyValue value = (InstancePropertyValue)entry.getValue();
                switch (omrsPropertyName) {
                    case "confidence": {
                        IGCSearchCondition byConfidence = new IGCSearchCondition(rootOfProperties + "confidencePercent", "=", value.valueAsString());
                        conditions.addCondition(byConfidence);
                        break;
                    }
                    case "threshold": {
                        IGCSearchCondition byThreshold = new IGCSearchCondition(rootOfProperties + P_THRESHOLD, "=", value.valueAsString());
                        conditions.addCondition(byThreshold);
                        break;
                    }
                    case "partialMatch": {
                        IGCSearchCondition byPartialMatch = new IGCSearchCondition(rootOfProperties + "confidencePercent", "<", "100");
                        conditions.addCondition(byPartialMatch);
                        break;
                    }
                    case "valueFrequency": {
                        IGCSearchCondition byValueFrequency = new IGCSearchCondition(rootOfProperties + "value_frequency", "=", value.valueAsString());
                        conditions.addCondition(byValueFrequency);
                    }
                }
            }
        } else {
            conditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
        }
        IGCRepositoryHelper.setConditionsFromMatchCriteria(conditions, matchCriteria);
        igcSearch.addConditions(conditions);
        return igcSearch;
    }

    @Override
    public IGCSearch getComplexIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, String searchCriteria) throws FunctionNotSupportedException {
        IGCSearchCondition nonNull;
        if (searchCriteria == null || searchCriteria.equals("")) {
            return this.getSimpleIGCSearchCriteria();
        }
        IGCSearch igcSearch = new IGCSearch();
        igcSearch.addType("data_class");
        IGCSearchConditionSet conditions = new IGCSearchConditionSet();
        boolean matchesSomething = false;
        Pattern pattern = Pattern.compile(searchCriteria);
        Matcher discovered = pattern.matcher("Discovered");
        Matcher proposed = pattern.matcher("Proposed");
        if (discovered.matches()) {
            matchesSomething = true;
            nonNull = new IGCSearchCondition("classified_assets_detected", "isNull", Boolean.valueOf(true));
            conditions.addCondition(nonNull);
            igcSearch.addProperty("classified_assets_detected");
        }
        if (proposed.matches()) {
            matchesSomething = true;
            nonNull = new IGCSearchCondition("classifications_selected", "isNull", Boolean.valueOf(true));
            conditions.addCondition(nonNull);
            igcSearch.addProperty("classifications_selected");
        }
        if (!matchesSomething) {
            conditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
        }
        igcSearch.addConditions(conditions);
        return igcSearch;
    }

    private void mapDetectedClassifications_fromDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        String methodName = "mapDetectedClassifications_fromDataClass";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("data_class", "=", fromIgcObject.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        String[] classificationProperties = new String[]{"classifies_asset", "confidencePercent", P_THRESHOLD};
        IGCSearch igcSearch = new IGCSearch("classification", classificationProperties, igcSearchConditionSet);
        IGCVersionEnum igcVersion = igcomrsRepositoryConnector.getIGCVersion();
        if (igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
            igcSearch.addProperty("value_frequency");
        }
        ItemList detectedClassifications = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        detectedClassifications.getAllPages(igcomrsRepositoryConnector.getIGCRestClient());
        for (Reference detectedClassification : detectedClassifications.getItems()) {
            Reference classifiedObj = (Reference)igcRestClient.getPropertyByName(detectedClassification, "classifies_asset");
            if (classifiedObj == null || classifiedObj.getType().equals("main_object")) continue;
            try {
                Object valFreq;
                Object threshold;
                Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), classifiedObj, fromIgcObject, "detected_classifications", userId, detectedClassification.getId());
                Object confidence = igcRestClient.getPropertyByName(detectedClassification, "confidencePercent");
                InstanceProperties relationshipProperties = relationship.getProperties();
                if (relationshipProperties == null) {
                    relationshipProperties = new InstanceProperties();
                }
                if (confidence != null) {
                    int confidenceVal = ((Number)confidence).intValue();
                    relationshipProperties = repositoryHelper.addIntPropertyToInstance(repositoryName, relationshipProperties, "confidence", confidenceVal, "mapDetectedClassifications_fromDataClass");
                    relationshipProperties = repositoryHelper.addBooleanPropertyToInstance(repositoryName, relationshipProperties, "partialMatch", confidenceVal < 100, "mapDetectedClassifications_fromDataClass");
                }
                if ((threshold = igcRestClient.getPropertyByName(detectedClassification, P_THRESHOLD)) != null) {
                    relationshipProperties = repositoryHelper.addFloatPropertyToInstance(repositoryName, relationshipProperties, P_THRESHOLD, ((Float)threshold).floatValue(), "mapDetectedClassifications_fromDataClass");
                }
                if ((igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) && (valFreq = igcRestClient.getPropertyByName(detectedClassification, "value_frequency")) != null) {
                    relationshipProperties = repositoryHelper.addLongPropertyToInstance(repositoryName, relationshipProperties, "valueFrequency", ((Double)valFreq).longValue(), "mapDetectedClassifications_fromDataClass");
                }
                EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()).getEnumMappingByIgcValue("discovered");
                relationshipProperties.setProperty("status", (InstancePropertyValue)status);
                relationship.setProperties(relationshipProperties);
                if (log.isDebugEnabled()) {
                    log.debug("mapDetectedClassifications_fromDataClass - adding relationship: {}", (Object)relationship.getGUID());
                }
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private void mapSelectedClassifications_fromDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("selected_classification", "=", fromIgcObject.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        IGCSearch igcSearch = new IGCSearch("amazon_s3_data_file_field", igcSearchConditionSet);
        igcSearch.addType("data_file_field");
        igcSearch.addType("database_column");
        igcSearch.addProperty("selected_classification");
        igcSearch.addProperties(IGCRestConstants.getModificationProperties());
        ItemList assetsWithSelected = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        assetsWithSelected.getAllPages(igcomrsRepositoryConnector.getIGCRestClient());
        for (Reference assetWithSelected : assetsWithSelected.getItems()) {
            try {
                Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), assetWithSelected, fromIgcObject, "selected_classification", userId);
                InstanceProperties relationshipProperties = relationship.getProperties();
                if (relationshipProperties == null) {
                    relationshipProperties = new InstanceProperties();
                }
                EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()).getEnumMappingByIgcValue("selected");
                relationshipProperties.setProperty("status", (InstancePropertyValue)status);
                relationship.setProperties(relationshipProperties);
                if (log.isDebugEnabled()) {
                    log.debug("mapSelectedClassifications_fromDataClass - adding relationship: {}", (Object)relationship.getGUID());
                }
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private void mapDetectedClassifications_toDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        String methodName = "mapDetectedClassifications_toDataClass";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("classifies_asset", "=", fromIgcObject.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        String[] classificationProperties = new String[]{"data_class", "confidencePercent", P_THRESHOLD};
        IGCSearch igcSearch = new IGCSearch("classification", classificationProperties, igcSearchConditionSet);
        IGCVersionEnum igcVersion = igcomrsRepositoryConnector.getIGCVersion();
        if (igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
            igcSearch.addProperty("value_frequency");
        }
        ItemList detectedClassifications = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        detectedClassifications.getAllPages(igcomrsRepositoryConnector.getIGCRestClient());
        for (Reference detectedClassification : detectedClassifications.getItems()) {
            Reference dataClassObj = (Reference)igcRestClient.getPropertyByName(detectedClassification, "data_class");
            if (dataClassObj == null || dataClassObj.getType().equals("main_object")) continue;
            try {
                Object valFreq;
                Object threshold;
                Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), fromIgcObject, dataClassObj, "detected_classifications", userId, detectedClassification.getId());
                Object confidence = igcRestClient.getPropertyByName(detectedClassification, "confidencePercent");
                InstanceProperties relationshipProperties = relationship.getProperties();
                if (relationshipProperties == null) {
                    relationshipProperties = new InstanceProperties();
                }
                if (confidence != null) {
                    int confidenceVal = ((Number)confidence).intValue();
                    relationshipProperties = repositoryHelper.addIntPropertyToInstance(repositoryName, relationshipProperties, "confidence", confidenceVal, "mapDetectedClassifications_toDataClass");
                    relationshipProperties = repositoryHelper.addBooleanPropertyToInstance(repositoryName, relationshipProperties, "partialMatch", confidenceVal < 100, "mapDetectedClassifications_toDataClass");
                }
                if ((threshold = igcRestClient.getPropertyByName(detectedClassification, P_THRESHOLD)) != null) {
                    relationshipProperties = repositoryHelper.addFloatPropertyToInstance(repositoryName, relationshipProperties, P_THRESHOLD, ((Float)threshold).floatValue(), "mapDetectedClassifications_toDataClass");
                }
                if ((igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) && (valFreq = igcRestClient.getPropertyByName(detectedClassification, "value_frequency")) != null) {
                    relationshipProperties = repositoryHelper.addLongPropertyToInstance(repositoryName, relationshipProperties, "valueFrequency", ((Double)valFreq).longValue(), "mapDetectedClassifications_toDataClass");
                }
                EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()).getEnumMappingByIgcValue("discovered");
                relationshipProperties.setProperty("status", (InstancePropertyValue)status);
                relationship.setProperties(relationshipProperties);
                if (log.isDebugEnabled()) {
                    log.debug("mapDetectedClassifications_toDataClass - adding relationship: {}", (Object)relationship.getGUID());
                }
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private void mapSelectedClassifications_toDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        Reference withSelectedClassification;
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        Reference selectedClassification = (Reference)igcRestClient.getPropertyByName(withSelectedClassification = igcRestClient.getAssetWithSubsetOfProperties(fromIgcObject.getId(), fromIgcObject.getType(), new String[]{"selected_classification"}), "selected_classification");
        if (selectedClassification != null && selectedClassification.getType() != null) {
            try {
                Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), fromIgcObject, (Reference)igcRestClient.getPropertyByName(withSelectedClassification, "selected_classification"), "selected_classification", userId);
                InstanceProperties relationshipProperties = relationship.getProperties();
                if (relationshipProperties == null) {
                    relationshipProperties = new InstanceProperties();
                }
                EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()).getEnumMappingByIgcValue("selected");
                relationshipProperties.setProperty("status", (InstancePropertyValue)status);
                relationship.setProperties(relationshipProperties);
                if (log.isDebugEnabled()) {
                    log.debug("mapSelectedClassifications_toDataClass - adding relationship: {}", (Object)relationship.getGUID());
                }
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("No selected_classification set for asset -- skipping.");
        }
    }

    private static class Singleton {
        private static final DataClassAssignmentMapper INSTANCE = new DataClassAssignmentMapper();

        private Singleton() {
        }
    }
}

