/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.TermAssignmentStatusMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticAssignmentMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(SemanticAssignmentMapper.class);

    public static SemanticAssignmentMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    private SemanticAssignmentMapper() {
        super("main_object", "term", "assigned_to_terms", "assigned_assets", "SemanticAssignment", "assignedElements", "meaning");
        RelationshipMapping.ProxyMapping pmOne = this.getProxyOneMapping();
        pmOne.addExcludedIgcAssetType("term");
        pmOne.addExcludedIgcAssetType("connector");
        pmOne.addExcludedIgcAssetType("data_connection");
        pmOne.addExcludedIgcAssetType("group");
        pmOne.addExcludedIgcAssetType("information_governance_policy");
        pmOne.addExcludedIgcAssetType("label");
        pmOne.addExcludedIgcAssetType("user");
        this.addLiteralPropertyMapping("description", null);
        this.addLiteralPropertyMapping("expression", null);
        this.addLiteralPropertyMapping("status", TermAssignmentStatusMapper.getInstance(null).getDefaultEnumValue());
        this.addLiteralPropertyMapping("confidence", 100);
        this.addLiteralPropertyMapping("steward", null);
        this.addLiteralPropertyMapping("source", null);
    }

    @Override
    public boolean includeRelationshipForIgcObjects(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference oneObject, Reference otherObject) {
        IGCRestClient igcRestClient;
        boolean isClassification;
        if (log.isDebugEnabled()) {
            log.debug("Considering inclusion of objects: {} ({}) and {} ({})", new Object[]{oneObject.getName(), oneObject.getType(), otherObject.getName(), otherObject.getType()});
        }
        boolean bl = isClassification = ClassificationMapping.isClassification(igcRestClient = igcomrsRepositoryConnector.getIGCRestClient(), oneObject) || ClassificationMapping.isClassification(igcRestClient, otherObject);
        if (isClassification && log.isDebugEnabled()) {
            log.debug(" ... skipping, reserved Classification object.");
        }
        return !isClassification;
    }

    private static class Singleton {
        private static final SemanticAssignmentMapper INSTANCE = new SemanticAssignmentMapper();

        private Singleton() {
        }
    }
}

