/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.TermRelationshipStatusMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.GlossaryMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermCategorizationMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(TermCategorizationMapper.class);

    public static TermCategorizationMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    private TermCategorizationMapper() {
        super("category", "term", "terms", "parent_category", "TermCategorization", "categories", "terms");
        this.addAlternativePropertyFromTwo("referencing_categories");
        this.addLiteralPropertyMapping("description", null);
        this.addLiteralPropertyMapping("status", TermRelationshipStatusMapper.getInstance(null).getEnumMappingByIgcValue("Active"));
    }

    @Override
    public boolean includeRelationshipForIgcObjects(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference oneObject, Reference otherObject) {
        boolean isClassification;
        IGCRestClient igcRestClient;
        boolean isGlossary;
        if (log.isDebugEnabled()) {
            log.debug("Considering inclusion of objects: {} ({}) and {} ({})", new Object[]{oneObject.getName(), oneObject.getType(), otherObject.getName(), otherObject.getType()});
        }
        boolean bl = isGlossary = GlossaryMapper.isGlossary(igcRestClient = igcomrsRepositoryConnector.getIGCRestClient(), oneObject) || GlossaryMapper.isGlossary(igcRestClient, otherObject);
        if (isGlossary && log.isDebugEnabled()) {
            log.debug(" ... skipping, Glossary-level category.");
        }
        boolean bl2 = isClassification = ClassificationMapping.isClassification(igcRestClient, oneObject) || ClassificationMapping.isClassification(igcRestClient, otherObject);
        if (isClassification && log.isDebugEnabled()) {
            log.debug(" ... skipping, classification object.");
        }
        return !isGlossary && !isClassification;
    }

    private static class Singleton {
        private static final TermCategorizationMapper INSTANCE = new TermCategorizationMapper();

        private Singleton() {
        }
    }
}

