/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model;

import java.util.Objects;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCGuidHeader;

public class IGCEntityGuid
extends IGCGuidHeader {
    private static final String GENERATED_TYPE_POSTFIX = "!";
    private static final String IGC_TYPE_POSTFIX = "@";
    private String assetType;
    private String generatedPrefix;
    private String rid;

    public IGCEntityGuid(String metadataCollectionId, String assetType, String rid) {
        this(metadataCollectionId, assetType, null, rid);
    }

    public IGCEntityGuid(String metadataCollectionId, String assetType, String prefix, String rid) {
        super(metadataCollectionId);
        this.assetType = IGCRestConstants.getAssetTypeForSearch((String)assetType);
        this.generatedPrefix = prefix;
        this.rid = rid;
    }

    public String asGuid() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.assetType);
        sb.append(IGC_TYPE_POSTFIX);
        sb.append(super.toString());
        if (this.generatedPrefix != null) {
            sb.append(this.generatedPrefix);
            sb.append(GENERATED_TYPE_POSTFIX);
        }
        sb.append(this.rid);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IGCEntityGuid)) {
            return false;
        }
        IGCEntityGuid that = (IGCEntityGuid)obj;
        return Objects.equals(this.getMetadataCollectionId(), that.getMetadataCollectionId()) && Objects.equals(this.getAssetType(), that.getAssetType()) && Objects.equals(this.getGeneratedPrefix(), that.getGeneratedPrefix()) && Objects.equals(this.getRid(), that.getRid());
    }

    public int hashCode() {
        return Objects.hash(this.getMetadataCollectionId(), this.getAssetType(), this.getGeneratedPrefix(), this.getRid());
    }

    public static IGCEntityGuid fromGuid(String guid) {
        if (guid == null) {
            return null;
        }
        int indexOfTypePostfix = guid.indexOf(IGC_TYPE_POSTFIX);
        int indexOfMetadataColPostfix = guid.indexOf(":");
        if (indexOfTypePostfix > 0 && indexOfMetadataColPostfix > indexOfTypePostfix) {
            String rid;
            String assetType = IGCRestConstants.getAssetTypeForSearch((String)guid.substring(0, indexOfTypePostfix));
            String metadataCollectionId = guid.substring(indexOfTypePostfix + 1, indexOfMetadataColPostfix);
            String generatedPrefix = null;
            int indexOfGeneratedPostfix = guid.indexOf(GENERATED_TYPE_POSTFIX);
            if (indexOfGeneratedPostfix > indexOfMetadataColPostfix) {
                generatedPrefix = guid.substring(indexOfMetadataColPostfix + 1, indexOfGeneratedPostfix);
                rid = guid.substring(indexOfGeneratedPostfix + 1);
            } else {
                rid = guid.substring(indexOfMetadataColPostfix + 1);
            }
            return new IGCEntityGuid(metadataCollectionId, assetType, generatedPrefix, rid);
        }
        return null;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public String getGeneratedPrefix() {
        return this.generatedPrefix;
    }

    public boolean isGeneratedEntityGuid() {
        return this.generatedPrefix != null;
    }

    public String getRid() {
        return this.rid;
    }
}

