/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.AttributeMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeMappingStore {
    private static final Logger log = LoggerFactory.getLogger(AttributeMappingStore.class);
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private Map<String, AttributeMapping> omrsGuidToMapping = new HashMap<String, AttributeMapping>();
    private Map<String, AttributeTypeDef> omrsGuidToAttributeTypeDef = new HashMap<String, AttributeTypeDef>();
    private Map<String, String> omrsNameToGuid = new HashMap<String, String>();
    private Map<String, List<String>> omrsTypeDefCategoryToGuids = new HashMap<String, List<String>>();

    public AttributeMappingStore(IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        this.igcomrsRepositoryConnector = igcomrsRepositoryConnector;
    }

    public boolean addMapping(AttributeTypeDef omrsTypeDef, Class mappingClass) {
        AttributeMapping mapping = this.getAttributeMapper(mappingClass);
        if (mapping != null) {
            String guid = omrsTypeDef.getGUID();
            this.omrsGuidToAttributeTypeDef.put(guid, omrsTypeDef);
            this.omrsGuidToMapping.put(guid, mapping);
            this.omrsNameToGuid.put(omrsTypeDef.getName(), guid);
            this.addGuidToCategory(omrsTypeDef.getCategory().getName(), guid);
        }
        return mapping != null;
    }

    private void addGuidToCategory(String categoryName, String guid) {
        if (!this.omrsTypeDefCategoryToGuids.containsKey(categoryName)) {
            this.omrsTypeDefCategoryToGuids.put(categoryName, new ArrayList());
        }
        this.omrsTypeDefCategoryToGuids.get(categoryName).add(guid);
    }

    public void addAttributeTypeDef(AttributeTypeDef attributeTypeDef) {
        String guid = attributeTypeDef.getGUID();
        this.omrsGuidToAttributeTypeDef.put(guid, attributeTypeDef);
        this.omrsNameToGuid.put(attributeTypeDef.getName(), guid);
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String guid) {
        if (this.omrsGuidToAttributeTypeDef.containsKey(guid)) {
            return this.omrsGuidToAttributeTypeDef.get(guid);
        }
        if (log.isWarnEnabled()) {
            log.warn("Unable to find OMRS AttributeTypeDef: {}", (Object)guid);
        }
        return null;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String name) {
        if (this.omrsNameToGuid.containsKey(name)) {
            String guid = this.omrsNameToGuid.get(name);
            return this.getAttributeTypeDefByGUID(guid);
        }
        if (log.isWarnEnabled()) {
            log.warn("Unable to find OMRS AttributeTypeDef: {}", (Object)name);
        }
        return null;
    }

    public List<AttributeTypeDef> getAttributeTypeDefsByCategory(AttributeTypeDefCategory category) {
        String categoryName = category.getName();
        ArrayList<AttributeTypeDef> results = new ArrayList<AttributeTypeDef>();
        if (this.omrsTypeDefCategoryToGuids.containsKey(categoryName)) {
            for (String guid : this.omrsTypeDefCategoryToGuids.get(categoryName)) {
                results.add(this.getAttributeTypeDefByGUID(guid));
            }
        } else if (log.isWarnEnabled()) {
            log.warn("Unable to find OMRS AttributeTypeDefCategory: {}", (Object)categoryName);
        }
        return results;
    }

    public List<AttributeTypeDef> getAllAttributeTypeDefs() {
        return new ArrayList<AttributeTypeDef>(this.omrsGuidToAttributeTypeDef.values());
    }

    private AttributeMapping getAttributeMapper(Class mappingClass) {
        AttributeMapping attributeMapper;
        block2: {
            attributeMapper = null;
            try {
                Method getInstance = mappingClass.getMethod("getInstance", IGCVersionEnum.class);
                attributeMapper = (AttributeMapping)getInstance.invoke(null, this.igcomrsRepositoryConnector.getIGCVersion());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error("Unable to find or instantiate AttributeMapping class: {}", (Object)mappingClass, (Object)e);
            }
        }
        return attributeMapper;
    }
}

