/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationMappingStore {
    private static final Logger log = LoggerFactory.getLogger(ClassificationMappingStore.class);
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private List<TypeDef> typeDefs = new ArrayList<TypeDef>();
    private Map<String, ClassificationMapping> omrsGuidToMapping = new HashMap<String, ClassificationMapping>();
    private Map<String, String> omrsNameToGuid = new HashMap<String, String>();

    public ClassificationMappingStore(IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        this.igcomrsRepositoryConnector = igcomrsRepositoryConnector;
    }

    public boolean addMapping(TypeDef omrsTypeDef, Class mappingClass) {
        ClassificationMapping mapping = this.getClassificationMapper(mappingClass);
        if (mapping != null) {
            this.typeDefs.add(omrsTypeDef);
            String guid = omrsTypeDef.getGUID();
            String name = omrsTypeDef.getName();
            this.omrsGuidToMapping.put(guid, mapping);
            this.omrsNameToGuid.put(name, guid);
        }
        return mapping != null;
    }

    public List<TypeDef> getTypeDefs() {
        return this.typeDefs;
    }

    public ClassificationMapping getMappingByOmrsTypeGUID(String guid) {
        if (this.omrsGuidToMapping.containsKey(guid)) {
            return this.omrsGuidToMapping.get(guid);
        }
        if (log.isWarnEnabled()) {
            log.warn("Unable to find mapping for OMRS type: {}", (Object)guid);
        }
        return null;
    }

    public ClassificationMapping getMappingByOmrsTypeName(String name) {
        if (this.omrsNameToGuid.containsKey(name)) {
            return this.getMappingByOmrsTypeGUID(this.omrsNameToGuid.get(name));
        }
        if (log.isWarnEnabled()) {
            log.warn("Unable to find mapping for OMRS type: {}", (Object)name);
        }
        return null;
    }

    public ClassificationMapping getMappingByTypes(String omrsClassificationType, String igcAssetType) {
        ClassificationMapping found = null;
        ClassificationMapping candidate = this.getMappingByOmrsTypeName(omrsClassificationType);
        String candidateIgcType = candidate.getIgcAssetType();
        Set<String> excludedIgcTypes = candidate.getExcludedIgcAssetTypes();
        if (!excludedIgcTypes.contains(igcAssetType)) {
            if (candidateIgcType.equals(igcAssetType) || candidateIgcType.equals("main_object")) {
                found = candidate;
            } else if (candidate.hasSubTypes()) {
                for (ClassificationMapping subMapping : candidate.getSubTypes()) {
                    candidateIgcType = candidate.getIgcAssetType();
                    if (!candidateIgcType.equals(igcAssetType) && !candidateIgcType.equals("main_object")) continue;
                    found = subMapping;
                    break;
                }
            }
        }
        return found;
    }

    private ClassificationMapping getClassificationMapper(Class mappingClass) {
        ClassificationMapping classificationMapper;
        block2: {
            classificationMapper = null;
            try {
                Method getInstance = mappingClass.getMethod("getInstance", IGCVersionEnum.class);
                classificationMapper = (ClassificationMapping)getInstance.invoke(null, this.igcomrsRepositoryConnector.getIGCVersion());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error("Unable to find or instantiate ClassificationMapping class: {}", (Object)mappingClass, (Object)e);
            }
        }
        return classificationMapper;
    }
}

