/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.eventmapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSAuditCode;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.events.InfosphereEvents;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.events.InfosphereEventsAssetEvent;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.events.InfosphereEventsDCEvent;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.events.InfosphereEventsIAEvent;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.events.InfosphereEventsIMAMEvent;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.eventmapper.model.ChangeSet;
import org.odpi.egeria.connectors.ibm.igc.eventmapper.model.PurgeMarker;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCRelationshipGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.OMRSStub;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventMapperBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGCOMRSRepositoryEventMapper
extends OMRSRepositoryEventMapperBase
implements OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(IGCOMRSRepositoryEventMapper.class);
    private static final Duration pollDuration = Duration.ofMillis(100L);
    private String sourceName = "IGCOMRSRepositoryEventMapper";
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private IGCOMRSMetadataCollection igcomrsMetadataCollection;
    private IGCRepositoryHelper igcRepositoryHelper;
    private IGCRestClient igcRestClient;
    private String metadataCollectionId;
    private String originatorServerName;
    private String originatorServerType;
    private IGCVersionEnum igcVersion;
    private Properties igcKafkaProperties;
    private String igcKafkaTopic;
    private IGCKafkaConsumerThread igcKafkaConsumer;
    private ObjectMapper mapper;

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        IGCOMRSAuditCode auditCode = IGCOMRSAuditCode.EVENT_MAPPER_STARTING;
        this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        if (!(this.repositoryConnector instanceof IGCOMRSRepositoryConnector)) {
            this.raiseConnectorCheckedException(IGCOMRSErrorCode.EVENT_MAPPER_IMPROPERLY_INITIALIZED, "start", null, this.repositoryConnector.getServerName());
        }
        this.igcomrsRepositoryConnector = (IGCOMRSRepositoryConnector)this.repositoryConnector;
        this.igcVersion = this.igcomrsRepositoryConnector.getIGCVersion();
        this.igcRestClient = this.igcomrsRepositoryConnector.getIGCRestClient();
        this.igcKafkaTopic = "InfosphereEvents";
        String igcKafkaBootstrap = this.connectionBean.getEndpoint().getAddress();
        this.igcKafkaProperties = new Properties();
        this.igcKafkaProperties.put("bootstrap.servers", igcKafkaBootstrap);
        this.igcKafkaProperties.put("group.id", "IGCOMRSRepositoryEventMapper_consumer");
        this.igcKafkaProperties.put("key.deserializer", StringDeserializer.class.getName());
        this.igcKafkaProperties.put("value.deserializer", StringDeserializer.class.getName());
        this.mapper = new ObjectMapper();
        this.igcKafkaConsumer = new IGCKafkaConsumerThread();
        try {
            this.igcomrsMetadataCollection = (IGCOMRSMetadataCollection)this.igcomrsRepositoryConnector.getMetadataCollection();
            this.igcRepositoryHelper = this.igcomrsMetadataCollection.getIgcRepositoryHelper();
            this.igcomrsMetadataCollection.setEventMapper(this);
        }
        catch (RepositoryErrorException e) {
            this.raiseConnectorCheckedException(IGCOMRSErrorCode.REST_CLIENT_FAILURE, "start", (Exception)((Object)e), this.igcomrsRepositoryConnector.getServerName());
        }
        this.metadataCollectionId = this.igcomrsRepositoryConnector.getMetadataCollectionId();
        this.originatorServerName = this.igcomrsRepositoryConnector.getServerName();
        this.originatorServerType = this.igcomrsRepositoryConnector.getServerType();
        this.igcKafkaConsumer.start();
    }

    public void processEvent(String event) {
        log.debug("Processing event: {}", (Object)event);
        if (this.igcVersion.isEqualTo(IGCVersionEnum.V11702) || this.igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
            this.processEventV117(event);
        } else {
            this.processEventV115(event);
        }
    }

    private void processEventV115(String event) {
        try {
            InfosphereEvents eventObj = (InfosphereEvents)this.mapper.readValue(event, InfosphereEvents.class);
            switch (eventObj.getEventType()) {
                case "IMAM_SHARE_EVENT": {
                    this.processIMAMShareEventV115((InfosphereEventsIMAMEvent)eventObj);
                    break;
                }
                case "DC_CREATE_EVENT": 
                case "DC_MERGED_EVENT": {
                    this.processDataConnectionEventV115((InfosphereEventsDCEvent)eventObj);
                    break;
                }
                case "IA_COLUMN_CLASSIFIED_EVENT": 
                case "IA_COLUMN_ANALYZED_EVENT": 
                case "IA_TABLE_RESULTS_PUBLISHED": 
                case "IA_COLUMN_FAILED_EVENT": {
                    this.processIAEventV115((InfosphereEventsIAEvent)eventObj);
                    break;
                }
                case "IA_PROJECT_CREATED_EVENT": 
                case "IA_TABLE_ADDED_TO_PROJECT": 
                case "IA_TABLES_ADDED_TO_PROJECT": 
                case "IA_TABLE_REMOVED_FROM_PROJECT": 
                case "IA_TABLES_REMOVED_FROM_PROJECT": 
                case "IA_DATARULE_CREATED_EVENT": 
                case "IA_DATARULE_DELETED_EVENT": 
                case "IA_DATARULESET_CREATED_EVENT": 
                case "IA_DATARULESET_DELETED_EVENT": 
                case "IA_DATARULE_DEFINITION_CREATED_EVENT": 
                case "IA_DATARULE_DEFINITION_DELETED_EVENT": 
                case "IA_DATARULESET_DEFINITION_CREATED_EVENT": 
                case "IA_DATARULESET_DEFINITION_DELETED_EVENT": 
                case "IA_COLUMN_ANALYSIS_SUBMITTED_EVENT": 
                case "IA_COLUMN_ANALYSES_SUBMITTED_EVENT": 
                case "IA_COLUMN_ANALYSIS_STARTED_EVENT": 
                case "IA_COLUMN_ANALYSIS_FINISHED_EVENT": 
                case "IA_COLUMN_ANALYSIS_FAILED_EVENT": 
                case "IA_PROFILE_BATCH_COMPLETED_EVENT": 
                case "IA_DATAQUALITY_ANALYSIS_SUBMITTED": 
                case "IA_DATAQUALITY_ANALYSIS_SUBMITTED_EVENT": 
                case "IA_DATAQUALITY_ANALYSES_SUBMITTED_EVENT": 
                case "IA_DATAQUALITY_ANALYSIS_STARTED_EVENT": 
                case "IA_DATAQUALITY_ANALYSIS_FINISHED_EVENT": 
                case "IA_DATAQUALITY_ANALYSIS_FAILED_EVENT": 
                case "DISCOVER_IMPORT_COMPLETE": {
                    log.info("Found Information Analyzer event that cannot be processed via APIs, skipping.");
                    break;
                }
                case "IGC_ETLGROUP_EVENT": {
                    log.info("Found DataStage event that should be processed via data engine proxy, skipping.");
                    break;
                }
                default: {
                    this.processAssetEventV115((InfosphereEventsAssetEvent)eventObj);
                    break;
                }
            }
        }
        catch (IOException e) {
            log.error("Unable to translate event {} into object.", (Object)event, (Object)e);
        }
    }

    private void processIMAMShareEventV115(InfosphereEventsIMAMEvent event) {
        Map<String, String> createdRIDs = this.getRIDsAndTypesFromEventString(event.getCreatedRIDs());
        Map<String, String> updatedRIDs = this.getRIDsAndTypesFromEventString(event.getMergedRIDs());
        Map<String, String> deletedRIDs = this.getRIDsAndTypesFromEventString(event.getDeletedRIDs());
        for (Map.Entry<String, String> entry : createdRIDs.entrySet()) {
            this.processAsset(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : updatedRIDs.entrySet()) {
            this.processAsset(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : deletedRIDs.entrySet()) {
            this.sendPurgedEntity(entry.getValue(), entry.getKey());
        }
    }

    private void processDataConnectionEventV115(InfosphereEventsDCEvent event) {
        String action;
        switch (action = event.getEventType()) {
            case "DC_CREATE_EVENT": {
                this.processAsset(event.getCreatedRID(), "data_connection");
                break;
            }
            case "DC_MERGED_EVENT": {
                this.processAsset(event.getMergedRID(), "data_connection");
                break;
            }
            default: {
                log.warn("Found unhandled action type '{}' for data connection on event: {}", (Object)action, (Object)event);
            }
        }
    }

    private void processAssetEventV115(InfosphereEventsAssetEvent event) {
        String action;
        String assetRid = event.getAssetRid();
        switch (action = event.getAction()) {
            case "CREATE": 
            case "MODIFY": 
            case "DELETE": {
                String igcAssetDisplayName = event.getAssetType();
                if (igcAssetDisplayName == null || igcAssetDisplayName.equals("OMRS Stub")) break;
                String igcAssetType = this.igcRepositoryHelper.getIgcAssetTypeForAssetName(igcAssetDisplayName);
                this.processAsset(assetRid, igcAssetType);
                break;
            }
            case "ASSIGNED_RELATIONSHIP": {
                log.debug("Ignoring ASSIGNED_RELATIONSHIP event -- should be handled already by an earlier CREATE or MODIFY event: {}", (Object)event);
                break;
            }
            default: {
                log.warn("Action '{}' is not yet implemented: {}", (Object)action, (Object)event);
            }
        }
    }

    private void processIAEventV115(InfosphereEventsIAEvent event) {
        String action;
        switch (action = event.getEventType()) {
            case "IA_COLUMN_ANALYZED_EVENT": 
            case "IA_COLUMN_CLASSIFIED_EVENT": {
                log.info("Column / field analyzed or classified, but not yet published -- skipping: {}", (Object)action);
                break;
            }
            case "IA_TABLE_RESULTS_PUBLISHED": {
                String containerRid = event.getDataCollectionRid();
                Reference containerAsset = this.igcRestClient.getAssetRefById(containerRid);
                String searchProperty = null;
                String searchAssetType = null;
                switch (containerAsset.getType()) {
                    case "database_table": {
                        searchProperty = "database_table_or_view";
                        searchAssetType = "database_column";
                        break;
                    }
                    case "data_file_record": {
                        searchProperty = "data_file_record";
                        searchAssetType = "data_file_field";
                        break;
                    }
                    default: {
                        log.warn("Unimplemented asset type '{}' for IA publishing: {}", (Object)containerAsset.getType(), (Object)event);
                    }
                }
                this.processAsset(containerRid, containerAsset.getType());
                IGCSearchCondition igcSearchCondition = new IGCSearchCondition(searchProperty, "=", containerAsset.getId());
                IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
                IGCSearch igcSearch = new IGCSearch(searchAssetType, new String[]{searchProperty}, igcSearchConditionSet);
                ItemList subAssets = this.igcRestClient.search(igcSearch);
                if (subAssets != null) {
                    subAssets.getAllPages(this.igcRestClient);
                    log.debug("Processing {} child assets from IA publication: {}", (Object)subAssets.getPaging().getNumTotal(), (Object)containerRid);
                    for (Reference child : subAssets.getItems()) {
                        this.processAsset(child.getId(), child.getType());
                    }
                    break;
                }
                log.warn("Unable to find any sub-assets for IA published container '{}': {}", (Object)containerRid, (Object)event);
                break;
            }
            default: {
                log.info("Action '{}' is not yet implemented for IA: {}", (Object)action, (Object)event);
            }
        }
    }

    private EntityDetail getEntityDetailForAssetWithGUID(Reference asset, IGCEntityGuid guid) {
        EntityDetail detail = null;
        try {
            detail = this.igcRepositoryHelper.getEntityDetailFromFullAsset(this.localServerUserId, guid, asset);
        }
        catch (EntityNotKnownException e) {
            log.error("Unable to find EntityDetail for GUID: {}", (Object)guid, (Object)e);
        }
        catch (RepositoryErrorException e) {
            log.error("Unexpected error in retrieving EntityDetail for GUID: {}", (Object)guid, (Object)e);
        }
        return detail;
    }

    private EntityDetail getEntityDetailForStubWithGUID(OMRSStub stub, IGCEntityGuid guid) {
        EntityDetail detail = null;
        log.debug("Retrieving EntityDetail for stub: {}", (Object)stub);
        Reference asset = this.getIgcAssetFromStubPayload(stub);
        if (asset != null) {
            if (guid == null) {
                guid = this.igcRepositoryHelper.getEntityGuid(asset.getType(), null, asset.getId());
            }
            log.debug(" ... retrieved asset from stub: {}", (Object)asset);
            try {
                detail = this.igcRepositoryHelper.getEntityDetailFromFullAsset(this.localServerUserId, guid, asset);
            }
            catch (EntityNotKnownException e) {
                log.error("Unable to find EntityDetail for stub with GUID: {}", (Object)guid, (Object)e);
            }
            catch (RepositoryErrorException e) {
                log.error("Unexpected error in retrieving EntityDetail for stub: {}", (Object)stub.getId(), (Object)e);
            }
        }
        return detail;
    }

    private Reference getIgcAssetFromStubPayload(OMRSStub stub) {
        Reference asset = null;
        if (stub != null) {
            log.debug("Retrieving IGC Reference for stub payload: {}", (Object)stub.getPayload());
            asset = this.igcomrsRepositoryConnector.getIGCRestClient().readJSONIntoPOJO(stub.getPayload());
            asset.setFullyRetrieved();
        }
        return asset;
    }

    private Map<String, String> getRIDsAndTypesFromEventString(String payload) {
        HashMap<String, String> dict = new HashMap<String, String>();
        if (payload != null && !payload.equals("")) {
            for (String asset : payload.split(",")) {
                String[] assetTokens = (asset = asset.trim()).split(":");
                if (assetTokens.length == 2) {
                    String type = assetTokens[0];
                    String rid = assetTokens[1];
                    dict.put(rid, IGCRestConstants.getImamTypeToIgcType().getOrDefault(type, null));
                    continue;
                }
                log.warn("Unexpected number of tokens ({}) from event payload: {}", (Object)assetTokens.length, (Object)payload);
            }
        }
        return dict;
    }

    private void processAsset(String rid, String assetType) {
        this.processAsset(rid, assetType, null, null);
    }

    private void processAsset(String rid, String assetType, IGCRelationshipGuid relationshipGUID, String limitToPrefix) {
        log.debug("processAsset called with rid {} and type {}", (Object)rid, (Object)assetType);
        Reference latestVersion = this.igcRepositoryHelper.getFullAssetDetails(rid, assetType);
        if (latestVersion == null) {
            if (assetType != null) {
                this.sendPurgedEntity(assetType, rid);
            } else {
                log.warn("No asset type was provided for purged RID {} -- cannot generate purgeEntity event.", (Object)rid);
            }
        } else {
            OMRSStub stub = this.igcRepositoryHelper.getOMRSStubForAsset(latestVersion);
            ChangeSet changeSet = new ChangeSet(this.igcRestClient, latestVersion, stub);
            Set<String> changedProperties = changeSet.getChangedProperties();
            if (stub == null) {
                log.debug("Creating a new entity and stub for: {}", (Object)latestVersion.getId());
                this.sendNewEntity(latestVersion);
            } else if (!changedProperties.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("Detected changes on entity {}", (Object)latestVersion.getId());
                    log.debug(" ... properties that changed: {}", changedProperties);
                    for (String propertyName : changedProperties) {
                        log.debug(" ...... details for property '{}'", (Object)propertyName);
                        log.debug(" .......... {}", changeSet.getChangesForProperty(propertyName));
                    }
                    log.debug(" ... before: {}", (Object)stub.getPayload());
                    log.debug(" ... now:    {}", (Object)this.igcRestClient.getValueAsJSON(latestVersion));
                }
                this.sendUpdatedEntity(latestVersion, stub);
            } else {
                log.info("Skipping asset - no changes detected: {}", (Object)latestVersion.getId());
            }
            Map<String, List<RelationshipMapping>> relationshipMap = this.igcRepositoryHelper.getIgcPropertiesToRelationshipMappings(latestVersion.getType(), this.localServerUserId);
            log.debug(" ... found mappings: {}", relationshipMap);
            if (relationshipMap.containsKey("__SELF__")) {
                for (RelationshipMapping relationshipMapping : relationshipMap.get("__SELF__")) {
                    this.processSelfReferencingRelationship(relationshipMapping, latestVersion, stub, relationshipGUID);
                }
            }
            if (!changedProperties.isEmpty()) {
                for (String igcProperty : changeSet.getChangedProperties()) {
                    log.debug(" ... checking for any relationship on: {}", (Object)igcProperty);
                    if (!relationshipMap.containsKey(igcProperty)) continue;
                    List<ChangeSet.Change> changesForProperty = changeSet.getChangesForProperty(igcProperty);
                    log.debug(" ...... found differences for property: {}", changesForProperty);
                    for (RelationshipMapping relationshipMapping : relationshipMap.get(igcProperty)) {
                        this.processRelationships(relationshipMapping, latestVersion, changesForProperty, relationshipGUID);
                    }
                }
            }
        }
    }

    private void processRelationships(RelationshipMapping relationshipMapping, Reference latestVersion, List<ChangeSet.Change> changesForProperty, IGCRelationshipGuid relationshipTriggerGUID) {
        log.debug("processRelationships called with relationshipMapping {}, reference {} and changes {}", new Object[]{relationshipMapping, latestVersion, changesForProperty});
        for (ChangeSet.Change change : changesForProperty) {
            String assetType = latestVersion.getType();
            List referenceListProperties = this.igcRestClient.getPagedRelationshipPropertiesForType(assetType);
            if (referenceListProperties != null) {
                Object relatedValue = change.getNewValue(referenceListProperties);
                log.debug(" ... found value: {}", relatedValue);
                if (relatedValue != null) {
                    if (relatedValue instanceof ItemList) {
                        log.debug(" ... found ItemList, processing each item");
                        ItemList related = (ItemList)relatedValue;
                        for (Reference relatedAsset : related.getItems()) {
                            this.processOneOrMoreRelationships(relationshipMapping, latestVersion, relatedAsset, referenceListProperties, change, relationshipTriggerGUID);
                        }
                        continue;
                    }
                    if (relatedValue instanceof Reference) {
                        log.debug(" ... found single Reference, processing it");
                        Reference relatedAsset = (Reference)relatedValue;
                        this.processOneOrMoreRelationships(relationshipMapping, latestVersion, relatedAsset, referenceListProperties, change, relationshipTriggerGUID);
                        continue;
                    }
                    if (change.getIgcPropertyPath().endsWith("_id") && Reference.isSimpleType((Object)relatedValue)) {
                        log.error(" ... change consolidation in ChangeSet did not work: {}", (Object)change);
                        continue;
                    }
                    if (change.getIgcPropertyPath().endsWith("_name") || change.getIgcPropertyPath().endsWith("_url")) continue;
                    log.warn("Expected relationship for path '{}' for guid {} but found neither Reference nor ItemList: {}", new Object[]{change.getIgcPropertyPath(), latestVersion.getId(), relatedValue});
                    continue;
                }
                log.warn("Expected relationship for path '{}' for guid {} but found nothing.", (Object)change.getIgcPropertyPath(), (Object)latestVersion.getId());
                continue;
            }
            log.warn("No registered POJO to translate asset type '{}' for guid {} -- skipping its relationships.", (Object)assetType, (Object)latestVersion.getId());
        }
    }

    private void processOneOrMoreRelationships(RelationshipMapping relationshipMapping, Reference latestVersion, Reference relatedAsset, List<String> referenceListProperties, ChangeSet.Change change, IGCRelationshipGuid relationshipTriggerGUID) {
        String omrsRelationshipType = relationshipMapping.getOmrsRelationshipType();
        String latestVersionRID = latestVersion.getId();
        String relatedRID = relatedAsset.getId();
        if (relatedRID != null && !relatedRID.equals("null")) {
            log.debug("processOneOrMoreRelationships processing between {} and {} for type: {}", new Object[]{latestVersionRID, relatedRID, omrsRelationshipType});
            RelationshipMapping.ProxyMapping pmOne = relationshipMapping.getProxyOneMapping();
            RelationshipMapping.ProxyMapping pmTwo = relationshipMapping.getProxyTwoMapping();
            String latestVersionType = latestVersion.getType();
            String relatedAssetType = relatedAsset.getType();
            List<Object> proxyOnes = new ArrayList();
            List<Object> proxyTwos = new ArrayList();
            String relationshipLevelRid = null;
            if (relationshipMapping.hasRelationshipLevelAsset()) {
                String relationshipLevelType = relationshipMapping.getRelationshipLevelIgcAsset();
                if (latestVersionType.equals(relationshipLevelType)) {
                    relationshipLevelRid = latestVersionRID;
                    proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(latestVersion, this.igcRestClient);
                    proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(latestVersion, this.igcRestClient);
                } else if (relatedAssetType.equals(relationshipLevelType)) {
                    relationshipLevelRid = relatedRID;
                    proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(relatedAsset, this.igcRestClient);
                    proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(relatedAsset, this.igcRestClient);
                }
            } else if (relationshipMapping.sameTypeOnBothEnds() && !relationshipMapping.samePropertiesOnBothEnds()) {
                String igcPropertyName = change.getIgcPropertyName();
                log.debug(" ... relationship is the same on both ends, but property differs: {}", (Object)igcPropertyName);
                if (pmOne.getIgcRelationshipProperties().contains(igcPropertyName)) {
                    log.debug(" ... proxy mapping 1 contains the property, setting 1 from '{}' and 2 from '{}'", (Object)latestVersion.getName(), (Object)relatedAsset.getName());
                    proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(latestVersion, this.igcRestClient);
                    proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(relatedAsset, this.igcRestClient);
                } else if (pmTwo.getIgcRelationshipProperties().contains(igcPropertyName)) {
                    log.debug(" ... proxy mapping 2 contains the property, setting 1 from '{}' and 2 from '{}'", (Object)relatedAsset.getName(), (Object)latestVersion.getName());
                    proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(relatedAsset, this.igcRestClient);
                    proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(latestVersion, this.igcRestClient);
                }
            } else if (relationshipMapping.sameTypeOnBothEnds() || pmOne.matchesAssetType(latestVersionType) && pmTwo.matchesAssetType(relatedAssetType)) {
                proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(latestVersion, this.igcRestClient);
                proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(relatedAsset, this.igcRestClient);
            } else if (pmTwo.matchesAssetType(latestVersionType) && pmOne.matchesAssetType(relatedAssetType)) {
                proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(relatedAsset, this.igcRestClient);
                proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(latestVersion, this.igcRestClient);
            } else if (relationshipMapping.hasLinkingAsset()) {
                String linkingType = relationshipMapping.getLinkingAssetType();
                if (latestVersionType.equals(linkingType) && pmTwo.matchesAssetType(relatedAssetType) || relatedAssetType.equals(linkingType) && pmOne.matchesAssetType(latestVersionType)) {
                    proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(latestVersion, this.igcRestClient);
                    proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(relatedAsset, this.igcRestClient);
                } else if (relatedAssetType.equals(linkingType) && pmTwo.matchesAssetType(latestVersionType) || latestVersionType.equals(linkingType) && pmOne.matchesAssetType(relatedAssetType)) {
                    proxyOnes = relationshipMapping.getProxyOneAssetFromAsset(relatedAsset, this.igcRestClient);
                    proxyTwos = relationshipMapping.getProxyTwoAssetFromAsset(latestVersion, this.igcRestClient);
                } else {
                    log.warn("Unable to match assets to proxies through linking asset '{}' for guids {} and {} through relationship type {} -- skipped, but this is likely indicative of a problem with the mapping.", new Object[]{linkingType, latestVersion.getId(), relatedAsset.getId(), omrsRelationshipType});
                }
            } else {
                log.warn("Unable to match assets {} and {} to proxies for any asset translation for relationship type {} -- skipped, but this is likely indicative of a problem with the mapping.", new Object[]{latestVersion.getId(), relatedAsset.getId(), omrsRelationshipType});
                proxyOnes.add(latestVersion);
                proxyTwos.add(relatedAsset);
            }
            for (Reference reference : proxyOnes) {
                for (Reference reference2 : proxyTwos) {
                    this.processSingleRelationship(relationshipMapping, reference, reference2, referenceListProperties, change, relationshipLevelRid, relationshipTriggerGUID);
                }
            }
        } else {
            log.info("Related RID for guid {} and relationship {} was null -- skipped.", (Object)latestVersion.getId(), (Object)omrsRelationshipType);
        }
    }

    private void processSingleRelationship(RelationshipMapping relationshipMapping, Reference proxyOne, Reference proxyTwo, List<String> referenceListProperties, ChangeSet.Change change, String relationshipLevelRid, IGCRelationshipGuid relationshipTriggerGUID) {
        block26: {
            String omrsRelationshipType = relationshipMapping.getOmrsRelationshipType();
            String latestVersionRID = proxyOne.getId();
            String relatedRID = proxyTwo.getId();
            if (relatedRID != null && !relatedRID.equals("null") && relationshipMapping.includeRelationshipForIgcObjects(this.igcomrsRepositoryConnector, proxyOne, proxyTwo)) {
                log.debug("processSingleRelationship processing between {} and {} for type: {}", new Object[]{latestVersionRID, relatedRID, omrsRelationshipType});
                RelationshipMapping.ProxyMapping pmOne = relationshipMapping.getProxyOneMapping();
                RelationshipMapping.ProxyMapping pmTwo = relationshipMapping.getProxyTwoMapping();
                IGCRelationshipGuid igcRelationshipGuid = RelationshipMapping.getRelationshipGUID(this.igcRepositoryHelper, relationshipMapping, proxyOne, proxyTwo, change.getIgcPropertyName(), relationshipLevelRid, true);
                log.debug(" ... calculated relationship GUID: {}", (Object)igcRelationshipGuid);
                if (relationshipTriggerGUID == null || !relationshipTriggerGUID.equals(igcRelationshipGuid)) {
                    String changeType = change.getOp();
                    log.debug(" ... change action: {}", (Object)changeType);
                    if (changeType.equals("remove")) {
                        try {
                            RelationshipDef relationshipDef = (RelationshipDef)this.igcomrsMetadataCollection.getTypeDefByName(this.localServerUserId, omrsRelationshipType);
                            this.sendPurgedRelationship(relationshipMapping, relationshipDef, igcRelationshipGuid, change.getIgcPropertyName(), proxyOne, proxyTwo);
                            String proxyOneType = proxyOne.getType();
                            String proxyTwoType = proxyTwo.getType();
                            if (!IGCRestConstants.getRelationshipLevelTypes().contains(proxyTwoType)) {
                                IGCEntityGuid igcEntityGuid2 = RelationshipMapping.getProxyTwoGuidFromRelationship(this.igcRepositoryHelper, igcRelationshipGuid);
                                this.processAsset(igcEntityGuid2.getRid(), pmTwo.getIgcAssetType(), igcRelationshipGuid, igcEntityGuid2.getGeneratedPrefix());
                            } else {
                                log.debug(" ... proxy two was a relationship-level type, not processing it as an asset: {}", (Object)proxyTwoType);
                            }
                            if (!IGCRestConstants.getRelationshipLevelTypes().contains(proxyOneType)) {
                                IGCEntityGuid igcEntityGuid1 = RelationshipMapping.getProxyOneGuidFromRelationship(this.igcRepositoryHelper, igcRelationshipGuid);
                                this.processAsset(igcEntityGuid1.getRid(), pmOne.getIgcAssetType(), igcRelationshipGuid, igcEntityGuid1.getGeneratedPrefix());
                                break block26;
                            }
                            log.debug(" ... proxy one was a relationship-level type, not processing it as an asset: {}", (Object)proxyOneType);
                        }
                        catch (InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException e) {
                            log.error("Unable to retrieve relationship type definition: {}", (Object)omrsRelationshipType, (Object)e);
                        }
                    } else {
                        try {
                            Relationship relationship = this.igcomrsMetadataCollection.getRelationship(this.localServerUserId, igcRelationshipGuid.toString());
                            log.debug(" ... retrieved relationship: {}", (Object)relationship);
                            String proxyOneType = proxyOne.getType();
                            String proxyTwoType = proxyTwo.getType();
                            if (!IGCRestConstants.getRelationshipLevelTypes().contains(proxyTwoType)) {
                                this.processAsset(relatedRID, proxyTwo.getType(), igcRelationshipGuid, igcRelationshipGuid.getGeneratedPrefix2());
                            } else {
                                log.debug(" ... proxy two was a relationship-level type, not processing it as an asset: {}", (Object)proxyTwoType);
                            }
                            if (!IGCRestConstants.getRelationshipLevelTypes().contains(proxyOneType)) {
                                this.processAsset(latestVersionRID, proxyOne.getType(), igcRelationshipGuid, igcRelationshipGuid.getGeneratedPrefix1());
                            } else {
                                log.debug(" ... proxy one was a relationship-level type, not processing it as an asset: {}", (Object)proxyOneType);
                            }
                            switch (changeType) {
                                case "add": {
                                    this.sendNewRelationship(relationship, relationshipLevelRid);
                                    break;
                                }
                                case "replace": {
                                    this.sendReplacedRelationship(relationshipMapping, relationship, proxyOne, proxyTwo, relationshipLevelRid, referenceListProperties, change);
                                    break;
                                }
                                default: {
                                    log.warn("Unknown action '{}' for relationship {}", (Object)changeType, (Object)igcRelationshipGuid);
                                    break;
                                }
                            }
                        }
                        catch (RelationshipNotKnownException e) {
                            log.error("Unable to find relationship with GUID: {}", (Object)igcRelationshipGuid, (Object)e);
                        }
                        catch (InvalidParameterException | RepositoryErrorException e) {
                            log.error("Unknown error occurred trying to retrieve relationship: {}", (Object)igcRelationshipGuid, (Object)e);
                        }
                    }
                } else {
                    log.info("Relationship was same as one that triggered this processing -- skipping: {}", (Object)relationshipTriggerGUID);
                }
            } else {
                log.warn("Related RID for relationship type {} and guid {} was null, or explicitly excluded.", (Object)omrsRelationshipType, (Object)latestVersionRID);
            }
        }
    }

    private void processSelfReferencingRelationship(RelationshipMapping relationshipMapping, Reference latestVersion, OMRSStub stub, IGCRelationshipGuid relationshipTriggerGUID) {
        block6: {
            String omrsRelationshipType = relationshipMapping.getOmrsRelationshipType();
            String latestVersionRID = latestVersion.getId();
            log.debug("processSelfReferencingRelationship processing for {} and type: {}", (Object)latestVersionRID, (Object)omrsRelationshipType);
            IGCRelationshipGuid igcRelationshipGuid = RelationshipMapping.getRelationshipGUID(this.igcRepositoryHelper, relationshipMapping, latestVersion, latestVersion, "__SELF__", null);
            log.debug(" ... calculated relationship GUID: {}", (Object)igcRelationshipGuid);
            if (relationshipTriggerGUID == null || !relationshipTriggerGUID.equals(igcRelationshipGuid)) {
                try {
                    Relationship relationship = this.igcomrsMetadataCollection.getRelationship(this.localServerUserId, igcRelationshipGuid.toString());
                    log.debug(" ... retrieved relationship: {}", (Object)relationship);
                    if (stub == null) {
                        this.sendNewRelationship(relationship, null);
                        break block6;
                    }
                    this.sendUpdatedRelationship(relationship, stub);
                }
                catch (RelationshipNotKnownException e) {
                    log.error("Unable to find relationship with GUID: {}", (Object)igcRelationshipGuid, (Object)e);
                }
                catch (InvalidParameterException | RepositoryErrorException e) {
                    log.error("Unknown error occurred trying to retrieve relationship: {}", (Object)igcRelationshipGuid, (Object)e);
                }
            } else {
                log.info("Relationship was same as the one that triggered this processing -- skipping: {}", (Object)relationshipTriggerGUID);
            }
        }
    }

    private void sendNewRelationship(Relationship relationship, String relationshipLevelRid) {
        if (relationship != null) {
            Reference relationshipLevelAsset;
            this.repositoryEventProcessor.processNewRelationshipEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, relationship);
            if (relationshipLevelRid != null && (relationshipLevelAsset = this.igcRestClient.getAssetById(relationshipLevelRid)) != null) {
                this.igcRepositoryHelper.upsertOMRSStubForAsset(relationshipLevelAsset);
            }
        }
    }

    private void sendUpdatedRelationship(Relationship relationship, OMRSStub stub) {
        if (relationship != null) {
            Relationship old = relationship;
            Reference igcStubObject = this.getIgcAssetFromStubPayload(stub);
            if (igcStubObject != null) {
                old.setVersion(igcStubObject.getModifiedOn().getTime());
            }
            this.repositoryEventProcessor.processUpdatedRelationshipEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, old, relationship);
        }
    }

    private void sendReplacedRelationship(RelationshipMapping relationshipMapping, Relationship relationship, Reference proxyOne, Reference proxyTwo, String relationshipLevelRid, List<String> referenceListProperties, ChangeSet.Change change) {
        block10: {
            String newRelationshipGUID = relationship.getGUID();
            String igcPropertyName = change.getIgcPropertyName();
            Object ora = change.getOldValue(referenceListProperties);
            if (ora != null) {
                Reference oldRelatedAsset = (Reference)ora;
                if (oldRelatedAsset.getId() != null) {
                    Reference newRelatedAsset = (Reference)change.getNewValue(referenceListProperties);
                    log.debug("Processing relationship replacement for: {}", (Object)oldRelatedAsset);
                    String newRelatedAssetRID = newRelatedAsset.getId();
                    try {
                        RelationshipDef relationshipDef = (RelationshipDef)this.igcomrsMetadataCollection.getTypeDefByName(this.localServerUserId, relationshipMapping.getOmrsRelationshipType());
                        Reference oldProxyOne = null;
                        Reference oldProxyTwo = null;
                        if (newRelatedAssetRID.equals(proxyOne.getId())) {
                            oldProxyOne = oldRelatedAsset;
                            oldProxyTwo = proxyTwo;
                        } else if (newRelatedAssetRID.equals(proxyTwo.getId())) {
                            oldProxyOne = proxyOne;
                            oldProxyTwo = oldRelatedAsset;
                        }
                        if (oldProxyOne != null && oldProxyTwo != null) {
                            IGCRelationshipGuid oldRelationshipGUID = RelationshipMapping.getRelationshipGUID(this.igcRepositoryHelper, relationshipMapping, oldProxyOne, oldProxyTwo, igcPropertyName, null, true);
                            log.debug(" ... calculated old relationship GUID: {}", (Object)oldRelationshipGUID);
                            this.sendPurgedRelationship(relationshipMapping, relationshipDef, oldRelationshipGUID, igcPropertyName, oldProxyOne, oldProxyTwo);
                            break block10;
                        }
                        log.warn("Unable to find previous version for relationship replacement -- sending only new: {}", (Object)newRelationshipGUID);
                    }
                    catch (InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException e) {
                        log.error("Unable to find relationship type definition '{}' / not supported for guid: {}", new Object[]{relationshipMapping.getOmrsRelationshipType(), newRelationshipGUID, e});
                    }
                } else {
                    log.warn("Unable to find any previous version for the relationship replacement (no ID) -- sending only new: {}", (Object)newRelationshipGUID);
                }
            } else {
                log.warn("Unable to find any previous version for the relationship replacement (null) -- sending only new: {}", (Object)newRelationshipGUID);
            }
        }
        this.sendNewRelationship(relationship, relationshipLevelRid);
    }

    private void sendPurgedRelationship(RelationshipMapping relationshipMapping, RelationshipDef relationshipDef, IGCRelationshipGuid relationshipGUID, String igcPropertyName, Reference proxyOne, Reference proxyTwo) {
        IGCEntityGuid proxyOneGuid = RelationshipMapping.getProxyOneGuidFromRelationship(this.igcRepositoryHelper, relationshipGUID);
        String relationshipLevelRid = null;
        if (relationshipGUID.isRelationshipLevelObject()) {
            relationshipLevelRid = proxyOneGuid.getRid();
        }
        if (proxyOne != null && proxyTwo != null) {
            try {
                OMRSStub stubOne = this.igcRepositoryHelper.getOMRSStubForAsset(proxyOne);
                OMRSStub stubTwo = this.igcRepositoryHelper.getOMRSStubForAsset(proxyTwo);
                Relationship relationship = RelationshipMapping.getMappedRelationship(this.igcomrsRepositoryConnector, relationshipMapping, relationshipDef, this.getIgcAssetFromStubPayload(stubOne), this.getIgcAssetFromStubPayload(stubTwo), igcPropertyName, this.localServerUserId, relationshipLevelRid, true);
                this.repositoryEventProcessor.processDeletePurgedRelationshipEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to retrieve relationship details for: {}", (Object)relationshipGUID, (Object)e);
            }
        } else {
            log.warn("Unable to produce DeletePurgedRelationshipEvent for relationship: {}", (Object)relationshipGUID);
        }
    }

    private void sendNewEntity(Reference asset) {
        boolean atLeastOneEvent = false;
        List<EntityMapping> referenceableMappers = this.igcRepositoryHelper.getMappers(asset.getType(), this.localServerUserId);
        for (EntityMapping referenceableMapper : referenceableMappers) {
            String ridPrefix = referenceableMapper.getIgcRidPrefix();
            IGCEntityGuid igcEntityGuid = this.igcRepositoryHelper.getEntityGuid(asset.getType(), ridPrefix, asset.getId());
            EntityDetail detail = this.getEntityDetailForAssetWithGUID(asset, igcEntityGuid);
            if (detail != null) {
                atLeastOneEvent = true;
                this.repositoryEventProcessor.processNewEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, detail);
                List classifications = detail.getClassifications();
                if (classifications == null) continue;
                for (Classification classification : classifications) {
                    this.sendNewClassification(detail);
                }
                continue;
            }
            log.warn("Unable to retrieve new entity for asset type {} with prefix {} and RID: {}", new Object[]{asset.getType(), ridPrefix, asset.getId()});
        }
        if (atLeastOneEvent) {
            this.igcRepositoryHelper.upsertOMRSStubForAsset(asset);
        }
    }

    private void sendUpdatedEntity(Reference latestVersion, OMRSStub stub) {
        boolean atLeastOneEvent = false;
        List<EntityMapping> referenceableMappers = this.igcRepositoryHelper.getMappers(latestVersion.getType(), this.localServerUserId);
        for (EntityMapping referenceableMapper : referenceableMappers) {
            String ridPrefix = referenceableMapper.getIgcRidPrefix();
            IGCEntityGuid igcEntityGuid = this.igcRepositoryHelper.getEntityGuid(latestVersion.getType(), ridPrefix, latestVersion.getId());
            EntityDetail detail = this.getEntityDetailForAssetWithGUID(latestVersion, igcEntityGuid);
            if (detail != null) {
                atLeastOneEvent = true;
                EntityDetail last = this.getEntityDetailForStubWithGUID(stub, igcEntityGuid);
                this.repositoryEventProcessor.processUpdatedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, last, detail);
                this.processClassifications(detail, detail.getClassifications(), last == null ? new ArrayList() : last.getClassifications());
                continue;
            }
            log.warn("Unable to generate updated entity for asset type {} with prefix {} and RID: {}", new Object[]{latestVersion.getType(), ridPrefix, latestVersion.getId()});
        }
        if (atLeastOneEvent) {
            this.igcRepositoryHelper.upsertOMRSStubForAsset(latestVersion);
        }
    }

    private void processClassifications(EntityDetail detail, List<Classification> latestClassifications, List<Classification> lastClassifications) {
        Map<String, Classification> latestClassificationByGUID = this.getClassificationMapFromList(latestClassifications);
        Map<String, Classification> lastClassificationByGUID = this.getClassificationMapFromList(lastClassifications);
        ArrayList<String> matchingGUIDs = new ArrayList<String>();
        for (String guid : latestClassificationByGUID.keySet()) {
            if (!lastClassificationByGUID.containsKey(guid)) {
                this.sendNewClassification(detail);
                continue;
            }
            matchingGUIDs.add(guid);
        }
        for (String guid : lastClassificationByGUID.keySet()) {
            if (latestClassificationByGUID.containsKey(guid)) continue;
            this.sendRemovedClassification(detail);
        }
        for (String matchingGUID : matchingGUIDs) {
            Classification last;
            Classification latest = latestClassificationByGUID.get(matchingGUID);
            if (latest.equals((Object)(last = lastClassificationByGUID.get(matchingGUID)))) continue;
            this.sendChangedClassification(detail);
        }
    }

    private Map<String, Classification> getClassificationMapFromList(List<Classification> classifications) {
        HashMap<String, Classification> map = new HashMap<String, Classification>();
        if (classifications != null) {
            for (Classification classification : classifications) {
                String typeGUID = classification.getType().getTypeDefGUID();
                if (map.containsKey(typeGUID)) {
                    log.warn("Found multiple classifications of type {} -- clobbering!", (Object)typeGUID);
                }
                map.put(typeGUID, classification);
            }
        }
        return map;
    }

    private void sendNewClassification(EntityDetail detail) {
        this.repositoryEventProcessor.processClassifiedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, detail);
    }

    private void sendChangedClassification(EntityDetail detail) {
        this.repositoryEventProcessor.processReclassifiedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, detail);
    }

    private void sendRemovedClassification(EntityDetail detail) {
        this.repositoryEventProcessor.processDeclassifiedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, detail);
    }

    private void sendPurgedEntity(String igcAssetType, String rid) {
        this.sendPurgedEntity(igcAssetType, rid, new HashSet<String>());
    }

    private void sendPurgedEntity(String igcAssetType, String rid, Set<String> alreadyPurgedRids) {
        if (alreadyPurgedRids.contains(rid)) {
            log.debug("Received RID has already been purged -- skipping: {}", (Object)rid);
        } else {
            log.debug("Purging entity of type '{}' with RID: {}", (Object)igcAssetType, (Object)rid);
            OMRSStub stub = this.igcRepositoryHelper.getOMRSStubForAsset(rid, igcAssetType);
            if (stub != null) {
                Reference fromObject = this.getIgcAssetFromStubPayload(stub);
                List<EntityMapping> referenceableMappers = this.igcRepositoryHelper.getMappers(igcAssetType, this.localServerUserId);
                for (EntityMapping referenceableMapper : referenceableMappers) {
                    log.debug("Checking via: {}", (Object)referenceableMapper.getClass().getName());
                    if (referenceableMapper.isOmrsType(this.igcRestClient, fromObject)) {
                        ArrayList<PurgeMarker> purgeMarkers = new ArrayList<PurgeMarker>();
                        String ridPrefix = referenceableMapper.getIgcRidPrefix();
                        IGCEntityGuid igcEntityGuid = this.igcRepositoryHelper.getEntityGuid(igcAssetType, ridPrefix, rid);
                        List<RelationshipMapping> relationshipMappers = referenceableMapper.getRelationshipMappers();
                        for (RelationshipMapping relationshipMapping : relationshipMappers) {
                            log.debug("Checking for relationships via: {}", (Object)relationshipMapping.getClass().getName());
                            RelationshipMapping.ProxyMapping pmOne = relationshipMapping.getProxyOneMapping();
                            RelationshipMapping.ProxyMapping pmTwo = relationshipMapping.getProxyTwoMapping();
                            try {
                                RelationshipDef relationshipDef = (RelationshipDef)this.igcomrsMetadataCollection.getTypeDefByName(this.localServerUserId, relationshipMapping.getOmrsRelationshipType());
                                RelationshipMapping.ContainedType childEnd = relationshipMapping.getContainedType();
                                if (childEnd.equals((Object)RelationshipMapping.ContainedType.ONE) && pmTwo.matchesAssetType(igcAssetType) || childEnd.equals((Object)RelationshipMapping.ContainedType.TWO) && pmOne.matchesAssetType(igcAssetType)) {
                                    log.debug(" ... containment detected for type '{}' and relationship {}", (Object)igcAssetType, (Object)relationshipMapping.getClass().getName());
                                    purgeMarkers.add(new PurgeMarker(fromObject, relationshipDef, relationshipMapping));
                                }
                                List<String> propertyNames = null;
                                ArrayList<Reference> endOne = new ArrayList<Reference>();
                                ArrayList<Reference> endTwo = new ArrayList<Reference>();
                                boolean iterateOnOne = false;
                                if (pmOne.matchesAssetType(igcAssetType)) {
                                    log.debug(" ... setting 'from' to end1: {}", (Object)igcAssetType);
                                    propertyNames = pmOne.getIgcRelationshipProperties();
                                    endOne.addAll(relationshipMapping.getProxyOneAssetFromAsset(fromObject, this.igcRestClient));
                                    iterateOnOne = true;
                                } else if (pmTwo.matchesAssetType(igcAssetType)) {
                                    log.debug(" ... setting 'from' to end2: {}", (Object)igcAssetType);
                                    propertyNames = pmTwo.getIgcRelationshipProperties();
                                    endTwo.addAll(relationshipMapping.getProxyTwoAssetFromAsset(fromObject, this.igcRestClient));
                                    iterateOnOne = false;
                                } else {
                                    log.warn("Unable to match the purged entity '{}' to either end of relationship: {}", (Object)igcAssetType, (Object)relationshipDef.getName());
                                }
                                if (propertyNames == null) continue;
                                for (String property : propertyNames) {
                                    log.debug(" ... checking for relationship on property: {}", (Object)property);
                                    Object relatedResult = this.igcRestClient.getPropertyByName(fromObject, property);
                                    if (relatedResult == null) continue;
                                    if (relatedResult instanceof Reference) {
                                        Reference relationship = (Reference)relatedResult;
                                        if (relationship.getType() == null) continue;
                                        this.cascadeRelationshipPurge(relationshipMapping, relationshipDef, endOne, endTwo, relationship, property, iterateOnOne);
                                        continue;
                                    }
                                    if (!(relatedResult instanceof ItemList)) continue;
                                    ItemList relationships = (ItemList)relatedResult;
                                    for (Reference relationship : relationships.getItems()) {
                                        this.cascadeRelationshipPurge(relationshipMapping, relationshipDef, endOne, endTwo, relationship, property, iterateOnOne);
                                    }
                                }
                            }
                            catch (InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException e) {
                                log.error("Unable to retrieve the relationship type definition for '{}' -- cannot purge relationship.", (Object)relationshipMapping.getOmrsRelationshipType(), (Object)e);
                            }
                        }
                        for (PurgeMarker purgeMarker : purgeMarkers) {
                            this.recurseOnContainedEntities(purgeMarker, alreadyPurgedRids);
                        }
                        EntityDetail detail = this.getEntityDetailForStubWithGUID(stub, igcEntityGuid);
                        if (detail != null) {
                            log.debug(" ... purging entity: {}", (Object)igcEntityGuid);
                            this.repositoryEventProcessor.processDeletePurgedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, null, detail);
                            alreadyPurgedRids.add(igcEntityGuid.getRid());
                            continue;
                        }
                        log.warn("No stub information exists for purged GUID {} -- cannot generated purgeEntity event.", (Object)igcEntityGuid);
                        continue;
                    }
                    log.info("Type ({}) did not match mapper, skipped: {}", (Object)igcAssetType, (Object)referenceableMapper.getClass().getName());
                }
                log.debug("Deleting stub: {}", (Object)rid);
                this.igcRepositoryHelper.deleteOMRSStubForAsset(rid, igcAssetType);
            } else {
                log.info("No stub information exists for RID {} of type {} -- cannot generated purgeEntity event.", (Object)rid, (Object)igcAssetType);
            }
        }
    }

    private void recurseOnContainedEntities(PurgeMarker marker, Set<String> alreadyPurgedRids) {
        RelationshipMapping.ProxyMapping parent;
        RelationshipMapping relationshipMapping = marker.getMapping();
        Reference parentObject = marker.getTriggerObject();
        RelationshipMapping.ContainedType childEnd = relationshipMapping.getContainedType();
        log.debug("Recursing on mapping: {}", (Object)relationshipMapping.getClass().getName());
        String parentRid = parentObject.getId();
        if (childEnd.equals((Object)RelationshipMapping.ContainedType.TWO)) {
            log.debug(" ... setting parent as 1, child as 2");
            parent = relationshipMapping.getProxyOneMapping();
        } else {
            log.debug(" ... setting child as 1, parent as 2");
            parent = relationshipMapping.getProxyTwoMapping();
        }
        List<String> relationshipProperties = parent.getIgcRelationshipProperties();
        log.debug(" ... iterating through parent's properties: {}", relationshipProperties);
        for (String property : relationshipProperties) {
            log.debug(" ... getting child entities from property: {}", (Object)property);
            Object relatedResult = this.igcRestClient.getPropertyByName(parentObject, property);
            if (relatedResult == null) continue;
            if (relatedResult instanceof Reference) {
                Reference relationship = (Reference)relatedResult;
                if (relationship.getId().equals(parentRid)) continue;
                log.debug(" ... purging child entity: {}", (Object)relationship.getId());
                this.sendPurgedEntity(relationship.getType(), relationship.getId(), alreadyPurgedRids);
                continue;
            }
            if (!(relatedResult instanceof ItemList)) continue;
            ItemList relationships = (ItemList)relatedResult;
            for (Reference relationship : relationships.getItems()) {
                if (relationship.getId().equals(parentRid)) continue;
                log.debug(" ... purging child entity: {}", (Object)relationship.getId());
                this.sendPurgedEntity(relationship.getType(), relationship.getId(), alreadyPurgedRids);
            }
        }
    }

    private void cascadeRelationshipPurge(RelationshipMapping relationshipMapping, RelationshipDef relationshipDef, List<Reference> endOne, List<Reference> endTwo, Reference relatedObject, String propertyName, boolean iterateOnOne) {
        if (iterateOnOne) {
            for (Reference one : endOne) {
                IGCRelationshipGuid relGuid = RelationshipMapping.getRelationshipGUID(this.igcRepositoryHelper, relationshipMapping, one, relatedObject, propertyName, null, true);
                log.debug(" ... purging relationship for purged entity: {}", (Object)relGuid);
                this.sendPurgedRelationship(relationshipMapping, relationshipDef, relGuid, propertyName, one, relatedObject);
            }
        } else {
            for (Reference two : endTwo) {
                IGCRelationshipGuid relGuid = RelationshipMapping.getRelationshipGUID(this.igcRepositoryHelper, relationshipMapping, relatedObject, two, propertyName, null, true);
                log.debug(" ... purging relationship for purged entity: {}", (Object)relGuid);
                this.sendPurgedRelationship(relationshipMapping, relationshipDef, relGuid, propertyName, relatedObject, two);
            }
        }
    }

    private void processEventV117(String event) {
        log.debug("Not yet implemented as v11.7-specific -- backing to v11.5 processing: {}", (Object)event);
        this.processEventV115(event);
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        this.igcKafkaConsumer.stop();
        IGCOMRSAuditCode auditCode = IGCOMRSAuditCode.EVENT_MAPPER_SHUTDOWN;
        this.auditLog.logRecord("disconnect", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.igcomrsRepositoryConnector.getServerName()), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    public void sendNewTypeDefEvent(TypeDef newTypeDef) {
        this.repositoryEventProcessor.processNewTypeDefEvent(this.sourceName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, newTypeDef);
    }

    public void sendNewAttributeTypeDefEvent(AttributeTypeDef newAttributeTypeDef) {
        this.repositoryEventProcessor.processNewAttributeTypeDefEvent(this.sourceName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, newAttributeTypeDef);
    }

    public void sendRefreshEntityRequest(String typeDefGUID, String typeDefName, String entityGUID, String homeMetadataCollectionId) {
        this.repositoryEventProcessor.processRefreshEntityRequested(this.sourceName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, entityGUID, homeMetadataCollectionId);
    }

    public void sendRefreshRelationshipRequest(String typeDefGUID, String typeDefName, String relationshipGUID, String homeMetadataCollectionId) {
        this.repositoryEventProcessor.processRefreshRelationshipRequest(this.sourceName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, relationshipGUID, homeMetadataCollectionId);
    }

    private void raiseConnectorCheckedException(IGCOMRSErrorCode errorCode, String methodName, Exception cause, String ... params) throws ConnectorCheckedException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)cause);
    }

    private class IGCKafkaConsumerThread
    implements Runnable {
        private final AtomicBoolean running = new AtomicBoolean(false);

        private IGCKafkaConsumerThread() {
        }

        void start() {
            Thread worker = new Thread(this);
            worker.start();
        }

        void stop() {
            this.running.set(false);
        }

        @Override
        public void run() {
            this.running.set(true);
            try (KafkaConsumer consumer = new KafkaConsumer(IGCOMRSRepositoryEventMapper.this.igcKafkaProperties);){
                consumer.subscribe(Collections.singletonList(IGCOMRSRepositoryEventMapper.this.igcKafkaTopic));
                IGCOMRSAuditCode auditCode = IGCOMRSAuditCode.EVENT_MAPPER_RUNNING;
                IGCOMRSRepositoryEventMapper.this.auditLog.logRecord("run", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(IGCOMRSRepositoryEventMapper.this.igcomrsRepositoryConnector.getServerName()), null, auditCode.getSystemAction(), auditCode.getUserAction());
                while (this.running.get()) {
                    try {
                        ConsumerRecords events = consumer.poll(pollDuration);
                        for (ConsumerRecord event : events) {
                            IGCOMRSRepositoryEventMapper.this.processEvent((String)event.value());
                        }
                    }
                    catch (Exception e) {
                        auditCode = IGCOMRSAuditCode.EVENT_MAPPER_CONSUMER_FAILURE;
                        IGCOMRSRepositoryEventMapper.this.auditLog.logException("consumer failure", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
                    }
                }
            }
        }
    }
}

