/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.InstanceMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCRelationshipGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.OMRSStub;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.ClassificationMappingStore;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.EntityMappingStore;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.RelationshipMappingStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGCRepositoryHelper {
    private static final Logger log = LoggerFactory.getLogger(IGCRepositoryHelper.class);
    public static final String MAPPING_PKG = "org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.";
    public static final String DEFAULT_IGC_TYPE = "main_object";
    public static final String DEFAULT_IGC_TYPE_DISPLAY_NAME = "Main Object";
    private static final String GENERATED_ENTITY_QNAME_PREFIX = "gen!";
    private static final String GENERATED_ENTITY_QNAME_POSTFIX = "@";
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private OMRSRepositoryHelper repositoryHelper;
    private IGCRestClient igcRestClient;
    private EntityMappingStore entityMappingStore;
    private RelationshipMappingStore relationshipMappingStore;
    private ClassificationMappingStore classificationMappingStore;
    private String repositoryName;
    private String metadataCollectionId;
    private XMLOutputFactory xmlOutputFactory;

    IGCRepositoryHelper(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, OMRSRepositoryHelper repositoryHelper, IGCRestClient igcRestClient) {
        this.igcomrsRepositoryConnector = igcomrsRepositoryConnector;
        this.repositoryHelper = repositoryHelper;
        this.igcRestClient = igcRestClient;
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
        this.repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        this.metadataCollectionId = igcomrsRepositoryConnector.getMetadataCollectionId();
        this.entityMappingStore = new EntityMappingStore(igcomrsRepositoryConnector);
        this.relationshipMappingStore = new RelationshipMappingStore(igcomrsRepositoryConnector);
        this.classificationMappingStore = new ClassificationMappingStore(igcomrsRepositoryConnector);
    }

    boolean addEntityMapping(TypeDef omrsTypeDef, Class mappingClass) {
        return this.entityMappingStore.addMapping(omrsTypeDef, mappingClass, this.igcomrsRepositoryConnector);
    }

    boolean addClassificationMapping(TypeDef omrsTypeDef, Class mappingClass) {
        return this.classificationMappingStore.addMapping(omrsTypeDef, mappingClass);
    }

    boolean addRelationshipMapping(TypeDef omrsTypeDef, Class mappingClass) {
        return this.relationshipMappingStore.addMapping(omrsTypeDef, mappingClass);
    }

    List<RelationshipMapping> getAllRelationshipMappings() {
        return this.relationshipMappingStore.getAllMappings();
    }

    List<EntityMapping> getAllEntityMappings() {
        return this.entityMappingStore.getAllMappings();
    }

    List<TypeDef> getMappedEntityTypes() {
        return this.entityMappingStore.getTypeDefs();
    }

    List<TypeDef> getMappedClassificationTypes() {
        return this.classificationMappingStore.getTypeDefs();
    }

    List<TypeDef> getMappedRelationshipTypes() {
        return this.relationshipMappingStore.getTypeDefs();
    }

    EntityMapping getEntityMappingByGUID(String guid) {
        return this.entityMappingStore.getMappingByOmrsTypeGUID(guid);
    }

    EntityMapping getEntityMappingByIgcType(String assetType, String prefix) {
        return this.entityMappingStore.getMappingByIgcAssetTypeAndPrefix(assetType, prefix);
    }

    List<EntityMapping> getEntityMappingsByIgcType(String assetType) {
        return this.entityMappingStore.getMappingsByIgcAssetType(assetType);
    }

    Set<EntityMapping> getEntityMappingsByPrefix(String prefix) {
        return this.entityMappingStore.getMappingsByIgcPrefix(prefix);
    }

    ClassificationMapping getClassificationMappingByGUID(String guid) {
        return this.classificationMappingStore.getMappingByOmrsTypeGUID(guid);
    }

    RelationshipMapping getRelationshipMappingByGUID(String guid) {
        return this.relationshipMappingStore.getMappingByOmrsTypeGUID(guid);
    }

    ClassificationMapping getClassificationMappingByTypes(String omrsClassificationType, String igcAssetType) {
        return this.classificationMappingStore.getMappingByTypes(omrsClassificationType, igcAssetType);
    }

    RelationshipMapping getRelationshipMappingByTypes(String omrsRelationshipType, String proxyOneType, String proxyTwoType) {
        return this.relationshipMappingStore.getMappingByTypes(omrsRelationshipType, proxyOneType, proxyTwoType);
    }

    public Map<String, List<RelationshipMapping>> getIgcPropertiesToRelationshipMappings(String assetType, String userId) {
        HashMap<String, List<RelationshipMapping>> map = new HashMap<String, List<RelationshipMapping>>();
        List<EntityMapping> mappers = this.getMappers(assetType, userId);
        for (EntityMapping mapper : mappers) {
            List<RelationshipMapping> relationshipMappings = mapper.getRelationshipMappers();
            for (RelationshipMapping relationshipMapping : relationshipMappings) {
                if (relationshipMapping.getProxyOneMapping().matchesAssetType(assetType)) {
                    List<String> relationshipNamesOne = relationshipMapping.getProxyOneMapping().getIgcRelationshipProperties();
                    for (String relationshipName : relationshipNamesOne) {
                        if (!map.containsKey(relationshipName)) {
                            map.put(relationshipName, new ArrayList());
                        }
                        if (map.get(relationshipName).contains(relationshipMapping)) continue;
                        map.get(relationshipName).add(relationshipMapping);
                    }
                }
                if (!relationshipMapping.getProxyTwoMapping().matchesAssetType(assetType)) continue;
                List<String> relationshipNamesTwo = relationshipMapping.getProxyTwoMapping().getIgcRelationshipProperties();
                for (String relationshipName : relationshipNamesTwo) {
                    if (!map.containsKey(relationshipName)) {
                        map.put(relationshipName, new ArrayList());
                    }
                    if (map.get(relationshipName).contains(relationshipMapping)) continue;
                    map.get(relationshipName).add(relationshipMapping);
                }
            }
        }
        return map;
    }

    void processResultsForMapping(EntityMapping mapping, List<EntityDetail> entityDetails, String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<String> limitResultsByClassification, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "processResultsForMapping";
        String igcAssetType = mapping.getIgcAssetType();
        IGCSearchConditionSet classificationLimiters = this.getSearchCriteriaForClassifications(igcAssetType, limitResultsByClassification);
        if (limitResultsByClassification != null && !limitResultsByClassification.isEmpty() && classificationLimiters == null) {
            log.info("Classification limiters were specified, but none apply to the asset type {}, so excluding this asset type from search.", (Object)igcAssetType);
        } else {
            IGCSearch igcSearch = new IGCSearch();
            igcSearch.addType(igcAssetType);
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
            IGCRepositoryHelper.addTypeSpecificConditions(mapping, matchCriteria, matchProperties, igcSearchConditionSet);
            String qualifiedNameRegex = null;
            InstanceMapping.SearchFilter filter = InstanceMapping.getAllNoneOrSome(mapping, matchProperties, matchCriteria);
            if (filter.equals((Object)InstanceMapping.SearchFilter.NONE)) {
                igcSearchConditionSet.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
            } else if (filter.equals((Object)InstanceMapping.SearchFilter.SOME)) {
                Map propertiesToMatch = matchProperties.getInstanceProperties();
                if (propertiesToMatch != null) {
                    for (Map.Entry entry : propertiesToMatch.entrySet()) {
                        String omrsPropertyName = (String)entry.getKey();
                        InstancePropertyValue value = (InstancePropertyValue)entry.getValue();
                        if (omrsPropertyName.equals("qualifiedName")) {
                            qualifiedNameRegex = (String)((PrimitivePropertyValue)value).getPrimitiveValue();
                        }
                        this.addSearchConditionFromValue(igcSearchConditionSet, omrsPropertyName, mapping, value);
                    }
                }
            } else {
                log.debug("Skipping detailed matchProperties iteration, as we should return all types based on criteria and literal mappings.");
            }
            if (!filter.equals((Object)InstanceMapping.SearchFilter.NONE)) {
                if (classificationLimiters != null) {
                    igcSearchConditionSet.addNestedConditionSet(classificationLimiters);
                }
                IGCSearchSorting igcSearchSorting = null;
                if (sequencingProperty == null && sequencingOrder != null) {
                    igcSearchSorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
                }
                IGCRepositoryHelper.setConditionsFromMatchCriteria(igcSearchConditionSet, matchCriteria);
                igcSearch.addProperties(mapping.getAllPropertiesForEntityDetail(this.igcRestClient, igcAssetType));
                igcSearch.addConditions(igcSearchConditionSet);
                this.setPagingForSearch(igcSearch, fromEntityElement, pageSize);
                if (igcSearchSorting != null) {
                    igcSearch.addSortingCriteria(igcSearchSorting);
                }
                boolean includeResult = true;
                if (qualifiedNameRegex != null && (this.repositoryHelper.isStartsWithRegex(qualifiedNameRegex) || this.repositoryHelper.isExactMatchRegex(qualifiedNameRegex))) {
                    String unqualifiedName = this.repositoryHelper.getUnqualifiedLiteralString(qualifiedNameRegex);
                    String prefix = mapping.getIgcRidPrefix();
                    boolean generatedQN = IGCRepositoryHelper.isQualifiedNameOfGeneratedEntity(unqualifiedName);
                    boolean bl = includeResult = entityTypeGUID == null || generatedQN && prefix != null || !generatedQN && prefix == null;
                    if (!includeResult) {
                        String omrsTypeName = mapping.getOmrsTypeDefName();
                        try {
                            TypeDef entityTypeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "processResultsForMapping");
                            includeResult = this.repositoryHelper.isTypeOf(this.metadataCollectionId, omrsTypeName, entityTypeDef.getName());
                        }
                        catch (TypeErrorException e) {
                            log.error("Unable to lookup type for inclusion comparison: {}", (Object)entityTypeGUID, (Object)e);
                        }
                    }
                    log.debug("Include result for name '{}' and prefix '{}'? {}", new Object[]{unqualifiedName, prefix, includeResult});
                }
                if (includeResult) {
                    this.processResults(mapping, (ItemList<Reference>)this.igcRestClient.search(igcSearch), entityDetails, matchProperties, matchCriteria, null, pageSize, userId);
                }
            }
        }
    }

    String addTypeToSearch(EntityMapping mapping, IGCSearch igcSearch) {
        String igcType = DEFAULT_IGC_TYPE;
        if (mapping == null) {
            igcSearch.addType(igcType);
        } else {
            igcType = mapping.getIgcAssetType();
            igcSearch.addType(igcType);
        }
        return igcType;
    }

    void setPagingForSearch(IGCSearch igcSearch, int beginAt, int pageSize) {
        if (pageSize > 0) {
            igcSearch.setPageSize(pageSize);
        } else {
            igcSearch.setPageSize(this.igcomrsRepositoryConnector.getMaxPageSize());
        }
        igcSearch.setBeginAt(beginAt);
    }

    void processResults(EntityMapping mapper, ItemList<Reference> results, List<EntityDetail> entityDetails, InstanceProperties matchProperties, MatchCriteria matchCriteria, String searchCriteria, int pageSize, String userId) throws RepositoryErrorException {
        if (pageSize == 0) {
            results.getAllPages(this.igcRestClient);
        }
        for (Reference reference : results.getItems()) {
            IGCEntityGuid idToLookup;
            if (reference.getType().equals(DEFAULT_IGC_TYPE)) continue;
            EntityDetail ed = null;
            log.debug("processResults with mapper: {}", (Object)mapper.getClass().getCanonicalName());
            if (mapper.igcRidNeedsPrefix()) {
                log.debug(" ... prefix required, getEntityDetail with: {}", (Object)(mapper.getIgcRidPrefix() + "!" + reference.getId()));
                idToLookup = new IGCEntityGuid(this.metadataCollectionId, reference.getType(), mapper.getIgcRidPrefix(), reference.getId());
            } else {
                log.debug(" ... no prefix required, getEntityDetail with: {}", (Object)reference.getId());
                idToLookup = new IGCEntityGuid(this.metadataCollectionId, reference.getType(), reference.getId());
            }
            try {
                ed = this.getEntityDetailFromFullAsset(userId, idToLookup, reference);
            }
            catch (EntityNotKnownException e) {
                log.error("Unable to find entity: {}", (Object)idToLookup, (Object)e);
            }
            if (ed == null || !this.includeResult(ed, matchProperties, matchCriteria, searchCriteria)) continue;
            entityDetails.add(ed);
            if (pageSize <= 0 || entityDetails.size() != pageSize) continue;
            break;
        }
        if (results.hasMorePages() && entityDetails.size() < pageSize) {
            results.getNextPage(this.igcRestClient);
            this.processResults(mapper, results, entityDetails, matchProperties, matchCriteria, searchCriteria, pageSize, userId);
        }
    }

    void processResults(RelationshipMapping mapper, ItemList<Reference> results, List<Relationship> relationships, int pageSize, String userId) throws RepositoryErrorException {
        if (pageSize == 0) {
            results.getAllPages(this.igcRestClient);
        }
        IGCOMRSMetadataCollection igcomrsMetadataCollection = (IGCOMRSMetadataCollection)this.igcomrsRepositoryConnector.getMetadataCollection();
        for (Reference candidateTwo : results.getItems()) {
            String igcType = candidateTwo.getType();
            String relationshipLevelType = mapper.getRelationshipLevelIgcAsset();
            String relationshipLevelRid = null;
            ArrayList<Reference> endOnes = new ArrayList<Reference>();
            ArrayList<Reference> endTwos = new ArrayList<Reference>();
            if (relationshipLevelType != null && relationshipLevelType.equals(igcType)) {
                relationshipLevelRid = candidateTwo.getId();
                log.debug("processResults (relationship-level) with mapper: {}", (Object)mapper.getClass().getCanonicalName());
                RelationshipMapping.RelationshipLevelProxyMapping pmRelationship = mapper.getRelationshipLevelProxyMapping();
                String propertyToOne = pmRelationship.getIgcRelationshipPropertyToEndOne();
                String propertyToTwo = pmRelationship.getIgcRelationshipPropertyToEndTwo();
                Object endOne = this.igcRestClient.getPropertyByName(candidateTwo, propertyToOne);
                IGCRepositoryHelper.addReferencesToList(this.igcRestClient, endOnes, endOne);
                Object endTwo = this.igcRestClient.getPropertyByName(candidateTwo, propertyToTwo);
                IGCRepositoryHelper.addReferencesToList(this.igcRestClient, endTwos, endTwo);
            } else if (!igcType.equals(DEFAULT_IGC_TYPE)) {
                endTwos.add(candidateTwo);
                log.debug("processResults with mapper: {}", (Object)mapper.getClass().getCanonicalName());
                RelationshipMapping.ProxyMapping pmTwo = mapper.getProxyTwoMapping();
                List<String> relationshipProperties = pmTwo.getIgcRelationshipProperties();
                for (String igcPropertyName : relationshipProperties) {
                    if (igcPropertyName.equals("__SELF__")) {
                        endOnes.add(candidateTwo);
                        continue;
                    }
                    Object otherEnd = this.igcRestClient.getPropertyByName(candidateTwo, igcPropertyName);
                    if (otherEnd == null) continue;
                    if (otherEnd instanceof Reference) {
                        Reference other = (Reference)otherEnd;
                        if (other.getType() == null) continue;
                        endOnes.addAll(mapper.getProxyOneAssetFromAsset(other, this.igcRestClient));
                        continue;
                    }
                    if (otherEnd instanceof ItemList) {
                        ItemList otherEnds = (ItemList)otherEnd;
                        otherEnds.getAllPages(this.igcRestClient);
                        for (Reference other : otherEnds.getItems()) {
                            endOnes.addAll(mapper.getProxyOneAssetFromAsset(other, this.igcRestClient));
                        }
                        continue;
                    }
                    log.warn("Not a relationship, skipping: {}", otherEnd);
                }
            }
            for (Reference endOne : endOnes) {
                for (Reference endTwo : endTwos) {
                    String endOneType = endOne.getType();
                    String endTwoType = endTwo.getType();
                    if (endOneType == null || endOneType.equals(DEFAULT_IGC_TYPE) || endTwoType == null || endTwoType.equals(DEFAULT_IGC_TYPE) || !mapper.includeRelationshipForIgcObjects(this.igcomrsRepositoryConnector, endOne, endTwo)) continue;
                    IGCRelationshipGuid idToLookup = RelationshipMapping.getRelationshipGUID(this, mapper, endOne, endTwo, null, relationshipLevelRid, true);
                    Relationship relationship = null;
                    try {
                        relationship = igcomrsMetadataCollection.getRelationship(userId, idToLookup.toString());
                    }
                    catch (InvalidParameterException | RelationshipNotKnownException e) {
                        log.error("Unable to find relationship: {}", (Object)idToLookup);
                    }
                    if (relationship == null) continue;
                    relationships.add(relationship);
                    if (pageSize <= 0 || relationships.size() != pageSize) continue;
                    break;
                }
                if (pageSize <= 0 || relationships.size() != pageSize) continue;
                break;
            }
            if (pageSize <= 0 || relationships.size() != pageSize) continue;
            break;
        }
        if (results.hasMorePages() && relationships.size() < pageSize) {
            results.getNextPage(this.igcRestClient);
            this.processResults(mapper, results, relationships, pageSize, userId);
        }
    }

    private boolean includeResult(EntityDetail ed, InstanceProperties matchProperties, MatchCriteria matchCriteria, String searchCriteria) {
        if (matchProperties != null) {
            Map propertiesToMatch = matchProperties.getInstanceProperties();
            InstanceProperties edProperties = ed.getProperties();
            if (edProperties == null) {
                edProperties = new InstanceProperties();
            }
            if (propertiesToMatch != null) {
                for (Map.Entry toMatch : propertiesToMatch.entrySet()) {
                    String propertyName = (String)toMatch.getKey();
                    InstancePropertyValue valueToMatch = (InstancePropertyValue)toMatch.getValue();
                    InstancePropertyValue edValue = edProperties.getPropertyValue(propertyName);
                    boolean bValuesMatch = this.valuesMatch(valueToMatch, edValue);
                    if (matchCriteria.equals((Object)MatchCriteria.ANY) && bValuesMatch) {
                        return true;
                    }
                    if (matchCriteria.equals((Object)MatchCriteria.NONE) && bValuesMatch) {
                        return false;
                    }
                    if (!matchCriteria.equals((Object)MatchCriteria.ALL) || bValuesMatch) continue;
                    return false;
                }
                return !matchCriteria.equals((Object)MatchCriteria.ANY);
            }
            return true;
        }
        if (searchCriteria != null && !searchCriteria.equals("")) {
            InstanceProperties edProperties = ed.getProperties();
            if (edProperties == null) {
                return false;
            }
            Pattern pattern = Pattern.compile(searchCriteria);
            Map allProperties = edProperties.getInstanceProperties();
            for (InstancePropertyValue value : allProperties.values()) {
                Matcher matcher;
                if (!value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE) || !((PrimitivePropertyValue)value).getPrimitiveDefCategory().equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING) || !(matcher = pattern.matcher(value.valueAsString())).matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean valuesMatch(InstancePropertyValue valueWithPossibleRegex, InstancePropertyValue valueToCheck) {
        if (valueWithPossibleRegex == null && valueToCheck == null) {
            return true;
        }
        if (valueWithPossibleRegex != null && valueToCheck == null) {
            return false;
        }
        if (valueWithPossibleRegex == null) {
            return false;
        }
        if (valueWithPossibleRegex.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE) && ((PrimitivePropertyValue)valueWithPossibleRegex).getPrimitiveDefCategory().equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING)) {
            String searchCriteria = valueWithPossibleRegex.valueAsString();
            Pattern pattern = Pattern.compile(searchCriteria);
            Matcher matcher = pattern.matcher(valueToCheck.valueAsString());
            return matcher.matches();
        }
        return valueWithPossibleRegex.equals((Object)valueToCheck);
    }

    public boolean isIdentityString(String candidate) {
        int count = Identity.isIdentityString((String)candidate);
        if (this.repositoryHelper.isStartsWithRegex(candidate)) {
            String unqualified = this.repositoryHelper.getUnqualifiedLiteralString(candidate);
            return unqualified.startsWith(GENERATED_ENTITY_QNAME_PREFIX) || unqualified.startsWith("(");
        }
        if (count > 0 && (this.repositoryHelper.isContainsRegex(candidate) || this.repositoryHelper.isEndsWithRegex(candidate))) {
            return true;
        }
        return this.repositoryHelper.isExactMatchRegex(candidate) && count >= 4;
    }

    public static void setConditionsFromMatchCriteria(IGCSearchConditionSet igcSearchConditionSet, MatchCriteria matchCriteria) {
        if (matchCriteria != null) {
            switch (matchCriteria) {
                case ALL: {
                    igcSearchConditionSet.setMatchAnyCondition(false);
                    break;
                }
                case ANY: {
                    igcSearchConditionSet.setMatchAnyCondition(true);
                    break;
                }
                case NONE: {
                    igcSearchConditionSet.setMatchAnyCondition(false);
                    igcSearchConditionSet.setNegateAll(true);
                }
            }
        }
    }

    private IGCSearchConditionSet getSearchCriteriaForClassification(String igcAssetType, String classificationName) throws FunctionNotSupportedException {
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        ClassificationMapping classificationMapping = this.classificationMappingStore.getMappingByTypes(classificationName, igcAssetType);
        if (classificationMapping != null) {
            igcSearchConditionSet = classificationMapping.getIGCSearchCriteria(this.repositoryHelper, this.repositoryName, null);
        } else {
            log.warn("Classification {} cannot be applied to IGC asset type {} - excluding from search limitations.", (Object)classificationName, (Object)igcAssetType);
        }
        return igcSearchConditionSet.size() > 0 ? igcSearchConditionSet : null;
    }

    IGCSearchConditionSet getSearchCriteriaForClassifications(String igcAssetType, List<String> classificationNames) throws FunctionNotSupportedException {
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        if (classificationNames != null && !classificationNames.isEmpty()) {
            for (String classificationName : classificationNames) {
                IGCSearchConditionSet classificationLimiter = this.getSearchCriteriaForClassification(igcAssetType, classificationName);
                if (classificationLimiter == null) continue;
                igcSearchConditionSet.addNestedConditionSet(classificationLimiter);
                igcSearchConditionSet.setMatchAnyCondition(false);
            }
        }
        return igcSearchConditionSet.size() > 0 ? igcSearchConditionSet : null;
    }

    public IGCEntityGuid getEntityGuid(String assetType, String prefix, String rid) {
        return new IGCEntityGuid(this.metadataCollectionId, assetType, prefix, rid);
    }

    public IGCRelationshipGuid getRelationshipGuid(String assetType1, String assetType2, String prefix1, String prefix2, String rid1, String rid2, String relationshipType) {
        return new IGCRelationshipGuid(this.metadataCollectionId, assetType1, assetType2, prefix1, prefix2, rid1, rid2, relationshipType);
    }

    public static boolean isQualifiedNameOfGeneratedEntity(String qualifiedName) {
        return qualifiedName.startsWith(GENERATED_ENTITY_QNAME_PREFIX);
    }

    public static String getQualifiedNameForGeneratedEntity(String prefix, String qualifiedName) {
        return GENERATED_ENTITY_QNAME_PREFIX + prefix + GENERATED_ENTITY_QNAME_POSTFIX + qualifiedName;
    }

    public static String getSearchableQualifiedName(String qualifiedName) {
        if (IGCRepositoryHelper.isQualifiedNameOfGeneratedEntity(qualifiedName)) {
            return qualifiedName.substring(qualifiedName.indexOf(GENERATED_ENTITY_QNAME_POSTFIX) + 1);
        }
        return qualifiedName;
    }

    public static String getPrefixFromGeneratedQualifiedName(String qualifiedName) {
        if (IGCRepositoryHelper.isQualifiedNameOfGeneratedEntity(qualifiedName)) {
            return qualifiedName.substring(qualifiedName.indexOf(GENERATED_ENTITY_QNAME_PREFIX) + GENERATED_ENTITY_QNAME_PREFIX.length(), qualifiedName.indexOf(GENERATED_ENTITY_QNAME_POSTFIX));
        }
        return null;
    }

    public EntityDetail getEntityDetailFromFullAsset(String userId, IGCEntityGuid guid, Reference asset) throws RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntityDetailFromFullAsset";
        this.validateGuidAndType(guid, "getEntityDetailFromFullAsset");
        EntityMappingInstance entityMap = this.getMappingInstanceForParameters(guid, asset, userId);
        return this.getEntityDetailFromMapInstance(entityMap, guid.getGeneratedPrefix(), guid.getAssetType(), "getEntityDetailFromFullAsset");
    }

    private void validateGuidAndType(IGCEntityGuid guid, String methodName) throws EntityNotKnownException, RepositoryErrorException {
        log.debug("{} with guid = {}", (Object)methodName, (Object)guid);
        if (guid == null) {
            this.raiseEntityNotKnownException(methodName, "<null>", "<null>", this.repositoryName);
        } else {
            String igcType = guid.getAssetType();
            if (igcType.equals(DEFAULT_IGC_TYPE)) {
                this.raiseRepositoryErrorException(IGCOMRSErrorCode.UNSUPPORTED_OBJECT_TYPE, methodName, guid.toString(), igcType, this.repositoryName);
            }
        }
    }

    private EntityDetail getEntityDetailFromMapInstance(EntityMappingInstance mappingInstance, String prefix, String igcType, String methodName) throws RepositoryErrorException {
        EntityDetail detail = null;
        if (mappingInstance != null) {
            detail = EntityMapping.getEntityDetail(mappingInstance);
        } else {
            this.raiseRepositoryErrorException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, methodName, (prefix == null ? "" : prefix) + igcType, this.repositoryName);
        }
        return detail;
    }

    public EntityDetail getEntityDetail(String userId, IGCEntityGuid guid) throws RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntityDetail";
        this.validateGuidAndType(guid, "getEntityDetail");
        String prefix = guid.getGeneratedPrefix();
        String igcType = guid.getAssetType();
        EntityMappingInstance entityMap = this.getMappingInstanceForParameters(igcType, guid.getRid(), prefix, userId);
        return this.getEntityDetailFromMapInstance(entityMap, prefix, igcType, "getEntityDetail");
    }

    private EntityMappingInstance getMappingInstanceForParameters(IGCEntityGuid guid, Reference asset, String userId) {
        log.debug("Looking for mapper for retrieved asset with guid {}", (Object)guid);
        EntityMappingInstance entityMap = null;
        EntityMapping found = this.getEntityMappingByIgcType(guid.getAssetType(), guid.getGeneratedPrefix());
        if (found != null) {
            log.debug("Found mapper class: {} ({})", (Object)found.getClass().getCanonicalName(), (Object)found);
            entityMap = new EntityMappingInstance(found, this.igcomrsRepositoryConnector, asset, userId);
        } else {
            log.debug("No mapper class found!");
        }
        return entityMap;
    }

    public EntityMappingInstance getMappingInstanceForParameters(String igcAssetType, String rid, String prefix, String userId) {
        log.debug("Looking for mapper for type {} with prefix {}", (Object)igcAssetType, (Object)prefix);
        EntityMappingInstance entityMap = null;
        EntityMapping found = this.getEntityMappingByIgcType(igcAssetType, prefix);
        if (found != null) {
            log.debug("Found mapper class: {} ({})", (Object)found.getClass().getCanonicalName(), (Object)found);
            entityMap = new EntityMappingInstance(found, this.igcomrsRepositoryConnector, igcAssetType, rid, userId);
        } else {
            log.debug("No mapper class found!");
        }
        return entityMap;
    }

    public List<EntityMapping> getMappers(String igcAssetType, String userId) {
        EntityMapping defaultMapper;
        List<EntityMapping> mappers = this.entityMappingStore.getMappingsByIgcAssetType(igcAssetType);
        if (mappers == null) {
            mappers = new ArrayList<EntityMapping>();
        }
        if (mappers.isEmpty() && (defaultMapper = this.entityMappingStore.getDefaultEntityMapper()) != null) {
            mappers.add(defaultMapper);
        }
        return mappers;
    }

    public String getIgcAssetTypeForAssetName(String igcAssetName) {
        EntityMapping mapping = this.entityMappingStore.getMappingByIgcAssetDisplayName(igcAssetName);
        if (mapping != null) {
            return mapping.getIgcAssetType();
        }
        return null;
    }

    private void addSearchConditionFromValue(IGCSearchConditionSet igcSearchConditionSet, String omrsPropertyName, EntityMapping mapping, InstancePropertyValue value) throws FunctionNotSupportedException {
        if (omrsPropertyName != null) {
            if (omrsPropertyName.equals("__COMPLEX_PROPERTY__")) {
                log.warn("Unhandled search condition: complex OMRS mapping, unknown IGC property.");
            } else {
                String igcPropertyName = mapping.getIgcPropertyName(omrsPropertyName);
                if (igcPropertyName == null) {
                    log.warn("Unhandled search condition for unknown IGC property from OMRS property: {}", (Object)omrsPropertyName);
                } else if (igcPropertyName.equals("__COMPLEX_PROPERTY__")) {
                    log.debug("Adding complex property search criteria for: {}", (Object)omrsPropertyName);
                    mapping.addComplexPropertySearchCriteria(this.repositoryHelper, this.repositoryName, this.igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, value);
                } else if (!igcPropertyName.equals("__LITERAL_MAPPING__")) {
                    log.debug("Adding non-literal property search criteria for: {}", (Object)omrsPropertyName);
                    IGCRepositoryHelper.addIGCSearchConditionFromValue(this.repositoryHelper, this.repositoryName, igcSearchConditionSet, igcPropertyName, value);
                }
            }
        }
    }

    public static void addIGCSearchConditionFromValue(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, InstancePropertyValue value) throws FunctionNotSupportedException {
        String methodName = "addIGCSearchConditionFromValue";
        InstancePropertyCategory category = value.getInstancePropertyCategory();
        block0 : switch (category) {
            case PRIMITIVE: {
                PrimitivePropertyValue actualValue = (PrimitivePropertyValue)value;
                PrimitiveDefCategory primitiveType = actualValue.getPrimitiveDefCategory();
                switch (primitiveType) {
                    case OM_PRIMITIVE_TYPE_BOOLEAN: 
                    case OM_PRIMITIVE_TYPE_BYTE: 
                    case OM_PRIMITIVE_TYPE_CHAR: 
                    case OM_PRIMITIVE_TYPE_SHORT: 
                    case OM_PRIMITIVE_TYPE_INT: 
                    case OM_PRIMITIVE_TYPE_LONG: 
                    case OM_PRIMITIVE_TYPE_FLOAT: 
                    case OM_PRIMITIVE_TYPE_DOUBLE: 
                    case OM_PRIMITIVE_TYPE_BIGINTEGER: 
                    case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                        igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, "=", actualValue.getPrimitiveValue().toString()));
                        break block0;
                    }
                    case OM_PRIMITIVE_TYPE_DATE: {
                        Long epoch = (Long)actualValue.getPrimitiveValue();
                        igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, epoch.longValue(), epoch + 999L));
                        break block0;
                    }
                }
                String candidateValue = actualValue.getPrimitiveValue().toString();
                IGCSearchCondition regex = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addIGCSearchConditionFromValue", igcPropertyName, candidateValue);
                igcSearchConditionSet.addCondition(regex);
                break;
            }
            case ENUM: {
                igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, "=", ((EnumPropertyValue)value).getSymbolicName()));
                break;
            }
            case MAP: {
                Map mapValues = ((MapPropertyValue)value).getMapValues().getInstanceProperties();
                for (Map.Entry nextEntry : mapValues.entrySet()) {
                    IGCRepositoryHelper.addIGCSearchConditionFromValue(repositoryHelper, repositoryName, igcSearchConditionSet, (String)nextEntry.getKey(), (InstancePropertyValue)nextEntry.getValue());
                }
                break;
            }
            case ARRAY: {
                Map arrayValues = ((ArrayPropertyValue)value).getArrayValues().getInstanceProperties();
                for (Map.Entry nextEntry : arrayValues.entrySet()) {
                    IGCRepositoryHelper.addIGCSearchConditionFromValue(repositoryHelper, repositoryName, igcSearchConditionSet, igcPropertyName, (InstancePropertyValue)nextEntry.getValue());
                }
                break;
            }
            default: {
                log.warn("Unable to handle search criteria for value type: {}", (Object)category);
            }
        }
    }

    public static boolean equivalentValues(Object igcValue, InstancePropertyValue omrsValue) {
        if (igcValue == null && omrsValue == null) {
            return true;
        }
        if (igcValue == null || omrsValue == null) {
            return false;
        }
        InstancePropertyCategory category = omrsValue.getInstancePropertyCategory();
        switch (category) {
            case PRIMITIVE: {
                PrimitivePropertyValue actualValue = (PrimitivePropertyValue)omrsValue;
                PrimitiveDefCategory primitiveType = actualValue.getPrimitiveDefCategory();
                String igcValueAsString = "";
                String omrsValueAsString = "";
                switch (primitiveType) {
                    case OM_PRIMITIVE_TYPE_BOOLEAN: {
                        if (igcValue instanceof Boolean) {
                            return ((Boolean)igcValue).booleanValue() == ((Boolean)actualValue.getPrimitiveValue()).booleanValue();
                        }
                        return IGCRepositoryHelper.compareAsStrings(omrsValue, igcValue);
                    }
                    case OM_PRIMITIVE_TYPE_SHORT: {
                        if (igcValue instanceof Short) {
                            return ((Short)igcValue).intValue() == ((Short)actualValue.getPrimitiveValue()).intValue();
                        }
                        return IGCRepositoryHelper.compareAsStrings(omrsValue, igcValue);
                    }
                    case OM_PRIMITIVE_TYPE_INT: {
                        if (igcValue instanceof Integer) {
                            return ((Integer)igcValue).intValue() == ((Integer)actualValue.getPrimitiveValue()).intValue();
                        }
                        return IGCRepositoryHelper.compareAsStrings(omrsValue, igcValue);
                    }
                    case OM_PRIMITIVE_TYPE_LONG: {
                        if (igcValue instanceof Long) {
                            return ((Long)igcValue).longValue() == ((Long)actualValue.getPrimitiveValue()).longValue();
                        }
                        return IGCRepositoryHelper.compareAsStrings(omrsValue, igcValue);
                    }
                    case OM_PRIMITIVE_TYPE_FLOAT: {
                        if (igcValue instanceof Float) {
                            return ((Float)igcValue).floatValue() == ((Float)actualValue.getPrimitiveValue()).floatValue();
                        }
                        return IGCRepositoryHelper.compareAsStrings(omrsValue, igcValue);
                    }
                    case OM_PRIMITIVE_TYPE_DOUBLE: {
                        if (igcValue instanceof Double) {
                            return ((Double)igcValue).doubleValue() == ((Double)actualValue.getPrimitiveValue()).doubleValue();
                        }
                        return IGCRepositoryHelper.compareAsStrings(omrsValue, igcValue);
                    }
                    case OM_PRIMITIVE_TYPE_BIGINTEGER: 
                    case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                        if (igcValue instanceof BigInteger || igcValue instanceof BigDecimal) {
                            return igcValue.equals(actualValue.getPrimitiveValue());
                        }
                        return IGCRepositoryHelper.compareAsStrings(omrsValue, igcValue);
                    }
                    case OM_PRIMITIVE_TYPE_DATE: {
                        if (igcValue instanceof Long) {
                            return ((Long)igcValue).longValue() == ((Long)actualValue.getPrimitiveValue()).longValue();
                        }
                        if (igcValue instanceof Date) {
                            return ((Date)igcValue).getTime() == ((Long)actualValue.getPrimitiveValue()).longValue();
                        }
                        return IGCRepositoryHelper.compareAsStrings(omrsValue, igcValue);
                    }
                }
                return IGCRepositoryHelper.compareAsStrings(omrsValue, igcValue);
            }
            case ENUM: {
                String symbolicName = ((EnumPropertyValue)omrsValue).getSymbolicName();
                return igcValue.toString().equals(symbolicName);
            }
        }
        log.warn("Unable to handle value equivalency for value type: {}", (Object)category);
        return false;
    }

    private static boolean compareAsStrings(InstancePropertyValue omrsValue, Object igcValue) {
        if (omrsValue == null && igcValue == null) {
            return true;
        }
        if (omrsValue != null && igcValue == null) {
            return false;
        }
        if (omrsValue == null) {
            return false;
        }
        String omrsValueAsString = omrsValue.valueAsString();
        String igcValueAsString = igcValue.toString();
        return igcValueAsString.equals(omrsValueAsString);
    }

    public static IGCSearchCondition getRegexSearchCondition(OMRSRepositoryHelper repositoryHelper, String repositoryName, String methodName, String igcPropertyToSearch, String valueWithRegex) throws FunctionNotSupportedException {
        IGCSearchCondition igcSearchCondition;
        String igcValueToSearch = repositoryHelper.getUnqualifiedLiteralString(valueWithRegex);
        if (repositoryHelper.isContainsRegex(valueWithRegex)) {
            igcSearchCondition = new IGCSearchCondition(igcPropertyToSearch, "like %{0}%", igcValueToSearch);
        } else if (repositoryHelper.isStartsWithRegex(valueWithRegex)) {
            igcSearchCondition = new IGCSearchCondition(igcPropertyToSearch, "like {0}%", igcValueToSearch);
        } else if (repositoryHelper.isEndsWithRegex(valueWithRegex)) {
            igcSearchCondition = new IGCSearchCondition(igcPropertyToSearch, "like %{0}", igcValueToSearch);
        } else if (repositoryHelper.isExactMatchRegex(valueWithRegex)) {
            igcSearchCondition = new IGCSearchCondition(igcPropertyToSearch, "=", igcValueToSearch);
        } else {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.REGEX_NOT_IMPLEMENTED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(repositoryName, valueWithRegex);
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), IGCRepositoryHelper.class.getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return igcSearchCondition;
    }

    public static void addTypeSpecificConditions(EntityMapping mapping, MatchCriteria matchCriteria, InstanceProperties matchProperties, IGCSearchConditionSet igcSearchConditionSet) {
        IGCSearchConditionSet typeSpecificConditions;
        if ((matchCriteria.equals((Object)MatchCriteria.ALL) || matchCriteria.equals((Object)MatchCriteria.ANY) && (matchProperties == null || matchProperties.getPropertyCount() == 0)) && (typeSpecificConditions = mapping.getIGCSearchCriteria()).size() > 0) {
            igcSearchConditionSet.addNestedConditionSet(typeSpecificConditions);
            igcSearchConditionSet.setMatchAnyCondition(false);
        }
    }

    public OMRSStub getOMRSStubForAsset(String rid, String type) {
        String stubName = IGCRepositoryHelper.getStubNameForAsset(rid, type);
        IGCSearchCondition condition = new IGCSearchCondition("name", "=", stubName);
        String[] properties = new String[]{"$sourceRID", "$sourceType", "$payload"};
        IGCSearchConditionSet conditionSet = new IGCSearchConditionSet(condition);
        IGCSearch igcSearch = new IGCSearch("$OMRS-Stub", properties, conditionSet);
        ItemList results = this.igcRestClient.search(igcSearch);
        OMRSStub stub = null;
        if (results.getPaging().getNumTotal() > 0) {
            if (results.getPaging().getNumTotal() > 1) {
                log.warn("Found multiple stubs for asset, taking only the first: {}", (Object)stubName);
            }
            stub = (OMRSStub)((Object)results.getItems().get(0));
        } else {
            log.info("No stub found for asset: {}", (Object)stubName);
        }
        return stub;
    }

    public OMRSStub getOMRSStubForAsset(Reference asset) {
        return this.getOMRSStubForAsset(asset.getId(), asset.getType());
    }

    public String upsertOMRSStubForAsset(Reference asset) {
        String stubName = IGCRepositoryHelper.getStubNameFromAsset(asset);
        String payload = this.igcRestClient.getValueAsJSON(asset);
        StringWriter stringWriter = new StringWriter();
        try {
            XMLStreamWriter xmlStreamWriter = this.xmlOutputFactory.createXMLStreamWriter(stringWriter);
            xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            xmlStreamWriter.writeStartElement("doc");
            xmlStreamWriter.writeNamespace("xmlns", "http://www.ibm.com/iis/flow-doc");
            xmlStreamWriter.writeStartElement("assets");
            xmlStreamWriter.writeStartElement("asset");
            xmlStreamWriter.writeAttribute("class", "$OMRS-Stub");
            xmlStreamWriter.writeAttribute("repr", stubName);
            xmlStreamWriter.writeAttribute("ID", "stub1");
            this.addAttributeToAssetXML(xmlStreamWriter, "name", stubName);
            this.addAttributeToAssetXML(xmlStreamWriter, "$sourceType", asset.getType());
            this.addAttributeToAssetXML(xmlStreamWriter, "$sourceRID", asset.getId());
            this.addAttributeToAssetXML(xmlStreamWriter, "$payload", payload);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("importAction");
            xmlStreamWriter.writeAttribute("completeAssetIDs", "stub1");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.flush();
            xmlStreamWriter.close();
        }
        catch (XMLStreamException e) {
            log.error("Unable to write XML stream: {}", (Object)asset, (Object)e);
        }
        String stubXML = stringWriter.getBuffer().toString();
        log.debug("Constructed XML for stub: {}", (Object)stubName);
        String results = this.igcRestClient.upsertOpenIgcAsset(stubXML);
        return results.substring("stub1".length() + 5, results.length() - 2);
    }

    private void addAttributeToAssetXML(XMLStreamWriter xmlStreamWriter, String attrName, String attrValue) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("attribute");
        xmlStreamWriter.writeAttribute("name", attrName);
        xmlStreamWriter.writeAttribute("value", attrValue);
        xmlStreamWriter.writeEndElement();
    }

    public boolean deleteOMRSStubForAsset(String rid, String assetType) {
        String stubName = IGCRepositoryHelper.getStubNameForAsset(rid, assetType);
        StringWriter stringWriter = new StringWriter();
        try {
            XMLStreamWriter xmlStreamWriter = this.xmlOutputFactory.createXMLStreamWriter(stringWriter);
            xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            xmlStreamWriter.writeStartElement("doc");
            xmlStreamWriter.writeNamespace("xmlns", "http://www.ibm.com/iis/flow-doc");
            xmlStreamWriter.writeStartElement("assets");
            xmlStreamWriter.writeStartElement("asset");
            xmlStreamWriter.writeAttribute("class", "$OMRS-Stub");
            xmlStreamWriter.writeAttribute("repr", stubName);
            xmlStreamWriter.writeAttribute("ID", "stub1");
            this.addAttributeToAssetXML(xmlStreamWriter, "name", stubName);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("assetsToDelete");
            xmlStreamWriter.writeCharacters("stub1");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.flush();
            xmlStreamWriter.close();
        }
        catch (XMLStreamException e) {
            log.error("Unable to write XML stream.", (Throwable)e);
        }
        String stubXML = stringWriter.getBuffer().toString();
        log.debug("Constructed XML for stub deletion: {}", (Object)stubName);
        return this.igcRestClient.deleteOpenIgcAsset(stubXML);
    }

    private static String getStubNameFromAsset(Reference asset) {
        return IGCRepositoryHelper.getStubNameForAsset(asset.getId(), asset.getType());
    }

    private static String getStubNameForAsset(String rid, String assetType) {
        return assetType + "_" + rid;
    }

    public Reference getFullAssetDetails(String rid, String assetType) {
        Reference fullAsset = null;
        if (assetType != null) {
            if (assetType.equals(DEFAULT_IGC_TYPE)) {
                log.debug("Received 'main_object' as type, looking up basic ref to determine actual type.");
                fullAsset = this.igcRestClient.getAssetRefById(rid);
                if (fullAsset != null) {
                    assetType = fullAsset.getType();
                }
            }
            if (!assetType.equals(DEFAULT_IGC_TYPE)) {
                List allProps = this.igcRestClient.getAllPropertiesForType(assetType);
                if (allProps != null) {
                    fullAsset = this.igcRestClient.getAssetWithSubsetOfProperties(rid, assetType, allProps, this.igcRestClient.getDefaultPageSize());
                    if (fullAsset != null) {
                        List allPaged = this.igcRestClient.getPagedRelationshipPropertiesForType(assetType);
                        for (String pagedProperty : allPaged) {
                            Object shouldBeItemList = this.igcRestClient.getPropertyByName(fullAsset, pagedProperty);
                            if (!(shouldBeItemList instanceof ItemList)) continue;
                            ItemList pagedValue = (ItemList)shouldBeItemList;
                            pagedValue.getAllPages(this.igcRestClient);
                        }
                        fullAsset.setFullyRetrieved();
                    }
                } else {
                    log.info("No registered POJO for asset type {} -- returning basic reference.", (Object)assetType);
                    fullAsset = this.igcRestClient.getAssetRefById(rid);
                }
            } else {
                log.info("Object retrieved remained 'main_object' -- returning: {}", (Object)fullAsset);
            }
        } else {
            fullAsset = this.igcRestClient.getAssetRefById(rid);
            if (fullAsset == null) {
                log.info("Unable to retrieve any asset with RID {} -- assume it was deleted.", (Object)rid);
            } else {
                log.info("No asset type provided -- returning basic reference.");
            }
        }
        return fullAsset;
    }

    public static IGCSearchSorting sortFromNonPropertySequencingOrder(SequencingOrder sequencingOrder) {
        IGCSearchSorting sort = null;
        if (sequencingOrder != null) {
            switch (sequencingOrder) {
                case GUID: {
                    sort = new IGCSearchSorting("_id");
                    break;
                }
                case CREATION_DATE_RECENT: {
                    sort = new IGCSearchSorting("created_on", Boolean.valueOf(false));
                    break;
                }
                case CREATION_DATE_OLDEST: {
                    sort = new IGCSearchSorting("created_on", Boolean.valueOf(true));
                    break;
                }
                case LAST_UPDATE_RECENT: {
                    sort = new IGCSearchSorting("modified_on", Boolean.valueOf(false));
                    break;
                }
                case LAST_UPDATE_OLDEST: {
                    sort = new IGCSearchSorting("modified_on", Boolean.valueOf(true));
                    break;
                }
                default: {
                    sort = null;
                }
            }
        }
        return sort;
    }

    public static void addReferencesToList(IGCRestClient igcRestClient, List<Reference> list, Object candidate) {
        if (candidate instanceof Reference) {
            Reference reference = (Reference)candidate;
            if (reference.getType() != null) {
                list.add(reference);
            }
        } else if (candidate instanceof ItemList) {
            ItemList references = (ItemList)candidate;
            references.getAllPages(igcRestClient);
            list.addAll(references.getItems());
        }
    }

    private void raiseRepositoryErrorException(IGCOMRSErrorCode errorCode, String methodName, String ... params) throws RepositoryErrorException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void raiseEntityNotKnownException(String methodName, String ... params) throws EntityNotKnownException {
        IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.ENTITY_NOT_KNOWN;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

