/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;

public abstract class InstanceMapping {
    private Map<String, Object> literalOmrsPropertyMapping = new HashMap<String, Object>();

    public void addLiteralPropertyMapping(String omrsPropertyName, Object value) {
        this.literalOmrsPropertyMapping.put(omrsPropertyName, value);
    }

    public Set<String> getLiteralPropertyMappings() {
        return this.literalOmrsPropertyMapping.keySet();
    }

    public Object getOmrsPropertyLiteralValue(String omrsPropertyName) {
        Object value = null;
        if (this.literalOmrsPropertyMapping.containsKey(omrsPropertyName)) {
            value = this.literalOmrsPropertyMapping.get(omrsPropertyName);
        }
        return value;
    }

    public boolean isOmrsPropertyLiteralMapped(String omrsPropertyName) {
        return this.literalOmrsPropertyMapping.containsKey(omrsPropertyName);
    }

    public abstract Set<String> getMappedOmrsPropertyNames();

    public static SearchFilter getAllNoneOrSome(InstanceMapping mapping, InstanceProperties matchProperties, MatchCriteria matchCriteria) {
        SearchFilter filter = SearchFilter.SOME;
        if (matchProperties != null) {
            Set<String> mappedOmrsProperties = mapping.getMappedOmrsPropertyNames();
            HashMap propertiesToMatch = matchProperties.getInstanceProperties();
            if (propertiesToMatch == null) {
                propertiesToMatch = new HashMap();
            }
            if (!mappedOmrsProperties.containsAll(propertiesToMatch.keySet()) && matchCriteria.equals((Object)MatchCriteria.ALL)) {
                filter = SearchFilter.NONE;
            } else {
                boolean allValuesAreUnequal = true;
                for (Map.Entry entry : propertiesToMatch.entrySet()) {
                    String omrsPropertyName = (String)entry.getKey();
                    if (!mapping.isOmrsPropertyLiteralMapped(omrsPropertyName)) continue;
                    Object literalValue = mapping.getOmrsPropertyLiteralValue(omrsPropertyName);
                    boolean valuesAreEqual = IGCRepositoryHelper.equivalentValues(literalValue, (InstancePropertyValue)entry.getValue());
                    if (valuesAreEqual && !matchCriteria.equals((Object)MatchCriteria.ALL)) {
                        filter = matchCriteria.equals((Object)MatchCriteria.NONE) ? SearchFilter.NONE : SearchFilter.ALL;
                        allValuesAreUnequal = false;
                        break;
                    }
                    if (valuesAreEqual || !matchCriteria.equals((Object)MatchCriteria.ALL)) continue;
                    filter = SearchFilter.NONE;
                    break;
                }
                if (allValuesAreUnequal && matchCriteria.equals((Object)MatchCriteria.NONE)) {
                    filter = SearchFilter.ALL;
                }
            }
        }
        return filter;
    }

    public static enum SearchFilter {
        ALL,
        NONE,
        SOME;

    }
}

