/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.InstanceMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.AttributeMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityMapping
extends InstanceMapping {
    private static final Logger log = LoggerFactory.getLogger(EntityMapping.class);
    private String igcAssetType;
    private String igcAssetTypeDisplayName;
    private String omrsTypeDefName;
    private String igcRidPrefix;
    private ArrayList<String> otherIgcTypes;
    public static final String COMPLEX_MAPPING_SENTINEL = "__COMPLEX_PROPERTY__";
    public static final String LITERAL_MAPPING_SENTINEL = "__LITERAL_MAPPING__";
    private Map<String, PropertyMapping> mappingByIgcProperty;
    private Map<String, PropertyMapping> mappingByOmrsProperty;
    private HashSet<String> complexIgcProperties;
    private HashSet<String> complexOmrsProperties;
    private ArrayList<RelationshipMapping> relationshipMappers;
    private ArrayList<ClassificationMapping> classificationMappers;
    private ArrayList<InstanceStatus> omrsSupportedStatuses;

    EntityMapping(String igcAssetType, String igcAssetTypeDisplayName, String omrsTypeDefName, String igcRidPrefix) {
        this.igcAssetType = igcAssetType;
        this.igcAssetTypeDisplayName = igcAssetTypeDisplayName;
        this.omrsTypeDefName = omrsTypeDefName;
        this.igcRidPrefix = igcRidPrefix;
        this.mappingByIgcProperty = new HashMap<String, PropertyMapping>();
        this.mappingByOmrsProperty = new HashMap<String, PropertyMapping>();
        this.complexIgcProperties = new HashSet();
        this.complexOmrsProperties = new HashSet();
        this.relationshipMappers = new ArrayList();
        this.classificationMappers = new ArrayList();
        this.omrsSupportedStatuses = new ArrayList();
        this.addSupportedStatus(InstanceStatus.ACTIVE);
        this.addSupportedStatus(InstanceStatus.DELETED);
        this.otherIgcTypes = new ArrayList();
    }

    private void addSupportedStatus(InstanceStatus status) {
        this.omrsSupportedStatuses.add(status);
    }

    public final List<InstanceStatus> getSupportedStatuses() {
        return this.omrsSupportedStatuses;
    }

    public final String getIgcAssetType() {
        return this.igcAssetType;
    }

    public final String getIgcAssetTypeDisplayName() {
        return this.igcAssetTypeDisplayName;
    }

    public final boolean igcRidNeedsPrefix() {
        return this.igcRidPrefix != null;
    }

    public final String getIgcRidPrefix() {
        return this.igcRidPrefix;
    }

    public final String getOmrsTypeDefName() {
        return this.omrsTypeDefName;
    }

    public final boolean matchesAssetType(String igcAssetType) {
        String matchType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
        return this.igcAssetType.equals(matchType) || this.igcAssetType.equals("main_object");
    }

    public boolean isOmrsType(IGCRestClient igcRestClient, Reference igcObject) {
        return true;
    }

    final void addOtherIGCAssetType(String igcAssetTypeName) {
        this.otherIgcTypes.add(igcAssetTypeName);
    }

    public final List<String> getOtherIGCAssetTypes() {
        return this.otherIgcTypes;
    }

    public final void addSimplePropertyMapping(String igcPropertyName, String omrsPropertyName) {
        if (igcPropertyName != null && omrsPropertyName != null) {
            PropertyMapping pm = new PropertyMapping(igcPropertyName, omrsPropertyName);
            this.mappingByOmrsProperty.put(omrsPropertyName, pm);
            this.mappingByIgcProperty.put(igcPropertyName, pm);
        } else {
            log.warn("Attempted to add null property to mapping -- IGC = {}, OMRS = {}", (Object)igcPropertyName, (Object)omrsPropertyName);
        }
    }

    public final void addComplexIgcProperty(String igcPropertyName) {
        if (igcPropertyName != null) {
            this.complexIgcProperties.add(igcPropertyName);
        } else {
            log.warn("Attempted to add null property to mapping -- IGC.");
        }
    }

    final void addComplexOmrsProperty(String omrsPropertyName) {
        if (omrsPropertyName != null) {
            this.complexOmrsProperties.add(omrsPropertyName);
        } else {
            log.warn("Attempted to add null property to mapping -- OMRS.");
        }
    }

    public Set<String> getSimpleMappedIgcProperties() {
        return this.mappingByIgcProperty.keySet();
    }

    public final Set<String> getComplexMappedIgcProperties() {
        return this.complexIgcProperties;
    }

    public final Set<String> getAllMappedIgcProperties() {
        HashSet<String> igcProperties = new HashSet<String>(this.getSimpleMappedIgcProperties());
        if (this.getComplexMappedIgcProperties() != null) {
            igcProperties.addAll(this.getComplexMappedIgcProperties());
        }
        return igcProperties;
    }

    private Set<String> getSimpleMappedOmrsProperties() {
        return this.mappingByOmrsProperty.keySet();
    }

    protected Set<String> getComplexMappedOmrsProperties() {
        return this.complexOmrsProperties;
    }

    public final Set<String> getWriteableMappedOmrsProperties() {
        HashSet<String> omrsProperties = new HashSet<String>(this.getSimpleMappedOmrsProperties());
        omrsProperties.addAll(this.getComplexMappedOmrsProperties());
        return omrsProperties;
    }

    @Override
    public Set<String> getMappedOmrsPropertyNames() {
        HashSet<String> omrsProperties = new HashSet<String>(this.getSimpleMappedOmrsProperties());
        if (this.getComplexMappedOmrsProperties() != null) {
            omrsProperties.addAll(this.getComplexMappedOmrsProperties());
        }
        if (this.getLiteralPropertyMappings() != null) {
            omrsProperties.addAll(this.getLiteralPropertyMappings());
        }
        return omrsProperties;
    }

    public final String getIgcPropertyName(String omrsPropertyName) {
        String igcPropertyName = null;
        if (this.isOmrsPropertySimpleMapped(omrsPropertyName)) {
            igcPropertyName = this.mappingByOmrsProperty.get(omrsPropertyName).getIgcPropertyName();
        } else if (this.isOmrsPropertyComplexMapped(omrsPropertyName)) {
            igcPropertyName = COMPLEX_MAPPING_SENTINEL;
        } else if (this.isOmrsPropertyLiteralMapped(omrsPropertyName)) {
            igcPropertyName = LITERAL_MAPPING_SENTINEL;
        }
        return igcPropertyName;
    }

    public final String getOmrsPropertyName(String igcPropertyName) {
        String omrsPropertyName = null;
        if (this.isIgcPropertySimpleMapped(igcPropertyName)) {
            omrsPropertyName = this.mappingByIgcProperty.get(igcPropertyName).getOmrsPropertyName();
        } else if (this.isIgcPropertyComplexMapped(igcPropertyName)) {
            omrsPropertyName = COMPLEX_MAPPING_SENTINEL;
        }
        return omrsPropertyName;
    }

    private boolean isIgcPropertySimpleMapped(String igcPropertyName) {
        return this.mappingByIgcProperty.containsKey(igcPropertyName);
    }

    private boolean isIgcPropertyComplexMapped(String igcPropertyName) {
        return this.complexIgcProperties.contains(igcPropertyName);
    }

    private boolean isOmrsPropertySimpleMapped(String omrsPropertyName) {
        return this.mappingByOmrsProperty.containsKey(omrsPropertyName);
    }

    private boolean isOmrsPropertyComplexMapped(String omrsPropertyName) {
        return this.complexOmrsProperties.contains(omrsPropertyName);
    }

    public final void addRelationshipMapper(RelationshipMapping relationshipMapping) {
        this.relationshipMappers.add(relationshipMapping);
    }

    public final List<RelationshipMapping> getRelationshipMappers() {
        return this.relationshipMappers;
    }

    public final void addClassificationMapper(ClassificationMapping classificationMapping) {
        this.classificationMappers.add(classificationMapping);
    }

    public final List<ClassificationMapping> getClassificationMappers() {
        return this.classificationMappers;
    }

    public Reference getBaseIgcAssetFromAlternative(String igcAssetType, String igcRid, IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        Reference simple = new Reference();
        simple.setId(igcRid);
        simple.setType(igcAssetType);
        return simple;
    }

    protected InstanceProperties complexPropertyMappings(EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        return instanceProperties;
    }

    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, InstancePropertyValue value) throws FunctionNotSupportedException {
    }

    public void addComplexStringSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String searchCriteria) throws FunctionNotSupportedException {
    }

    public IGCSearchConditionSet getIGCSearchCriteria() {
        return new IGCSearchConditionSet();
    }

    private static void setupEntityObj(EntityMappingInstance entityMap, EntitySummary omrsObj) {
        Reference igcEntity = entityMap.getIgcEntity();
        EntityMapping mapping = entityMap.getMapping();
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        String userId = entityMap.getUserId();
        if (igcRestClient.hasModificationDetails(igcEntity.getType())) {
            omrsObj.setCreatedBy((String)igcRestClient.getPropertyByName(igcEntity, "created_by"));
            omrsObj.setCreateTime((Date)igcRestClient.getPropertyByName(igcEntity, "created_on"));
            omrsObj.setUpdatedBy((String)igcRestClient.getPropertyByName(igcEntity, "modified_by"));
            omrsObj.setUpdateTime((Date)igcRestClient.getPropertyByName(igcEntity, "modified_on"));
            if (omrsObj.getUpdateTime() != null) {
                omrsObj.setVersion(omrsObj.getUpdateTime().getTime());
            }
        }
        List<Classification> omrsClassifications = entityMap.getOmrsClassifications();
        List<ClassificationMapping> classificationMappings = mapping.getClassificationMappers();
        if (!classificationMappings.isEmpty() && omrsClassifications.isEmpty()) {
            for (ClassificationMapping classificationMapping : classificationMappings) {
                classificationMapping.addMappedOMRSClassifications(igcomrsRepositoryConnector, omrsClassifications, igcEntity, userId);
            }
        }
        omrsObj.setClassifications(omrsClassifications);
    }

    public final List<String> getAllPropertiesForEntitySummary(IGCRestClient igcRestClient, String igcAssetType) {
        HashSet<String> allProperties = new HashSet<String>();
        for (ClassificationMapping classificationMapping : this.getClassificationMappers()) {
            Set<String> classificationProperties = classificationMapping.getMappedIgcPropertyNames();
            if (classificationProperties == null) continue;
            allProperties.addAll(classificationProperties);
        }
        allProperties.addAll(this.getAllMappedIgcProperties());
        List allKnownProperties = igcRestClient.getAllPropertiesForType(igcAssetType);
        allProperties.retainAll(allKnownProperties);
        return new ArrayList<String>(allProperties);
    }

    public static final EntitySummary getEntitySummary(EntityMappingInstance entityMap) {
        EntityMapping mapping = entityMap.getMapping();
        IGCRestClient igcRestClient = entityMap.getRepositoryConnector().getIGCRestClient();
        if (!entityMap.isIgcEntityAlreadyRetrieved()) {
            entityMap.setPropertiesToRetrieveForIgcEntity(mapping.getAllPropertiesForEntitySummary(igcRestClient, entityMap.getIgcEntityType()));
        }
        entityMap.initializeEntitySummary();
        EntitySummary preliminary = entityMap.getOmrsSummary();
        if (preliminary != null) {
            EntityMapping.setupEntityObj(entityMap, preliminary);
        }
        return entityMap.getOmrsSummary();
    }

    public final List<String> getAllPropertiesForEntityDetail(IGCRestClient igcRestClient, String igcAssetType) {
        HashSet<String> allProperties = new HashSet<String>(this.getAllMappedIgcProperties());
        for (ClassificationMapping classificationMapping : this.getClassificationMappers()) {
            Set<String> classificationProperties = classificationMapping.getMappedIgcPropertyNames();
            if (classificationProperties == null) continue;
            allProperties.addAll(classificationProperties);
        }
        List nonRelationshipProperties = igcRestClient.getNonRelationshipPropertiesForType(igcAssetType);
        if (nonRelationshipProperties != null) {
            allProperties.addAll(nonRelationshipProperties);
        }
        List allKnownProperties = igcRestClient.getAllPropertiesForType(igcAssetType);
        allProperties.retainAll(allKnownProperties);
        return new ArrayList<String>(allProperties);
    }

    public static final EntityDetail getEntityDetail(EntityMappingInstance entityMap) {
        EntityMapping mapping = entityMap.getMapping();
        IGCRestClient igcRestClient = entityMap.getRepositoryConnector().getIGCRestClient();
        if (!entityMap.isIgcEntityAlreadyRetrieved()) {
            entityMap.setPropertiesToRetrieveForIgcEntity(mapping.getAllPropertiesForEntityDetail(igcRestClient, entityMap.getIgcEntityType()));
        }
        entityMap.initializeEntityDetail();
        EntityDetail preliminary = entityMap.getOmrsDetail();
        if (preliminary != null) {
            EntityMapping.setupEntityObj(entityMap, (EntitySummary)preliminary);
            InstanceProperties instanceProperties = EntityMapping.getMappedInstanceProperties(entityMap);
            entityMap.updateOmrsDetailWithProperties(instanceProperties);
        }
        return entityMap.getOmrsDetail();
    }

    private static InstanceProperties getMappedInstanceProperties(EntityMappingInstance entityMap) {
        TypeDefAttribute typeDefAttribute;
        String methodName = "getMappedInstanceProperties";
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCOMRSMetadataCollection igcomrsMetadataCollection = entityMap.getMetadataCollection();
        OMRSRepositoryHelper omrsRepositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        Reference igcEntity = entityMap.getIgcEntity();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        EntityMapping mapping = entityMap.getMapping();
        String omrsTypeDefName = mapping.getOmrsTypeDefName();
        Map<String, TypeDefAttribute> omrsAttributeMap = igcomrsMetadataCollection.getTypeDefAttributesForType(omrsTypeDefName);
        InstanceProperties instanceProperties = new InstanceProperties();
        for (String igcPropertyName : mapping.getSimpleMappedIgcProperties()) {
            String omrsAttribute = mapping.getOmrsPropertyName(igcPropertyName);
            if (omrsAttributeMap.containsKey(omrsAttribute)) {
                typeDefAttribute = omrsAttributeMap.get(omrsAttribute);
                instanceProperties = AttributeMapping.addPrimitivePropertyToInstance(omrsRepositoryHelper, repositoryName, instanceProperties, typeDefAttribute, igcRestClient.getPropertyByName(igcEntity, igcPropertyName), "getMappedInstanceProperties");
                continue;
            }
            log.warn("No OMRS attribute {} defined for asset type {} -- skipping mapping.", (Object)omrsAttribute, (Object)omrsTypeDefName);
        }
        for (String omrsPropertyName : mapping.getLiteralPropertyMappings()) {
            Object value;
            if (!omrsAttributeMap.containsKey(omrsPropertyName) || (value = mapping.getOmrsPropertyLiteralValue(omrsPropertyName)) == null) continue;
            typeDefAttribute = omrsAttributeMap.get(omrsPropertyName);
            AttributeTypeDefCategory attributeTypeDefCategory = typeDefAttribute.getAttributeType().getCategory();
            if (attributeTypeDefCategory == AttributeTypeDefCategory.PRIMITIVE) {
                instanceProperties = AttributeMapping.addPrimitivePropertyToInstance(omrsRepositoryHelper, repositoryName, instanceProperties, typeDefAttribute, value, "getMappedInstanceProperties");
                continue;
            }
            instanceProperties.setProperty(omrsPropertyName, (InstancePropertyValue)value);
        }
        mapping.complexPropertyMappings(entityMap, instanceProperties);
        return instanceProperties;
    }

    public static final List<Relationship> getMappedRelationships(IGCEntityGuid igcGuid, EntityMappingInstance entityMap, String relationshipTypeGUID, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize) throws EntityNotKnownException {
        String methodName = "getMappedRelationships";
        entityMap.initializeWithRelationships(sequencingOrder, pageSize);
        Reference igcEntity = entityMap.getIgcEntity();
        if (igcEntity == null) {
            IGCOMRSErrorCode errorCode = IGCOMRSErrorCode.ENTITY_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(igcGuid.toString(), "null", entityMap.getRepositoryConnector().getRepositoryName());
            throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), EntityMapping.class.getName(), "getMappedRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        EntityMapping entityMapping = entityMap.getMapping();
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        String userId = entityMap.getUserId();
        List<Relationship> omrsRelationships = entityMap.getOmrsRelationships();
        List<RelationshipMapping> relationshipMappers = entityMapping.getRelationshipMappers();
        RelationshipMapping.getMappedRelationships(igcomrsRepositoryConnector, omrsRelationships, relationshipMappers, relationshipTypeGUID, igcEntity, userId);
        return omrsRelationships;
    }

    public static final class PropertyMapping {
        private String igcPropertyName;
        private String omrsPropertyName;

        public PropertyMapping(String igcPropertyName, String omrsPropertyName) {
            this.igcPropertyName = igcPropertyName;
            this.omrsPropertyName = omrsPropertyName;
        }

        public String getIgcPropertyName() {
            return this.igcPropertyName;
        }

        public String getOmrsPropertyName() {
            return this.omrsPropertyName;
        }
    }
}

