/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class GovernanceDefinition_Mapper
extends ReferenceableMapper {
    public static GovernanceDefinition_Mapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    private GovernanceDefinition_Mapper() {
        super("", "", "GovernanceDefinition");
    }

    protected GovernanceDefinition_Mapper(String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName) {
        super(igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName);
        this.addSimplePropertyMapping("name", "title");
        this.addSimplePropertyMapping("short_description", "summary");
        this.addSimplePropertyMapping("long_description", "description");
        this.addComplexIgcProperty("parent_policy");
        this.addComplexOmrsProperty("domain");
        this.addLiteralPropertyMapping("scope", null);
        this.addLiteralPropertyMapping("priority", null);
        this.addLiteralPropertyMapping("implications", null);
        this.addLiteralPropertyMapping("outcomes", null);
        this.addLiteralPropertyMapping("results", null);
    }

    @Override
    protected InstanceProperties complexPropertyMappings(EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        instanceProperties = super.complexPropertyMappings(entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        Reference igcEntity = entityMap.getIgcEntity();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        Reference parentPolicy = (Reference)igcRestClient.getPropertyByName(igcEntity, "parent_policy");
        if (parentPolicy != null) {
            instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "domain", parentPolicy.getName(), "complexPropertyMappings");
        }
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, InstancePropertyValue value) throws FunctionNotSupportedException {
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, value);
        String methodName = "addComplexPropertySearchCriteria";
        if (omrsPropertyName.equals("domain") && value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE)) {
            String domain = value.valueAsString();
            IGCSearchCondition condition = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", "parent_policy.name", domain);
            igcSearchConditionSet.addCondition(condition);
        }
    }

    private static class Singleton {
        private static final GovernanceDefinition_Mapper INSTANCE = new GovernanceDefinition_Mapper();

        private Singleton() {
        }
    }
}

