/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Term;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.GlossaryMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermAnchorMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(TermAnchorMapper.class);

    public static TermAnchorMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    private TermAnchorMapper() {
        super("category", "term", "terms", "parent_category", "TermAnchor", "anchor", "terms", "GL", null);
        this.setOptimalStart(RelationshipMapping.OptimalStart.CUSTOM);
        this.setContainedType(RelationshipMapping.ContainedType.TWO);
    }

    @Override
    public List<Reference> getProxyOneAssetFromAsset(Reference term, IGCRestClient igcRestClient) {
        String assetType = term.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (assetType.equals("term")) {
            Identity termIdentity = term.getIdentity(igcRestClient);
            if (termIdentity != null) {
                Identity rootIdentity = termIdentity.getUltimateParentIdentity();
                Reference root = new Reference(rootIdentity.getName(), rootIdentity.getAssetType(), rootIdentity.getRid());
                asList.add(root);
            } else {
                log.error("Term has no identity: {}", (Object)term);
            }
        } else {
            log.warn("Not a term asset, just returning as-is: {}", (Object)term);
            asList.add(term);
        }
        return asList;
    }

    @Override
    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, Reference toIgcObject, String userId) {
        String assetType = IGCRestConstants.getAssetTypeForSearch((String)fromIgcObject.getType());
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        RelationshipDef relationshipDef = (RelationshipDef)repositoryHelper.getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), "TermAnchor");
        if (GlossaryMapper.isGlossary(igcRestClient, fromIgcObject)) {
            IGCSearchCondition byParent;
            IGCSearchCondition byCatPath;
            IGCSearchConditionSet conditionSet = new IGCSearchConditionSet();
            if (toIgcObject == null) {
                log.debug("Looking for all offspring terms from: {} of type {}", (Object)fromIgcObject.getName(), (Object)fromIgcObject.getType());
                byCatPath = new IGCSearchCondition("parent_category.category_path", "=", fromIgcObject.getId());
                byParent = new IGCSearchCondition("parent_category", "=", fromIgcObject.getId());
                conditionSet.addCondition(byCatPath);
                conditionSet.addCondition(byParent);
                conditionSet.setMatchAnyCondition(true);
            } else {
                log.debug("Looking for single terms for: {} of type {}", (Object)toIgcObject.getName(), (Object)toIgcObject.getType());
                byCatPath = new IGCSearchCondition("parent_category.category_path", "=", fromIgcObject.getId());
                byParent = new IGCSearchCondition("parent_category", "=", fromIgcObject.getId());
                IGCSearchCondition byTerm = new IGCSearchCondition("_id", "=", toIgcObject.getId());
                IGCSearchConditionSet inGlossary = new IGCSearchConditionSet(byCatPath);
                inGlossary.addCondition(byParent);
                inGlossary.setMatchAnyCondition(true);
                IGCSearchConditionSet byTermCS = new IGCSearchConditionSet(byTerm);
                conditionSet.addNestedConditionSet(byTermCS);
                conditionSet.addNestedConditionSet(inGlossary);
                conditionSet.setMatchAnyCondition(false);
            }
            IGCSearch igcSearch = new IGCSearch("term", IGCRestConstants.getModificationProperties(), conditionSet);
            ItemList terms = igcRestClient.search(igcSearch);
            if (terms != null) {
                terms.getAllPages(igcRestClient);
                log.debug(" ... found a total of {} offspring terms.", (Object)terms.getItems().size());
                for (Term term : terms.getItems()) {
                    try {
                        Relationship relationship = TermAnchorMapper.getMappedRelationship(igcomrsRepositoryConnector, TermAnchorMapper.getInstance(null), relationshipDef, fromIgcObject, (Reference)term, "terms", userId, null, true);
                        relationships.add(relationship);
                    }
                    catch (RepositoryErrorException e) {
                        log.error("Unable to map downward relationship.", (Throwable)e);
                    }
                }
            }
        } else if (assetType.equals("term")) {
            Identity catIdentity = fromIgcObject.getIdentity(igcRestClient);
            Identity rootIdentity = catIdentity.getUltimateParentIdentity();
            Reference root = igcRestClient.getAssetWithSubsetOfProperties(rootIdentity.getRid(), rootIdentity.getAssetType(), IGCRestConstants.getModificationProperties());
            if (root != null) {
                log.debug("Mapping ultimate parent category from: {} of type {}", (Object)fromIgcObject.getName(), (Object)fromIgcObject.getType());
                try {
                    Relationship relationship = TermAnchorMapper.getMappedRelationship(igcomrsRepositoryConnector, TermAnchorMapper.getInstance(null), relationshipDef, root, fromIgcObject, "parent_category", userId, null, true);
                    relationships.add(relationship);
                }
                catch (RepositoryErrorException e) {
                    log.error("Unable to map upward relationship.", (Throwable)e);
                }
            } else {
                log.error("Unable to find root-level category with identity: {}", (Object)rootIdentity);
            }
        } else {
            log.warn("Found unexpected asset type during relationship mapping: {}", (Object)fromIgcObject);
        }
    }

    @Override
    public boolean includeRelationshipForIgcObjects(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference oneObject, Reference otherObject) {
        log.debug("Considering inclusion of objects: {} ({}) and {} ({})", new Object[]{oneObject.getName(), oneObject.getType(), otherObject.getName(), otherObject.getType()});
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        return GlossaryMapper.isGlossary(igcRestClient, oneObject) && otherObject.getType().equals("term") || oneObject.getType().equals("term") && GlossaryMapper.isGlossary(igcRestClient, otherObject);
    }

    private static class Singleton {
        private static final TermAnchorMapper INSTANCE = new TermAnchorMapper();

        private Singleton() {
        }
    }
}

