/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.eventmapper.IGCOMRSRepositoryEventMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.InstanceMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCRelationshipGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.AttributeMappingStore;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGCOMRSMetadataCollection
extends OMRSMetadataCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(IGCOMRSMetadataCollection.class);
    private IGCRestClient igcRestClient;
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private IGCRepositoryHelper igcRepositoryHelper;
    private IGCOMRSRepositoryEventMapper eventMapper = null;
    private TypeDefStore typeDefStore;
    private AttributeMappingStore attributeMappingStore;
    private String mappingPackage;

    public IGCOMRSMetadataCollection(IGCOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId) {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        log.debug("Constructing IGCOMRSMetadataCollection with name: {}", (Object)repositoryName);
        parentConnector.setRepositoryName(repositoryName);
        this.igcRestClient = parentConnector.getIGCRestClient();
        this.igcomrsRepositoryConnector = parentConnector;
        this.igcRepositoryHelper = new IGCRepositoryHelper(this.igcomrsRepositoryConnector, repositoryHelper, this.igcRestClient);
        this.typeDefStore = new TypeDefStore();
        this.attributeMappingStore = new AttributeMappingStore(parentConnector);
        this.mappingPackage = "org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.";
    }

    public IGCRepositoryHelper getIgcRepositoryHelper() {
        return this.igcRepositoryHelper;
    }

    public void setMappingPackage(String mappingPackage) {
        this.mappingPackage = mappingPackage;
    }

    public String getMappingPackage() {
        return this.mappingPackage;
    }

    public TypeDefGallery getAllTypes(String userId) throws RepositoryErrorException, InvalidParameterException {
        String methodName = "getAllTypes";
        super.basicRequestValidation(userId, "getAllTypes");
        TypeDefGallery typeDefGallery = new TypeDefGallery();
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        log.debug("Retrieved {} implemented TypeDefs for this repository.", (Object)typeDefs.size());
        typeDefGallery.setTypeDefs(typeDefs);
        List<AttributeTypeDef> attributeTypeDefs = this.attributeMappingStore.getAllAttributeTypeDefs();
        log.debug("Retrieved {} implemented AttributeTypeDefs for this repository.", (Object)attributeTypeDefs.size());
        typeDefGallery.setAttributeTypeDefs(attributeTypeDefs);
        return typeDefGallery;
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        super.typeDefCategoryParameterValidation(userId, category, "category", "findTypeDefsByCategory");
        List<TypeDef> typeDefs = new ArrayList<TypeDef>();
        switch (category) {
            case ENTITY_DEF: {
                typeDefs = this.igcRepositoryHelper.getMappedEntityTypes();
                break;
            }
            case RELATIONSHIP_DEF: {
                typeDefs = this.igcRepositoryHelper.getMappedRelationshipTypes();
                break;
            }
            case CLASSIFICATION_DEF: {
                typeDefs = this.igcRepositoryHelper.getMappedClassificationTypes();
            }
        }
        return typeDefs;
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        super.attributeTypeDefCategoryParameterValidation(userId, category, "category", "findAttributeTypeDefsByCategory");
        return this.attributeMappingStore.getAttributeTypeDefsByCategory(category);
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "findTypeDefsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        super.typeDefPropertyParameterValidation(userId, matchCriteria, "matchCriteria", "findTypeDefsByProperty");
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        ArrayList<TypeDef> results = new ArrayList();
        Map properties = matchCriteria.getTypeDefProperties();
        if (properties != null && !properties.isEmpty()) {
            for (TypeDef candidate : typeDefs) {
                List candidateProperties = candidate.getPropertiesDefinition();
                if (candidateProperties == null) continue;
                for (TypeDefAttribute candidateAttribute : candidateProperties) {
                    String candidateName = candidateAttribute.getAttributeName();
                    if (!properties.containsKey(candidateName)) continue;
                    results.add(candidate);
                }
            }
        } else {
            results = typeDefs;
        }
        return results;
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "searchForTypeDefs";
        String searchCriteriaParameterName = "searchCriteria";
        super.typeDefSearchParameterValidation(userId, searchCriteria, "searchCriteria", "searchForTypeDefs");
        ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>();
        for (TypeDef candidate : this.igcRepositoryHelper.getMappedEntityTypes()) {
            if (!candidate.getName().matches(searchCriteria)) continue;
            typeDefs.add(candidate);
        }
        for (TypeDef candidate : this.igcRepositoryHelper.getMappedRelationshipTypes()) {
            if (!candidate.getName().matches(searchCriteria)) continue;
            typeDefs.add(candidate);
        }
        for (TypeDef candidate : this.igcRepositoryHelper.getMappedClassificationTypes()) {
            if (!candidate.getName().matches(searchCriteria)) continue;
            typeDefs.add(candidate);
        }
        return typeDefs;
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getTypeDefByGUID");
        TypeDef found = this.typeDefStore.getTypeDefByGUID(guid);
        if (found == null) {
            this.raiseTypeDefNotKnownException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, "getTypeDefByGUID", guid, this.repositoryName);
        }
        return found;
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getAttributeTypeDefByGUID");
        AttributeTypeDef found = this.attributeMappingStore.getAttributeTypeDefByGUID(guid);
        if (found == null) {
            this.raiseTypeDefNotKnownException(IGCOMRSErrorCode.ATTRIBUTE_TYPEDEF_NOT_MAPPED, "getAttributeTypeDefByGUID", guid, this.repositoryName);
        }
        return found;
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "getTypeDefByName");
        TypeDef found = this.typeDefStore.getTypeDefByName(name);
        if (found == null) {
            this.raiseTypeDefNotKnownException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, "getTypeDefByName", name, this.repositoryName);
        }
        return found;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "getAttributeTypeDefByName");
        AttributeTypeDef found = this.attributeMappingStore.getAttributeTypeDefByName(name);
        if (found == null) {
            this.raiseTypeDefNotKnownException(IGCOMRSErrorCode.ATTRIBUTE_TYPEDEF_NOT_MAPPED, "getAttributeTypeDefByName", name, this.repositoryName);
        }
        return found;
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException {
        Class<?> mappingClass;
        String omrsTypeDefName;
        TypeDefCategory typeDefCategory;
        block18: {
            String methodName = "addTypeDef";
            String typeDefParameterName = "newTypeDef";
            super.newTypeDefParameterValidation(userId, newTypeDef, "newTypeDef", "addTypeDef");
            typeDefCategory = newTypeDef.getCategory();
            omrsTypeDefName = newTypeDef.getName();
            log.debug("Looking for mapping for {} of type {}", (Object)omrsTypeDefName, (Object)typeDefCategory.getName());
            StringBuilder sbMapperClassnamePreferred = new StringBuilder();
            StringBuilder sbMapperClassnameFallback = new StringBuilder();
            sbMapperClassnamePreferred.append(this.getMappingPackage());
            sbMapperClassnameFallback.append("org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.");
            switch (typeDefCategory) {
                case RELATIONSHIP_DEF: {
                    sbMapperClassnamePreferred.append("relationships.");
                    sbMapperClassnameFallback.append("relationships.");
                    break;
                }
                case CLASSIFICATION_DEF: {
                    sbMapperClassnamePreferred.append("classifications.");
                    sbMapperClassnameFallback.append("classifications.");
                    break;
                }
                case ENTITY_DEF: {
                    sbMapperClassnamePreferred.append("entities.");
                    sbMapperClassnameFallback.append("entities.");
                    break;
                }
                default: {
                    log.info("Unknown TypeDef category '{}', no mapping available.", (Object)typeDefCategory.getName());
                }
            }
            sbMapperClassnamePreferred.append(omrsTypeDefName);
            sbMapperClassnameFallback.append(omrsTypeDefName);
            sbMapperClassnamePreferred.append("Mapper");
            sbMapperClassnameFallback.append("Mapper");
            mappingClass = null;
            try {
                mappingClass = Class.forName(sbMapperClassnamePreferred.toString());
                log.debug(" ... found preferred mapping class: {}", (Object)mappingClass.getCanonicalName());
            }
            catch (ClassNotFoundException e) {
                if (this.getMappingPackage().equals("org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.")) break block18;
                try {
                    mappingClass = Class.forName(sbMapperClassnameFallback.toString());
                    log.debug(" ... found fallback mapping class: {}", (Object)mappingClass.getCanonicalName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (mappingClass == null) {
            this.typeDefStore.addUnimplementedTypeDef(newTypeDef);
            this.raiseTypeDefNotSupportedException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, "addTypeDef", omrsTypeDefName, this.repositoryName);
        } else {
            boolean success = false;
            switch (typeDefCategory) {
                case RELATIONSHIP_DEF: {
                    success = this.igcRepositoryHelper.addRelationshipMapping(newTypeDef, mappingClass);
                    break;
                }
                case CLASSIFICATION_DEF: {
                    success = this.igcRepositoryHelper.addClassificationMapping(newTypeDef, mappingClass);
                    break;
                }
                case ENTITY_DEF: {
                    success = this.igcRepositoryHelper.addEntityMapping(newTypeDef, mappingClass);
                    break;
                }
                default: {
                    log.info("Unknown TypeDef category '{}', no mapping available.", (Object)typeDefCategory.getName());
                }
            }
            if (!success) {
                this.typeDefStore.addUnimplementedTypeDef(newTypeDef);
                this.raiseTypeDefNotSupportedException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, "addTypeDef", omrsTypeDefName, this.repositoryName);
            } else {
                this.typeDefStore.addTypeDef(newTypeDef);
            }
        }
        this.checkEventMapperIsConfigured("addTypeDef");
        this.eventMapper.sendNewTypeDefEvent(newTypeDef);
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException {
        String methodName = "addAttributeTypeDef";
        String typeDefParameterName = "newAttributeTypeDef";
        super.newAttributeTypeDefParameterValidation(userId, newAttributeTypeDef, "newAttributeTypeDef", "addAttributeTypeDef");
        AttributeTypeDefCategory attributeTypeDefCategory = newAttributeTypeDef.getCategory();
        String omrsTypeDefName = newAttributeTypeDef.getName();
        log.debug("Looking for mapping for {} of type {}", (Object)omrsTypeDefName, (Object)attributeTypeDefCategory.getName());
        if (attributeTypeDefCategory.equals((Object)AttributeTypeDefCategory.COLLECTION) || attributeTypeDefCategory.equals((Object)AttributeTypeDefCategory.PRIMITIVE)) {
            this.attributeMappingStore.addMapping(newAttributeTypeDef);
        } else {
            Class<?> mappingClass;
            block8: {
                StringBuilder sbMapperClassnamePreferred = new StringBuilder();
                StringBuilder sbMapperClassnameFallback = new StringBuilder();
                sbMapperClassnamePreferred.append(this.getMappingPackage());
                sbMapperClassnameFallback.append("org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.");
                sbMapperClassnamePreferred.append("attributes.");
                sbMapperClassnameFallback.append("attributes.");
                sbMapperClassnamePreferred.append(omrsTypeDefName);
                sbMapperClassnameFallback.append(omrsTypeDefName);
                sbMapperClassnamePreferred.append("Mapper");
                sbMapperClassnameFallback.append("Mapper");
                mappingClass = null;
                try {
                    mappingClass = Class.forName(sbMapperClassnamePreferred.toString());
                    log.debug(" ... found preferred mapping class: {}", (Object)mappingClass.getCanonicalName());
                }
                catch (ClassNotFoundException e) {
                    if (this.getMappingPackage().equals("org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.")) break block8;
                    try {
                        mappingClass = Class.forName(sbMapperClassnameFallback.toString());
                        log.debug(" ... found fallback mapping class: {}", (Object)mappingClass.getCanonicalName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (mappingClass == null) {
                this.attributeMappingStore.addUnimplementedAttributeTypeDef(newAttributeTypeDef);
                this.raiseTypeDefNotSupportedException(IGCOMRSErrorCode.ATTRIBUTE_TYPEDEF_NOT_MAPPED, "addAttributeTypeDef", omrsTypeDefName, this.repositoryName);
            } else {
                this.attributeMappingStore.addMapping(newAttributeTypeDef, mappingClass);
            }
        }
        this.checkEventMapperIsConfigured("addAttributeTypeDef");
        this.eventMapper.sendNewAttributeTypeDefEvent(newAttributeTypeDef);
    }

    private void verifyPropertiesForTypeDef(TypeDef typeDef, Set<String> mappedProperties, List<String> gaps) {
        TypeDefLink superTypeLink;
        List properties = typeDef.getPropertiesDefinition();
        if (properties != null) {
            for (TypeDefAttribute typeDefAttribute : properties) {
                String omrsPropertyName = typeDefAttribute.getAttributeName();
                if (mappedProperties.contains(omrsPropertyName)) continue;
                gaps.add(omrsPropertyName);
            }
        }
        if ((superTypeLink = typeDef.getSuperType()) != null) {
            String superTypeGUID = superTypeLink.getGUID();
            TypeDef superType = this.typeDefStore.getTypeDefByGUID(superTypeGUID);
            if (superType == null) {
                superType = this.typeDefStore.getUnimplementedTypeDefByGUID(superTypeGUID, true);
            }
            if (superType != null) {
                this.verifyPropertiesForTypeDef(superType, mappedProperties, gaps);
            }
        }
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, InvalidTypeDefException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        super.typeDefParameterValidation(userId, typeDef, "typeDef", "verifyTypeDef");
        String guid = typeDef.getGUID();
        if (this.typeDefStore.getUnimplementedTypeDefByGUID(guid, false) != null) {
            this.raiseTypeDefNotSupportedException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, "verifyTypeDef", typeDef.getName(), this.repositoryName);
            return false;
        }
        if (this.typeDefStore.getTypeDefByGUID(guid) != null) {
            ArrayList<String> gaps = new ArrayList<String>();
            Set<String> mappedProperties = new HashSet<String>();
            switch (typeDef.getCategory()) {
                case ENTITY_DEF: {
                    EntityMapping entityMapping = this.igcRepositoryHelper.getEntityMappingByGUID(guid);
                    if (entityMapping == null) break;
                    mappedProperties = entityMapping.getMappedOmrsPropertyNames();
                    break;
                }
                case RELATIONSHIP_DEF: {
                    RelationshipMapping relationshipMapping = this.igcRepositoryHelper.getRelationshipMappingByGUID(guid);
                    if (relationshipMapping == null) break;
                    mappedProperties = relationshipMapping.getMappedOmrsPropertyNames();
                    break;
                }
                case CLASSIFICATION_DEF: {
                    ClassificationMapping classificationMapping = this.igcRepositoryHelper.getClassificationMappingByGUID(guid);
                    if (classificationMapping == null) break;
                    mappedProperties = classificationMapping.getMappedOmrsPropertyNames();
                }
            }
            this.verifyPropertiesForTypeDef(typeDef, mappedProperties, gaps);
            if (!gaps.isEmpty()) {
                log.warn("Unable to verify type definition {} due to missing property mappings for: {}", (Object)typeDef.getName(), (Object)String.join((CharSequence)", ", gaps));
                this.raiseTypeDefNotSupportedException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, "verifyTypeDef", typeDef.getName(), this.repositoryName);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, InvalidTypeDefException {
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        super.attributeTypeDefParameterValidation(userId, attributeTypeDef, "attributeTypeDef", "verifyAttributeTypeDef");
        String guid = attributeTypeDef.getGUID();
        if (this.attributeMappingStore.getUnimplementedAttributeTypeDefByGUID(guid, false) != null) {
            this.raiseTypeDefNotSupportedException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, "verifyAttributeTypeDef", attributeTypeDef.getName(), this.repositoryName);
        }
        return this.attributeMappingStore.getAttributeTypeDefByGUID(guid, false) != null;
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "isEntityKnown";
        super.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        EntityDetail detail = null;
        try {
            detail = this.getEntityDetail(userId, guid);
        }
        catch (EntityNotKnownException e) {
            log.info("Entity {} not known to the repository.", (Object)guid, (Object)e);
        }
        return detail;
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        log.debug("getEntitySummary with guid = {}", (Object)guid);
        IGCEntityGuid igcGuid = IGCEntityGuid.fromGuid(guid);
        if (igcGuid == null) {
            this.raiseEntityNotKnownException(IGCOMRSErrorCode.ENTITY_NOT_KNOWN, "getEntitySummary", guid, "<null>", this.repositoryName);
        }
        EntitySummary summary = null;
        String igcType = igcGuid.getAssetType();
        String prefix = igcGuid.getGeneratedPrefix();
        if (igcType.equals("main_object")) {
            this.raiseRepositoryErrorException(IGCOMRSErrorCode.UNSUPPORTED_OBJECT_TYPE, "getEntitySummary", guid, igcType, this.repositoryName);
        } else {
            EntityMappingInstance entityMap = this.igcRepositoryHelper.getMappingInstanceForParameters(igcGuid.getAssetType(), igcGuid.getRid(), prefix, userId);
            if (entityMap != null) {
                summary = EntityMapping.getEntitySummary(entityMap);
            } else {
                this.raiseRepositoryErrorException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, "getEntitySummary", prefix + igcType, this.repositoryName);
            }
        }
        return summary;
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        IGCEntityGuid igcGuid = IGCEntityGuid.fromGuid(guid);
        if (igcGuid == null) {
            this.raiseEntityNotKnownException(IGCOMRSErrorCode.ENTITY_NOT_KNOWN, "getEntityDetail", guid, "<null>", this.repositoryName);
        }
        return this.igcRepositoryHelper.getEntityDetail(userId, igcGuid);
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        super.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        ArrayList<Relationship> alRelationships = new ArrayList<Relationship>();
        if (asOfTime != null) {
            this.raiseFunctionNotSupportedException(IGCOMRSErrorCode.NO_HISTORY, "getRelationshipsForEntity");
        } else if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            IGCEntityGuid igcGuid = IGCEntityGuid.fromGuid(entityGUID);
            if (igcGuid == null) {
                this.raiseEntityNotKnownException(IGCOMRSErrorCode.ENTITY_NOT_KNOWN, "getRelationshipsForEntity", entityGUID, "<null>", this.repositoryName);
            }
            String rid = igcGuid.getRid();
            String prefix = igcGuid.getGeneratedPrefix();
            String igcType = igcGuid.getAssetType();
            EntityMappingInstance entityMap = this.igcRepositoryHelper.getMappingInstanceForParameters(igcType, rid, prefix, userId);
            if (entityMap != null) {
                alRelationships.addAll(EntityMapping.getMappedRelationships(igcGuid, entityMap, relationshipTypeGUID, fromRelationshipElement, sequencingOrder, sequencingProperty, pageSize));
            } else {
                this.raiseRepositoryErrorException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, "getRelationshipsForEntity", prefix + igcType, this.repositoryName);
            }
        }
        return alRelationships.isEmpty() ? null : alRelationships;
    }

    /*
     * WARNING - void declaration
     */
    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        ArrayList<EntityDetail> entityDetails;
        block17: {
            block18: {
                List<EntityMapping> mappers;
                String qualifiedNameToFind;
                block19: {
                    block16: {
                        String methodName = "findEntitiesByProperty";
                        super.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
                        entityDetails = new ArrayList<EntityDetail>();
                        if (asOfTime == null) break block16;
                        this.raiseFunctionNotSupportedException(IGCOMRSErrorCode.NO_HISTORY, "findEntitiesByProperty");
                        break block17;
                    }
                    if (limitResultsByStatus != null && (limitResultsByStatus.size() != 1 || !limitResultsByStatus.contains(InstanceStatus.ACTIVE))) break block17;
                    if (matchProperties == null || matchProperties.getPropertyCount() != 1 || !((String)matchProperties.getPropertyNames().next()).equals("qualifiedName")) break block18;
                    qualifiedNameToFind = (String)((PrimitivePropertyValue)matchProperties.getInstanceProperties().get("qualifiedName")).getPrimitiveValue();
                    log.debug("Short-circuiting find to qualifiedName search: {}", (Object)qualifiedNameToFind);
                    if (!this.repositoryHelper.isExactMatchRegex(qualifiedNameToFind) && !this.repositoryHelper.isEndsWithRegex(qualifiedNameToFind)) break block19;
                    List<Object> mappers2 = new ArrayList();
                    if (matchCriteria != null && matchCriteria.equals((Object)MatchCriteria.NONE)) {
                        mappers2 = this.findMappingsForInputs(entityTypeGUID, null, userId);
                    } else {
                        String igcType;
                        void var17_24;
                        Identity identity;
                        String unqualifiedName = this.repositoryHelper.getUnqualifiedLiteralString(qualifiedNameToFind);
                        String string = unqualifiedName;
                        String prefix = null;
                        if (IGCRepositoryHelper.isQualifiedNameOfGeneratedEntity(unqualifiedName)) {
                            prefix = IGCRepositoryHelper.getPrefixFromGeneratedQualifiedName(unqualifiedName);
                            String string2 = IGCRepositoryHelper.getSearchableQualifiedName(unqualifiedName);
                            log.debug(" ... generated name with prefix {} and name: {}", (Object)prefix, (Object)string2);
                        }
                        Identity.StringType stringType = Identity.StringType.EXACT;
                        if (this.repositoryHelper.isEndsWithRegex(qualifiedNameToFind)) {
                            stringType = Identity.StringType.ENDS_WITH;
                        }
                        if ((identity = Identity.getFromString((String)var17_24, (IGCRestClient)this.igcRestClient, (Identity.StringType)stringType)) != null && !identity.isPartial()) {
                            log.debug(" ... proceeding on basis of identity: {}", (Object)identity);
                            igcType = identity.getAssetType();
                            mappers2.add(this.igcRepositoryHelper.getEntityMappingByIgcType(igcType, prefix));
                        } else if (identity != null) {
                            igcType = identity.getAssetType();
                            mappers2 = this.igcRepositoryHelper.getEntityMappingsByIgcType(igcType);
                        } else {
                            mappers2 = this.findMappingsForInputs(entityTypeGUID, prefix, userId);
                        }
                    }
                    for (EntityMapping entityMapping : mappers2) {
                        boolean runSearch = true;
                        if (entityTypeGUID != null) {
                            String mappedOmrsTypeName = entityMapping.getOmrsTypeDefName();
                            TypeDef entityTypeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "findEntitiesByProperty");
                            runSearch = this.repositoryHelper.isTypeOf(this.metadataCollectionId, mappedOmrsTypeName, entityTypeDef.getName());
                        }
                        if (runSearch) {
                            this.igcRepositoryHelper.processResultsForMapping(entityMapping, entityDetails, userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByClassification, sequencingProperty, sequencingOrder, pageSize);
                            continue;
                        }
                        log.warn("Unable to confirm that the qualifiedName-embedded type ({}) is a subtype of the requested type ({}) -- skipping qualifiedName search.", (Object)entityMapping.getOmrsTypeDefName(), (Object)entityTypeGUID);
                    }
                    break block17;
                }
                if (!this.repositoryHelper.isStartsWithRegex(qualifiedNameToFind) && !this.repositoryHelper.isContainsRegex(qualifiedNameToFind)) break block17;
                if (matchCriteria != null && matchCriteria.equals((Object)MatchCriteria.NONE)) {
                    mappers = this.findMappingsForInputs(entityTypeGUID, null, userId);
                } else {
                    void var17_29;
                    String unqualifiedName = this.repositoryHelper.getUnqualifiedLiteralString(qualifiedNameToFind);
                    Object var17_27 = null;
                    if (IGCRepositoryHelper.isQualifiedNameOfGeneratedEntity(unqualifiedName)) {
                        String string = IGCRepositoryHelper.getPrefixFromGeneratedQualifiedName(unqualifiedName);
                    }
                    mappers = this.findMappingsForInputs(entityTypeGUID, (String)var17_29, userId);
                }
                for (EntityMapping entityMapping : mappers) {
                    this.igcRepositoryHelper.processResultsForMapping(entityMapping, entityDetails, userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByClassification, sequencingProperty, sequencingOrder, pageSize);
                }
                break block17;
            }
            List<EntityMapping> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
            for (EntityMapping mapping : mappingsToSearch) {
                if (pageSize != 0 && (pageSize <= 0 || entityDetails.size() >= pageSize)) continue;
                this.igcRepositoryHelper.processResultsForMapping(mapping, entityDetails, userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByClassification, sequencingProperty, sequencingOrder, pageSize);
            }
        }
        return entityDetails.isEmpty() ? null : entityDetails;
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByClassification";
        this.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        if (asOfTime != null) {
            this.raiseFunctionNotSupportedException(IGCOMRSErrorCode.NO_HISTORY, "findEntitiesByClassification");
        } else if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            List<EntityMapping> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
            for (EntityMapping mapping : mappingsToSearch) {
                ClassificationMapping foundMapping = null;
                List<ClassificationMapping> classificationMappings = mapping.getClassificationMappers();
                for (ClassificationMapping classificationMapping : classificationMappings) {
                    String candidateName = classificationMapping.getOmrsClassificationType();
                    if (!candidateName.equals(classificationName)) continue;
                    foundMapping = classificationMapping;
                    break;
                }
                if (foundMapping != null) {
                    IGCSearch igcSearch = new IGCSearch();
                    igcSearch.addType(mapping.getIgcAssetType());
                    IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
                    IGCRepositoryHelper.addTypeSpecificConditions(mapping, matchCriteria, null, igcSearchConditionSet);
                    IGCSearchConditionSet baseCriteria = foundMapping.getIGCSearchCriteria(this.repositoryHelper, this.repositoryName, matchClassificationProperties);
                    igcSearchConditionSet.addNestedConditionSet(baseCriteria);
                    IGCSearchSorting igcSearchSorting = null;
                    if (sequencingProperty == null && sequencingOrder != null) {
                        igcSearchSorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
                    }
                    IGCRepositoryHelper.setConditionsFromMatchCriteria(igcSearchConditionSet, matchCriteria);
                    igcSearch.addProperties(mapping.getAllPropertiesForEntityDetail(this.igcRestClient, mapping.getIgcAssetType()));
                    igcSearch.addConditions(igcSearchConditionSet);
                    this.igcRepositoryHelper.setPagingForSearch(igcSearch, fromEntityElement, pageSize);
                    if (igcSearchSorting != null) {
                        igcSearch.addSortingCriteria(igcSearchSorting);
                    }
                    this.igcRepositoryHelper.processResults(mapping, (ItemList<Reference>)this.igcRestClient.search(igcSearch), entityDetails, null, null, null, pageSize, userId);
                    continue;
                }
                log.info("No classification mapping has been implemented for {} on entity {} -- skipping from search.", (Object)classificationName, (Object)mapping.getOmrsTypeDefName());
            }
        }
        return entityDetails.isEmpty() ? null : entityDetails;
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByPropertyValue";
        super.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        if (asOfTime != null) {
            this.raiseFunctionNotSupportedException(IGCOMRSErrorCode.NO_HISTORY, "findEntitiesByPropertyValue");
        } else if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            if (this.igcRepositoryHelper.isIdentityString(searchCriteria)) {
                log.debug("Treating {} as an identity-string (qualifiedName) search.", (Object)searchCriteria);
                InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.repositoryName, null, "qualifiedName", searchCriteria, "findEntitiesByPropertyValue");
                return this.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, MatchCriteria.ALL, fromEntityElement, limitResultsByStatus, limitResultsByClassification, null, sequencingProperty, sequencingOrder, pageSize);
            }
            log.debug("Treating {} as a normal (non-identity-string / non-qualifiedName) search.", (Object)searchCriteria);
            List<EntityMapping> mappingsToSearch = this.getMappingsToSearch(entityTypeGUID, userId);
            for (EntityMapping mapping : mappingsToSearch) {
                String[] tokens;
                if (pageSize != 0 && (pageSize <= 0 || entityDetails.size() >= pageSize)) continue;
                IGCSearch igcSearch = new IGCSearch();
                String igcAssetType = this.igcRepositoryHelper.addTypeToSearch(mapping, igcSearch);
                StringBuilder sbNewCriteria = new StringBuilder();
                if (IGCRestConstants.getUserTypes().contains(igcAssetType) && searchCriteria != null && (tokens = searchCriteria.split(" ")).length > 1) {
                    if (this.repositoryHelper.isExactMatchRegex(searchCriteria) || this.repositoryHelper.isStartsWithRegex(searchCriteria)) {
                        sbNewCriteria.append("\\Q");
                        if (tokens.length == 2) {
                            sbNewCriteria.append(tokens[1]);
                        } else {
                            int iLastToken = tokens.length - 1;
                            sbNewCriteria.append(tokens[iLastToken - 1]).append(" ").append(tokens[iLastToken]);
                        }
                    } else if (this.repositoryHelper.isEndsWithRegex(searchCriteria) || this.repositoryHelper.isContainsRegex(searchCriteria)) {
                        sbNewCriteria.append(".*\\Q");
                        if (tokens.length == 2) {
                            sbNewCriteria.append(tokens[1]);
                        } else {
                            int iLastToken = tokens.length - 1;
                            sbNewCriteria.append(tokens[iLastToken - 1]).append(" ").append(tokens[iLastToken]);
                        }
                    }
                }
                ArrayList<String> properties = this.igcRestClient.getAllStringPropertiesForType(igcAssetType);
                Set<String> simpleMappedIgcProperties = mapping.getSimpleMappedIgcProperties();
                if (properties != null) {
                    IGCSearchConditionSet classificationLimiters = this.igcRepositoryHelper.getSearchCriteriaForClassifications(igcAssetType, limitResultsByClassification);
                    if (limitResultsByClassification != null && !limitResultsByClassification.isEmpty() && classificationLimiters == null) {
                        log.info("Classification limiters were specified, but none apply to the asset type {}, so excluding this asset type from search.", (Object)igcAssetType);
                        continue;
                    }
                    IGCSearchConditionSet outerConditions = new IGCSearchConditionSet();
                    IGCRepositoryHelper.addTypeSpecificConditions(mapping, MatchCriteria.ALL, null, outerConditions);
                    String newCriteria = sbNewCriteria.toString();
                    if (newCriteria.equals("")) {
                        newCriteria = searchCriteria;
                    }
                    if (newCriteria != null && !newCriteria.equals("")) {
                        if (this.igcRestClient.getIgcVersion().isEqualTo(IGCVersionEnum.V11702)) {
                            ArrayList<String> propertiesWithoutLongDescription = new ArrayList<String>();
                            for (String property : properties) {
                                if (property.equals("long_description")) continue;
                                propertiesWithoutLongDescription.add(property);
                            }
                            properties = propertiesWithoutLongDescription;
                        }
                        IGCSearchConditionSet innerConditions = new IGCSearchConditionSet();
                        innerConditions.setMatchAnyCondition(true);
                        for (String property : properties) {
                            if (!simpleMappedIgcProperties.contains(property)) continue;
                            innerConditions.addCondition(IGCRepositoryHelper.getRegexSearchCondition(this.repositoryHelper, this.repositoryName, "findEntitiesByPropertyValue", property, newCriteria));
                        }
                        mapping.addComplexStringSearchCriteria(this.repositoryHelper, this.repositoryName, this.igcRestClient, innerConditions, newCriteria);
                        outerConditions.addNestedConditionSet(innerConditions);
                    }
                    if (classificationLimiters != null) {
                        outerConditions.addNestedConditionSet(classificationLimiters);
                        outerConditions.setMatchAnyCondition(false);
                    }
                    IGCSearchSorting igcSearchSorting = null;
                    if (sequencingProperty == null && sequencingOrder != null) {
                        igcSearchSorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
                    }
                    igcSearch.addConditions(outerConditions);
                    this.igcRepositoryHelper.setPagingForSearch(igcSearch, fromEntityElement, pageSize);
                    if (igcSearchSorting != null) {
                        igcSearch.addSortingCriteria(igcSearchSorting);
                    }
                    igcSearch.addProperties(mapping.getAllPropertiesForEntityDetail(this.igcRestClient, igcAssetType));
                    this.igcRepositoryHelper.processResults(mapping, (ItemList<Reference>)this.igcRestClient.search(igcSearch), entityDetails, null, null, searchCriteria, pageSize, userId);
                    continue;
                }
                log.warn("Unable to find POJO to handle IGC asset type '{}' -- skipping search against this asset type.", (Object)igcAssetType);
            }
        }
        return entityDetails.isEmpty() ? null : entityDetails;
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "isRelationshipKnown";
        super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        Relationship relationship = null;
        try {
            relationship = this.getRelationship(userId, guid);
        }
        catch (RelationshipNotKnownException e) {
            log.info("Could not find relationship {} in repository.", (Object)guid, (Object)e);
        }
        return relationship;
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        Reference proxyTwo;
        Reference proxyOne;
        RelationshipMapping relationshipMapping;
        String relationshipLevelRid;
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, "getRelationship");
        log.debug("Looking up relationship: {}", (Object)guid);
        IGCRelationshipGuid igcRelationshipGuid = IGCRelationshipGuid.fromGuid(guid);
        if (igcRelationshipGuid == null) {
            this.raiseRelationshipNotKnownException(IGCOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, "getRelationship", guid, this.repositoryName);
        }
        String proxyOneRid = igcRelationshipGuid.getRid1();
        String proxyTwoRid = igcRelationshipGuid.getRid2();
        String proxyOneType = igcRelationshipGuid.getAssetType1();
        String proxyTwoType = igcRelationshipGuid.getAssetType2();
        String omrsRelationshipName = igcRelationshipGuid.getRelationshipType();
        ArrayList<RelationshipMapping> mappings = new ArrayList<RelationshipMapping>();
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        String string = relationshipLevelRid = igcRelationshipGuid.isRelationshipLevelObject() ? proxyOneRid : null;
        if (relationshipLevelRid != null) {
            Reference relationshipAsset = this.igcRestClient.getAssetById(relationshipLevelRid);
            String relationshipAssetType = relationshipAsset.getType();
            relationshipMapping = this.igcRepositoryHelper.getRelationshipMappingByTypes(omrsRelationshipName, relationshipAssetType, relationshipAssetType);
            proxyOne = relationshipMapping.getProxyOneAssetFromAsset(relationshipAsset, this.igcRestClient).get(0);
            proxyTwo = relationshipMapping.getProxyTwoAssetFromAsset(relationshipAsset, this.igcRestClient).get(0);
            mappings.add(relationshipMapping);
        } else {
            Reference oneEnd = this.igcRestClient.getAssetWithSubsetOfProperties(proxyOneRid, proxyOneType, this.igcRestClient.getAllPropertiesForType(proxyOneType));
            proxyTwo = this.igcRestClient.getAssetWithSubsetOfProperties(proxyTwoRid, proxyTwoType, this.igcRestClient.getAllPropertiesForType(proxyTwoType));
            relationshipMapping = this.igcRepositoryHelper.getRelationshipMappingByTypes(omrsRelationshipName, proxyOneType, proxyTwoType);
            proxyOne = relationshipMapping.getProxyOneAssetFromAsset(oneEnd, this.igcRestClient).get(0);
            mappings.add(relationshipMapping);
        }
        if (mappings.isEmpty()) {
            this.raiseRepositoryErrorException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, "getRelationship", omrsRelationshipName, this.repositoryName);
        }
        Relationship found = null;
        try {
            TypeDef relationshipTypeDef = this.getTypeDefByName(userId, omrsRelationshipName);
            RelationshipMapping.getMappedRelationships(this.igcomrsRepositoryConnector, relationships, mappings, relationshipTypeDef.getGUID(), proxyOne, proxyTwo, userId);
        }
        catch (TypeDefNotKnownException e) {
            this.raiseRepositoryErrorException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, "getRelationship", omrsRelationshipName, this.repositoryName);
        }
        if (relationships.isEmpty()) {
            this.raiseRelationshipNotKnownException(IGCOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, "getRelationship", guid, this.repositoryName);
        } else if (relationships.size() > 1) {
            for (Relationship relationship : relationships) {
                if (!relationship.getGUID().equals(guid)) continue;
                found = relationship;
            }
        } else {
            found = (Relationship)relationships.get(0);
        }
        if (found == null) {
            this.raiseRelationshipNotKnownException(IGCOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, "getRelationship", guid, this.repositoryName);
        }
        return found;
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByProperty";
        this.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        if (asOfTime != null) {
            this.raiseFunctionNotSupportedException(IGCOMRSErrorCode.NO_HISTORY, "findRelationshipsByProperty");
        } else if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            List<RelationshipMapping> mappingsToSearch = this.getRelationshipMappingsToSearch(relationshipTypeGUID, userId);
            for (RelationshipMapping mapping : mappingsToSearch) {
                List<IGCSearch> searches = mapping.getComplexIGCSearchCriteria(this.repositoryHelper, this.repositoryName, this.igcRestClient, matchProperties, matchCriteria);
                for (IGCSearch igcSearch : searches) {
                    this.igcRepositoryHelper.setPagingForSearch(igcSearch, fromRelationshipElement, pageSize);
                    InstanceMapping.SearchFilter filter = mapping.getAllNoneOrSome(matchProperties, matchCriteria);
                    if (filter.equals((Object)InstanceMapping.SearchFilter.NONE)) continue;
                    this.igcRepositoryHelper.processResults(mapping, (ItemList<Reference>)this.igcRestClient.search(igcSearch), relationships, pageSize, userId);
                }
            }
        }
        return relationships.isEmpty() ? null : relationships;
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByPropertyValue";
        this.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        if (asOfTime != null) {
            this.raiseFunctionNotSupportedException(IGCOMRSErrorCode.NO_HISTORY, "findRelationshipsByPropertyValue");
        } else if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            List<RelationshipMapping> mappingsToSearch = this.getRelationshipMappingsToSearch(relationshipTypeGUID, userId);
            for (RelationshipMapping mapping : mappingsToSearch) {
                List<IGCSearch> searches = mapping.getComplexIGCSearchCriteria(this.repositoryHelper, this.repositoryName, this.igcRestClient, searchCriteria);
                for (IGCSearch igcSearch : searches) {
                    this.igcRepositoryHelper.setPagingForSearch(igcSearch, fromRelationshipElement, pageSize);
                    this.igcRepositoryHelper.processResults(mapping, (ItemList<Reference>)this.igcRestClient.search(igcSearch), relationships, pageSize, userId);
                }
            }
        }
        return relationships.isEmpty() ? null : relationships;
    }

    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, HomeEntityException, UserNotAuthorizedException {
        String methodName = "refreshEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshEntityReferenceCopy");
        EntityDetail entity = this.isEntityKnown(userId, entityGUID);
        if (entity != null && this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
            OMRSErrorCode errorCode = OMRSErrorCode.HOME_REFRESH;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"refreshEntityReferenceCopy", entityGUID, this.metadataCollectionId, this.repositoryName});
            throw new HomeEntityException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "refreshEntityReferenceCopy", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.checkEventMapperIsConfigured("refreshEntityReferenceCopy");
        this.eventMapper.sendRefreshEntityRequest(typeDefGUID, typeDefName, entityGUID, homeMetadataCollectionId);
    }

    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, HomeRelationshipException, UserNotAuthorizedException {
        String methodName = "refreshRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshRelationshipReferenceCopy");
        Relationship relationship = this.isRelationshipKnown(userId, relationshipGUID);
        if (relationship != null && this.metadataCollectionId.equals(relationship.getMetadataCollectionId())) {
            OMRSErrorCode errorCode = OMRSErrorCode.HOME_REFRESH;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"refreshRelationshipReferenceCopy", relationshipGUID, this.metadataCollectionId, this.repositoryName});
            throw new HomeRelationshipException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "refreshRelationshipReferenceCopy", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.checkEventMapperIsConfigured("refreshRelationshipReferenceCopy");
        this.eventMapper.sendRefreshRelationshipRequest(typeDefGUID, typeDefName, relationshipGUID, homeMetadataCollectionId);
    }

    public void setEventMapper(IGCOMRSRepositoryEventMapper eventMapper) {
        this.eventMapper = eventMapper;
    }

    public Map<String, TypeDefAttribute> getTypeDefAttributesForType(String omrsTypeName) {
        return this.typeDefStore.getAllTypeDefAttributesForName(omrsTypeName);
    }

    private void checkEventMapperIsConfigured(String methodName) throws RepositoryErrorException {
        if (this.eventMapper == null) {
            this.raiseRepositoryErrorException(IGCOMRSErrorCode.EVENT_MAPPER_NOT_INITIALIZED, methodName, this.repositoryName);
        }
    }

    private List<EntityMapping> getMappingsToSearch(String entityTypeGUID, String userId) throws InvalidParameterException, RepositoryErrorException {
        ArrayList<EntityMapping> mappingsToSearch = new ArrayList<EntityMapping>();
        if (entityTypeGUID == null) {
            for (EntityMapping candidate : this.igcRepositoryHelper.getAllEntityMappings()) {
                if (candidate.getOmrsTypeDefName().equals("Referenceable")) continue;
                mappingsToSearch.add(candidate);
            }
        } else {
            String requestedTypeName;
            EntityMapping mappingExact = this.igcRepositoryHelper.getEntityMappingByGUID(entityTypeGUID);
            if (mappingExact == null) {
                TypeDef unimplemented = this.typeDefStore.getUnimplementedTypeDefByGUID(entityTypeGUID);
                requestedTypeName = unimplemented.getName();
            } else {
                requestedTypeName = mappingExact.getOmrsTypeDefName();
            }
            List<TypeDef> allEntityTypes = this.findTypeDefsByCategory(userId, TypeDefCategory.ENTITY_DEF);
            for (TypeDef typeDef : allEntityTypes) {
                String typeDefName;
                EntityMapping implementedMapping = this.igcRepositoryHelper.getEntityMappingByGUID(typeDef.getGUID());
                if (implementedMapping == null || (typeDefName = typeDef.getName()).equals("Referenceable") || !this.repositoryHelper.isTypeOf(this.metadataCollectionId, typeDefName, requestedTypeName)) continue;
                mappingsToSearch.add(implementedMapping);
            }
        }
        return mappingsToSearch;
    }

    private List<RelationshipMapping> getRelationshipMappingsToSearch(String relationshipTypeGUID, String userId) {
        ArrayList<RelationshipMapping> mappingsToSearch = new ArrayList<RelationshipMapping>();
        if (relationshipTypeGUID == null) {
            for (RelationshipMapping candidate : this.igcRepositoryHelper.getAllRelationshipMappings()) {
                if (candidate.hasSubTypes()) continue;
                mappingsToSearch.add(candidate);
            }
        } else {
            RelationshipMapping mappingExact = this.igcRepositoryHelper.getRelationshipMappingByGUID(relationshipTypeGUID);
            if (mappingExact != null) {
                if (mappingExact.hasSubTypes()) {
                    mappingsToSearch.addAll(mappingExact.getSubTypes());
                } else {
                    mappingsToSearch.add(mappingExact);
                }
            }
        }
        return mappingsToSearch;
    }

    private List<EntityMapping> findMappingsForInputs(String entityTypeGUID, String prefix, String userId) {
        log.debug("Looking for mappers for GUID {} and prefix: {}", (Object)entityTypeGUID, (Object)prefix);
        List<Object> mappers = new ArrayList();
        if (entityTypeGUID != null) {
            try {
                mappers = this.getMappingsToSearch(entityTypeGUID, userId);
            }
            catch (InvalidParameterException | RepositoryErrorException e) {
                log.error("Unable to retrieve mappers for: {}", (Object)entityTypeGUID, (Object)e);
            }
        } else if (prefix != null) {
            mappers = new ArrayList<EntityMapping>(this.igcRepositoryHelper.getEntityMappingsByPrefix(prefix));
        } else {
            try {
                mappers = this.getMappingsToSearch(entityTypeGUID, userId);
            }
            catch (InvalidParameterException | RepositoryErrorException e) {
                log.error("Unable to retrieve all mappers (no entityTypeGUID requested).", e);
            }
        }
        return mappers;
    }

    private void raiseTypeDefNotKnownException(IGCOMRSErrorCode errorCode, String methodName, String ... params) throws TypeDefNotKnownException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void raiseTypeDefNotSupportedException(IGCOMRSErrorCode errorCode, String methodName, String ... params) throws TypeDefNotSupportedException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new TypeDefNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void raiseEntityNotKnownException(IGCOMRSErrorCode errorCode, String methodName, String ... params) throws EntityNotKnownException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void raiseRepositoryErrorException(IGCOMRSErrorCode errorCode, String methodName, String ... params) throws RepositoryErrorException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void raiseFunctionNotSupportedException(IGCOMRSErrorCode errorCode, String methodName) throws FunctionNotSupportedException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
        throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void raiseRelationshipNotKnownException(IGCOMRSErrorCode errorCode, String methodName, String ... params) throws RelationshipNotKnownException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new RelationshipNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

