/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSAuditCode;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.OMRSStub;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;

public class IGCOMRSRepositoryConnector
extends OMRSRepositoryConnector {
    protected IGCRestClient igcRestClient;
    protected IGCVersionEnum igcVersion;
    protected List<String> defaultZones = new ArrayList<String>();

    public OMRSMetadataCollection getMetadataCollection() throws RepositoryErrorException {
        String methodName = "getMetadataCollection";
        if (this.metadataCollection == null) {
            try {
                this.connectToIGC("getMetadataCollection");
            }
            catch (ConnectorCheckedException e) {
                this.raiseRepositoryErrorException(IGCOMRSErrorCode.REST_CLIENT_FAILURE, "getMetadataCollection", e, this.getServerName());
            }
        }
        return super.getMetadataCollection();
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        IGCOMRSAuditCode auditCode = IGCOMRSAuditCode.REPOSITORY_SERVICE_STARTING;
        this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        if (this.metadataCollection == null) {
            this.connectToIGC("start");
        }
        auditCode = IGCOMRSAuditCode.REPOSITORY_SERVICE_STARTED;
        this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.getServerName(), this.getIGCVersion().getVersionString()), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    public IGCVersionEnum getIGCVersion() {
        return this.igcVersion;
    }

    public void disconnect() {
        this.igcRestClient.disconnect();
        if (this.auditLog != null) {
            IGCOMRSAuditCode auditCode = IGCOMRSAuditCode.REPOSITORY_SERVICE_SHUTDOWN;
            this.auditLog.logRecord("disconnect", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.getServerName()), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public IGCRestClient getIGCRestClient() {
        return this.igcRestClient;
    }

    public List<String> getDefaultZones() {
        return this.defaultZones;
    }

    protected void connectToIGC(String methodName) throws ConnectorCheckedException {
        EndpointProperties endpointProperties = this.connectionProperties.getEndpoint();
        if (endpointProperties == null) {
            this.raiseConnectorCheckedException(IGCOMRSErrorCode.REST_CLIENT_FAILURE, methodName, null, "<null>");
        } else {
            Object zones;
            String address = endpointProperties.getProtocol() + "://" + endpointProperties.getAddress();
            String igcUser = this.connectionProperties.getUserId();
            String igcPass = this.connectionProperties.getClearPassword();
            Map proxyProperties = this.connectionBean.getConfigurationProperties();
            if (proxyProperties != null && (zones = proxyProperties.get("defaultZones")) instanceof List) {
                for (Object zone : (List)zones) {
                    if (!(zone instanceof String)) continue;
                    this.defaultZones.add((String)zone);
                }
            }
            boolean successfulInit = false;
            IGCOMRSAuditCode auditCode = IGCOMRSAuditCode.CONNECTING_TO_IGC;
            this.auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(address), null, auditCode.getSystemAction(), auditCode.getUserAction());
            try {
                this.igcRestClient = new IGCRestClient(address, igcUser, igcPass);
                if (this.igcRestClient.start()) {
                    if (this.getMaxPageSize() > 0) {
                        this.igcRestClient.setDefaultPageSize(this.getMaxPageSize());
                    }
                    this.igcVersion = this.igcRestClient.getIgcVersion();
                    boolean success = this.upsertOMRSBundleZip();
                    this.igcRestClient.registerPOJO(OMRSStub.class);
                    successfulInit = success;
                }
            }
            catch (RepositoryErrorException e) {
                this.raiseConnectorCheckedException(IGCOMRSErrorCode.OMRS_BUNDLE_FAILURE, methodName, e, address);
            }
            catch (Exception e) {
                this.raiseConnectorCheckedException(IGCOMRSErrorCode.REST_CLIENT_FAILURE, methodName, e, "<null>");
            }
            if (!successfulInit) {
                this.raiseConnectorCheckedException(IGCOMRSErrorCode.REST_CLIENT_FAILURE, methodName, null, "<null>");
            }
            auditCode = IGCOMRSAuditCode.CONNECTED_TO_IGC;
            this.auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(address), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.metadataCollection = new IGCOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, this.metadataCollectionId);
        }
    }

    protected boolean upsertOMRSBundleZip() throws RepositoryErrorException {
        String methodName = "upsertOMRSBundleZip";
        ClassPathResource bundleResource = new ClassPathResource("OMRS.zip");
        boolean success = this.igcRestClient.upsertOpenIgcBundle("OMRS", (AbstractResource)bundleResource);
        if (!success) {
            this.raiseRepositoryErrorException(IGCOMRSErrorCode.OMRS_BUNDLE_FAILURE, "upsertOMRSBundleZip", null, "open");
        }
        return success;
    }

    protected void raiseConnectorCheckedException(IGCOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws ConnectorCheckedException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), cause);
    }

    protected void raiseRepositoryErrorException(IGCOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RepositoryErrorException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), cause);
    }
}

