/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.MainObject;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Term;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.GovernanceClassificationStatusMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfidentialityMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(ConfidentialityMapper.class);

    public static ConfidentialityMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected ConfidentialityMapper() {
        super("main_object", "assigned_to_terms", "Referenceable", "Confidentiality");
        this.addLiteralPropertyMapping("status", GovernanceClassificationStatusMapper.getInstance(null).getEnumMappingByIgcValue(""));
        this.addLiteralPropertyMapping("confidence", 100);
        this.addLiteralPropertyMapping("steward", null);
        this.addLiteralPropertyMapping("source", null);
        this.addLiteralPropertyMapping("notes", null);
        this.addMappedOmrsProperty("level");
        this.addExcludedIgcAssetType("connector");
        this.addExcludedIgcAssetType("data_connection");
        this.addExcludedIgcAssetType("group");
        this.addExcludedIgcAssetType("information_governance_policy");
        this.addExcludedIgcAssetType("label");
        this.addExcludedIgcAssetType("user");
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        ItemList assignedToTerms;
        String methodName = "addMappedOMRSClassification";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        if (fromIgcObject instanceof MainObject && (assignedToTerms = ((MainObject)fromIgcObject).getAssignedToTerms()) != null) {
            List allAssignedTerms = igcRestClient.getAllPages("assigned_to_terms", assignedToTerms);
            for (Term assignedTerm : allAssignedTerms) {
                Identity termIdentity = assignedTerm.getIdentity(igcRestClient);
                Identity catIdentity = termIdentity.getParentIdentity();
                if (!catIdentity.toString().endsWith("Confidentiality")) continue;
                InstanceProperties classificationProperties = new InstanceProperties();
                String confidentialityName = assignedTerm.getName();
                int spaceIndex = confidentialityName.indexOf(" ");
                if (spaceIndex > 0) {
                    String level = confidentialityName.substring(0, spaceIndex);
                    try {
                        int parsedLevel = Integer.parseInt(level);
                        classificationProperties = igcomrsRepositoryConnector.getRepositoryHelper().addIntPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), classificationProperties, "level", parsedLevel, "addMappedOMRSClassification");
                    }
                    catch (NumberFormatException e) {
                        log.error("Unable to detect a level in the Confidentiality classification: {}", (Object)confidentialityName, (Object)e);
                    }
                    try {
                        Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, classificationProperties, fromIgcObject, userId);
                        classifications.add(classification);
                    }
                    catch (RepositoryErrorException e) {
                        log.error("Unable to map Confidentiality classification.", (Throwable)e);
                    }
                    continue;
                }
                log.error("Unable to detect a level in the Confidentiality classification: {}", (Object)confidentialityName);
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, InstanceProperties matchClassificationProperties) {
        Map properties;
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("assigned_to_terms.parent_category.name", "=", "Confidentiality");
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        if (matchClassificationProperties != null && (properties = matchClassificationProperties.getInstanceProperties()).containsKey("level")) {
            PrimitivePropertyValue levelValue = (PrimitivePropertyValue)properties.get("level");
            Integer level = (Integer)levelValue.getPrimitiveValue();
            String levelAsString = level.toString() + " ";
            IGCSearchCondition propertyCondition = new IGCSearchCondition("assigned_to_terms.name", "like {0}%", levelAsString);
            igcSearchConditionSet.addCondition(propertyCondition);
            igcSearchConditionSet.setMatchAnyCondition(false);
        }
        return igcSearchConditionSet;
    }

    private static class Singleton {
        private static final ConfidentialityMapper INSTANCE = new ConfidentialityMapper();

        private Singleton() {
        }
    }
}

