/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.SchemaElement_Mapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.DataClassAssignmentMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class SchemaAttribute_Mapper
extends SchemaElement_Mapper {
    protected SchemaAttribute_Mapper(String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName) {
        super(igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName, null);
        this.addLiteralPropertyMapping("maxCardinality", 1);
        this.addComplexIgcProperty("allows_null_values");
        this.addComplexOmrsProperty("minCardinality");
        this.addLiteralPropertyMapping("aliases", null);
        this.addLiteralPropertyMapping("sortOrder", null);
        this.addLiteralPropertyMapping("name", null);
        this.addRelationshipMapper(DataClassAssignmentMapper.getInstance(null));
    }

    @Override
    protected InstanceProperties complexPropertyMappings(EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        instanceProperties = super.complexPropertyMappings(entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        Reference igcEntity = entityMap.getIgcEntity();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        Boolean allowsNulls = (Boolean)igcRestClient.getPropertyByName(igcEntity, "allows_null_values");
        if (allowsNulls != null) {
            instanceProperties = repositoryHelper.addIntPropertyToInstance(repositoryName, instanceProperties, "minCardinality", allowsNulls != false ? 0 : 1, "complexPropertyMappings");
        }
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, InstancePropertyValue value) throws FunctionNotSupportedException {
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, value);
        if (omrsPropertyName.equals("minCardinality")) {
            Object minCardinality = ((PrimitivePropertyValue)value).getPrimitiveValue();
            boolean optional = minCardinality == null || (Integer)minCardinality <= 0;
            IGCSearchCondition igcSearchCondition = new IGCSearchCondition("allows_null_values", "=", optional ? "true" : "false");
            igcSearchConditionSet.addCondition(igcSearchCondition);
        }
    }
}

