/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Category;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.GlossaryMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryAnchorMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(CategoryAnchorMapper.class);

    public static CategoryAnchorMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected CategoryAnchorMapper() {
        super("category", "category", "subcategories", "parent_category", "CategoryAnchor", "anchor", "categories", "GL", null);
        this.setOptimalStart(RelationshipMapping.OptimalStart.CUSTOM);
        this.setContainedType(RelationshipMapping.ContainedType.TWO);
    }

    @Override
    public List<Reference> getProxyOneAssetFromAsset(Reference category, IGCRestClient igcRestClient) {
        String assetType = category.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (assetType.equals("category")) {
            Identity catIdentity = category.getIdentity(igcRestClient);
            if (catIdentity != null) {
                Identity rootIdentity = catIdentity.getUltimateParentIdentity();
                Reference root = new Reference(rootIdentity.getName(), rootIdentity.getAssetType(), rootIdentity.getRid());
                root.setContext(Collections.emptyList());
                asList.add(root);
            } else {
                log.debug("Already at a root-level category, returning as-is: {} of type {}", (Object)category.getName(), (Object)category.getType());
                asList.add(category);
            }
        } else {
            log.warn("Not a category asset, just returning as-is: {} of type {}", (Object)category.getName(), (Object)category.getType());
            asList.add(category);
        }
        return asList;
    }

    @Override
    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
        String assetType = IGCRestConstants.getAssetTypeForSearch((String)fromIgcObject.getType());
        if (assetType.equals("category")) {
            IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
            OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
            RelationshipDef relationshipDef = (RelationshipDef)repositoryHelper.getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), "CategoryAnchor");
            if (GlossaryMapper.isGlossary(igcRestClient, fromIgcObject)) {
                ItemList children;
                IGCSearchCondition byCatPath;
                IGCSearchConditionSet conditionSet = new IGCSearchConditionSet();
                if (toIgcObject == null) {
                    log.debug("Looking for all offspring categories from: {} of type {}", (Object)fromIgcObject.getName(), (Object)fromIgcObject.getType());
                    byCatPath = new IGCSearchCondition("category_path", "=", fromIgcObject.getId());
                    conditionSet.addCondition(byCatPath);
                } else {
                    log.debug("Looking for single category for: {} of type {}", (Object)toIgcObject.getName(), (Object)toIgcObject.getType());
                    byCatPath = new IGCSearchCondition("category_path", "=", fromIgcObject.getId());
                    IGCSearchCondition byCategory = new IGCSearchCondition("_id", "=", toIgcObject.getId());
                    conditionSet.addCondition(byCatPath);
                    conditionSet.addCondition(byCategory);
                    conditionSet.setMatchAnyCondition(false);
                }
                IGCSearch igcSearch = new IGCSearch("category", IGCRestConstants.getModificationProperties(), conditionSet);
                IGCSearchSorting sorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
                if (sorting != null) {
                    igcSearch.addSortingCriteria(sorting);
                }
                if (pageSize > 0) {
                    igcSearch.setPageSize(fromRelationshipElement + pageSize);
                }
                if ((children = igcRestClient.search(igcSearch)) != null) {
                    if (pageSize == 0) {
                        List allPages = igcRestClient.getAllPages(null, children);
                        children.setAllPages(allPages);
                    }
                    log.debug(" ... found a total of {} offspring categories.", (Object)children.getItems().size());
                    for (Category child : children.getItems()) {
                        try {
                            Relationship relationship = CategoryAnchorMapper.getMappedRelationship(igcomrsRepositoryConnector, CategoryAnchorMapper.getInstance(null), relationshipDef, fromIgcObject, (Reference)child, "subcategories", userId, null, true);
                            relationships.add(relationship);
                        }
                        catch (RepositoryErrorException e) {
                            log.error("Unable to map downward relationship.", (Throwable)e);
                        }
                    }
                }
            } else {
                Identity catIdentity = fromIgcObject.getIdentity(igcRestClient);
                Identity rootIdentity = catIdentity.getUltimateParentIdentity();
                Reference root = igcRestClient.getAssetWithSubsetOfProperties(rootIdentity.getRid(), rootIdentity.getAssetType(), IGCRestConstants.getModificationProperties());
                if (root != null) {
                    log.debug("Mapping ultimate parent category from: {} of type {}", (Object)fromIgcObject.getName(), (Object)fromIgcObject.getType());
                    try {
                        Relationship relationship = CategoryAnchorMapper.getMappedRelationship(igcomrsRepositoryConnector, CategoryAnchorMapper.getInstance(null), relationshipDef, root, fromIgcObject, "parent_category", userId, null, true);
                        relationships.add(relationship);
                    }
                    catch (RepositoryErrorException e) {
                        log.error("Unable to map upward relationship.", (Throwable)e);
                    }
                } else {
                    log.error("Unable to find root-level category with identity: {}", (Object)rootIdentity);
                }
            }
        } else {
            log.warn("Found unexpected asset type during relationship mapping: {}", (Object)fromIgcObject);
        }
    }

    @Override
    public boolean includeRelationshipForIgcObjects(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference oneObject, Reference otherObject) {
        log.debug("Considering inclusion of objects: {} ({}) and {} ({})", new Object[]{oneObject.getName(), oneObject.getType(), otherObject.getName(), otherObject.getType()});
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        return GlossaryMapper.isGlossary(igcRestClient, oneObject) && otherObject.getType().equals("category") && !GlossaryMapper.isGlossary(igcRestClient, otherObject) || !GlossaryMapper.isGlossary(igcRestClient, oneObject) && oneObject.getType().equals("category") && GlossaryMapper.isGlossary(igcRestClient, otherObject);
    }

    private static class Singleton {
        private static final CategoryAnchorMapper INSTANCE = new CategoryAnchorMapper();

        private Singleton() {
        }
    }
}

