/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Classification;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Classificationenabledgroup;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.DataClass;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.InformationAsset;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.MainObject;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.DataClassAssignmentStatusMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClassAssignmentMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(DataClassAssignmentMapper.class);
    private static final String R_DATA_CLASS_ASSIGNMENT = "DataClassAssignment";
    private static final String P_THRESHOLD = "threshold";

    public static DataClassAssignmentMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected DataClassAssignmentMapper() {
        super("main_object", "data_class", "detected_classifications", "classified_assets_detected", R_DATA_CLASS_ASSIGNMENT, "elementsAssignedToDataClass", "dataClassesAssignedToElement");
        this.setOptimalStart(RelationshipMapping.OptimalStart.CUSTOM);
        this.addAlternativePropertyFromOne("selected_classification");
        this.addAlternativePropertyFromTwo("classifications_selected");
        this.setRelationshipLevelIgcAsset("classification", "classifies_asset", "data_class");
        this.addMappedOmrsProperty("confidence");
        this.addMappedOmrsProperty(P_THRESHOLD);
        this.addMappedOmrsProperty("partialMatch");
        this.addMappedOmrsProperty("valueFrequency");
        this.addMappedOmrsProperty("status");
        this.addLiteralPropertyMapping("method", null);
        this.addLiteralPropertyMapping("steward", null);
        this.addLiteralPropertyMapping("source", null);
    }

    @Override
    public List<Reference> getProxyOneAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient) {
        String otherAssetType = relationshipAsset.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (otherAssetType.equals("classification")) {
            Reference classifiedObj;
            Object co = igcRestClient.getPropertyByName(relationshipAsset, "classifies_asset");
            if (co == null || co.equals("") || co.equals("null")) {
                Reference classification = igcRestClient.getAssetById(relationshipAsset.getId());
                classifiedObj = (Reference)igcRestClient.getPropertyByName(classification, "classifies_asset");
            } else {
                classifiedObj = (Reference)co;
            }
            asList.add(classifiedObj);
        } else {
            log.debug("Not a classification asset, just returning as-is: {} of type {}", (Object)relationshipAsset.getName(), (Object)relationshipAsset.getType());
            asList.add(relationshipAsset);
        }
        return asList;
    }

    @Override
    public List<Reference> getProxyTwoAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient) {
        String otherAssetType = relationshipAsset.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (otherAssetType.equals("classification")) {
            Reference dataClass;
            Object dc = igcRestClient.getPropertyByName(relationshipAsset, "data_class");
            if (dc == null || dc.equals("") || dc.equals("null")) {
                Reference classification = igcRestClient.getAssetById(relationshipAsset.getId());
                dataClass = (Reference)igcRestClient.getPropertyByName(classification, "data_class");
            } else {
                dataClass = (Reference)dc;
            }
            asList.add(dataClass);
        } else {
            log.debug("Not a classification asset, just returning as-is: {} of type {}", (Object)relationshipAsset.getName(), (Object)relationshipAsset.getType());
            asList.add(relationshipAsset);
        }
        return asList;
    }

    @Override
    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
        if (fromIgcObject instanceof DataClass) {
            this.mapDetectedClassifications_fromDataClass(igcomrsRepositoryConnector, relationships, (DataClass)fromIgcObject, toIgcObject instanceof Classificationenabledgroup ? (Classificationenabledgroup)toIgcObject : null, sequencingOrder, userId);
            this.mapSelectedClassifications_fromDataClass(igcomrsRepositoryConnector, relationships, (DataClass)fromIgcObject, userId);
        } else if (fromIgcObject instanceof Classificationenabledgroup) {
            this.mapDetectedClassifications_toDataClass(igcomrsRepositoryConnector, relationships, (Classificationenabledgroup)fromIgcObject, toIgcObject instanceof DataClass ? (DataClass)toIgcObject : null, sequencingOrder, userId);
            this.mapSelectedClassifications_toDataClass(igcomrsRepositoryConnector, relationships, (Classificationenabledgroup)fromIgcObject, userId);
        }
    }

    @Override
    public List<IGCSearch> getComplexIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, InstanceProperties matchProperties, MatchCriteria matchCriteria) {
        EnumPropertyValue statusEnum;
        String statusName;
        if (matchProperties == null) {
            return this.getSimpleIGCSearchCriteria();
        }
        Map mapOfValues = matchProperties.getInstanceProperties();
        if (mapOfValues == null) {
            return this.getSimpleIGCSearchCriteria();
        }
        ArrayList<IGCSearch> searches = new ArrayList<IGCSearch>();
        IGCSearch searchForDataClass = new IGCSearch("data_class");
        searchForDataClass.addProperties(this.getProxyTwoMapping().getRealIgcRelationshipProperties());
        IGCSearchConditionSet conditionsForDataClass = new IGCSearchConditionSet();
        IGCSearch searchForClassification = new IGCSearch("classification");
        searchForClassification.addProperties(igcRestClient.getAllPropertiesForType("classification"));
        IGCSearchConditionSet conditionsForClassification = new IGCSearchConditionSet();
        boolean considerOtherProperties = true;
        InstancePropertyValue status = mapOfValues.getOrDefault("status", null);
        if (status != null && status.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.ENUM) && (statusName = (statusEnum = (EnumPropertyValue)status).getSymbolicName()) != null) {
            if (statusName.equals("Discovered")) {
                conditionsForDataClass.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
            } else if (statusName.equals("Proposed")) {
                IGCSearchCondition proposed = new IGCSearchCondition("classifications_selected", "isNull", Boolean.valueOf(true));
                conditionsForDataClass.addCondition(proposed);
                considerOtherProperties = false;
            } else {
                conditionsForDataClass.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                conditionsForClassification.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                considerOtherProperties = false;
            }
        }
        if (considerOtherProperties) {
            Set searchProperties = mapOfValues.keySet();
            Set<String> mappedOmrsProperties = this.getMappedOmrsPropertyNames();
            if (!mappedOmrsProperties.containsAll(searchProperties)) {
                conditionsForDataClass.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                conditionsForClassification.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
            } else {
                for (Map.Entry entry : mapOfValues.entrySet()) {
                    String omrsPropertyName = (String)entry.getKey();
                    InstancePropertyValue value = (InstancePropertyValue)entry.getValue();
                    switch (omrsPropertyName) {
                        case "confidence": {
                            IGCSearchCondition byConfidence = new IGCSearchCondition("confidencePercent", "=", value.valueAsString());
                            conditionsForClassification.addCondition(byConfidence);
                            break;
                        }
                        case "threshold": {
                            IGCSearchCondition byThreshold = new IGCSearchCondition(P_THRESHOLD, "=", value.valueAsString());
                            conditionsForClassification.addCondition(byThreshold);
                            break;
                        }
                        case "partialMatch": {
                            IGCSearchCondition byPartialMatch;
                            boolean isPartialMatch = Boolean.parseBoolean(value.valueAsString());
                            if (isPartialMatch) {
                                byPartialMatch = new IGCSearchCondition("confidencePercent", "<", "100");
                                conditionsForClassification.addCondition(byPartialMatch);
                                break;
                            }
                            byPartialMatch = new IGCSearchCondition("confidencePercent", "=", "100");
                            conditionsForClassification.addCondition(byPartialMatch);
                            break;
                        }
                        case "valueFrequency": {
                            IGCSearchCondition byValueFrequency = new IGCSearchCondition("value_frequency", "=", value.valueAsString());
                            conditionsForClassification.addCondition(byValueFrequency);
                        }
                    }
                }
            }
        }
        IGCRepositoryHelper.setConditionsFromMatchCriteria(conditionsForDataClass, matchCriteria);
        IGCRepositoryHelper.setConditionsFromMatchCriteria(conditionsForClassification, matchCriteria);
        searchForDataClass.addConditions(conditionsForDataClass);
        searchForClassification.addConditions(conditionsForClassification);
        searches.add(searchForDataClass);
        searches.add(searchForClassification);
        return searches;
    }

    private void mapDetectedClassifications_fromDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, DataClass dataClass, Classificationenabledgroup toIgcObject, SequencingOrder sequencingOrder, String userId) {
        String methodName = "mapDetectedClassifications_fromDataClass";
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCSearchCondition byDataClass = new IGCSearchCondition("data_class", "=", dataClass.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(byDataClass);
        if (toIgcObject != null) {
            IGCSearchCondition byAsset = new IGCSearchCondition("classifies_asset", "=", toIgcObject.getId());
            igcSearchConditionSet.addCondition(byAsset);
            igcSearchConditionSet.setMatchAnyCondition(false);
        }
        String[] classificationProperties = new String[]{"classifies_asset", "confidencePercent", P_THRESHOLD};
        ItemList<Classification> detectedClassifications = this.getDetectedClassifications(igcomrsRepositoryConnector, classificationProperties, igcSearchConditionSet, sequencingOrder);
        for (Classification detectedClassification : detectedClassifications.getItems()) {
            MainObject classifiedObj = detectedClassification.getClassifiesAsset();
            if (classifiedObj == null || classifiedObj.getType().equals("main_object")) continue;
            try {
                Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), (Reference)classifiedObj, (Reference)dataClass, "detected_classifications", userId, detectedClassification.getId());
                this.setDetectedRelationshipProperties(detectedClassification, relationship, repositoryHelper, repositoryName, "mapDetectedClassifications_fromDataClass", igcomrsRepositoryConnector.getIGCVersion());
                log.debug("mapDetectedClassifications_fromDataClass - adding relationship: {}", (Object)relationship.getGUID());
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private void mapSelectedClassifications_fromDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, DataClass dataClass, String userId) {
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("selected_classification", "=", dataClass.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        IGCSearch igcSearch = new IGCSearch("amazon_s3_data_file_field", igcSearchConditionSet);
        igcSearch.addType("data_file_field");
        igcSearch.addType("database_column");
        igcSearch.addProperties(IGCRestConstants.getModificationProperties());
        igcSearch.addProperty("selected_classification");
        ItemList assetsWithSelected = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        List allAssetsWithSelected = igcomrsRepositoryConnector.getIGCRestClient().getAllPages(null, assetsWithSelected);
        for (InformationAsset assetWithSelected : allAssetsWithSelected) {
            try {
                Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), (Reference)assetWithSelected, (Reference)dataClass, "selected_classification", userId);
                this.setSelectedRelationshipProperties(relationship, igcomrsRepositoryConnector.getIGCVersion());
                log.debug("mapSelectedClassifications_fromDataClass - adding relationship: {}", (Object)relationship.getGUID());
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private void mapDetectedClassifications_toDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Classificationenabledgroup fromIgcObject, DataClass dataClass, SequencingOrder sequencingOrder, String userId) {
        String methodName = "mapDetectedClassifications_toDataClass";
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        if (fromIgcObject != null) {
            IGCSearchCondition byAsset = new IGCSearchCondition("classifies_asset", "=", fromIgcObject.getId());
            igcSearchConditionSet.addCondition(byAsset);
        }
        if (dataClass != null) {
            IGCSearchCondition byDataClass = new IGCSearchCondition("data_class", "=", dataClass.getId());
            igcSearchConditionSet.addCondition(byDataClass);
            igcSearchConditionSet.setMatchAnyCondition(false);
        }
        String[] classificationProperties = new String[]{"confidencePercent", "data_class", P_THRESHOLD};
        ItemList<Classification> detectedClassifications = this.getDetectedClassifications(igcomrsRepositoryConnector, classificationProperties, igcSearchConditionSet, sequencingOrder);
        for (Classification detectedClassification : detectedClassifications.getItems()) {
            DataClass dataClassObj = detectedClassification.getDataClass();
            if (dataClassObj == null || dataClassObj.getType() == null || dataClassObj.getType().equals("main_object")) continue;
            try {
                Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), (Reference)fromIgcObject, (Reference)dataClassObj, "detected_classifications", userId, detectedClassification.getId());
                this.setDetectedRelationshipProperties(detectedClassification, relationship, repositoryHelper, repositoryName, "mapDetectedClassifications_toDataClass", igcomrsRepositoryConnector.getIGCVersion());
                log.debug("mapDetectedClassifications_toDataClass - adding relationship: {}", (Object)relationship.getGUID());
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private void mapSelectedClassifications_toDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Classificationenabledgroup fromIgcObject, String userId) {
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        DataClass selectedClassification = fromIgcObject.getSelectedClassification();
        if (selectedClassification == null) {
            Classificationenabledgroup withSelectedClassification = (Classificationenabledgroup)igcRestClient.getAssetWithSubsetOfProperties(fromIgcObject.getId(), fromIgcObject.getType(), new String[]{"selected_classification"});
            selectedClassification = withSelectedClassification.getSelectedClassification();
        }
        if (selectedClassification != null && selectedClassification.getType() != null) {
            try {
                Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), (Reference)fromIgcObject, (Reference)selectedClassification, "selected_classification", userId);
                this.setSelectedRelationshipProperties(relationship, igcomrsRepositoryConnector.getIGCVersion());
                log.debug("mapSelectedClassifications_toDataClass - adding relationship: {}", (Object)relationship.getGUID());
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        } else {
            log.debug("No selected_classification set for asset -- skipping.");
        }
    }

    private ItemList<Classification> getDetectedClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String[] classificationProperties, IGCSearchConditionSet igcSearchConditionSet, SequencingOrder sequencingOrder) {
        ItemList detectedClassifications;
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        IGCSearch igcSearch = new IGCSearch("classification", classificationProperties, igcSearchConditionSet);
        IGCVersionEnum igcVersion = igcomrsRepositoryConnector.getIGCVersion();
        if (igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
            igcSearch.addProperty("value_frequency");
        }
        IGCSearchSorting sorting = null;
        if (sequencingOrder != null && sequencingOrder.equals((Object)SequencingOrder.GUID)) {
            sorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
        }
        if (sorting != null) {
            igcSearch.addSortingCriteria(sorting);
        }
        if (igcSearchConditionSet.size() > 0) {
            detectedClassifications = igcRestClient.search(igcSearch);
            List allPages = igcRestClient.getAllPages(null, detectedClassifications);
            detectedClassifications.setAllPages(allPages);
        } else {
            igcSearchConditionSet.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
            detectedClassifications = igcRestClient.search(igcSearch);
        }
        return detectedClassifications;
    }

    private void setDetectedRelationshipProperties(Classification detectedClassification, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String repositoryName, String methodName, IGCVersionEnum igcVersion) {
        Number valFreq;
        Number threshold;
        Number confidence;
        InstanceProperties relationshipProperties = relationship.getProperties();
        if (relationshipProperties == null) {
            relationshipProperties = new InstanceProperties();
        }
        if ((confidence = detectedClassification.getConfidencepercent()) != null) {
            int confidenceVal = confidence.intValue();
            relationshipProperties = repositoryHelper.addIntPropertyToInstance(repositoryName, relationshipProperties, "confidence", confidenceVal, methodName);
            relationshipProperties = repositoryHelper.addBooleanPropertyToInstance(repositoryName, relationshipProperties, "partialMatch", confidenceVal < 100, methodName);
        }
        if ((threshold = detectedClassification.getThreshold()) != null) {
            relationshipProperties = repositoryHelper.addFloatPropertyToInstance(repositoryName, relationshipProperties, P_THRESHOLD, threshold.floatValue(), methodName);
        }
        if ((igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) && (valFreq = detectedClassification.getValueFrequency()) != null) {
            relationshipProperties = repositoryHelper.addLongPropertyToInstance(repositoryName, relationshipProperties, "valueFrequency", valFreq.longValue(), methodName);
        }
        EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance(igcVersion).getEnumMappingByIgcValue("discovered");
        relationshipProperties.setProperty("status", (InstancePropertyValue)status);
        relationship.setProperties(relationshipProperties);
    }

    private void setSelectedRelationshipProperties(Relationship relationship, IGCVersionEnum igcVersion) {
        InstanceProperties relationshipProperties = relationship.getProperties();
        if (relationshipProperties == null) {
            relationshipProperties = new InstanceProperties();
        }
        EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance(igcVersion).getEnumMappingByIgcValue("selected");
        relationshipProperties.setProperty("status", (InstancePropertyValue)status);
        relationship.setProperties(relationshipProperties);
    }

    private static class Singleton {
        private static final DataClassAssignmentMapper INSTANCE = new DataClassAssignmentMapper();

        private Singleton() {
        }
    }
}

