/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipMappingStore {
    private static final Logger log = LoggerFactory.getLogger(RelationshipMappingStore.class);
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private List<TypeDef> typeDefs = new ArrayList<TypeDef>();
    private Map<String, RelationshipMapping> omrsGuidToMapping = new HashMap<String, RelationshipMapping>();
    private Map<String, String> omrsNameToGuid = new HashMap<String, String>();

    public RelationshipMappingStore(IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        this.igcomrsRepositoryConnector = igcomrsRepositoryConnector;
    }

    public List<TypeDef> getTypeDefs() {
        return this.typeDefs;
    }

    public boolean addMapping(TypeDef omrsTypeDef, Class<?> mappingClass) {
        RelationshipMapping mapping = this.getRelationshipMapper(mappingClass);
        if (mapping != null) {
            this.typeDefs.add(omrsTypeDef);
            String guid = omrsTypeDef.getGUID();
            this.omrsGuidToMapping.put(guid, mapping);
            this.omrsNameToGuid.put(omrsTypeDef.getName(), guid);
        }
        return mapping != null;
    }

    public RelationshipMapping getMappingByOmrsTypeGUID(String guid) {
        if (this.omrsGuidToMapping.containsKey(guid)) {
            return this.omrsGuidToMapping.get(guid);
        }
        log.warn("Unable to find mapping for OMRS type: {}", (Object)guid);
        return null;
    }

    public RelationshipMapping getMappingByOmrsTypeName(String name) {
        if (this.omrsNameToGuid.containsKey(name)) {
            String guid = this.omrsNameToGuid.get(name);
            return this.getMappingByOmrsTypeGUID(guid);
        }
        log.warn("Unable to find mapping for OMRS type: {}", (Object)name);
        return null;
    }

    public List<RelationshipMapping> getAllMappings() {
        return new ArrayList<RelationshipMapping>(this.omrsGuidToMapping.values());
    }

    public RelationshipMapping getMappingByTypes(String omrsRelationshipType, String proxyOneType, String proxyTwoType) {
        RelationshipMapping found = null;
        block0: for (RelationshipMapping candidate : this.omrsGuidToMapping.values()) {
            String relationshipLevelAssetType;
            if (candidate == null) continue;
            if (this.matchingRelationshipMapper(candidate, omrsRelationshipType, proxyOneType, proxyTwoType)) {
                found = candidate;
                break;
            }
            if (candidate.hasSubTypes()) {
                for (RelationshipMapping subMapping : candidate.getSubTypes()) {
                    if (!this.matchingRelationshipMapper(subMapping, omrsRelationshipType, proxyOneType, proxyTwoType)) continue;
                    found = subMapping;
                    continue block0;
                }
                continue;
            }
            if (!candidate.hasRelationshipLevelAsset() || !proxyOneType.equals(relationshipLevelAssetType = candidate.getRelationshipLevelIgcAsset()) || !proxyTwoType.equals(relationshipLevelAssetType)) continue;
            found = candidate;
            break;
        }
        return found;
    }

    private boolean matchingRelationshipMapper(RelationshipMapping candidate, String omrsRelationshipType, String proxyOneType, String proxyTwoType) {
        return candidate != null && candidate.getOmrsRelationshipType().equals(omrsRelationshipType) && candidate.getProxyOneMapping().matchesAssetType(proxyOneType) && candidate.getProxyTwoMapping().matchesAssetType(proxyTwoType);
    }

    private RelationshipMapping getRelationshipMapper(Class<?> mappingClass) {
        RelationshipMapping relationshipMapper = null;
        try {
            Method getInstance = mappingClass.getMethod("getInstance", IGCVersionEnum.class);
            relationshipMapper = (RelationshipMapping)getInstance.invoke(null, this.igcomrsRepositoryConnector.getIGCVersion());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to find or instantiate RelationshipMapping class: {}", mappingClass, (Object)e);
        }
        return relationshipMapper;
    }
}

