/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.InstanceMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.AttributeMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassificationMapping
extends InstanceMapping {
    private static final Logger log = LoggerFactory.getLogger(ClassificationMapping.class);
    private String igcAssetType;
    private List<String> igcRelationshipProperties;
    private String omrsEntityType;
    private String omrsClassificationType;
    private Set<String> excludeIgcAssetType;
    private List<InstanceStatus> omrsSupportedStatuses;
    private Set<String> mappedOmrsPropertyNames;
    private Map<String, EntityMapping.PropertyMapping> mappingByIgcProperty;
    private Map<String, EntityMapping.PropertyMapping> mappingByOmrsProperty;
    private List<ClassificationMapping> subtypes;

    public ClassificationMapping(String igcAssetType, String igcRelationshipProperty, String omrsEntityType, String omrsClassificationType) {
        this.igcAssetType = igcAssetType;
        this.igcRelationshipProperties = new ArrayList<String>();
        if (igcRelationshipProperty != null) {
            this.igcRelationshipProperties.add(igcRelationshipProperty);
        }
        this.omrsEntityType = omrsEntityType;
        this.omrsClassificationType = omrsClassificationType;
        this.excludeIgcAssetType = new HashSet<String>();
        this.omrsSupportedStatuses = new ArrayList<InstanceStatus>();
        this.mappedOmrsPropertyNames = new HashSet<String>();
        this.mappingByIgcProperty = new HashMap<String, EntityMapping.PropertyMapping>();
        this.mappingByOmrsProperty = new HashMap<String, EntityMapping.PropertyMapping>();
        this.subtypes = new ArrayList<ClassificationMapping>();
        this.addSupportedStatus(InstanceStatus.ACTIVE);
        this.addSupportedStatus(InstanceStatus.DELETED);
    }

    public static boolean isClassification(IGCRestClient igcRestClient, Reference igcObject) {
        Identity identity;
        Identity rootIdentity;
        String assetType = IGCRestConstants.getAssetTypeForSearch((String)igcObject.getType());
        if ((assetType.equals("category") || assetType.equals("term")) && (rootIdentity = (identity = igcObject.getIdentity(igcRestClient)).getUltimateParentIdentity()) != null) {
            return rootIdentity.getName().equals("Classifications");
        }
        return false;
    }

    public void addSupportedStatus(InstanceStatus status) {
        this.omrsSupportedStatuses.add(status);
    }

    public List<InstanceStatus> getSupportedStatuses() {
        return this.omrsSupportedStatuses;
    }

    public void addMappedOmrsProperty(String name) {
        this.mappedOmrsPropertyNames.add(name);
    }

    @Override
    public Set<String> getMappedOmrsPropertyNames() {
        HashSet<String> omrsProperties = new HashSet<String>();
        if (this.mappedOmrsPropertyNames != null) {
            omrsProperties.addAll(this.mappedOmrsPropertyNames);
        }
        if (this.getLiteralPropertyMappings() != null) {
            omrsProperties.addAll(this.getLiteralPropertyMappings());
        }
        omrsProperties.addAll(this.mappingByOmrsProperty.keySet());
        return omrsProperties;
    }

    public String getIgcAssetType() {
        return this.igcAssetType;
    }

    public Set<String> getMappedIgcPropertyNames() {
        HashSet<String> igcProperties = new HashSet<String>();
        if (this.igcRelationshipProperties != null) {
            igcProperties.addAll(this.igcRelationshipProperties);
        }
        igcProperties.addAll(this.getSimpleMappedIgcProperties());
        return igcProperties;
    }

    public final Set<String> getSimpleMappedIgcProperties() {
        return this.mappingByIgcProperty.keySet();
    }

    public String getOmrsClassificationType() {
        return this.omrsClassificationType;
    }

    public void addExcludedIgcAssetType(String igcAssetType) {
        this.excludeIgcAssetType.add(igcAssetType);
    }

    public Set<String> getExcludedIgcAssetTypes() {
        return this.excludeIgcAssetType;
    }

    public void addIgcRelationshipProperty(String property) {
        this.igcRelationshipProperties.add(property);
    }

    public final void addSimplePropertyMapping(String igcPropertyName, String omrsPropertyName) {
        if (omrsPropertyName != null && igcPropertyName != null) {
            EntityMapping.PropertyMapping pm = new EntityMapping.PropertyMapping(igcPropertyName, omrsPropertyName);
            if (this.mappingByOmrsProperty.containsKey(omrsPropertyName)) {
                EntityMapping.PropertyMapping existing = this.mappingByOmrsProperty.remove(omrsPropertyName);
                this.mappingByIgcProperty.remove(existing.getIgcPropertyName());
            }
            this.mappingByOmrsProperty.put(omrsPropertyName, pm);
            this.mappingByIgcProperty.put(igcPropertyName, pm);
        } else {
            log.warn("Attempted to add null property to mapping -- IGC = {}, OMRS = {}", (Object)igcPropertyName, (Object)omrsPropertyName);
        }
    }

    public boolean hasSubTypes() {
        return !this.subtypes.isEmpty();
    }

    public void addSubType(ClassificationMapping subClassificationMapping) {
        this.subtypes.add(subClassificationMapping);
    }

    public List<ClassificationMapping> getSubTypes() {
        return this.subtypes;
    }

    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        try {
            Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, new InstanceProperties(), fromIgcObject, userId);
            classifications.add(classification);
        }
        catch (RepositoryErrorException e) {
            log.error("Unable to map classification.", (Throwable)e);
        }
    }

    public IGCSearchConditionSet getIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, InstanceProperties matchClassificationProperties) throws FunctionNotSupportedException {
        return new IGCSearchConditionSet();
    }

    public boolean matchesAssetType(String igcAssetType) {
        String simplifiedType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
        return this.igcAssetType.equals(simplifiedType) || this.igcAssetType.equals("main_object") && !this.excludeIgcAssetType.contains(simplifiedType);
    }

    protected Classification getMappedClassification(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, InstanceProperties classificationProperties, Reference fromIgcObject, String userId) throws RepositoryErrorException {
        String methodName = "getMappedClassification";
        Classification classification = null;
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        IGCOMRSMetadataCollection igcomrsMetadataCollection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
        OMRSRepositoryHelper omrsRepositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        Map<String, TypeDefAttribute> omrsAttributeMap = igcomrsMetadataCollection.getTypeDefAttributesForType(this.omrsClassificationType);
        for (Map.Entry<String, EntityMapping.PropertyMapping> entry : this.mappingByIgcProperty.entrySet()) {
            String igcPropertyName = entry.getKey();
            String omrsAttribute = entry.getValue().getOmrsPropertyName();
            if (omrsAttributeMap.containsKey(omrsAttribute)) {
                TypeDefAttribute typeDefAttribute = omrsAttributeMap.get(omrsAttribute);
                classificationProperties = AttributeMapping.addPrimitivePropertyToInstance(omrsRepositoryHelper, repositoryName, classificationProperties, typeDefAttribute, igcRestClient.getPropertyByName(fromIgcObject, igcPropertyName), "getMappedClassification");
                continue;
            }
            log.warn("No OMRS attribute {} defined for classification type {} -- skipping mapping.", (Object)omrsAttribute, (Object)this.omrsClassificationType);
        }
        for (String omrsPropertyName : this.getLiteralPropertyMappings()) {
            Object value;
            if (!omrsAttributeMap.containsKey(omrsPropertyName) || (value = this.getOmrsPropertyLiteralValue(omrsPropertyName)) == null) continue;
            TypeDefAttribute typeDefAttribute = omrsAttributeMap.get(omrsPropertyName);
            AttributeTypeDefCategory attributeTypeDefCategory = typeDefAttribute.getAttributeType().getCategory();
            if (attributeTypeDefCategory == AttributeTypeDefCategory.PRIMITIVE) {
                classificationProperties = AttributeMapping.addPrimitivePropertyToInstance(omrsRepositoryHelper, repositoryName, classificationProperties, typeDefAttribute, value, "getMappedClassification");
                continue;
            }
            classificationProperties.setProperty(omrsPropertyName, (InstancePropertyValue)value);
        }
        try {
            classification = igcomrsRepositoryConnector.getRepositoryHelper().getNewClassification(igcomrsRepositoryConnector.getRepositoryName(), userId, this.omrsClassificationType, this.omrsEntityType, ClassificationOrigin.ASSIGNED, null, classificationProperties);
            if (igcRestClient.hasModificationDetails(fromIgcObject.getType())) {
                classification.setCreatedBy((String)igcRestClient.getPropertyByName(fromIgcObject, "created_by"));
                classification.setCreateTime((Date)igcRestClient.getPropertyByName(fromIgcObject, "created_on"));
                classification.setUpdateTime((Date)igcRestClient.getPropertyByName(fromIgcObject, "modified_on"));
                classification.setUpdatedBy((String)igcRestClient.getPropertyByName(fromIgcObject, "modified_by"));
                if (classification.getUpdateTime() != null) {
                    classification.setVersion(classification.getUpdateTime().getTime());
                }
            }
        }
        catch (TypeErrorException e) {
            throw new RepositoryErrorException(IGCOMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(this.omrsClassificationType, this.omrsEntityType), this.getClass().getName(), "getMappedClassification", (Throwable)e);
        }
        return classification;
    }
}

