/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Category;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Term;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaMapper.class);

    public static SubjectAreaMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected SubjectAreaMapper() {
        super("category", "assigned_to_terms", "Referenceable", "SubjectArea");
        this.addMappedOmrsProperty("name");
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        ItemList assignedToTerms;
        String methodName = "addMappedOMRSClassifications";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        if (fromIgcObject instanceof Category && (assignedToTerms = ((Category)fromIgcObject).getAssignedToTerms()) != null) {
            List allAssignedToTerms = igcRestClient.getAllPages("assigned_to_terms", assignedToTerms);
            log.debug("Looking for SubjectArea mapping within {} candidate terms.", (Object)allAssignedToTerms.size());
            boolean isSubjectArea = false;
            for (Term termCandidate : allAssignedToTerms) {
                if (!termCandidate.getName().equals(this.getOmrsClassificationType())) continue;
                isSubjectArea = true;
                break;
            }
            if (isSubjectArea) {
                log.debug(" ... found SubjectArea classification.");
                InstanceProperties classificationProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), null, "name", fromIgcObject.getName(), "addMappedOMRSClassifications");
                try {
                    Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, classificationProperties, fromIgcObject, userId);
                    classifications.add(classification);
                }
                catch (RepositoryErrorException e) {
                    log.error("Unable to map classification.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, InstanceProperties matchClassificationProperties) throws FunctionNotSupportedException {
        Map properties;
        String methodName = "getIGCSearchCriteria";
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("assigned_to_terms.name", "=", this.getOmrsClassificationType());
        IGCSearchConditionSet subjectArea = new IGCSearchConditionSet(igcSearchCondition);
        IGCSearchConditionSet byName = new IGCSearchConditionSet();
        if (matchClassificationProperties != null && (properties = matchClassificationProperties.getInstanceProperties()).containsKey("name")) {
            PrimitivePropertyValue name = (PrimitivePropertyValue)properties.get("name");
            String subjectAreaName = name.valueAsString();
            IGCSearchCondition condition = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "getIGCSearchCriteria", "name", subjectAreaName);
            byName.addCondition(condition);
            byName.setMatchAnyCondition(false);
        }
        if (byName.size() > 0) {
            igcSearchConditionSet.addNestedConditionSet(subjectArea);
            igcSearchConditionSet.addNestedConditionSet(byName);
            igcSearchConditionSet.setMatchAnyCondition(false);
            return igcSearchConditionSet;
        }
        return subjectArea;
    }

    private static class Singleton {
        private static final SubjectAreaMapper INSTANCE = new SubjectAreaMapper();

        private Singleton() {
        }
    }
}

