/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.ConnectionEndpointMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointMapper
extends ReferenceableMapper {
    private static final Logger log = LoggerFactory.getLogger(EndpointMapper.class);

    public static EndpointMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected EndpointMapper() {
        super("host", "Host", "Endpoint");
        this.addOtherIGCAssetType("host_(engine)");
        this.addSimplePropertyMapping("name", "name");
        this.addSimplePropertyMapping("short_description", "description");
        this.addLiteralPropertyMapping("protocol", null);
        this.addLiteralPropertyMapping("encryptionMethod", null);
        this.addRelationshipMapper(ConnectionEndpointMapper.getInstance(null));
        this.addComplexIgcProperty("name");
        this.addComplexOmrsProperty("networkAddress");
    }

    @Override
    public Reference getBaseIgcAssetFromAlternative(String otherAssetType, String otherAssetRid, IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        if (otherAssetType.equals("host_(engine)")) {
            IGCSearchCondition igcSearchCondition = new IGCSearchCondition("_id", "=", otherAssetRid);
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
            IGCSearch igcSearch = new IGCSearch("host", igcSearchConditionSet);
            igcSearch.setPageSize(2);
            ItemList hosts = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
            if (!hosts.getItems().isEmpty()) {
                return (Reference)hosts.getItems().get(0);
            }
            log.warn("Unable to translate host_(engine) to host, returning host_(engine).");
            return super.getBaseIgcAssetFromAlternative(otherAssetType, otherAssetRid, igcomrsRepositoryConnector);
        }
        log.debug("Not a host_(engine) asset, just returning as-is: {}", (Object)otherAssetType);
        return super.getBaseIgcAssetFromAlternative(otherAssetType, otherAssetRid, igcomrsRepositoryConnector);
    }

    @Override
    protected InstanceProperties complexPropertyMappings(EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        instanceProperties = super.complexPropertyMappings(entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        Reference igcEntity = entityMap.getIgcEntity();
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        String networkAddress = (String)igcRestClient.getPropertyByName(igcEntity, "name");
        instanceProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), instanceProperties, "networkAddress", networkAddress, "complexPropertyMappings");
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, InstancePropertyValue value) throws FunctionNotSupportedException {
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, value);
        String methodName = "addComplexPropertySearchCriteria";
        if (omrsPropertyName.equals("networkAddress")) {
            log.debug("Adding complex search criteria for: networkAddress");
            String networkAddress = ((PrimitivePropertyValue)value).getPrimitiveValue().toString();
            IGCSearchCondition condition = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", "name", networkAddress);
            igcSearchConditionSet.addCondition(condition);
        }
    }

    private static class Singleton {
        private static final EndpointMapper INSTANCE = new EndpointMapper();

        private Singleton() {
        }
    }
}

