/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaElement_Mapper
extends ReferenceableMapper {
    private static final Logger log = LoggerFactory.getLogger(SchemaElement_Mapper.class);

    protected SchemaElement_Mapper(String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName, String prefix) {
        super(igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName, prefix);
        this.addSimplePropertyMapping("name", "displayName");
        this.addSimplePropertyMapping("short_description", "description");
        this.addComplexOmrsProperty("anchorGUID");
    }

    @Override
    protected InstanceProperties complexPropertyMappings(EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        IGCRepositoryHelper igcRepositoryHelper;
        instanceProperties = super.complexPropertyMappings(entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        Reference igcEntity = entityMap.getIgcEntity();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        try {
            igcRepositoryHelper = ((IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection()).getIgcRepositoryHelper();
        }
        catch (RepositoryErrorException e) {
            throw new OMRSRuntimeException(IGCOMRSErrorCode.REST_CLIENT_FAILURE.getMessageDefinition(igcomrsRepositoryConnector.getServerName()), this.getClass().getName(), "complexPropertyMappings", (Throwable)e);
        }
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        instanceProperties = this.addAnchorGUIDProperty(repositoryHelper, repositoryName, igcRepositoryHelper, igcEntity, igcRestClient, instanceProperties);
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, InstancePropertyValue value) throws FunctionNotSupportedException {
        String guidString;
        IGCSearchConditionSet toAdd;
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, value);
        String methodName = "addComplexPropertySearchCriteria";
        if (omrsPropertyName.equals("anchorGUID") && value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE) && (toAdd = this.getParentAssetSearchCriteria(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", guidString = value.valueAsString(), true)).size() > 0) {
            igcSearchConditionSet.addNestedConditionSet(toAdd);
        }
    }

    @Override
    public void addComplexStringSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String searchCriteria) throws FunctionNotSupportedException {
        String methodName = "addComplexStringSearchCriteria";
        IGCSearchConditionSet toAdd = this.getParentAssetSearchCriteria(repositoryHelper, repositoryName, "addComplexStringSearchCriteria", searchCriteria, false);
        if (toAdd.size() > 0) {
            igcSearchConditionSet.addNestedConditionSet(toAdd);
        }
    }

    protected String getParentPropertyName() {
        String parentPropertyName = null;
        switch (this.getIgcAssetType()) {
            case "database_column": {
                parentPropertyName = "database_table_or_view";
                break;
            }
            case "database_schema": {
                parentPropertyName = "database";
                break;
            }
            case "database_table": {
                parentPropertyName = "database_schema";
                break;
            }
            case "data_file_field": {
                parentPropertyName = "data_file_record";
                break;
            }
            case "data_file_record": {
                parentPropertyName = "data_file";
            }
        }
        return parentPropertyName;
    }

    protected IGCSearchConditionSet getParentAssetSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, String methodName, String regex, boolean failOnInexactRegex) throws FunctionNotSupportedException {
        IGCSearchConditionSet conditions = new IGCSearchConditionSet();
        if (repositoryHelper.isExactMatchRegex(regex)) {
            IGCEntityGuid guid = IGCEntityGuid.fromGuid(repositoryHelper.getUnqualifiedLiteralString(regex));
            if (guid != null) {
                switch (this.getIgcAssetType()) {
                    case "database_column": {
                        IGCSearchConditionSet nested = new IGCSearchConditionSet();
                        IGCSearchCondition view = new IGCSearchCondition("view.database_schema", "=", guid.getRid());
                        IGCSearchCondition table = new IGCSearchCondition("database_table.database_schema", "=", guid.getRid());
                        nested.addCondition(view);
                        nested.addCondition(table);
                        nested.setMatchAnyCondition(true);
                        conditions.addNestedConditionSet(nested);
                        break;
                    }
                    case "database_table": {
                        IGCSearchCondition condition = new IGCSearchCondition("database_schema", "=", guid.getRid());
                        conditions.addCondition(condition);
                        break;
                    }
                    case "data_file_field": {
                        IGCSearchCondition condition = new IGCSearchCondition("data_file_record.data_file", "=", guid.getRid());
                        conditions.addCondition(condition);
                        break;
                    }
                    case "data_file_record": {
                        IGCSearchCondition condition = new IGCSearchCondition("data_file", "=", guid.getRid());
                        conditions.addCondition(condition);
                        break;
                    }
                    default: {
                        log.warn("Unable to add criteria for anchorGUID, type not known: {}", (Object)this.getIgcAssetType());
                    }
                }
            }
        } else if (failOnInexactRegex) {
            throw new FunctionNotSupportedException(IGCOMRSErrorCode.REGEX_NOT_IMPLEMENTED.getMessageDefinition(repositoryName, regex), this.getClass().getName(), methodName);
        }
        return conditions;
    }

    protected InstanceProperties addAnchorGUIDProperty(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRepositoryHelper igcRepositoryHelper, Reference igcEntity, IGCRestClient igcRestClient, InstanceProperties instanceProperties) {
        String methodName = "addAnchorGUIDProperty";
        Identity identity = igcEntity.getIdentity(igcRestClient);
        Identity asset = this.getParentAssetIdentity(identity);
        if (asset != null) {
            IGCEntityGuid assetGuid = igcRepositoryHelper.getEntityGuid(asset.getAssetType(), null, asset.getRid());
            instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "anchorGUID", assetGuid.toString(), "addAnchorGUIDProperty");
        }
        return instanceProperties;
    }

    private Identity getParentAssetIdentity(Identity identity) {
        Identity parent = identity.getParentIdentity();
        if (parent != null) {
            String type = parent.getAssetType();
            if (type.equals("database_schema") || type.equals("data_file")) {
                return parent;
            }
            return this.getParentAssetIdentity(parent);
        }
        return null;
    }
}

