/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import java.util.Collections;
import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Note;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachedNoteLogEntryMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(AttachedNoteLogEntryMapper.class);

    public static AttachedNoteLogEntryMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected AttachedNoteLogEntryMapper() {
        super("main_object", "note", "notes", "belonging_to", "AttachedNoteLogEntry", "logs", "entries", "NL", null);
        this.setContainedType(RelationshipMapping.ContainedType.TWO);
        this.setOptimalStart(RelationshipMapping.OptimalStart.CUSTOM);
        RelationshipMapping.ProxyMapping pmOne = this.getProxyOneMapping();
        pmOne.addExcludedIgcAssetType("connector");
        pmOne.addExcludedIgcAssetType("data_connection");
        pmOne.addExcludedIgcAssetType("group");
        pmOne.addExcludedIgcAssetType("label");
    }

    private Reference getAssetFromNote(Note note, IGCRestClient igcRestClient) {
        Reference asset = note.getBelongingTo();
        if (asset == null) {
            Note withAsset = (Note)igcRestClient.getAssetWithSubsetOfProperties(note.getId(), note.getType(), new String[]{"belonging_to"});
            asset = withAsset.getBelongingTo();
        }
        return asset;
    }

    private List<Note> getNotesFromAsset(Reference asset, IGCRestClient igcRestClient) {
        ItemList notes = asset.getNotes();
        if (notes != null) {
            return igcRestClient.getAllPages("notes", notes);
        }
        String type = asset.getType();
        if (igcRestClient.getPagedRelationshipPropertiesForType(type).contains("notes")) {
            Reference withNotes = igcRestClient.getAssetWithSubsetOfProperties(asset.getId(), asset.getType(), new String[]{"notes"});
            notes = withNotes.getNotes();
            return igcRestClient.getAllPages("notes", notes);
        }
        return Collections.emptyList();
    }

    @Override
    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
        log.debug("Adding mapped relationships from {} to {}.", (Object)(fromIgcObject == null ? "<null>" : fromIgcObject.getType()), (Object)(toIgcObject == null ? "<null>" : toIgcObject.getType()));
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        RelationshipDef relationshipDef = (RelationshipDef)repositoryHelper.getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), "AttachedNoteLogEntry");
        RelationshipMapping.ProxyMapping one = this.getProxyOneMapping();
        if (fromIgcObject instanceof Note) {
            if (toIgcObject != null && one.matchesAssetType(toIgcObject.getType())) {
                this.addRelationshipSafe(igcomrsRepositoryConnector, relationshipDef, toIgcObject, fromIgcObject, userId, relationships);
            } else if (toIgcObject == null) {
                Reference asset = this.getAssetFromNote((Note)fromIgcObject, igcRestClient);
                if (asset != null) {
                    this.addRelationshipSafe(igcomrsRepositoryConnector, relationshipDef, asset, fromIgcObject, userId, relationships);
                } else {
                    log.warn("Unable to find the owning asset for note: {}", (Object)fromIgcObject);
                }
            } else {
                log.warn("Skipping asset relationship, not a type that contains notes: {}", (Object)fromIgcObject);
            }
        } else if (fromIgcObject != null && one.matchesAssetType(fromIgcObject.getType())) {
            if (toIgcObject instanceof Note) {
                this.addRelationshipSafe(igcomrsRepositoryConnector, relationshipDef, fromIgcObject, toIgcObject, userId, relationships);
            } else {
                List<Note> notes = this.getNotesFromAsset(fromIgcObject, igcRestClient);
                for (Note note : notes) {
                    this.addRelationshipSafe(igcomrsRepositoryConnector, relationshipDef, fromIgcObject, (Reference)note, userId, relationships);
                }
            }
        } else {
            log.warn("Neither end of the relationship was an IGC note, unable to determine relationship.");
        }
    }

    private void addRelationshipSafe(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipDef relationshipDef, Reference asset, Reference note, String userId, List<Relationship> relationships) {
        try {
            Relationship relationship = AttachedNoteLogEntryMapper.getMappedRelationship(igcomrsRepositoryConnector, AttachedNoteLogEntryMapper.getInstance(null), relationshipDef, asset, note, "notes", userId, null, true);
            relationships.add(relationship);
        }
        catch (RepositoryErrorException e) {
            log.error("Unable to map note-containing asset relationship.", (Throwable)e);
        }
    }

    @Override
    public List<IGCSearch> getComplexIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, InstanceProperties matchProperties, MatchCriteria matchCriteria) {
        return Collections.emptyList();
    }

    @Override
    public List<IGCSearch> getComplexIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, String searchCriteria) throws FunctionNotSupportedException {
        return Collections.emptyList();
    }

    private static class Singleton {
        private static final AttachedNoteLogEntryMapper INSTANCE = new AttachedNoteLogEntryMapper();

        private Singleton() {
        }
    }
}

