/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Connector;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionEndpointMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(ConnectionEndpointMapper.class);

    public static ConnectionEndpointMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected ConnectionEndpointMapper() {
        super("host", "data_connection", "data_connections", "data_connectors", "ConnectionEndpoint", "connectionEndpoint", "connections");
        this.setOptimalStart(RelationshipMapping.OptimalStart.CUSTOM);
        this.setLinkingAssetType("connector");
    }

    @Override
    public List<Reference> getProxyOneAssetFromAsset(Reference connectorAsset, IGCRestClient igcRestClient) {
        String otherAssetType = connectorAsset.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (otherAssetType.equals("connector")) {
            Reference withHost = igcRestClient.getAssetWithSubsetOfProperties(connectorAsset.getId(), connectorAsset.getType(), new String[]{"host", "data_connections"});
            asList.add((Reference)igcRestClient.getPropertyByName(withHost, "host"));
        } else {
            log.debug("Not a connector asset, just returning as-is: {} of type {}", (Object)connectorAsset.getName(), (Object)connectorAsset.getType());
            asList.add(connectorAsset);
        }
        return asList;
    }

    @Override
    public List<Reference> getProxyTwoAssetFromAsset(Reference connectorAsset, IGCRestClient igcRestClient) {
        if (connectorAsset != null && connectorAsset.getType().equals("connector")) {
            Connector withDataConnections = (Connector)igcRestClient.getAssetWithSubsetOfProperties(connectorAsset.getId(), connectorAsset.getType(), new String[]{"host", "data_connections"});
            ItemList dataConnections = withDataConnections.getDataConnections();
            return new ArrayList<Reference>(igcRestClient.getAllPages("data_connections", dataConnections));
        }
        if (connectorAsset != null) {
            log.debug("Not a connector asset, just returning as-is: {} of type {}", (Object)connectorAsset.getName(), (Object)connectorAsset.getType());
            ArrayList<Reference> referenceAsList = new ArrayList<Reference>();
            referenceAsList.add(connectorAsset);
            return referenceAsList;
        }
        log.warn("Received a null object, returning an empty list.");
        return Collections.emptyList();
    }

    @Override
    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
        String assetType = IGCRestConstants.getAssetTypeForSearch((String)fromIgcObject.getType());
        if (assetType.equals("host")) {
            this.addMappedOMRSRelationships_host(igcomrsRepositoryConnector, relationships, fromIgcObject, fromRelationshipElement, sequencingOrder, pageSize, userId);
        } else if (assetType.equals("data_connection")) {
            this.addMappedOMRSRelationships_connection(igcomrsRepositoryConnector, relationships, fromIgcObject, fromRelationshipElement, sequencingOrder, pageSize, userId);
        } else if (assetType.equals("connector")) {
            List<Reference> connections = this.getProxyTwoAssetFromAsset(fromIgcObject, igcomrsRepositoryConnector.getIGCRestClient());
            for (Reference connection : connections) {
                this.addMappedOMRSRelationships_connection(igcomrsRepositoryConnector, relationships, connection, fromRelationshipElement, sequencingOrder, pageSize, userId);
            }
        } else {
            log.warn("Found unexpected asset type during relationship mapping: {}", (Object)fromIgcObject);
        }
    }

    private void addMappedOMRSRelationships_host(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("data_connectors.host", "=", fromIgcObject.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        String[] properties = new String[]{"name"};
        IGCSearch igcSearch = new IGCSearch("data_connection", properties, igcSearchConditionSet);
        IGCSearchSorting sorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
        if (sorting != null) {
            igcSearch.addSortingCriteria(sorting);
        }
        if (pageSize > 0) {
            igcSearch.setPageSize(fromRelationshipElement + pageSize);
        }
        ItemList dataConnections = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        if (pageSize == 0) {
            List allPages = igcomrsRepositoryConnector.getIGCRestClient().getAllPages(null, dataConnections);
            dataConnections.setAllPages(allPages);
        }
        for (Reference dataConnection : dataConnections.getItems()) {
            if (dataConnection == null || dataConnection.getType().equals("main_object")) continue;
            try {
                log.debug("Retrieved connection: {} of type {}", (Object)dataConnection.getName(), (Object)dataConnection.getType());
                Relationship relationship = ConnectionEndpointMapper.getMappedRelationship(igcomrsRepositoryConnector, ConnectionEndpointMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), "ConnectionEndpoint"), fromIgcObject, dataConnection, "data_connections", userId);
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private void addMappedOMRSRelationships_connection(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("data_connections", "=", fromIgcObject.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        String[] properties = new String[]{"host"};
        IGCSearch igcSearch = new IGCSearch("connector", properties, igcSearchConditionSet);
        IGCSearchSorting sorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
        if (sorting != null) {
            igcSearch.addSortingCriteria(sorting);
        }
        if (pageSize > 0) {
            igcSearch.setPageSize(fromRelationshipElement + pageSize);
        }
        ItemList dataConnectors = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        if (pageSize == 0) {
            List allPages = igcomrsRepositoryConnector.getIGCRestClient().getAllPages(null, dataConnectors);
            dataConnectors.setAllPages(allPages);
        }
        for (Reference dataConnector : dataConnectors.getItems()) {
            if (dataConnector == null || dataConnector.getType().equals("main_object")) continue;
            try {
                log.debug("Retrieved connector: {} of type {}", (Object)dataConnector.getName(), (Object)dataConnector.getType());
                Reference host = (Reference)igcRestClient.getPropertyByName(dataConnector, "host");
                log.debug("Retrieved host: {} of type {}", (Object)host.getName(), (Object)host.getType());
                Relationship relationship = ConnectionEndpointMapper.getMappedRelationship(igcomrsRepositoryConnector, ConnectionEndpointMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), "ConnectionEndpoint"), host, fromIgcObject, "data_connections", userId);
                relationships.add(relationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to map relationship.", (Throwable)e);
            }
        }
    }

    private static class Singleton {
        private static final ConnectionEndpointMapper INSTANCE = new ConnectionEndpointMapper();

        private Singleton() {
        }
    }
}

