/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.InstanceMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCRelationshipGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.OMRSStub;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.ClassificationMappingStore;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.EntityMappingStore;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.RelationshipMappingStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGCRepositoryHelper {
    private static final Logger log = LoggerFactory.getLogger(IGCRepositoryHelper.class);
    public static final String MAPPING_PKG = "org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.";
    public static final String DEFAULT_IGC_TYPE = "main_object";
    public static final String DEFAULT_IGC_TYPE_DISPLAY_NAME = "Main Object";
    private static final String GENERATED_ENTITY_QNAME_PREFIX = "gen!";
    private static final String GENERATED_ENTITY_QNAME_POSTFIX = "@";
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private OMRSRepositoryHelper repositoryHelper;
    private IGCRestClient igcRestClient;
    private EntityMappingStore entityMappingStore;
    private RelationshipMappingStore relationshipMappingStore;
    private ClassificationMappingStore classificationMappingStore;
    private String repositoryName;
    private String metadataCollectionId;
    private XMLOutputFactory xmlOutputFactory;

    IGCRepositoryHelper(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, OMRSRepositoryHelper repositoryHelper, IGCRestClient igcRestClient) {
        this.igcomrsRepositoryConnector = igcomrsRepositoryConnector;
        this.repositoryHelper = repositoryHelper;
        this.igcRestClient = igcRestClient;
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
        this.repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        this.metadataCollectionId = igcomrsRepositoryConnector.getMetadataCollectionId();
        this.entityMappingStore = new EntityMappingStore(igcomrsRepositoryConnector);
        this.relationshipMappingStore = new RelationshipMappingStore(igcomrsRepositoryConnector);
        this.classificationMappingStore = new ClassificationMappingStore(igcomrsRepositoryConnector);
    }

    boolean addEntityMapping(TypeDef omrsTypeDef, Class mappingClass) {
        return this.entityMappingStore.addMapping(omrsTypeDef, mappingClass, this.igcomrsRepositoryConnector);
    }

    boolean updateEntityMapping(TypeDefPatch typeDefPatch) throws InvalidParameterException, PatchErrorException {
        return this.entityMappingStore.updateMapping(typeDefPatch);
    }

    TypeDef getEntityTypeDefByGUID(String guid) {
        return this.entityMappingStore.getTypeDefByGUID(guid);
    }

    boolean addClassificationMapping(TypeDef omrsTypeDef, Class mappingClass) {
        return this.classificationMappingStore.addMapping(omrsTypeDef, mappingClass);
    }

    boolean updateClassificationMapping(TypeDefPatch typeDefPatch) throws InvalidParameterException, PatchErrorException {
        return this.classificationMappingStore.updateMapping(typeDefPatch);
    }

    TypeDef getClassificationTypeDefByGUID(String guid) {
        return this.classificationMappingStore.getTypeDefByGUID(guid);
    }

    boolean addRelationshipMapping(TypeDef omrsTypeDef, Class mappingClass) {
        return this.relationshipMappingStore.addMapping(omrsTypeDef, mappingClass);
    }

    boolean updateRelationshipMapping(TypeDefPatch typeDefPatch) throws InvalidParameterException, PatchErrorException {
        return this.relationshipMappingStore.updateMapping(typeDefPatch);
    }

    TypeDef getRelationshipTypeDefByGUID(String guid) {
        return this.relationshipMappingStore.getTypeDefByGUID(guid);
    }

    List<RelationshipMapping> getAllRelationshipMappings() {
        return this.relationshipMappingStore.getAllMappings();
    }

    List<EntityMapping> getAllEntityMappings() {
        return this.entityMappingStore.getAllMappings();
    }

    List<TypeDef> getMappedEntityTypes() {
        return this.entityMappingStore.getTypeDefs();
    }

    List<TypeDef> getMappedClassificationTypes() {
        return this.classificationMappingStore.getTypeDefs();
    }

    List<TypeDef> getMappedRelationshipTypes() {
        return this.relationshipMappingStore.getTypeDefs();
    }

    EntityMapping getEntityMappingByGUID(String guid) {
        return this.entityMappingStore.getMappingByOmrsTypeGUID(guid);
    }

    EntityMapping getEntityMappingByIgcType(String assetType, String prefix) {
        return this.entityMappingStore.getMappingByIgcAssetTypeAndPrefix(assetType, prefix);
    }

    List<EntityMapping> getEntityMappingsByIgcType(String assetType) {
        return this.entityMappingStore.getMappingsByIgcAssetType(assetType);
    }

    Set<EntityMapping> getEntityMappingsByPrefix(String prefix) {
        return this.entityMappingStore.getMappingsByIgcPrefix(prefix);
    }

    ClassificationMapping getClassificationMappingByGUID(String guid) {
        return this.classificationMappingStore.getMappingByOmrsTypeGUID(guid);
    }

    RelationshipMapping getRelationshipMappingByGUID(String guid) {
        return this.relationshipMappingStore.getMappingByOmrsTypeGUID(guid);
    }

    ClassificationMapping getClassificationMappingByTypes(String omrsClassificationType, String igcAssetType) {
        return this.classificationMappingStore.getMappingByTypes(omrsClassificationType, igcAssetType);
    }

    RelationshipMapping getRelationshipMappingByTypes(String omrsRelationshipType, String proxyOneType, String proxyTwoType) {
        return this.relationshipMappingStore.getMappingByTypes(omrsRelationshipType, proxyOneType, proxyTwoType);
    }

    public Map<String, List<RelationshipMapping>> getIgcPropertiesToRelationshipMappings(String assetType, String userId) {
        HashMap<String, List<RelationshipMapping>> map = new HashMap<String, List<RelationshipMapping>>();
        List<EntityMapping> mappers = this.getMappers(assetType, userId);
        for (EntityMapping mapper : mappers) {
            List<RelationshipMapping> relationshipMappings = mapper.getRelationshipMappers();
            for (RelationshipMapping relationshipMapping : relationshipMappings) {
                if (relationshipMapping.getProxyOneMapping().matchesAssetType(assetType)) {
                    List<String> relationshipNamesOne = relationshipMapping.getProxyOneMapping().getIgcRelationshipProperties();
                    for (String relationshipName : relationshipNamesOne) {
                        if (!map.containsKey(relationshipName)) {
                            map.put(relationshipName, new ArrayList());
                        }
                        if (map.get(relationshipName).contains(relationshipMapping)) continue;
                        map.get(relationshipName).add(relationshipMapping);
                    }
                }
                if (!relationshipMapping.getProxyTwoMapping().matchesAssetType(assetType)) continue;
                List<String> relationshipNamesTwo = relationshipMapping.getProxyTwoMapping().getIgcRelationshipProperties();
                for (String relationshipName : relationshipNamesTwo) {
                    if (!map.containsKey(relationshipName)) {
                        map.put(relationshipName, new ArrayList());
                    }
                    if (map.get(relationshipName).contains(relationshipMapping)) continue;
                    map.get(relationshipName).add(relationshipMapping);
                }
            }
        }
        return map;
    }

    void processResultsForMapping(EntityMapping mapping, List<EntityDetail> entityDetails, String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "processResultsForMapping";
        IGCOMRSMetadataCollection igcomrsMetadataCollection = (IGCOMRSMetadataCollection)this.igcomrsRepositoryConnector.getMetadataCollection();
        String igcAssetType = mapping.getIgcAssetType();
        IGCSearchConditionSet classificationLimiters = this.getSearchCriteriaForClassifications(igcAssetType, matchClassifications);
        if (matchClassifications != null && !matchClassifications.getConditions().isEmpty() && classificationLimiters == null) {
            log.info("Classification limiters were specified, but none apply to the asset type {}, so excluding this asset type from search.", (Object)igcAssetType);
        } else {
            IGCSearch igcSearch = new IGCSearch();
            igcSearch.addType(igcAssetType);
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
            MatchCriteria outerMatchCriteria = matchProperties.getMatchCriteria();
            IGCRepositoryHelper.addTypeSpecificConditions(mapping, outerMatchCriteria, matchProperties, igcSearchConditionSet);
            String qualifiedNameRegex = null;
            InstanceMapping.SearchFilter filter = mapping.getAllNoneOrSome(matchProperties);
            if (filter.equals((Object)InstanceMapping.SearchFilter.NONE)) {
                igcSearchConditionSet.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
            } else if (filter.equals((Object)InstanceMapping.SearchFilter.SOME)) {
                qualifiedNameRegex = this.addAllConditions(igcSearchConditionSet, matchProperties, mapping);
            } else {
                log.debug("Skipping detailed matchProperties iteration, as we should return all types based on criteria and literal mappings.");
            }
            if (!filter.equals((Object)InstanceMapping.SearchFilter.NONE)) {
                if (classificationLimiters != null) {
                    igcSearchConditionSet.addNestedConditionSet(classificationLimiters);
                }
                IGCSearchSorting igcSearchSorting = null;
                if (sequencingProperty == null && sequencingOrder != null) {
                    igcSearchSorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
                }
                igcSearch.addProperties(mapping.getAllPropertiesForEntityDetail(this.igcRestClient, igcAssetType));
                igcSearch.addConditions(igcSearchConditionSet);
                this.setPagingForSearch(igcSearch, fromEntityElement, pageSize);
                if (igcSearchSorting != null) {
                    igcSearch.addSortingCriteria(igcSearchSorting);
                }
                boolean includeResult = true;
                if (qualifiedNameRegex != null && (this.repositoryHelper.isStartsWithRegex(qualifiedNameRegex) || this.repositoryHelper.isExactMatchRegex(qualifiedNameRegex))) {
                    String unqualifiedName = this.repositoryHelper.getUnqualifiedLiteralString(qualifiedNameRegex);
                    String prefix = mapping.getIgcRidPrefix();
                    boolean generatedQN = IGCRepositoryHelper.isQualifiedNameOfGeneratedEntity(unqualifiedName);
                    boolean bl = includeResult = entityTypeGUID == null || generatedQN && prefix != null || !generatedQN && prefix == null;
                    if (!includeResult) {
                        String omrsTypeName = mapping.getOmrsTypeDefName();
                        try {
                            TypeDef entityTypeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "processResultsForMapping");
                            includeResult = this.repositoryHelper.isTypeOf(this.metadataCollectionId, omrsTypeName, entityTypeDef.getName());
                        }
                        catch (TypeErrorException e) {
                            log.error("Unable to lookup type for inclusion comparison: {}", (Object)entityTypeGUID, (Object)e);
                        }
                    }
                    log.debug("Include result for name '{}' and prefix '{}'? {}", new Object[]{unqualifiedName, prefix, includeResult});
                }
                if (entitySubtypeGUIDs != null) {
                    includeResult = false;
                    String omrsTypeName = mapping.getOmrsTypeDefName();
                    for (String subtypeGUID : entitySubtypeGUIDs) {
                        TypeDef subtype = igcomrsMetadataCollection.getAnyTypeDefByGUID(subtypeGUID);
                        if (subtype == null || !this.repositoryHelper.isTypeOf(this.metadataCollectionId, omrsTypeName, subtype.getName())) continue;
                        includeResult = true;
                        break;
                    }
                }
                if (includeResult) {
                    this.processResults(mapping, (ItemList<Reference>)this.igcRestClient.search(igcSearch), entityDetails, matchProperties, null, pageSize, userId);
                }
            }
        }
    }

    private String addAllConditions(IGCSearchConditionSet igcSearchConditionSet, SearchProperties matchProperties, EntityMapping mapping) throws FunctionNotSupportedException {
        String qualifiedNameRegex = null;
        List conditionsToMatch = matchProperties.getConditions();
        if (conditionsToMatch != null) {
            for (PropertyCondition condition : conditionsToMatch) {
                SearchProperties nestedConditions = condition.getNestedConditions();
                if (nestedConditions != null) {
                    IGCSearchConditionSet nestedSet = new IGCSearchConditionSet();
                    String qname = this.addAllConditions(nestedSet, nestedConditions, mapping);
                    igcSearchConditionSet.addNestedConditionSet(nestedSet);
                    if (qname == null) continue;
                    qualifiedNameRegex = qname;
                    continue;
                }
                String omrsPropertyName = condition.getProperty();
                PropertyComparisonOperator operator = condition.getOperator();
                InstancePropertyValue value = condition.getValue();
                if (omrsPropertyName.equals("qualifiedName")) {
                    qualifiedNameRegex = value.valueAsString();
                }
                this.addSearchCondition(igcSearchConditionSet, omrsPropertyName, operator, value, mapping);
            }
            IGCRepositoryHelper.setConditionsFromMatchCriteria(igcSearchConditionSet, matchProperties.getMatchCriteria());
        }
        return qualifiedNameRegex;
    }

    String addTypeToSearch(EntityMapping mapping, IGCSearch igcSearch) {
        String igcType = DEFAULT_IGC_TYPE;
        if (mapping == null) {
            igcSearch.addType(igcType);
        } else {
            igcType = mapping.getIgcAssetType();
            igcSearch.addType(igcType);
        }
        return igcType;
    }

    void setPagingForSearch(IGCSearch igcSearch, int beginAt, int pageSize) {
        if (pageSize > 0) {
            igcSearch.setPageSize(pageSize);
        } else {
            igcSearch.setPageSize(this.igcomrsRepositoryConnector.getMaxPageSize());
        }
        igcSearch.setBeginAt(beginAt);
    }

    void processResults(EntityMapping mapper, ItemList<Reference> results, List<EntityDetail> entityDetails, SearchProperties matchProperties, String searchCriteria, int pageSize, String userId) throws RepositoryErrorException {
        if (pageSize == 0) {
            List allPages = this.igcRestClient.getAllPages(null, results);
            results.setAllPages(allPages);
        }
        for (Reference reference : results.getItems()) {
            IGCEntityGuid idToLookup;
            if (reference.getType().equals(DEFAULT_IGC_TYPE)) continue;
            EntityDetail ed = null;
            log.debug("processResults with mapper: {}", (Object)mapper.getClass().getCanonicalName());
            if (mapper.igcRidNeedsPrefix()) {
                log.debug(" ... prefix required, getEntityDetail with: {}", (Object)(mapper.getIgcRidPrefix() + "!" + reference.getId()));
                idToLookup = new IGCEntityGuid(this.metadataCollectionId, reference.getType(), mapper.getIgcRidPrefix(), reference.getId());
            } else {
                log.debug(" ... no prefix required, getEntityDetail with: {}", (Object)reference.getId());
                idToLookup = new IGCEntityGuid(this.metadataCollectionId, reference.getType(), reference.getId());
            }
            try {
                ed = this.getEntityDetailFromFullAsset(userId, idToLookup, reference);
            }
            catch (EntityNotKnownException e) {
                log.error("Unable to find entity: {}", (Object)idToLookup, (Object)e);
            }
            if (ed == null || !this.includeResult(ed, matchProperties, searchCriteria)) continue;
            entityDetails.add(ed);
            if (pageSize <= 0 || entityDetails.size() != pageSize) continue;
            break;
        }
        if (results.hasMorePages() && entityDetails.size() < pageSize) {
            ItemList nextPage = this.igcRestClient.getNextPage(null, results);
            this.processResults(mapper, (ItemList<Reference>)nextPage, entityDetails, matchProperties, searchCriteria, pageSize, userId);
        }
    }

    void processResults(RelationshipMapping mapper, ItemList<Reference> results, List<Relationship> relationships, int pageSize, String userId) throws RepositoryErrorException {
        if (pageSize == 0) {
            List allPages = this.igcRestClient.getAllPages(null, results);
            results.setAllPages(allPages);
        }
        IGCOMRSMetadataCollection igcomrsMetadataCollection = (IGCOMRSMetadataCollection)this.igcomrsRepositoryConnector.getMetadataCollection();
        for (Reference candidateTwo : results.getItems()) {
            String igcType = candidateTwo.getType();
            String relationshipLevelType = mapper.getRelationshipLevelIgcAsset();
            String relationshipLevelRid = null;
            ArrayList<Reference> endOnes = new ArrayList<Reference>();
            ArrayList<Reference> endTwos = new ArrayList<Reference>();
            if (relationshipLevelType != null && relationshipLevelType.equals(igcType)) {
                relationshipLevelRid = candidateTwo.getId();
                log.debug("processResults (relationship-level) with mapper: {}", (Object)mapper.getClass().getCanonicalName());
                RelationshipMapping.RelationshipLevelProxyMapping pmRelationship = mapper.getRelationshipLevelProxyMapping();
                String propertyToOne = pmRelationship.getIgcRelationshipPropertyToEndOne();
                String propertyToTwo = pmRelationship.getIgcRelationshipPropertyToEndTwo();
                Object endOne = this.igcRestClient.getPropertyByName(candidateTwo, propertyToOne);
                IGCRepositoryHelper.addReferencesToList(this.igcRestClient, endOnes, endOne);
                Object endTwo = this.igcRestClient.getPropertyByName(candidateTwo, propertyToTwo);
                IGCRepositoryHelper.addReferencesToList(this.igcRestClient, endTwos, endTwo);
            } else if (!igcType.equals(DEFAULT_IGC_TYPE)) {
                endTwos.add(candidateTwo);
                log.debug("processResults with mapper: {}", (Object)mapper.getClass().getCanonicalName());
                RelationshipMapping.ProxyMapping pmTwo = mapper.getProxyTwoMapping();
                List<String> relationshipProperties = pmTwo.getIgcRelationshipProperties();
                for (String igcPropertyName : relationshipProperties) {
                    if (igcPropertyName.equals("__SELF__")) {
                        endOnes.add(candidateTwo);
                        continue;
                    }
                    Object otherEnd = this.igcRestClient.getPropertyByName(candidateTwo, igcPropertyName);
                    if (otherEnd == null) continue;
                    if (otherEnd instanceof Reference) {
                        Reference other = (Reference)otherEnd;
                        if (other.getType() == null) continue;
                        endOnes.addAll(mapper.getProxyOneAssetFromAsset(other, this.igcRestClient));
                        continue;
                    }
                    if (otherEnd instanceof ItemList) {
                        ItemList otherEnds = (ItemList)otherEnd;
                        List allOtherEnds = this.igcRestClient.getAllPages(igcPropertyName, otherEnds);
                        for (Reference other : allOtherEnds) {
                            endOnes.addAll(mapper.getProxyOneAssetFromAsset(other, this.igcRestClient));
                        }
                        continue;
                    }
                    log.warn("Not a relationship, skipping: {}", otherEnd);
                }
            }
            for (Reference endOne : endOnes) {
                for (Reference endTwo : endTwos) {
                    String endOneType = endOne.getType();
                    String endTwoType = endTwo.getType();
                    if (endOneType == null || endOneType.equals(DEFAULT_IGC_TYPE) || endTwoType == null || endTwoType.equals(DEFAULT_IGC_TYPE) || !mapper.includeRelationshipForIgcObjects(this.igcomrsRepositoryConnector, endOne, endTwo)) continue;
                    IGCRelationshipGuid idToLookup = RelationshipMapping.getRelationshipGUID(this, mapper, endOne, endTwo, null, relationshipLevelRid, true);
                    Relationship relationship = null;
                    try {
                        relationship = igcomrsMetadataCollection.getRelationship(userId, idToLookup.toString());
                    }
                    catch (InvalidParameterException | RelationshipNotKnownException e) {
                        log.error("Unable to find relationship: {}", (Object)idToLookup);
                    }
                    if (relationship == null) continue;
                    relationships.add(relationship);
                    if (pageSize <= 0 || relationships.size() != pageSize) continue;
                    break;
                }
                if (pageSize <= 0 || relationships.size() != pageSize) continue;
                break;
            }
            if (pageSize <= 0 || relationships.size() != pageSize) continue;
            break;
        }
        if (results.hasMorePages() && relationships.size() < pageSize) {
            ItemList nextPage = this.igcRestClient.getNextPage(null, results);
            this.processResults(mapper, (ItemList<Reference>)nextPage, relationships, pageSize, userId);
        }
    }

    private boolean includeResult(EntityDetail ed, SearchProperties matchProperties, String searchCriteria) {
        if (matchProperties != null) {
            MatchCriteria matchCriteria = matchProperties.getMatchCriteria();
            List conditions = matchProperties.getConditions();
            InstanceProperties edProperties = ed.getProperties();
            if (edProperties == null) {
                edProperties = new InstanceProperties();
            }
            if (conditions != null) {
                for (PropertyCondition conditionToMatch : conditions) {
                    boolean bValuesMatch;
                    SearchProperties nestedConditions = conditionToMatch.getNestedConditions();
                    if (nestedConditions != null) {
                        bValuesMatch = this.includeResult(ed, nestedConditions, searchCriteria);
                    } else {
                        String propertyName = conditionToMatch.getProperty();
                        PropertyComparisonOperator operator = conditionToMatch.getOperator();
                        InstancePropertyValue valueToMatch = conditionToMatch.getValue();
                        InstancePropertyValue edValue = edProperties.getPropertyValue(propertyName);
                        bValuesMatch = this.valuesMatch(valueToMatch, operator, edValue);
                    }
                    if (matchCriteria.equals((Object)MatchCriteria.ANY) && bValuesMatch) {
                        return true;
                    }
                    if (matchCriteria.equals((Object)MatchCriteria.NONE) && bValuesMatch) {
                        return false;
                    }
                    if (!matchCriteria.equals((Object)MatchCriteria.ALL) || bValuesMatch) continue;
                    return false;
                }
                return !matchCriteria.equals((Object)MatchCriteria.ANY);
            }
            return true;
        }
        if (searchCriteria != null && !searchCriteria.equals("")) {
            InstanceProperties edProperties = ed.getProperties();
            if (edProperties == null) {
                return false;
            }
            Pattern pattern = Pattern.compile(searchCriteria);
            Map allProperties = edProperties.getInstanceProperties();
            for (InstancePropertyValue value : allProperties.values()) {
                Matcher matcher;
                if (!value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE) || !((PrimitivePropertyValue)value).getPrimitiveDefCategory().equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING) || !(matcher = pattern.matcher(value.valueAsString())).matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean valuesMatch(InstancePropertyValue valueRequested, PropertyComparisonOperator operator, InstancePropertyValue valueToCheck) {
        if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
            return valueToCheck == null || valueToCheck.valueAsObject() == null;
        }
        if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
            if (valueToCheck == null) {
                return false;
            }
            return valueToCheck.valueAsObject() != null;
        }
        OMRSRepositoryValidator repositoryValidator = this.igcomrsRepositoryConnector.getRepositoryValidator();
        BigDecimal requestAsNumber = repositoryValidator.getNumericRepresentation(valueRequested);
        BigDecimal valueAsNumber = repositoryValidator.getNumericRepresentation(valueToCheck);
        switch (operator) {
            case EQ: {
                return valueRequested.equals((Object)valueToCheck);
            }
            case NEQ: {
                return !valueRequested.equals((Object)valueToCheck);
            }
            case GTE: {
                if (requestAsNumber != null && valueAsNumber != null) {
                    return valueAsNumber.compareTo(requestAsNumber) >= 0;
                }
            }
            case GT: {
                if (requestAsNumber != null && valueAsNumber != null) {
                    return valueAsNumber.compareTo(requestAsNumber) > 0;
                }
            }
            case LTE: {
                if (requestAsNumber != null && valueAsNumber != null) {
                    return valueAsNumber.compareTo(requestAsNumber) <= 0;
                }
            }
            case LT: {
                if (requestAsNumber != null && valueAsNumber != null) {
                    return valueAsNumber.compareTo(requestAsNumber) < 0;
                }
            }
            case LIKE: {
                if (valueToCheck == null) {
                    return false;
                }
                return valueToCheck.valueAsString().matches(valueRequested.valueAsString());
            }
            case IN: {
                if (valueRequested instanceof ArrayPropertyValue) {
                    ArrayPropertyValue apv = (ArrayPropertyValue)valueRequested;
                    InstanceProperties ip = apv.getArrayValues();
                    Map map = ip.getInstanceProperties();
                    for (InstancePropertyValue valueCandidate : map.values()) {
                        if (!valueCandidate.equals((Object)valueToCheck)) continue;
                        return true;
                    }
                    break;
                }
                return false;
            }
        }
        return false;
    }

    public boolean isIdentityString(String candidate) {
        int count = Identity.isIdentityString((String)candidate);
        if (this.repositoryHelper.isStartsWithRegex(candidate)) {
            String unqualified = this.repositoryHelper.getUnqualifiedLiteralString(candidate);
            return unqualified.startsWith(GENERATED_ENTITY_QNAME_PREFIX) || unqualified.startsWith("(");
        }
        if (count > 0 && (this.repositoryHelper.isContainsRegex(candidate) || this.repositoryHelper.isEndsWithRegex(candidate))) {
            return true;
        }
        return this.repositoryHelper.isExactMatchRegex(candidate) && count >= 4;
    }

    public static void setConditionsFromMatchCriteria(IGCSearchConditionSet igcSearchConditionSet, MatchCriteria matchCriteria) {
        if (matchCriteria != null) {
            switch (matchCriteria) {
                case ALL: {
                    igcSearchConditionSet.setMatchAnyCondition(false);
                    break;
                }
                case ANY: {
                    igcSearchConditionSet.setMatchAnyCondition(true);
                    break;
                }
                case NONE: {
                    igcSearchConditionSet.setMatchAnyCondition(false);
                    igcSearchConditionSet.setNegateAll(true);
                }
            }
        }
    }

    private IGCSearchConditionSet getSearchCriteriaForClassification(String igcAssetType, ClassificationCondition condition) throws FunctionNotSupportedException {
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        String classificationName = condition.getName();
        ClassificationMapping classificationMapping = this.classificationMappingStore.getMappingByTypes(classificationName, igcAssetType);
        if (classificationMapping != null) {
            igcSearchConditionSet = classificationMapping.getIGCSearchCriteria(this.repositoryHelper, this.repositoryName, condition.getMatchProperties());
        } else {
            log.warn("Classification {} cannot be applied to IGC asset type {} - excluding from search limitations.", (Object)classificationName, (Object)igcAssetType);
        }
        return igcSearchConditionSet.size() > 0 ? igcSearchConditionSet : null;
    }

    IGCSearchConditionSet getSearchCriteriaForClassifications(String igcAssetType, SearchClassifications matchClassifications) throws FunctionNotSupportedException {
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        if (matchClassifications != null && !matchClassifications.getConditions().isEmpty()) {
            for (ClassificationCondition condition : matchClassifications.getConditions()) {
                IGCSearchConditionSet classificationLimiter = this.getSearchCriteriaForClassification(igcAssetType, condition);
                if (classificationLimiter == null) continue;
                igcSearchConditionSet.addNestedConditionSet(classificationLimiter);
                igcSearchConditionSet.setMatchAnyCondition(false);
            }
        }
        return igcSearchConditionSet.size() > 0 ? igcSearchConditionSet : null;
    }

    public IGCEntityGuid getEntityGuid(String assetType, String prefix, String rid) {
        return new IGCEntityGuid(this.metadataCollectionId, assetType, prefix, rid);
    }

    public IGCRelationshipGuid getRelationshipGuid(String assetType1, String assetType2, String prefix1, String prefix2, String rid1, String rid2, String relationshipType) {
        return new IGCRelationshipGuid(this.metadataCollectionId, assetType1, assetType2, prefix1, prefix2, rid1, rid2, relationshipType);
    }

    public static boolean isQualifiedNameOfGeneratedEntity(String qualifiedName) {
        return qualifiedName.startsWith(GENERATED_ENTITY_QNAME_PREFIX);
    }

    public static String getQualifiedNameForGeneratedEntity(String prefix, String qualifiedName) {
        return GENERATED_ENTITY_QNAME_PREFIX + prefix + GENERATED_ENTITY_QNAME_POSTFIX + qualifiedName;
    }

    public static String getSearchableQualifiedName(String qualifiedName) {
        if (IGCRepositoryHelper.isQualifiedNameOfGeneratedEntity(qualifiedName)) {
            return qualifiedName.substring(qualifiedName.indexOf(GENERATED_ENTITY_QNAME_POSTFIX) + 1);
        }
        return qualifiedName;
    }

    public static String getPrefixFromGeneratedQualifiedName(String qualifiedName) {
        if (IGCRepositoryHelper.isQualifiedNameOfGeneratedEntity(qualifiedName)) {
            return qualifiedName.substring(qualifiedName.indexOf(GENERATED_ENTITY_QNAME_PREFIX) + GENERATED_ENTITY_QNAME_PREFIX.length(), qualifiedName.indexOf(GENERATED_ENTITY_QNAME_POSTFIX));
        }
        return null;
    }

    public EntityDetail getEntityDetailFromFullAsset(String userId, IGCEntityGuid guid, Reference asset) throws RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntityDetailFromFullAsset";
        this.validateGuidAndType(guid, "getEntityDetailFromFullAsset");
        EntityMappingInstance entityMap = this.getMappingInstanceForParameters(guid, asset, userId);
        return this.getEntityDetailFromMapInstance(entityMap, guid.getGeneratedPrefix(), guid.getAssetType(), "getEntityDetailFromFullAsset");
    }

    private void validateGuidAndType(IGCEntityGuid guid, String methodName) throws EntityNotKnownException, RepositoryErrorException {
        log.debug("{} with guid = {}", (Object)methodName, (Object)guid);
        if (guid == null) {
            this.raiseEntityNotKnownException(methodName, "<null>", "<null>", this.repositoryName);
        } else {
            String igcType = guid.getAssetType();
            if (igcType.equals(DEFAULT_IGC_TYPE)) {
                this.raiseRepositoryErrorException(IGCOMRSErrorCode.UNSUPPORTED_OBJECT_TYPE, methodName, guid.toString(), igcType, this.repositoryName);
            }
        }
    }

    private EntityDetail getEntityDetailFromMapInstance(EntityMappingInstance mappingInstance, String prefix, String igcType, String methodName) throws RepositoryErrorException {
        EntityDetail detail = null;
        if (mappingInstance != null) {
            detail = EntityMapping.getEntityDetail(mappingInstance);
        } else {
            this.raiseRepositoryErrorException(IGCOMRSErrorCode.TYPEDEF_NOT_MAPPED, methodName, (prefix == null ? "" : prefix) + igcType, this.repositoryName);
        }
        return detail;
    }

    public EntityDetail getEntityDetail(String userId, IGCEntityGuid guid) throws RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntityDetail";
        this.validateGuidAndType(guid, "getEntityDetail");
        String prefix = guid.getGeneratedPrefix();
        String igcType = guid.getAssetType();
        EntityMappingInstance entityMap = this.getMappingInstanceForParameters(igcType, guid.getRid(), prefix, userId);
        return this.getEntityDetailFromMapInstance(entityMap, prefix, igcType, "getEntityDetail");
    }

    private EntityMappingInstance getMappingInstanceForParameters(IGCEntityGuid guid, Reference asset, String userId) {
        log.debug("Looking for mapper for retrieved asset with guid {}", (Object)guid);
        EntityMappingInstance entityMap = null;
        EntityMapping found = this.getEntityMappingByIgcType(guid.getAssetType(), guid.getGeneratedPrefix());
        if (found != null) {
            log.debug("Found mapper class: {} ({})", (Object)found.getClass().getCanonicalName(), (Object)found);
            entityMap = new EntityMappingInstance(found, this.igcomrsRepositoryConnector, asset, userId);
        } else {
            log.debug("No mapper class found!");
        }
        return entityMap;
    }

    public EntityMappingInstance getMappingInstanceForParameters(String igcAssetType, String rid, String prefix, String userId) {
        log.debug("Looking for mapper for type {} with prefix {}", (Object)igcAssetType, (Object)prefix);
        EntityMappingInstance entityMap = null;
        EntityMapping found = this.getEntityMappingByIgcType(igcAssetType, prefix);
        if (found != null) {
            log.debug("Found mapper class: {} ({})", (Object)found.getClass().getCanonicalName(), (Object)found);
            entityMap = new EntityMappingInstance(found, this.igcomrsRepositoryConnector, igcAssetType, rid, userId);
        } else {
            log.debug("No mapper class found!");
        }
        return entityMap;
    }

    public List<EntityMapping> getMappers(String igcAssetType, String userId) {
        EntityMapping defaultMapper;
        List<EntityMapping> mappers = this.entityMappingStore.getMappingsByIgcAssetType(igcAssetType);
        if (mappers == null) {
            mappers = new ArrayList<EntityMapping>();
        }
        if (mappers.isEmpty() && (defaultMapper = this.entityMappingStore.getDefaultEntityMapper()) != null) {
            mappers.add(defaultMapper);
        }
        return mappers;
    }

    public String getIgcAssetTypeForAssetName(String igcAssetName) {
        EntityMapping mapping = this.entityMappingStore.getMappingByIgcAssetDisplayName(igcAssetName);
        if (mapping != null) {
            return mapping.getIgcAssetType();
        }
        return null;
    }

    private void addSearchCondition(IGCSearchConditionSet igcSearchConditionSet, String omrsPropertyName, PropertyComparisonOperator operator, InstancePropertyValue value, EntityMapping mapping) throws FunctionNotSupportedException {
        if (omrsPropertyName != null) {
            if (omrsPropertyName.equals("__COMPLEX_PROPERTY__")) {
                log.warn("Unhandled search condition: complex OMRS mapping, unknown IGC property.");
            } else {
                String igcPropertyName = mapping.getIgcPropertyName(omrsPropertyName);
                if (igcPropertyName == null) {
                    log.warn("Unhandled search condition for unknown IGC property from OMRS property: {}", (Object)omrsPropertyName);
                } else if (igcPropertyName.equals("__COMPLEX_PROPERTY__")) {
                    log.debug("Adding complex property search criteria for: {}", (Object)omrsPropertyName);
                    mapping.addComplexPropertySearchCriteria(this.repositoryHelper, this.repositoryName, this.igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, operator, value);
                } else if (!igcPropertyName.equals("__LITERAL_MAPPING__")) {
                    log.debug("Adding non-literal property search criteria for: {}", (Object)omrsPropertyName);
                    IGCRepositoryHelper.addIGCSearchCondition(this.repositoryHelper, this.repositoryName, igcSearchConditionSet, igcPropertyName, operator, value);
                }
            }
        }
    }

    public static void addIGCSearchCondition(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, PropertyComparisonOperator operator, InstancePropertyValue value) throws FunctionNotSupportedException {
        String methodName = "addIGCSearchCondition";
        if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
            igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, "isNull", Boolean.valueOf(false)));
        } else if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
            igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, "isNull", Boolean.valueOf(true)));
        } else {
            InstancePropertyCategory category = value.getInstancePropertyCategory();
            block0 : switch (category) {
                case PRIMITIVE: {
                    PrimitivePropertyValue actualValue = (PrimitivePropertyValue)value;
                    PrimitiveDefCategory primitiveType = actualValue.getPrimitiveDefCategory();
                    switch (primitiveType) {
                        case OM_PRIMITIVE_TYPE_BOOLEAN: {
                            IGCRepositoryHelper.validateBooleanOperator(operator, "addIGCSearchCondition");
                            igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, IGCRepositoryHelper.getIgcOperator(operator), actualValue.valueAsString()));
                            break block0;
                        }
                        case OM_PRIMITIVE_TYPE_SHORT: 
                        case OM_PRIMITIVE_TYPE_INT: 
                        case OM_PRIMITIVE_TYPE_LONG: 
                        case OM_PRIMITIVE_TYPE_FLOAT: 
                        case OM_PRIMITIVE_TYPE_DOUBLE: 
                        case OM_PRIMITIVE_TYPE_BIGINTEGER: 
                        case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                            IGCRepositoryHelper.validateNumericOperator(operator, primitiveType.getName(), "addIGCSearchCondition");
                            igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, IGCRepositoryHelper.getIgcOperator(operator), actualValue.valueAsString()));
                            break block0;
                        }
                        case OM_PRIMITIVE_TYPE_DATE: {
                            IGCRepositoryHelper.validateNumericOperator(operator, primitiveType.getName(), "addIGCSearchCondition");
                            Long epoch = (Long)actualValue.getPrimitiveValue();
                            switch (operator) {
                                case EQ: {
                                    igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, epoch.longValue(), epoch + 999L));
                                    break;
                                }
                                case NEQ: {
                                    IGCSearchCondition less = new IGCSearchCondition(igcPropertyName, "<", "" + epoch);
                                    IGCSearchCondition more = new IGCSearchCondition(igcPropertyName, ">", "" + (epoch + 999L));
                                    IGCSearchConditionSet nested = new IGCSearchConditionSet();
                                    nested.addCondition(less);
                                    nested.addCondition(more);
                                    nested.setMatchAnyCondition(true);
                                    igcSearchConditionSet.addNestedConditionSet(nested);
                                    break;
                                }
                                case GTE: {
                                    igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, ">=", "" + epoch));
                                    break;
                                }
                                case GT: {
                                    igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, ">", "" + epoch));
                                    break;
                                }
                                case LTE: {
                                    igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, "<=", "" + (epoch + 999L)));
                                    break;
                                }
                                case LT: {
                                    igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, "<", "" + (epoch + 999L)));
                                }
                            }
                            break block0;
                        }
                    }
                    IGCRepositoryHelper.validateStringOperator(operator, primitiveType.getName(), "addIGCSearchCondition");
                    String candidateValue = actualValue.valueAsString();
                    IGCSearchCondition regex = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addIGCSearchCondition", igcPropertyName, operator, candidateValue);
                    igcSearchConditionSet.addCondition(regex);
                    break;
                }
                case ENUM: {
                    IGCRepositoryHelper.validateEnumOperator(operator, "addIGCSearchCondition");
                    igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, IGCRepositoryHelper.getIgcOperator(operator), ((EnumPropertyValue)value).getSymbolicName()));
                    break;
                }
                case MAP: {
                    Map mapValues = ((MapPropertyValue)value).getMapValues().getInstanceProperties();
                    for (Map.Entry nextEntry : mapValues.entrySet()) {
                        IGCRepositoryHelper.addIGCSearchCondition(repositoryHelper, repositoryName, igcSearchConditionSet, (String)nextEntry.getKey(), operator, (InstancePropertyValue)nextEntry.getValue());
                    }
                    break;
                }
                case ARRAY: {
                    if (operator.equals((Object)PropertyComparisonOperator.IN)) {
                        InstanceProperties ip = ((ArrayPropertyValue)value).getArrayValues();
                        if (ip != null) {
                            Map map = ip.getInstanceProperties();
                            if (map != null) {
                                ArrayList<String> valueList = new ArrayList<String>();
                                boolean primitivesOnly = true;
                                IGCSearchConditionSet nestedConditions = new IGCSearchConditionSet();
                                for (InstancePropertyValue oneValue : map.values()) {
                                    if (oneValue.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE)) {
                                        valueList.add(oneValue.valueAsString());
                                        continue;
                                    }
                                    primitivesOnly = false;
                                    IGCSearchConditionSet nested = new IGCSearchConditionSet();
                                    IGCRepositoryHelper.addIGCSearchCondition(repositoryHelper, repositoryName, nested, igcPropertyName, PropertyComparisonOperator.EQ, oneValue);
                                    nestedConditions.addNestedConditionSet(nested);
                                }
                                if (primitivesOnly) {
                                    igcSearchConditionSet.addCondition(new IGCSearchCondition(igcPropertyName, valueList));
                                    break;
                                }
                                nestedConditions.setMatchAnyCondition(true);
                                igcSearchConditionSet.addNestedConditionSet(nestedConditions);
                                break;
                            }
                            igcSearchConditionSet.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                            break;
                        }
                        igcSearchConditionSet.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                        break;
                    }
                    throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_SEARCH_COMPARISON.getMessageDefinition(operator.getName(), category.getName()), IGCRepositoryHelper.class.getName(), "addIGCSearchCondition");
                }
                default: {
                    log.warn("Unable to handle search criteria for value type: {}", (Object)category);
                }
            }
        }
    }

    public static String getIgcOperator(PropertyComparisonOperator operator) {
        switch (operator) {
            case EQ: {
                return "=";
            }
            case NEQ: {
                return "<>";
            }
            case GTE: {
                return ">=";
            }
            case GT: {
                return ">";
            }
            case LTE: {
                return "<=";
            }
            case LT: {
                return "<";
            }
            case LIKE: {
                return "like";
            }
            case IN: {
                return "in";
            }
            case IS_NULL: 
            case NOT_NULL: {
                return "isNull";
            }
        }
        return null;
    }

    public static void validateBooleanOperator(PropertyComparisonOperator operator, String methodName) throws FunctionNotSupportedException {
        boolean is = operator.equals((Object)PropertyComparisonOperator.EQ) || operator.equals((Object)PropertyComparisonOperator.NEQ) || operator.equals((Object)PropertyComparisonOperator.IS_NULL) || operator.equals((Object)PropertyComparisonOperator.NOT_NULL);
        IGCRepositoryHelper.checkOperator(is, operator, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName(), methodName);
    }

    public static void validateEnumOperator(PropertyComparisonOperator operator, String methodName) throws FunctionNotSupportedException {
        boolean is = operator.equals((Object)PropertyComparisonOperator.EQ) || operator.equals((Object)PropertyComparisonOperator.NEQ) || operator.equals((Object)PropertyComparisonOperator.IS_NULL) || operator.equals((Object)PropertyComparisonOperator.NOT_NULL);
        IGCRepositoryHelper.checkOperator(is, operator, InstancePropertyCategory.ENUM.getName(), methodName);
    }

    public static void validateNumericOperator(PropertyComparisonOperator operator, String type, String methodName) throws FunctionNotSupportedException {
        boolean is = operator.equals((Object)PropertyComparisonOperator.EQ) || operator.equals((Object)PropertyComparisonOperator.NEQ) || operator.equals((Object)PropertyComparisonOperator.GTE) || operator.equals((Object)PropertyComparisonOperator.GT) || operator.equals((Object)PropertyComparisonOperator.LTE) || operator.equals((Object)PropertyComparisonOperator.LT) || operator.equals((Object)PropertyComparisonOperator.IS_NULL) || operator.equals((Object)PropertyComparisonOperator.NOT_NULL);
        IGCRepositoryHelper.checkOperator(is, operator, type, methodName);
    }

    public static void validateStringOperator(PropertyComparisonOperator operator, String type, String methodName) throws FunctionNotSupportedException {
        boolean is = operator.equals((Object)PropertyComparisonOperator.LIKE) || operator.equals((Object)PropertyComparisonOperator.EQ) || operator.equals((Object)PropertyComparisonOperator.NEQ) || operator.equals((Object)PropertyComparisonOperator.IS_NULL) || operator.equals((Object)PropertyComparisonOperator.NOT_NULL);
        IGCRepositoryHelper.checkOperator(is, operator, type, methodName);
    }

    private static void checkOperator(boolean isValid, PropertyComparisonOperator operator, String type, String methodName) throws FunctionNotSupportedException {
        if (!isValid) {
            throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_SEARCH_COMPARISON.getMessageDefinition(operator.getName(), type), IGCRepositoryHelper.class.getName(), methodName);
        }
    }

    public static boolean equivalentValues(Object value, PropertyComparisonOperator operator, InstancePropertyValue requestedValue) {
        if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
            return value == null;
        }
        if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
            return value != null;
        }
        if (value == null && requestedValue == null) {
            return true;
        }
        if (value == null || requestedValue == null) {
            return false;
        }
        InstancePropertyCategory category = requestedValue.getInstancePropertyCategory();
        switch (category) {
            case PRIMITIVE: {
                PrimitivePropertyValue actualValue = (PrimitivePropertyValue)requestedValue;
                PrimitiveDefCategory primitiveType = actualValue.getPrimitiveDefCategory();
                switch (primitiveType) {
                    case OM_PRIMITIVE_TYPE_BOOLEAN: {
                        return IGCRepositoryHelper.compareBool(value, operator, actualValue);
                    }
                    case OM_PRIMITIVE_TYPE_SHORT: {
                        return IGCRepositoryHelper.compareShort(value, operator, actualValue);
                    }
                    case OM_PRIMITIVE_TYPE_INT: {
                        return IGCRepositoryHelper.compareInt(value, operator, actualValue);
                    }
                    case OM_PRIMITIVE_TYPE_LONG: {
                        return IGCRepositoryHelper.compareLong(value, operator, actualValue);
                    }
                    case OM_PRIMITIVE_TYPE_FLOAT: {
                        return IGCRepositoryHelper.compareFloat(value, operator, actualValue);
                    }
                    case OM_PRIMITIVE_TYPE_DOUBLE: {
                        return IGCRepositoryHelper.compareDouble(value, operator, actualValue);
                    }
                    case OM_PRIMITIVE_TYPE_BIGINTEGER: {
                        return IGCRepositoryHelper.compareBigInteger(value, operator, actualValue);
                    }
                    case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                        return IGCRepositoryHelper.compareBigDecimal(value, operator, actualValue);
                    }
                    case OM_PRIMITIVE_TYPE_DATE: {
                        return IGCRepositoryHelper.compareDate(value, operator, actualValue);
                    }
                }
                return IGCRepositoryHelper.compareString(value, operator, actualValue);
            }
            case ENUM: {
                String symbolicName = ((EnumPropertyValue)requestedValue).getSymbolicName();
                return value.toString().equals(symbolicName);
            }
            case ARRAY: {
                return IGCRepositoryHelper.compareList(value, operator, (ArrayPropertyValue)requestedValue);
            }
        }
        log.warn("Unable to handle value equivalency for value type: {}", (Object)category);
        return false;
    }

    private static boolean compareBool(Object value, PropertyComparisonOperator operator, PrimitivePropertyValue requestedValue) {
        boolean lValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : value.toString().toLowerCase().equals("true");
        boolean rValue = (Boolean)requestedValue.getPrimitiveValue();
        switch (operator) {
            case EQ: {
                return lValue == rValue;
            }
            case NEQ: {
                return lValue != rValue;
            }
        }
        return false;
    }

    private static boolean compareShort(Object value, PropertyComparisonOperator operator, PrimitivePropertyValue requestedValue) {
        Short lValue = value instanceof Short ? (Short)value : Short.parseShort(value.toString());
        Short rValue = (Short)requestedValue.getPrimitiveValue();
        return IGCRepositoryHelper.compareNumber(lValue.compareTo(rValue), operator);
    }

    private static boolean compareInt(Object value, PropertyComparisonOperator operator, PrimitivePropertyValue requestedValue) {
        Integer lValue = value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
        Integer rValue = (Integer)requestedValue.getPrimitiveValue();
        return IGCRepositoryHelper.compareNumber(lValue.compareTo(rValue), operator);
    }

    private static boolean compareLong(Object value, PropertyComparisonOperator operator, PrimitivePropertyValue requestedValue) {
        Long lValue = value instanceof Long ? (Long)value : Long.parseLong(value.toString());
        Long rValue = (Long)requestedValue.getPrimitiveValue();
        return IGCRepositoryHelper.compareNumber(lValue.compareTo(rValue), operator);
    }

    private static boolean compareFloat(Object value, PropertyComparisonOperator operator, PrimitivePropertyValue requestedValue) {
        Float lValue = Float.valueOf(value instanceof Float ? ((Float)value).floatValue() : Float.parseFloat(value.toString()));
        Float rValue = (Float)requestedValue.getPrimitiveValue();
        return IGCRepositoryHelper.compareNumber(lValue.compareTo(rValue), operator);
    }

    private static boolean compareDouble(Object value, PropertyComparisonOperator operator, PrimitivePropertyValue requestedValue) {
        Double lValue = value instanceof Double ? (Double)value : Double.parseDouble(value.toString());
        Double rValue = (Double)requestedValue.getPrimitiveValue();
        return IGCRepositoryHelper.compareNumber(lValue.compareTo(rValue), operator);
    }

    private static boolean compareBigInteger(Object value, PropertyComparisonOperator operator, PrimitivePropertyValue requestedValue) {
        BigInteger lValue = value instanceof BigInteger ? (BigInteger)value : new BigInteger(value.toString());
        BigInteger rValue = (BigInteger)requestedValue.getPrimitiveValue();
        return IGCRepositoryHelper.compareNumber(lValue.compareTo(rValue), operator);
    }

    private static boolean compareBigDecimal(Object value, PropertyComparisonOperator operator, PrimitivePropertyValue requestedValue) {
        BigDecimal lValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
        BigDecimal rValue = (BigDecimal)requestedValue.getPrimitiveValue();
        return IGCRepositoryHelper.compareNumber(lValue.compareTo(rValue), operator);
    }

    private static boolean compareDate(Object value, PropertyComparisonOperator operator, PrimitivePropertyValue requestedValue) {
        Long lValue = -1L;
        if (value instanceof Long) {
            lValue = (Long)value;
        } else if (value instanceof Date) {
            lValue = ((Date)value).getTime();
        }
        Long rValue = (Long)requestedValue.getPrimitiveValue();
        return IGCRepositoryHelper.compareNumber(lValue.compareTo(rValue), operator);
    }

    private static boolean compareNumber(int compareToResult, PropertyComparisonOperator operator) {
        switch (operator) {
            case EQ: {
                return compareToResult == 0;
            }
            case NEQ: {
                return compareToResult != 0;
            }
            case GTE: {
                return compareToResult >= 0;
            }
            case GT: {
                return compareToResult > 0;
            }
            case LTE: {
                return compareToResult <= 0;
            }
            case LT: {
                return compareToResult < 0;
            }
        }
        return false;
    }

    private static boolean compareString(Object value, PropertyComparisonOperator operator, PrimitivePropertyValue requestedValue) {
        String lValue = value.toString();
        String rValue = requestedValue.valueAsString();
        switch (operator) {
            case EQ: {
                return lValue.equals(rValue);
            }
            case NEQ: {
                return !lValue.equals(rValue);
            }
            case LIKE: {
                return lValue.matches(rValue);
            }
        }
        return false;
    }

    private static boolean compareList(Object value, PropertyComparisonOperator operator, ArrayPropertyValue requestedValue) {
        Map map;
        InstanceProperties ip;
        if (operator.equals((Object)PropertyComparisonOperator.IN) && (ip = requestedValue.getArrayValues()) != null && (map = ip.getInstanceProperties()) != null) {
            Collection requestedValues = map.values();
            boolean anyMatch = false;
            for (InstancePropertyValue oneValue : requestedValues) {
                if (!IGCRepositoryHelper.equivalentValues(value, operator, oneValue)) continue;
                anyMatch = true;
                break;
            }
            return anyMatch;
        }
        return false;
    }

    public static IGCSearchCondition getRegexSearchCondition(OMRSRepositoryHelper repositoryHelper, String repositoryName, String methodName, String igcPropertyToSearch, String valueWithRegex) throws FunctionNotSupportedException {
        return IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, methodName, igcPropertyToSearch, PropertyComparisonOperator.LIKE, valueWithRegex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IGCSearchCondition getRegexSearchCondition(OMRSRepositoryHelper repositoryHelper, String repositoryName, String methodName, String igcPropertyToSearch, PropertyComparisonOperator operator, String valueWithRegex) throws FunctionNotSupportedException {
        String igcValueToSearch = repositoryHelper.getUnqualifiedLiteralString(valueWithRegex);
        if (operator.equals((Object)PropertyComparisonOperator.LIKE)) {
            if (repositoryHelper.isContainsRegex(valueWithRegex)) {
                return new IGCSearchCondition(igcPropertyToSearch, "like %{0}%", igcValueToSearch);
            }
            if (repositoryHelper.isStartsWithRegex(valueWithRegex)) {
                return new IGCSearchCondition(igcPropertyToSearch, "like {0}%", igcValueToSearch);
            }
            if (repositoryHelper.isEndsWithRegex(valueWithRegex)) {
                return new IGCSearchCondition(igcPropertyToSearch, "like %{0}", igcValueToSearch);
            }
            if (!repositoryHelper.isExactMatchRegex(valueWithRegex)) throw new FunctionNotSupportedException(IGCOMRSErrorCode.REGEX_NOT_IMPLEMENTED.getMessageDefinition(repositoryName, valueWithRegex), IGCRepositoryHelper.class.getName(), methodName);
            return new IGCSearchCondition(igcPropertyToSearch, "=", igcValueToSearch);
        }
        if (operator.equals((Object)PropertyComparisonOperator.EQ)) {
            return new IGCSearchCondition(igcPropertyToSearch, "=", igcValueToSearch);
        }
        if (!operator.equals((Object)PropertyComparisonOperator.NEQ)) throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_SEARCH_COMPARISON.getMessageDefinition(operator.getName(), PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName()), IGCRepositoryHelper.class.getName(), methodName);
        return new IGCSearchCondition(igcPropertyToSearch, "<>", igcValueToSearch);
    }

    public static void addTypeSpecificConditions(EntityMapping mapping, MatchCriteria matchCriteria, SearchProperties matchProperties, IGCSearchConditionSet igcSearchConditionSet) {
        IGCSearchConditionSet typeSpecificConditions;
        if ((matchCriteria == null || matchCriteria.equals((Object)MatchCriteria.ALL) || matchCriteria.equals((Object)MatchCriteria.ANY) && (matchProperties == null || matchProperties.getConditions().size() == 0)) && (typeSpecificConditions = mapping.getIGCSearchCriteria()).size() > 0) {
            igcSearchConditionSet.addNestedConditionSet(typeSpecificConditions);
            igcSearchConditionSet.setMatchAnyCondition(false);
        }
    }

    public OMRSStub getOMRSStubForAsset(String rid, String type) {
        String stubName = IGCRepositoryHelper.getStubNameForAsset(rid, type);
        IGCSearchCondition condition = new IGCSearchCondition("name", "=", stubName);
        String[] properties = new String[]{"$sourceRID", "$sourceType", "$payload"};
        IGCSearchConditionSet conditionSet = new IGCSearchConditionSet(condition);
        IGCSearch igcSearch = new IGCSearch("$OMRS-Stub", properties, conditionSet);
        ItemList results = this.igcRestClient.search(igcSearch);
        OMRSStub stub = null;
        if (results.getPaging().getNumTotal() > 0) {
            if (results.getPaging().getNumTotal() > 1) {
                log.warn("Found multiple stubs for asset, taking only the first: {}", (Object)stubName);
            }
            stub = (OMRSStub)((Object)results.getItems().get(0));
        } else {
            log.info("No stub found for asset: {}", (Object)stubName);
        }
        return stub;
    }

    public OMRSStub getOMRSStubForAsset(Reference asset) {
        return this.getOMRSStubForAsset(asset.getId(), asset.getType());
    }

    public String upsertOMRSStubForAsset(Reference asset) {
        String stubName = IGCRepositoryHelper.getStubNameFromAsset(asset);
        String payload = this.igcRestClient.getValueAsJSON(asset);
        StringWriter stringWriter = new StringWriter();
        try {
            XMLStreamWriter xmlStreamWriter = this.xmlOutputFactory.createXMLStreamWriter(stringWriter);
            xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            xmlStreamWriter.writeStartElement("doc");
            xmlStreamWriter.writeNamespace("xmlns", "http://www.ibm.com/iis/flow-doc");
            xmlStreamWriter.writeStartElement("assets");
            xmlStreamWriter.writeStartElement("asset");
            xmlStreamWriter.writeAttribute("class", "$OMRS-Stub");
            xmlStreamWriter.writeAttribute("repr", stubName);
            xmlStreamWriter.writeAttribute("ID", "stub1");
            this.addAttributeToAssetXML(xmlStreamWriter, "name", stubName);
            this.addAttributeToAssetXML(xmlStreamWriter, "$sourceType", asset.getType());
            this.addAttributeToAssetXML(xmlStreamWriter, "$sourceRID", asset.getId());
            this.addAttributeToAssetXML(xmlStreamWriter, "$payload", payload);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("importAction");
            xmlStreamWriter.writeAttribute("completeAssetIDs", "stub1");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.flush();
            xmlStreamWriter.close();
        }
        catch (XMLStreamException e) {
            log.error("Unable to write XML stream: {}", (Object)asset, (Object)e);
        }
        String stubXML = stringWriter.getBuffer().toString();
        log.debug("Constructed XML for stub: {}", (Object)stubName);
        String results = this.igcRestClient.upsertOpenIgcAsset(stubXML);
        return results.substring("stub1".length() + 5, results.length() - 2);
    }

    private void addAttributeToAssetXML(XMLStreamWriter xmlStreamWriter, String attrName, String attrValue) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("attribute");
        xmlStreamWriter.writeAttribute("name", attrName);
        xmlStreamWriter.writeAttribute("value", attrValue);
        xmlStreamWriter.writeEndElement();
    }

    public boolean deleteOMRSStubForAsset(String rid, String assetType) {
        String stubName = IGCRepositoryHelper.getStubNameForAsset(rid, assetType);
        StringWriter stringWriter = new StringWriter();
        try {
            XMLStreamWriter xmlStreamWriter = this.xmlOutputFactory.createXMLStreamWriter(stringWriter);
            xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            xmlStreamWriter.writeStartElement("doc");
            xmlStreamWriter.writeNamespace("xmlns", "http://www.ibm.com/iis/flow-doc");
            xmlStreamWriter.writeStartElement("assets");
            xmlStreamWriter.writeStartElement("asset");
            xmlStreamWriter.writeAttribute("class", "$OMRS-Stub");
            xmlStreamWriter.writeAttribute("repr", stubName);
            xmlStreamWriter.writeAttribute("ID", "stub1");
            this.addAttributeToAssetXML(xmlStreamWriter, "name", stubName);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("assetsToDelete");
            xmlStreamWriter.writeCharacters("stub1");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.flush();
            xmlStreamWriter.close();
        }
        catch (XMLStreamException e) {
            log.error("Unable to write XML stream.", (Throwable)e);
        }
        String stubXML = stringWriter.getBuffer().toString();
        log.debug("Constructed XML for stub deletion: {}", (Object)stubName);
        return this.igcRestClient.deleteOpenIgcAsset(stubXML);
    }

    private static String getStubNameFromAsset(Reference asset) {
        return IGCRepositoryHelper.getStubNameForAsset(asset.getId(), asset.getType());
    }

    private static String getStubNameForAsset(String rid, String assetType) {
        return assetType + "_" + rid;
    }

    public Reference getFullAssetDetails(String rid, String assetType) {
        Reference fullAsset = null;
        if (assetType != null) {
            if (assetType.equals(DEFAULT_IGC_TYPE)) {
                log.debug("Received 'main_object' as type, looking up basic ref to determine actual type.");
                fullAsset = this.igcRestClient.getAssetRefById(rid);
                if (fullAsset != null) {
                    assetType = fullAsset.getType();
                }
            }
            if (!assetType.equals(DEFAULT_IGC_TYPE)) {
                List allProps = this.igcRestClient.getAllPropertiesForType(assetType);
                if (allProps != null) {
                    fullAsset = this.igcRestClient.getAssetWithSubsetOfProperties(rid, assetType, allProps, this.igcRestClient.getDefaultPageSize());
                    if (fullAsset != null) {
                        List allPaged = this.igcRestClient.getPagedRelationshipPropertiesForType(assetType);
                        for (String pagedProperty : allPaged) {
                            Object shouldBeItemList = this.igcRestClient.getPropertyByName(fullAsset, pagedProperty);
                            if (!(shouldBeItemList instanceof ItemList)) continue;
                            ItemList pagedValue = (ItemList)shouldBeItemList;
                            List allPages = this.igcRestClient.getAllPages(pagedProperty, pagedValue);
                            pagedValue.setAllPages(allPages);
                        }
                        fullAsset.setFullyRetrieved();
                    }
                } else {
                    log.info("No registered POJO for asset type {} -- returning basic reference.", (Object)assetType);
                    fullAsset = this.igcRestClient.getAssetRefById(rid);
                }
            } else {
                log.info("Object retrieved remained 'main_object' -- returning: {}", (Object)fullAsset);
            }
        } else {
            fullAsset = this.igcRestClient.getAssetRefById(rid);
            if (fullAsset == null) {
                log.info("Unable to retrieve any asset with RID {} -- assume it was deleted.", (Object)rid);
            } else {
                log.info("No asset type provided -- returning basic reference.");
            }
        }
        return fullAsset;
    }

    public static IGCSearchSorting sortFromNonPropertySequencingOrder(SequencingOrder sequencingOrder) {
        IGCSearchSorting sort = null;
        if (sequencingOrder != null) {
            switch (sequencingOrder) {
                case GUID: {
                    sort = new IGCSearchSorting("_id");
                    break;
                }
                case CREATION_DATE_RECENT: {
                    sort = new IGCSearchSorting("created_on", Boolean.valueOf(false));
                    break;
                }
                case CREATION_DATE_OLDEST: {
                    sort = new IGCSearchSorting("created_on", Boolean.valueOf(true));
                    break;
                }
                case LAST_UPDATE_RECENT: {
                    sort = new IGCSearchSorting("modified_on", Boolean.valueOf(false));
                    break;
                }
                case LAST_UPDATE_OLDEST: {
                    sort = new IGCSearchSorting("modified_on", Boolean.valueOf(true));
                    break;
                }
                default: {
                    sort = null;
                }
            }
        }
        return sort;
    }

    public static void addReferencesToList(IGCRestClient igcRestClient, List<Reference> list, Object candidate) {
        if (candidate instanceof Reference) {
            Reference reference = (Reference)candidate;
            if (reference.getType() != null) {
                list.add(reference);
            }
        } else if (candidate instanceof ItemList) {
            ItemList references = (ItemList)candidate;
            if (references.hasMorePages()) {
                list.addAll(igcRestClient.getAllPages(null, references));
            } else {
                list.addAll(references.getItems());
            }
        }
    }

    private void raiseRepositoryErrorException(IGCOMRSErrorCode errorCode, String methodName, String ... params) throws RepositoryErrorException {
        throw new RepositoryErrorException(errorCode.getMessageDefinition(params), this.getClass().getName(), methodName);
    }

    private void raiseEntityNotKnownException(String methodName, String ... params) throws EntityNotKnownException {
        throw new EntityNotKnownException(IGCOMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(params), this.getClass().getName(), methodName);
    }
}

