/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;

public abstract class InstanceMapping {
    private Map<String, Object> literalOmrsPropertyMapping = new HashMap<String, Object>();

    public void addLiteralPropertyMapping(String omrsPropertyName, Object value) {
        this.literalOmrsPropertyMapping.put(omrsPropertyName, value);
    }

    public void removeLiteralPropertyMapping(String omrsPropertyName) {
        if (this.literalOmrsPropertyMapping.containsKey(omrsPropertyName)) {
            this.literalOmrsPropertyMapping.remove(omrsPropertyName);
        }
    }

    public Set<String> getLiteralPropertyMappings() {
        return this.literalOmrsPropertyMapping.keySet();
    }

    public Object getOmrsPropertyLiteralValue(String omrsPropertyName) {
        Object value = null;
        if (this.literalOmrsPropertyMapping.containsKey(omrsPropertyName)) {
            value = this.literalOmrsPropertyMapping.get(omrsPropertyName);
        }
        return value;
    }

    public boolean isOmrsPropertyLiteralMapped(String omrsPropertyName) {
        return this.literalOmrsPropertyMapping.containsKey(omrsPropertyName);
    }

    public abstract Set<String> getMappedOmrsPropertyNames();

    public SearchFilter getAllNoneOrSome(SearchProperties matchProperties) {
        SearchFilter filter = SearchFilter.SOME;
        if (matchProperties != null) {
            Set<String> mappedOmrsProperties = this.getMappedOmrsPropertyNames();
            MatchCriteria matchCriteria = matchProperties.getMatchCriteria();
            ArrayList conditions = matchProperties.getConditions();
            if (conditions == null) {
                conditions = new ArrayList();
            }
            boolean allValuesAreUnequal = true;
            for (PropertyCondition condition : conditions) {
                SearchProperties nestedConditions = condition.getNestedConditions();
                if (nestedConditions != null) {
                    filter = this.getAllNoneOrSome(nestedConditions);
                    if (matchCriteria.equals((Object)MatchCriteria.NONE) && !filter.equals((Object)SearchFilter.NONE) || matchCriteria.equals((Object)MatchCriteria.ALL) && !filter.equals((Object)SearchFilter.ALL)) {
                        filter = SearchFilter.NONE;
                        break;
                    }
                    if (!matchCriteria.equals((Object)MatchCriteria.ANY) || filter.equals((Object)SearchFilter.NONE)) continue;
                    filter = SearchFilter.ALL;
                    break;
                }
                String omrsPropertyName = condition.getProperty();
                if (!mappedOmrsProperties.contains(omrsPropertyName)) {
                    filter = SearchFilter.NONE;
                    break;
                }
                if (!this.isOmrsPropertyLiteralMapped(omrsPropertyName)) continue;
                Object literalValue = this.getOmrsPropertyLiteralValue(omrsPropertyName);
                boolean valuesAreEqual = IGCRepositoryHelper.equivalentValues(literalValue, condition.getOperator(), condition.getValue());
                if (valuesAreEqual && !matchCriteria.equals((Object)MatchCriteria.ALL)) {
                    filter = matchCriteria.equals((Object)MatchCriteria.NONE) ? SearchFilter.NONE : SearchFilter.ALL;
                    allValuesAreUnequal = false;
                    break;
                }
                if (valuesAreEqual || !matchCriteria.equals((Object)MatchCriteria.ALL)) continue;
                filter = SearchFilter.NONE;
                break;
            }
            if (allValuesAreUnequal && matchCriteria.equals((Object)MatchCriteria.NONE)) {
                filter = SearchFilter.ALL;
            }
        }
        return filter;
    }

    public static enum SearchFilter {
        ALL,
        NONE,
        SOME;

    }
}

