/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttributeMapping {
    private static final Logger log = LoggerFactory.getLogger(AttributeMapping.class);
    private String omrsAttributeTypeDefName;

    public AttributeMapping(String omrsAttributeTypeDefName) {
        this.omrsAttributeTypeDefName = omrsAttributeTypeDefName;
    }

    public String getOmrsAttributeTypeDefName() {
        return this.omrsAttributeTypeDefName;
    }

    public static InstanceProperties addPrimitivePropertyToInstance(OMRSRepositoryHelper omrsRepositoryHelper, String sourceName, InstanceProperties properties, TypeDefAttribute property, Object propertyValue, String methodName) {
        InstanceProperties resultingProperties = properties;
        if (propertyValue != null) {
            String propertyName = property.getAttributeName();
            if (property.getAttributeType().getCategory() == AttributeTypeDefCategory.PRIMITIVE) {
                try {
                    List list;
                    if (propertyValue instanceof List && !(list = (List)propertyValue).isEmpty()) {
                        propertyValue = list.get(0);
                    }
                    PrimitiveDef primitiveDef = (PrimitiveDef)property.getAttributeType();
                    switch (primitiveDef.getPrimitiveDefCategory()) {
                        case OM_PRIMITIVE_TYPE_BOOLEAN: {
                            boolean booleanValue = propertyValue instanceof Boolean ? ((Boolean)propertyValue).booleanValue() : Boolean.valueOf(propertyValue.toString()).booleanValue();
                            resultingProperties = omrsRepositoryHelper.addBooleanPropertyToInstance(sourceName, properties, propertyName, booleanValue, methodName);
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_INT: {
                            Integer intValue = null;
                            if (propertyValue instanceof Integer) {
                                intValue = (Integer)propertyValue;
                            } else if (propertyValue instanceof Number) {
                                intValue = ((Number)propertyValue).intValue();
                            } else {
                                String propertyVal = propertyValue.toString();
                                if (!propertyVal.equals("")) {
                                    intValue = Integer.valueOf(propertyVal);
                                }
                            }
                            if (intValue != null) {
                                resultingProperties = omrsRepositoryHelper.addIntPropertyToInstance(sourceName, properties, propertyName, intValue.intValue(), methodName);
                            }
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_LONG: {
                            Long longValue = null;
                            if (propertyValue instanceof Long) {
                                longValue = (Long)propertyValue;
                            } else if (propertyValue instanceof Number) {
                                longValue = ((Number)propertyValue).longValue();
                            } else {
                                String propertyVal = propertyValue.toString();
                                if (!propertyVal.equals("")) {
                                    longValue = Long.valueOf(propertyVal);
                                }
                            }
                            if (longValue != null) {
                                resultingProperties = omrsRepositoryHelper.addLongPropertyToInstance(sourceName, properties, propertyName, longValue.longValue(), methodName);
                            }
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_FLOAT: {
                            Float floatValue = null;
                            if (propertyValue instanceof Float) {
                                floatValue = (Float)propertyValue;
                            } else if (propertyValue instanceof Number) {
                                floatValue = Float.valueOf(((Number)propertyValue).floatValue());
                            } else {
                                String propertyVal = propertyValue.toString();
                                if (!propertyVal.equals("")) {
                                    floatValue = Float.valueOf(propertyVal);
                                }
                            }
                            if (floatValue != null) {
                                resultingProperties = omrsRepositoryHelper.addFloatPropertyToInstance(sourceName, properties, propertyName, floatValue.floatValue(), methodName);
                            }
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_STRING: {
                            String stringValue = propertyValue instanceof String ? (String)propertyValue : propertyValue.toString();
                            if (stringValue != null && !stringValue.equals("")) {
                                resultingProperties = omrsRepositoryHelper.addStringPropertyToInstance(sourceName, properties, propertyName, stringValue, methodName);
                            }
                            break;
                        }
                        case OM_PRIMITIVE_TYPE_DATE: {
                            if (propertyValue instanceof Date) {
                                resultingProperties = omrsRepositoryHelper.addDatePropertyToInstance(sourceName, properties, propertyName, (Date)propertyValue, methodName);
                                break;
                            }
                            log.warn("Unable to parse date automatically -- must be first converted before passing in: {}", propertyValue);
                            break;
                        }
                        default: {
                            log.error("Unhandled primitive type {} for {}", (Object)primitiveDef.getPrimitiveDefCategory(), (Object)propertyName);
                            break;
                        }
                    }
                }
                catch (ClassCastException e) {
                    log.error("Unable to cast {} to {} for {}", new Object[]{propertyValue, property.getAttributeType(), propertyName, e});
                }
                catch (NumberFormatException e) {
                    log.warn("Unable to convert {} to {} for {}", new Object[]{propertyValue, property.getAttributeType(), propertyName, e});
                }
            } else {
                log.error("Cannot translate non-primitive property {} this way.", (Object)propertyName);
            }
        }
        return resultingProperties;
    }

    public static String getIgcValueFromPropertyValue(InstancePropertyValue value) throws PropertyErrorException {
        String igcValue;
        if (value == null) {
            return null;
        }
        String methodName = "getIgcValueFromPropertyValue";
        InstancePropertyCategory category = value.getInstancePropertyCategory();
        block0 : switch (category) {
            case PRIMITIVE: {
                PrimitivePropertyValue actualValue = (PrimitivePropertyValue)value;
                PrimitiveDefCategory primitiveType = actualValue.getPrimitiveDefCategory();
                switch (primitiveType) {
                    case OM_PRIMITIVE_TYPE_DATE: {
                        Long epoch = (Long)actualValue.getPrimitiveValue();
                        igcValue = "" + epoch;
                        break block0;
                    }
                }
                igcValue = actualValue.getPrimitiveValue().toString();
                break;
            }
            case ENUM: {
                igcValue = ((EnumPropertyValue)value).getSymbolicName();
                break;
            }
            case ARRAY: {
                StringBuilder sb = new StringBuilder();
                sb.append("[ ");
                Map arrayValues = ((ArrayPropertyValue)value).getArrayValues().getInstanceProperties();
                for (Map.Entry nextEntry : arrayValues.entrySet()) {
                    sb.append("\"");
                    sb.append(AttributeMapping.getIgcValueFromPropertyValue((InstancePropertyValue)nextEntry.getValue()));
                    sb.append("\",");
                }
                igcValue = sb.toString();
                if (igcValue.endsWith(",")) {
                    igcValue = igcValue.substring(0, igcValue.length() - 1);
                }
                igcValue = igcValue + " ]";
                break;
            }
            default: {
                throw new PropertyErrorException(IGCOMRSErrorCode.PROPERTY_CANNOT_BE_TRANSLATED.getMessageDefinition(value.toString(), category.getName()), AttributeMapping.class.getName(), "getIgcValueFromPropertyValue");
            }
        }
        return igcValue;
    }

    public static int compareInstanceProperty(InstancePropertyValue v1, InstancePropertyValue v2) {
        int result = 0;
        if (v1 == v2) {
            result = 0;
        } else if (v1 == null) {
            result = -1;
        } else if (v2 == null) {
            result = 1;
        } else {
            InstancePropertyCategory category = v1.getInstancePropertyCategory();
            if (category.equals((Object)InstancePropertyCategory.PRIMITIVE)) {
                PrimitivePropertyValue pv1 = (PrimitivePropertyValue)v1;
                PrimitivePropertyValue pv2 = (PrimitivePropertyValue)v2;
                PrimitiveDefCategory primitiveCategory = pv1.getPrimitiveDefCategory();
                switch (primitiveCategory) {
                    case OM_PRIMITIVE_TYPE_INT: {
                        result = ((Integer)pv1.getPrimitiveValue()).compareTo((Integer)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_BYTE: {
                        result = ((Byte)pv1.getPrimitiveValue()).compareTo((Byte)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_CHAR: {
                        result = ((Character)pv1.getPrimitiveValue()).compareTo((Character)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_STRING: {
                        result = ((String)pv1.getPrimitiveValue()).compareTo((String)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_LONG: 
                    case OM_PRIMITIVE_TYPE_DATE: {
                        result = ((Long)pv1.getPrimitiveValue()).compareTo((Long)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_FLOAT: {
                        result = ((Float)pv1.getPrimitiveValue()).compareTo((Float)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_SHORT: {
                        result = ((Short)pv1.getPrimitiveValue()).compareTo((Short)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_DOUBLE: {
                        result = ((Double)pv1.getPrimitiveValue()).compareTo((Double)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_BOOLEAN: {
                        result = ((Boolean)pv1.getPrimitiveValue()).compareTo((Boolean)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                        result = ((BigDecimal)pv1.getPrimitiveValue()).compareTo((BigDecimal)pv2.getPrimitiveValue());
                        break;
                    }
                    case OM_PRIMITIVE_TYPE_BIGINTEGER: {
                        result = ((BigInteger)pv1.getPrimitiveValue()).compareTo((BigInteger)pv2.getPrimitiveValue());
                        break;
                    }
                    default: {
                        result = pv1.getPrimitiveValue().toString().compareTo(pv2.getPrimitiveValue().toString());
                        break;
                    }
                }
            } else if (category.equals((Object)InstancePropertyCategory.ENUM)) {
                EnumPropertyValue ev1 = (EnumPropertyValue)v1;
                EnumPropertyValue ev2 = (EnumPropertyValue)v2;
                result = ev1.getOrdinal() - ev2.getOrdinal();
            } else {
                log.warn("Unhandled instance value type for comparison: {}", (Object)category);
            }
        }
        return result;
    }
}

