/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Category;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Term;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Spine_Mapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(Spine_Mapper.class);

    protected Spine_Mapper(String omrsClassificationType) {
        super("term", "referencing_categories", "GlossaryTerm", omrsClassificationType);
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        ItemList candidates;
        if (fromIgcObject instanceof Term && (candidates = ((Term)fromIgcObject).getReferencingCategories()) != null) {
            List allCandidates = igcomrsRepositoryConnector.getIGCRestClient().getAllPages("referencing_categories", candidates);
            boolean foundSpine = false;
            for (Category candidate : allCandidates) {
                if (!candidate.getName().equals(this.getOmrsClassificationType())) continue;
                foundSpine = true;
                break;
            }
            if (foundSpine) {
                try {
                    Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, null, fromIgcObject, userId);
                    classifications.add(classification);
                }
                catch (RepositoryErrorException e) {
                    log.error("Unable to map {} classification.", (Object)this.getOmrsClassificationType(), (Object)e);
                }
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, SearchProperties matchProperties) {
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        if (matchProperties == null || matchProperties.getMatchCriteria().equals((Object)MatchCriteria.NONE)) {
            IGCSearchCondition igcSearchCondition = new IGCSearchCondition("referencing_categories.name", "=", this.getOmrsClassificationType());
            igcSearchConditionSet.addCondition(igcSearchCondition);
        } else {
            igcSearchConditionSet.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
        }
        igcSearchConditionSet.setMatchAnyCondition(false);
        return igcSearchConditionSet;
    }
}

