/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.DataClass;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Filter;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.DataClassAssignmentMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.DataClassHierarchyMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClassMapper
extends ReferenceableMapper {
    private static final Logger log = LoggerFactory.getLogger(DataClassMapper.class);
    private static final String VALUE_DELIMITER = "__,__";

    public static DataClassMapper getInstance(IGCVersionEnum version) {
        if (version.isEqualTo(IGCVersionEnum.V11702) || version.isHigherThan(IGCVersionEnum.V11702)) {
            return SingletonNew.INSTANCE;
        }
        return SingletonOld.INSTANCE;
    }

    protected DataClassMapper(IGCVersionEnum version) {
        super("data_class", "Data Class", "DataClass");
        this.addOtherIGCAssetType("classification");
        this.addSimplePropertyMapping("name", "name");
        this.addSimplePropertyMapping("short_description", "description");
        this.addSimplePropertyMapping("class_code", "classCode");
        this.addSimplePropertyMapping("default_threshold", "defaultThreshold");
        this.addSimplePropertyMapping("example", "example");
        this.addComplexIgcProperty("data_type_filter_elements_enum");
        this.addComplexIgcProperty("data_class_type_single");
        this.addComplexIgcProperty("java_class_name_single");
        this.addComplexIgcProperty("regular_expression_single");
        this.addComplexIgcProperty("valid_value_strings");
        this.addComplexIgcProperty("validValueReferenceFile");
        this.addComplexOmrsProperty("dataType");
        this.addComplexOmrsProperty("specificationDetails");
        this.addComplexOmrsProperty("specification");
        if (version.isEqualTo(IGCVersionEnum.V11702) || version.isHigherThan(IGCVersionEnum.V11702)) {
            this.addComplexIgcProperty("expression");
            this.addComplexIgcProperty("script");
            this.addComplexIgcProperty("provider");
            this.addComplexIgcProperty("filters");
            this.addComplexOmrsProperty("userDefined");
        } else {
            this.addLiteralPropertyMapping("userDefined", null);
        }
        this.addLiteralPropertyMapping("namespace", null);
        this.addRelationshipMapper(DataClassHierarchyMapper.getInstance(version));
        this.addRelationshipMapper(DataClassAssignmentMapper.getInstance(version));
    }

    @Override
    public Reference getBaseIgcAssetFromAlternative(String igcAssetType, String igcRid, IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        if (igcAssetType.equals("classification")) {
            return DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()).getProxyTwoAssetFromAsset(igcRestClient.getAssetById(igcRid), igcRestClient).get(0);
        }
        return igcRestClient.getAssetWithSubsetOfProperties(igcRid, igcAssetType, igcRestClient.getAllPropertiesForType(igcAssetType));
    }

    @Override
    protected InstanceProperties complexPropertyMappings(EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        instanceProperties = super.complexPropertyMappings(entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        Reference igcEntity = entityMap.getIgcEntity();
        if (igcEntity instanceof DataClass) {
            DataClass dataClass = (DataClass)igcEntity;
            OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
            String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
            List dataTypes = dataClass.getDataTypeFilterElementsEnum();
            String dataType = null;
            for (String type : dataTypes) {
                if (dataType == null) {
                    dataType = type;
                    continue;
                }
                if (!type.equals("string") && type.equals(dataType)) continue;
                dataType = "string";
                break;
            }
            instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "dataType", dataType, "complexPropertyMappings");
            String dataClassType = dataClass.getDataClassTypeSingle();
            instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "specification", dataClassType, "complexPropertyMappings");
            String dataClassDetails = "";
            switch (dataClassType) {
                case "Regex": {
                    dataClassDetails = dataClass.getRegularExpressionSingle();
                    break;
                }
                case "ValidValues": {
                    List validValues = dataClass.getValidValueStrings();
                    if (validValues == null || validValues.isEmpty()) {
                        dataClassDetails = dataClass.getValidvaluereferencefile();
                        break;
                    }
                    dataClassDetails = String.join((CharSequence)VALUE_DELIMITER, validValues);
                    break;
                }
                case "Script": {
                    dataClassDetails = dataClass.getScript();
                    break;
                }
                case "ColumnSimilarity": {
                    dataClassDetails = dataClass.getExpression();
                    break;
                }
                case "UnstructuredFilter": {
                    ItemList filters = dataClass.getFilters();
                    if (filters.getItems().isEmpty()) break;
                    List allFilters = igcomrsRepositoryConnector.getIGCRestClient().getAllPages("filters", filters);
                    ArrayList<String> filterNames = new ArrayList<String>();
                    for (Filter filter : allFilters) {
                        filterNames.add(filter.getName());
                    }
                    dataClassDetails = String.join((CharSequence)VALUE_DELIMITER, filterNames);
                    break;
                }
                default: {
                    dataClassDetails = dataClass.getJavaClassNameSingle();
                }
            }
            instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "specificationDetails", dataClassDetails, "complexPropertyMappings");
            IGCVersionEnum igcVersion = igcomrsRepositoryConnector.getIGCVersion();
            if (igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
                String provider = dataClass.getProvider();
                instanceProperties = repositoryHelper.addBooleanPropertyToInstance(repositoryName, instanceProperties, "userDefined", provider == null || !provider.equals("IBM"), "complexPropertyMappings");
            }
        }
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, PropertyComparisonOperator operator, InstancePropertyValue value) throws FunctionNotSupportedException {
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, operator, value);
        String methodName = "addComplexPropertySearchCriteria";
        if (this.getComplexMappedOmrsProperties().contains(omrsPropertyName)) {
            log.debug("Adding complex search criteria for: {}", (Object)omrsPropertyName);
            IGCVersionEnum igcVersion = igcRestClient.getIgcVersion();
            String omrsValue = value.valueAsString();
            String igcPropertyToSearch = null;
            switch (omrsPropertyName) {
                case "dataType": {
                    igcPropertyToSearch = "data_type_filter_elements_enum";
                    break;
                }
                case "specificationDetails": {
                    IGCSearchCondition withValidValues;
                    IGCSearchConditionSet complexCriteria = new IGCSearchConditionSet();
                    IGCSearchConditionSet asRegex = new IGCSearchConditionSet();
                    IGCSearchCondition byRegex = new IGCSearchCondition("data_class_type_single", "=", "Regex");
                    IGCSearchCondition withRegex = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", "regular_expression_single", omrsValue);
                    asRegex.addCondition(byRegex);
                    asRegex.addCondition(withRegex);
                    asRegex.setMatchAnyCondition(false);
                    if (operator.equals((Object)PropertyComparisonOperator.NEQ)) {
                        asRegex.setNegateAll(true);
                    }
                    IGCSearchConditionSet asValidValues = new IGCSearchConditionSet();
                    IGCSearchCondition byValidValues = new IGCSearchCondition("data_class_type_single", "=", "ValidValues");
                    if (omrsValue.contains(VALUE_DELIMITER)) {
                        String unqualifiedValue = repositoryHelper.getUnqualifiedLiteralString(omrsValue);
                        String[] valueList = unqualifiedValue.split(VALUE_DELIMITER);
                        withValidValues = new IGCSearchCondition("valid_value_strings", Arrays.asList(valueList));
                    } else {
                        withValidValues = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", "validValueReferenceFile", omrsValue);
                    }
                    asValidValues.addCondition(byValidValues);
                    asValidValues.addCondition(withValidValues);
                    asValidValues.setMatchAnyCondition(false);
                    if (operator.equals((Object)PropertyComparisonOperator.NEQ)) {
                        asValidValues.setNegateAll(true);
                    }
                    if (igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
                        IGCSearchConditionSet asScript = new IGCSearchConditionSet();
                        IGCSearchCondition byScript = new IGCSearchCondition("data_class_type_single", "=", "Script");
                        IGCSearchCondition withScript = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", "script", omrsValue);
                        asScript.addCondition(byScript);
                        asScript.addCondition(withScript);
                        asScript.setMatchAnyCondition(false);
                        if (operator.equals((Object)PropertyComparisonOperator.NEQ)) {
                            asScript.setNegateAll(true);
                        }
                        IGCSearchConditionSet asColumnSimilarity = new IGCSearchConditionSet();
                        IGCSearchCondition byColumnSimilarity = new IGCSearchCondition("data_class_type_single", "=", "ColumnSimilarity");
                        IGCSearchCondition withColumnSimilarity = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", "expression", omrsValue);
                        asColumnSimilarity.addCondition(byColumnSimilarity);
                        asColumnSimilarity.addCondition(withColumnSimilarity);
                        asColumnSimilarity.setMatchAnyCondition(false);
                        if (operator.equals((Object)PropertyComparisonOperator.NEQ)) {
                            asColumnSimilarity.setNegateAll(true);
                        }
                        IGCSearchConditionSet asUnstructuredFilter = new IGCSearchConditionSet();
                        IGCSearchCondition byUnstructuredFilter = new IGCSearchCondition("data_class_type_single", "=", "UnstructuredFilter");
                        String unqualifiedValue = repositoryHelper.getUnqualifiedLiteralString(omrsValue);
                        String[] filterList = unqualifiedValue.split(VALUE_DELIMITER);
                        IGCSearchCondition withUnstructuredFilter = new IGCSearchCondition("filters.name", Arrays.asList(filterList));
                        asUnstructuredFilter.addCondition(byUnstructuredFilter);
                        asUnstructuredFilter.addCondition(withUnstructuredFilter);
                        asUnstructuredFilter.setMatchAnyCondition(false);
                        if (operator.equals((Object)PropertyComparisonOperator.NEQ)) {
                            asUnstructuredFilter.setNegateAll(true);
                        }
                        complexCriteria.addNestedConditionSet(asScript);
                        complexCriteria.addNestedConditionSet(asColumnSimilarity);
                        complexCriteria.addNestedConditionSet(asUnstructuredFilter);
                    }
                    IGCSearchConditionSet asJavaClass = new IGCSearchConditionSet();
                    IGCSearchCondition withJavaClass = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", "java_class_name_single", omrsValue);
                    asJavaClass.addCondition(withJavaClass);
                    asJavaClass.setMatchAnyCondition(false);
                    if (operator.equals((Object)PropertyComparisonOperator.NEQ)) {
                        asJavaClass.setNegateAll(true);
                    }
                    complexCriteria.addNestedConditionSet(asRegex);
                    complexCriteria.addNestedConditionSet(asValidValues);
                    complexCriteria.addNestedConditionSet(asJavaClass);
                    complexCriteria.setMatchAnyCondition(true);
                    igcSearchConditionSet.addNestedConditionSet(complexCriteria);
                    break;
                }
                case "specification": {
                    igcPropertyToSearch = "data_class_type_single";
                    break;
                }
                case "userDefined": {
                    if (!igcVersion.isEqualTo(IGCVersionEnum.V11702) && !igcVersion.isHigherThan(IGCVersionEnum.V11702)) break;
                    boolean isUserDefined = Boolean.parseBoolean(omrsValue);
                    IGCRepositoryHelper.validateBooleanOperator(operator, "addComplexPropertySearchCriteria");
                    IGCSearchCondition igcSearchCondition = null;
                    switch (operator) {
                        case IS_NULL: {
                            igcSearchCondition = new IGCSearchCondition("provider", "isNull", Boolean.valueOf(false));
                            break;
                        }
                        case NOT_NULL: {
                            igcSearchCondition = new IGCSearchCondition("provider", "isNull", Boolean.valueOf(true));
                            break;
                        }
                        case EQ: {
                            igcSearchCondition = new IGCSearchCondition("provider", isUserDefined ? "<>" : "=", "IBM");
                            break;
                        }
                        case NEQ: {
                            igcSearchCondition = new IGCSearchCondition("provider", isUserDefined ? "=" : "<>", "IBM");
                            break;
                        }
                    }
                    if (igcSearchCondition == null) break;
                    igcSearchConditionSet.addCondition(igcSearchCondition);
                }
            }
            if (igcPropertyToSearch != null) {
                igcSearchConditionSet.addCondition(IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", igcPropertyToSearch, operator, omrsValue));
            }
        }
    }

    private static class SingletonNew {
        private static final DataClassMapper INSTANCE = new DataClassMapper(IGCVersionEnum.V11702);

        private SingletonNew() {
        }
    }

    private static class SingletonOld {
        private static final DataClassMapper INSTANCE = new DataClassMapper(IGCVersionEnum.V11501);

        private SingletonOld() {
        }
    }
}

