/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model;

import java.util.Objects;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCGuidHeader;

public class IGCRelationshipGuid
extends IGCGuidHeader {
    private static final String GENERATED_TYPE_POSTFIX = "!";
    private static final String IGC_TYPE_POSTFIX = "@";
    private static final String RELATIONSHIP_TYPE_PREFIX = "<";
    private static final String RELATIONSHIP_TYPE_POSTFIX = ">";
    private String assetType1;
    private String assetType2;
    private String generatedPrefix1;
    private String generatedPrefix2;
    private String rid1;
    private String rid2;
    private String relationshipType;

    public IGCRelationshipGuid(String metadataCollectionId, String assetType1, String assetType2, String rid1, String rid2, String relationshipType) {
        this(metadataCollectionId, assetType1, assetType2, null, null, rid1, rid2, relationshipType);
    }

    public IGCRelationshipGuid(String metadataCollectionId, String assetType1, String assetType2, String prefix1, String prefix2, String rid1, String rid2, String relationshipType) {
        super(metadataCollectionId);
        this.assetType1 = assetType1;
        this.assetType2 = assetType2;
        this.generatedPrefix1 = prefix1;
        this.generatedPrefix2 = prefix2;
        this.rid1 = rid1;
        this.rid2 = rid2;
        this.relationshipType = relationshipType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(this.assetType1);
        sb.append(IGC_TYPE_POSTFIX);
        if (this.generatedPrefix1 != null) {
            sb.append(this.generatedPrefix1);
            sb.append(GENERATED_TYPE_POSTFIX);
        }
        sb.append(this.rid1);
        sb.append(RELATIONSHIP_TYPE_PREFIX);
        sb.append(this.relationshipType);
        sb.append(RELATIONSHIP_TYPE_POSTFIX);
        sb.append(this.assetType2);
        sb.append(IGC_TYPE_POSTFIX);
        if (this.generatedPrefix2 != null) {
            sb.append(this.generatedPrefix2);
            sb.append(GENERATED_TYPE_POSTFIX);
        }
        sb.append(this.rid2);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IGCRelationshipGuid)) {
            return false;
        }
        IGCRelationshipGuid that = (IGCRelationshipGuid)obj;
        return Objects.equals(this.getMetadataCollectionId(), that.getMetadataCollectionId()) && Objects.equals(this.getAssetType1(), that.getAssetType1()) && Objects.equals(this.getAssetType2(), that.getAssetType2()) && Objects.equals(this.getGeneratedPrefix1(), that.getGeneratedPrefix1()) && Objects.equals(this.getGeneratedPrefix2(), that.getGeneratedPrefix2()) && Objects.equals(this.getRid1(), that.getRid1()) && Objects.equals(this.getRid2(), that.getRid2()) && Objects.equals(this.getRelationshipType(), that.getRelationshipType());
    }

    public int hashCode() {
        return Objects.hash(this.getMetadataCollectionId(), this.getRelationshipType(), this.getAssetType1(), this.getGeneratedPrefix1(), this.getRid1(), this.getAssetType2(), this.getGeneratedPrefix2(), this.getRid2());
    }

    public static IGCRelationshipGuid fromGuid(String guid) {
        if (guid == null) {
            return null;
        }
        int indexOfMetadataColPostfix = guid.indexOf(":");
        int indexOfRelationshipTypePrefix = guid.indexOf(RELATIONSHIP_TYPE_PREFIX);
        int indexOfRelationshipTypePostfix = guid.indexOf(RELATIONSHIP_TYPE_POSTFIX);
        if (indexOfMetadataColPostfix > 0 && indexOfRelationshipTypePrefix > indexOfMetadataColPostfix && indexOfRelationshipTypePostfix > indexOfRelationshipTypePrefix) {
            String metadataCollectionId = guid.substring(0, indexOfMetadataColPostfix);
            String endpoint1 = guid.substring(indexOfMetadataColPostfix + 1, indexOfRelationshipTypePrefix);
            String endpoint2 = guid.substring(indexOfRelationshipTypePostfix + 1);
            String relationshipType = guid.substring(indexOfRelationshipTypePrefix + 1, indexOfRelationshipTypePostfix);
            String rid1 = IGCRelationshipGuid.getRidFromEndpoint(endpoint1);
            String rid2 = IGCRelationshipGuid.getRidFromEndpoint(endpoint2);
            String assetType1 = IGCRelationshipGuid.getAssetTypeFromEndpoint(endpoint1);
            String assetType2 = IGCRelationshipGuid.getAssetTypeFromEndpoint(endpoint2);
            String generatedPrefix1 = IGCRelationshipGuid.getGeneratedPrefixFromEndpoint(endpoint1);
            String generatedPrefix2 = IGCRelationshipGuid.getGeneratedPrefixFromEndpoint(endpoint2);
            return new IGCRelationshipGuid(metadataCollectionId, assetType1, assetType2, generatedPrefix1, generatedPrefix2, rid1, rid2, relationshipType);
        }
        return null;
    }

    private static String getAssetTypeFromEndpoint(String endpoint) {
        int indexOfTypePostfix = endpoint.indexOf(IGC_TYPE_POSTFIX);
        return endpoint.substring(0, indexOfTypePostfix);
    }

    private static String getGeneratedPrefixFromEndpoint(String endpoint) {
        int indexOfTypePostfix = endpoint.indexOf(IGC_TYPE_POSTFIX);
        int indexOfGeneratedPostfix = endpoint.indexOf(GENERATED_TYPE_POSTFIX);
        String generatedPrefix = null;
        if (indexOfGeneratedPostfix > 0) {
            generatedPrefix = endpoint.substring(indexOfTypePostfix + 1, indexOfGeneratedPostfix);
        }
        return generatedPrefix;
    }

    private static String getRidFromEndpoint(String endpoint) {
        int indexOfTypePostfix = endpoint.indexOf(IGC_TYPE_POSTFIX);
        int indexOfGeneratedPostfix = endpoint.indexOf(GENERATED_TYPE_POSTFIX);
        int lastIndex = Math.max(indexOfTypePostfix, indexOfGeneratedPostfix);
        return endpoint.substring(lastIndex + 1);
    }

    public String getAssetType1() {
        return this.assetType1;
    }

    public String getAssetType2() {
        return this.assetType2;
    }

    public String getGeneratedPrefix1() {
        return this.generatedPrefix1;
    }

    public String getGeneratedPrefix2() {
        return this.generatedPrefix2;
    }

    public String getRid1() {
        return this.rid1;
    }

    public String getRid2() {
        return this.rid2;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public boolean isRelationshipLevelObject() {
        return this.rid1 != null && this.rid1.equals(this.rid2) && (this.generatedPrefix1 == null && this.generatedPrefix2 == null || this.generatedPrefix1 != null && this.generatedPrefix1.equals(this.generatedPrefix2));
    }
}

