/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.MappingStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityMappingStore
extends MappingStore {
    private static final Logger log = LoggerFactory.getLogger(EntityMappingStore.class);
    private Map<String, EntityMapping> omrsGuidToMapping = new HashMap<String, EntityMapping>();
    private Map<String, List<String>> igcAssetTypeToOmrsGuids = new HashMap<String, List<String>>();
    private Map<String, String> igcAssetDisplayNameToOmrsGuid = new HashMap<String, String>();
    private Map<String, String> igcAssetTypeAndPrefixToOmrsGuid = new HashMap<String, String>();
    private Map<String, Set<String>> igcPrefixToOmrsGuids = new HashMap<String, Set<String>>();

    public EntityMappingStore(IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        super(igcomrsRepositoryConnector);
    }

    public boolean addMapping(TypeDef omrsTypeDef, Class<?> mappingClass, IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        EntityMapping mapping = this.getEntityMapper(mappingClass);
        if (mapping != null) {
            String guid = omrsTypeDef.getGUID();
            this.addTypeDef(omrsTypeDef);
            String igcAssetType = mapping.getIgcAssetType();
            this.omrsGuidToMapping.put(guid, mapping);
            this.addIgcAssetTypeToGuid(igcAssetType, guid);
            this.igcAssetDisplayNameToOmrsGuid.put(mapping.getIgcAssetTypeDisplayName(), guid);
            String prefix = mapping.getIgcRidPrefix();
            String coreKey = this.getPrefixedTypeKey(igcAssetType, prefix);
            log.debug(" ... adding core mapping from {} to: {}", (Object)coreKey, (Object)guid);
            this.igcAssetTypeAndPrefixToOmrsGuid.put(coreKey, guid);
            if (prefix != null && !prefix.equals("")) {
                if (!this.igcPrefixToOmrsGuids.containsKey(prefix)) {
                    this.igcPrefixToOmrsGuids.put(prefix, new HashSet());
                }
                this.igcPrefixToOmrsGuids.get(prefix).add(guid);
            }
            for (String otherType : mapping.getOtherIGCAssetTypes()) {
                this.addIgcAssetTypeToGuid(otherType, guid);
                String otherKey = this.getPrefixedTypeKey(otherType, prefix);
                log.debug(" ... adding additional mapping from {} to: {}", (Object)otherKey, (Object)guid);
                this.igcAssetTypeAndPrefixToOmrsGuid.put(otherKey, guid);
            }
            if (!mapping.getIgcAssetType().equals("__SUPERTYPE_WITH_NO_DIRECT_MAPPING__")) {
                IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
                igcRestClient.cacheTypeDetails(mapping.getIgcAssetType());
                List<String> otherTypes = mapping.getOtherIGCAssetTypes();
                if (otherTypes != null && !otherTypes.isEmpty()) {
                    for (String type : otherTypes) {
                        if (type.equals("__SUPERTYPE_WITH_NO_DIRECT_MAPPING__")) continue;
                        igcRestClient.cacheTypeDetails(type);
                    }
                }
            }
        }
        return mapping != null;
    }

    private void addIgcAssetTypeToGuid(String igcAssetType, String guid) {
        if (!this.igcAssetTypeToOmrsGuids.containsKey(igcAssetType)) {
            this.igcAssetTypeToOmrsGuids.put(igcAssetType, new ArrayList());
        }
        this.igcAssetTypeToOmrsGuids.get(igcAssetType).add(guid);
    }

    public EntityMapping getMappingByOmrsTypeGUID(String guid) {
        if (this.omrsGuidToMapping.containsKey(guid)) {
            return this.omrsGuidToMapping.get(guid);
        }
        log.warn("Unable to find mapping for OMRS type: {}", (Object)guid);
        return null;
    }

    public List<EntityMapping> getMappingsByIgcAssetType(String assetType) {
        String simpleType = IGCRestConstants.getAssetTypeForSearch((String)assetType);
        if (this.igcAssetTypeToOmrsGuids.containsKey(simpleType)) {
            List<String> guids = this.igcAssetTypeToOmrsGuids.get(simpleType);
            ArrayList<EntityMapping> mappings = new ArrayList<EntityMapping>();
            for (String guid : guids) {
                mappings.add(this.getMappingByOmrsTypeGUID(guid));
            }
            return mappings;
        }
        log.warn("Unable to find mapping for IGC type: {}", (Object)simpleType);
        return null;
    }

    public EntityMapping getMappingByIgcAssetDisplayName(String assetDisplayName) {
        if (this.igcAssetDisplayNameToOmrsGuid.containsKey(assetDisplayName)) {
            String guid = this.igcAssetDisplayNameToOmrsGuid.get(assetDisplayName);
            return this.getMappingByOmrsTypeGUID(guid);
        }
        log.warn("Unable to find mapping for IGC asset display name: {}", (Object)assetDisplayName);
        return null;
    }

    public EntityMapping getMappingByIgcAssetTypeAndPrefix(String assetType, String prefix) {
        String simpleType = IGCRestConstants.getAssetTypeForSearch((String)assetType);
        String key = this.getPrefixedTypeKey(simpleType, prefix);
        if (this.igcAssetTypeAndPrefixToOmrsGuid.containsKey(key)) {
            String guid = this.igcAssetTypeAndPrefixToOmrsGuid.get(key);
            return this.getMappingByOmrsTypeGUID(guid);
        }
        log.warn("Unable to find mapping for IGC asset type: {}", (Object)key);
        return null;
    }

    public Set<EntityMapping> getMappingsByIgcPrefix(String prefix) {
        if (prefix == null) {
            return Collections.emptySet();
        }
        if (this.igcPrefixToOmrsGuids.containsKey(prefix)) {
            Set<String> guids = this.igcPrefixToOmrsGuids.get(prefix);
            HashSet<EntityMapping> mappings = new HashSet<EntityMapping>();
            for (String guid : guids) {
                mappings.add(this.getMappingByOmrsTypeGUID(guid));
            }
            return mappings;
        }
        log.warn("Unable to find mapping for IGC prefix: {}", (Object)prefix);
        return Collections.emptySet();
    }

    public EntityMapping getMappingByOmrsTypeName(String name) {
        String guid = this.getGuidForName(name);
        if (guid == null) {
            log.warn("Unable to find mapping for OMRS type: {}", (Object)name);
            return null;
        }
        return this.getMappingByOmrsTypeGUID(guid);
    }

    public List<EntityMapping> getAllMappings() {
        return new ArrayList<EntityMapping>(this.omrsGuidToMapping.values());
    }

    public EntityMapping getDefaultEntityMapper() {
        EntityMapping referenceable = null;
        try {
            Class<?> mappingClass = Class.forName("org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper");
            referenceable = this.getEntityMapper(mappingClass);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to find default ReferenceableMapper class: {}", (Object)"org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper", (Object)e);
        }
        return referenceable;
    }

    private EntityMapping getEntityMapper(Class<?> mappingClass) {
        EntityMapping entityMapper = null;
        try {
            entityMapper = (EntityMapping)mappingClass.getMethod("getInstance", IGCVersionEnum.class).invoke(null, this.igcomrsRepositoryConnector.getIGCVersion());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to find or instantiate EntityMapping class: {}", mappingClass, (Object)e);
        }
        return entityMapper;
    }

    private String getPrefixedTypeKey(String type, String prefix) {
        if (prefix != null && !prefix.equals("")) {
            return prefix + "$" + type;
        }
        return type;
    }
}

