/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;

public abstract class MappingStore {
    protected IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private Map<String, TypeDef> typeDefs = new TreeMap<String, TypeDef>();
    private Map<String, String> omrsNameToGuid = new HashMap<String, String>();

    protected MappingStore(IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        this.igcomrsRepositoryConnector = igcomrsRepositoryConnector;
    }

    public void addTypeDef(TypeDef typeDef) {
        if (typeDef != null) {
            String guid = typeDef.getGUID();
            this.typeDefs.put(guid, typeDef);
            this.addNameToGuidMapping(typeDef.getName(), guid);
        }
    }

    private void addNameToGuidMapping(String name, String guid) {
        if (name != null && guid != null) {
            this.omrsNameToGuid.put(name, guid);
        }
    }

    public String getGuidForName(String name) {
        return this.omrsNameToGuid.getOrDefault(name, null);
    }

    public boolean updateMapping(TypeDefPatch typeDefPatch) throws InvalidParameterException, PatchErrorException {
        String omrsTypeGUID = typeDefPatch.getTypeDefGUID();
        TypeDef existing = this.typeDefs.getOrDefault(omrsTypeGUID, null);
        if (existing != null) {
            TypeDef updated = this.igcomrsRepositoryConnector.getRepositoryHelper().applyPatch(this.igcomrsRepositoryConnector.getServerName(), existing, typeDefPatch);
            this.typeDefs.put(omrsTypeGUID, updated);
        }
        return existing != null;
    }

    public List<TypeDef> getTypeDefs() {
        return new ArrayList<TypeDef>(this.typeDefs.values());
    }

    public TypeDef getTypeDefByGUID(String guid) {
        return this.typeDefs.getOrDefault(guid, null);
    }
}

