/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.CandidateKey;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.DatabaseColumn;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.KeyPatternMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ConfidentialityMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKeyMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(ConfidentialityMapper.class);

    public static PrimaryKeyMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected PrimaryKeyMapper() {
        super("database_column", "defined_primary_key", "RelationalColumn", "PrimaryKey");
        this.addIgcRelationshipProperty("selected_primary_key");
        this.addMappedOmrsProperty("name");
        this.addLiteralPropertyMapping("keyPattern", KeyPatternMapper.getInstance(null).getEnumMappingByIgcValue(""));
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, Reference fromIgcObject, String userId) {
        String methodName = "addMappedOMRSClassifications";
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        if (fromIgcObject instanceof DatabaseColumn) {
            DatabaseColumn dbColumn = (DatabaseColumn)fromIgcObject;
            Boolean bSelectedPK = dbColumn.getSelectedPrimaryKey();
            ItemList definedPK = dbColumn.getDefinedPrimaryKey();
            if (definedPK.getItems().isEmpty()) {
                if (bSelectedPK.booleanValue()) {
                    try {
                        InstanceProperties classificationProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, null, "name", fromIgcObject.getName(), "addMappedOMRSClassifications");
                        Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, classificationProperties, fromIgcObject, userId);
                        classifications.add(classification);
                    }
                    catch (RepositoryErrorException e) {
                        log.error("Unable to create classification.", (Throwable)e);
                    }
                }
            } else {
                List allCandidateKeys = igcRestClient.getAllPages("defined_primary_key", definedPK);
                for (CandidateKey candidateKey : allCandidateKeys) {
                    try {
                        InstanceProperties classificationProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, null, "name", candidateKey.getName(), "addMappedOMRSClassifications");
                        Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, classificationProperties, fromIgcObject, userId);
                        classifications.add(classification);
                    }
                    catch (RepositoryErrorException e) {
                        log.error("Unable to create classification.", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, SearchProperties matchProperties) throws FunctionNotSupportedException {
        IGCSearchConditionSet byName;
        String methodName = "getIGCSearchCriteria";
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("selected_primary_key", "=", "true");
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        if (matchProperties != null && (byName = this.getConditionsForProperties(matchProperties, repositoryHelper, repositoryName, "getIGCSearchCriteria")).size() > 0) {
            igcSearchConditionSet.addNestedConditionSet(byName);
            igcSearchConditionSet.setMatchAnyCondition(true);
        }
        return igcSearchConditionSet;
    }

    private IGCSearchConditionSet getConditionsForProperties(SearchProperties matchProperties, OMRSRepositoryHelper repositoryHelper, String repositoryName, String methodName) throws FunctionNotSupportedException {
        IGCSearchConditionSet set = new IGCSearchConditionSet();
        List propertyConditions = matchProperties.getConditions();
        for (PropertyCondition condition : propertyConditions) {
            SearchProperties nestedProperties = condition.getNestedConditions();
            if (nestedProperties != null) {
                IGCSearchConditionSet nestedSet = this.getConditionsForProperties(nestedProperties, repositoryHelper, repositoryName, methodName);
                IGCRepositoryHelper.setConditionsFromMatchCriteria(nestedSet, nestedProperties.getMatchCriteria());
                set.addNestedConditionSet(nestedSet);
                continue;
            }
            String propertyName = condition.getProperty();
            PropertyComparisonOperator operator = condition.getOperator();
            if (propertyName.equals("name")) {
                if (!operator.equals((Object)PropertyComparisonOperator.LIKE) && !operator.equals((Object)PropertyComparisonOperator.EQ)) continue;
                IGCSearchCondition byName = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, methodName, "defined_primary_key.name", condition.getValue().valueAsString());
                set.addCondition(byName);
                continue;
            }
            if (propertyName.equals("keyPattern")) {
                InstancePropertyValue value = condition.getValue();
                if (value instanceof EnumPropertyValue) {
                    EnumPropertyValue enumValue = (EnumPropertyValue)value;
                    if (enumValue.getOrdinal() == 99) continue;
                    set.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                    continue;
                }
                if (value == null) {
                    if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) continue;
                    set.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                    continue;
                }
                throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_ENUMERATION.getMessageDefinition(propertyName), this.getClass().getName(), methodName);
            }
            set.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
        }
        IGCRepositoryHelper.setConditionsFromMatchCriteria(set, matchProperties.getMatchCriteria());
        return set;
    }

    private static class Singleton {
        private static final PrimaryKeyMapper INSTANCE = new PrimaryKeyMapper();

        private Singleton() {
        }
    }
}

