/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.ContactMethodTypeMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.ContactThroughMapper_Person;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.ContactThroughMapper_Team;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class ContactDetailsMapper
extends ReferenceableMapper {
    public static final String IGC_RID_PREFIX = "CD";

    public static ContactDetailsMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected ContactDetailsMapper() {
        super("user", "User", "ContactDetails", IGC_RID_PREFIX);
        this.addOtherIGCAssetType("group");
        this.addComplexIgcProperty("email_address");
        this.addComplexOmrsProperty("contactMethodType");
        this.addComplexOmrsProperty("contactMethodValue");
        this.addRelationshipMapper(ContactThroughMapper_Team.getInstance(null));
        this.addRelationshipMapper(ContactThroughMapper_Person.getInstance(null));
    }

    @Override
    protected InstanceProperties complexPropertyMappings(EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        instanceProperties = super.complexPropertyMappings(entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        Reference igcEntity = entityMap.getIgcEntity();
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        String emailAddress = (String)igcRestClient.getPropertyByName(igcEntity, "email_address");
        if (emailAddress != null && !emailAddress.equals("")) {
            EnumPropertyValue contactMethod = ContactMethodTypeMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()).getEnumMappingByIgcValue("email_address");
            instanceProperties.setProperty("contactMethodType", (InstancePropertyValue)contactMethod);
            instanceProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), instanceProperties, "contactMethodValue", emailAddress, "complexPropertyMappings");
        }
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, PropertyComparisonOperator operator, InstancePropertyValue value) throws FunctionNotSupportedException {
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, operator, value);
        String methodName = "addComplexPropertySearchCriteria";
        if (omrsPropertyName.equals("contactMethodValue")) {
            String contactMethodValue = ((PrimitivePropertyValue)value).getPrimitiveValue().toString();
            IGCSearchCondition condition = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", "email_address", operator, contactMethodValue);
            igcSearchConditionSet.addCondition(condition);
        } else if (omrsPropertyName.equals("contactMethodType") && value instanceof EnumPropertyValue) {
            EnumPropertyValue toMatch = (EnumPropertyValue)value;
            String igcPropertyToSearch = ContactMethodTypeMapper.getInstance(null).getIgcValueForSymbolicName(toMatch.getSymbolicName());
            IGCRepositoryHelper.validateEnumOperator(operator, "addComplexPropertySearchCriteria");
            IGCSearchCondition igcSearchCondition = null;
            if (igcPropertyToSearch == null) {
                if (!operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
                    igcSearchCondition = IGCRestConstants.getConditionToForceNoSearchResults();
                }
            } else {
                switch (operator) {
                    case IS_NULL: 
                    case NEQ: {
                        igcSearchCondition = new IGCSearchCondition(igcPropertyToSearch, "isNull", Boolean.valueOf(false));
                        break;
                    }
                    case NOT_NULL: 
                    case EQ: {
                        igcSearchCondition = new IGCSearchCondition(igcPropertyToSearch, "isNull", Boolean.valueOf(true));
                        break;
                    }
                }
            }
            if (igcSearchCondition != null) {
                igcSearchConditionSet.addCondition(igcSearchCondition);
            }
        }
    }

    private static class Singleton {
        private static final ContactDetailsMapper INSTANCE = new ContactDetailsMapper();

        private Singleton() {
        }
    }
}

