/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.SchemaElementMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.DataClassAssignmentMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class SchemaAttributeMapper
extends SchemaElementMapper {
    public static SchemaAttributeMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected SchemaAttributeMapper(String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName) {
        super(igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName, null);
        this.addSimplePropertyMapping("position", "position");
        this.addSimplePropertyMapping("type", "nativeClass");
        this.addSimplePropertyMapping("default_value", "defaultValueOverride");
        this.addSimplePropertyMapping("minimum_length", "minimumLength");
        this.addSimplePropertyMapping("length", "length");
        this.addSimplePropertyMapping("fraction", "significantDigits");
        this.addSimplePropertyMapping("allows_null_values", "isNullable");
        this.addLiteralPropertyMapping("maxCardinality", 1);
        this.addLiteralPropertyMapping("aliases", null);
        this.addLiteralPropertyMapping("sortOrder", null);
        this.addLiteralPropertyMapping("orderedValues", null);
        this.addComplexIgcProperty("allows_null_values");
        this.addComplexOmrsProperty("minCardinality");
        this.addComplexIgcProperty("unique");
        this.addComplexOmrsProperty("allowsDuplicateValues");
        this.addLiteralPropertyMapping("name", null);
        this.addLiteralPropertyMapping("cardinality", null);
        this.addRelationshipMapper(DataClassAssignmentMapper.getInstance(null));
    }

    @Override
    protected InstanceProperties complexPropertyMappings(EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        Boolean isUnique;
        instanceProperties = super.complexPropertyMappings(entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        Reference igcEntity = entityMap.getIgcEntity();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        Boolean allowsNulls = (Boolean)igcRestClient.getPropertyByName(igcEntity, "allows_null_values");
        if (allowsNulls != null) {
            instanceProperties = repositoryHelper.addIntPropertyToInstance(repositoryName, instanceProperties, "minCardinality", allowsNulls != false ? 0 : 1, "complexPropertyMappings");
        }
        if ((isUnique = (Boolean)igcRestClient.getPropertyByName(igcEntity, "unique")) != null) {
            instanceProperties = repositoryHelper.addBooleanPropertyToInstance(repositoryName, instanceProperties, "allowsDuplicateValues", isUnique == false, "complexPropertyMappings");
        }
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, PropertyComparisonOperator operator, InstancePropertyValue value) throws FunctionNotSupportedException {
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, operator, value);
        String methodName = "addComplexPropertySearchCriteria";
        if (omrsPropertyName.equals("minCardinality")) {
            Object minObj = ((PrimitivePropertyValue)value).getPrimitiveValue();
            int minCardinality = minObj == null ? -1 : (Integer)minObj;
            boolean optional = minCardinality <= 0;
            IGCRepositoryHelper.validateNumericOperator(operator, value.getTypeName(), "addComplexPropertySearchCriteria");
            IGCSearchCondition condition = null;
            switch (operator) {
                case IS_NULL: {
                    condition = new IGCSearchCondition("allows_null_values", "isNull", Boolean.valueOf(false));
                    break;
                }
                case NOT_NULL: {
                    condition = new IGCSearchCondition("allows_null_values", "isNull", Boolean.valueOf(true));
                    break;
                }
                case EQ: 
                case NEQ: {
                    condition = new IGCSearchCondition("allows_null_values", "=", optional ? "true" : "false");
                    break;
                }
                case GTE: {
                    condition = new IGCSearchCondition("allows_null_values", "=", minCardinality >= 1 ? "false" : "true");
                    break;
                }
                case GT: {
                    condition = new IGCSearchCondition("allows_null_values", "=", minCardinality > 0 ? "false" : "true");
                    break;
                }
                case LTE: {
                    condition = new IGCSearchCondition("allows_null_values", "=", minCardinality <= 0 ? "true" : "false");
                    break;
                }
                case LT: {
                    condition = new IGCSearchCondition("allows_null_values", "=", minCardinality < 1 ? "true" : "false");
                    break;
                }
            }
            if (condition != null) {
                igcSearchConditionSet.addCondition(condition);
            }
        } else if (omrsPropertyName.equals("allowsDuplicateValues")) {
            boolean allowsDuplicates = Boolean.parseBoolean(value.valueAsString());
            IGCRepositoryHelper.validateBooleanOperator(operator, "addComplexPropertySearchCriteria");
            IGCSearchCondition condition = null;
            switch (operator) {
                case IS_NULL: {
                    condition = new IGCSearchCondition("unique", "isNull", Boolean.valueOf(false));
                    break;
                }
                case NOT_NULL: {
                    condition = new IGCSearchCondition("unique", "isNull", Boolean.valueOf(true));
                    break;
                }
                case EQ: {
                    condition = new IGCSearchCondition("unique", "=", allowsDuplicates ? "false" : "true");
                    break;
                }
                case NEQ: {
                    condition = new IGCSearchCondition("unique", "=", allowsDuplicates ? "true" : "false");
                    break;
                }
            }
            if (condition != null) {
                igcSearchConditionSet.addCondition(condition);
            }
        }
    }

    private static class Singleton {
        private static final SchemaAttributeMapper INSTANCE = new SchemaAttributeMapper("__SUPERTYPE_WITH_NO_DIRECT_MAPPING__", "__SUPERTYPE_WITH_NO_DIRECT_MAPPING__", "SchemaAttribute");

        private Singleton() {
        }
    }
}

