/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.SchemaElementMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class SchemaTypeMapper
extends SchemaElementMapper {
    public static SchemaTypeMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected SchemaTypeMapper(String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName, String prefix) {
        super(igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName, prefix);
        this.addSimplePropertyMapping("long_description", "usage");
        this.addSimplePropertyMapping("modified_by", "author");
        this.addComplexOmrsProperty("namespace");
        this.addLiteralPropertyMapping("versionNumber", null);
        this.addLiteralPropertyMapping("encodingStandard", null);
    }

    @Override
    protected InstanceProperties complexPropertyMappings(EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        instanceProperties = super.complexPropertyMappings(entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        Reference igcEntity = entityMap.getIgcEntity();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        Identity identity = igcEntity.getIdentity(igcRestClient);
        Identity parent = identity.getParentIdentity();
        if (parent != null) {
            instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "namespace", parent.getName(), "complexPropertyMappings");
        }
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, PropertyComparisonOperator operator, InstancePropertyValue value) throws FunctionNotSupportedException {
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, operator, value);
        String methodName = "addComplexPropertySearchCriteria";
        if (omrsPropertyName.equals("namespace") && value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE)) {
            String name = value.valueAsString();
            this.addNamespaceCriteria(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", name, operator, igcSearchConditionSet);
        }
    }

    @Override
    public void addComplexStringSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String searchCriteria) throws FunctionNotSupportedException {
        super.addComplexStringSearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, searchCriteria);
        String methodName = "addComplexStringSearchCriteria";
        this.addNamespaceCriteria(repositoryHelper, repositoryName, "addComplexStringSearchCriteria", searchCriteria, PropertyComparisonOperator.LIKE, igcSearchConditionSet);
    }

    private void addNamespaceCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, String methodName, String toSearch, PropertyComparisonOperator operator, IGCSearchConditionSet igcSearchConditionSet) throws FunctionNotSupportedException {
        String parentPropertyName = this.getParentPropertyName() + ".name";
        IGCSearchCondition regex = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, methodName, parentPropertyName, operator, toSearch);
        igcSearchConditionSet.addCondition(regex);
    }

    private static class Singleton {
        private static final SchemaTypeMapper INSTANCE = new SchemaTypeMapper("__SUPERTYPE_WITH_NO_DIRECT_MAPPING__", "__SUPERTYPE_WITH_NO_DIRECT_MAPPING__", "SchemaType", null);

        private Singleton() {
        }
    }
}

