/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.InstanceMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.AttributeMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCRelationshipGuid;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationshipMapping
extends InstanceMapping {
    private static final Logger log = LoggerFactory.getLogger(RelationshipMapping.class);
    public static final String SELF_REFERENCE_SENTINEL = "__SELF__";
    private ProxyMapping one;
    private ProxyMapping two;
    private RelationshipLevelProxyMapping relationshipLevelPM = null;
    private String omrsRelationshipType;
    private OptimalStart optimalStart;
    private ContainedType containedType;
    private List<RelationshipMapping> subtypes;
    private String linkingAssetType;
    private Set<String> mappedOmrsPropertyNames;

    public String toString() {
        return "RelationshipMapping: omrsRelationshipType=" + this.omrsRelationshipType + ", one={ " + this.one + " }, two={ " + this.two + " }";
    }

    protected RelationshipMapping(String igcAssetTypeProxyOne, String igcAssetTypeProxyTwo, String igcRelationshipPropertyFromOne, String igcRelationshipPropertyFromTwo, String omrsRelationshipType, String omrsRelationshipProxyOneProperty, String omrsRelationshipProxyTwoProperty) {
        this(igcAssetTypeProxyOne, igcAssetTypeProxyTwo, igcRelationshipPropertyFromOne, igcRelationshipPropertyFromTwo, omrsRelationshipType, omrsRelationshipProxyOneProperty, omrsRelationshipProxyTwoProperty, null, null);
    }

    protected RelationshipMapping(String igcAssetTypeProxyOne, String igcAssetTypeProxyTwo, String igcRelationshipPropertyFromOne, String igcRelationshipPropertyFromTwo, String omrsRelationshipType, String omrsRelationshipProxyOneProperty, String omrsRelationshipProxyTwoProperty, String igcProxyOneRidPrefix, String igcProxyTwoRidPrefix) {
        this.one = new ProxyMapping(igcAssetTypeProxyOne, igcRelationshipPropertyFromOne, omrsRelationshipProxyOneProperty, igcProxyOneRidPrefix);
        this.two = new ProxyMapping(igcAssetTypeProxyTwo, igcRelationshipPropertyFromTwo, omrsRelationshipProxyTwoProperty, igcProxyTwoRidPrefix);
        this.omrsRelationshipType = omrsRelationshipType;
        this.optimalStart = OptimalStart.OPPOSITE;
        this.containedType = ContainedType.NONE;
        this.subtypes = new ArrayList<RelationshipMapping>();
        this.mappedOmrsPropertyNames = new HashSet<String>();
    }

    void addMappedOmrsProperty(String name) {
        if (name != null) {
            this.mappedOmrsPropertyNames.add(name);
        } else {
            log.warn("Attempted to add null property to mapping -- OMRS.");
        }
    }

    @Override
    public Set<String> getMappedOmrsPropertyNames() {
        HashSet<String> omrsProperties = new HashSet<String>();
        if (this.mappedOmrsPropertyNames != null) {
            omrsProperties.addAll(this.mappedOmrsPropertyNames);
        }
        omrsProperties.addAll(this.getLiteralPropertyMappings());
        return omrsProperties;
    }

    void setRelationshipLevelIgcAsset(String igcAssetType, String igcPropertyToOne, String igcPropertyToTwo) {
        this.relationshipLevelPM = new RelationshipLevelProxyMapping(igcAssetType, igcPropertyToOne, igcPropertyToTwo);
    }

    public boolean hasRelationshipLevelAsset() {
        return this.relationshipLevelPM != null;
    }

    public String getRelationshipLevelIgcAsset() {
        if (this.hasRelationshipLevelAsset()) {
            return this.relationshipLevelPM.getIgcAssetType();
        }
        return null;
    }

    void setLinkingAssetType(String igcAssetType) {
        this.linkingAssetType = igcAssetType;
    }

    public boolean hasLinkingAsset() {
        return this.linkingAssetType != null;
    }

    public String getLinkingAssetType() {
        return this.linkingAssetType;
    }

    public List<Reference> getProxyOneAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient) {
        ArrayList<Reference> referenceAsList = new ArrayList<Reference>();
        referenceAsList.add(relationshipAsset);
        return referenceAsList;
    }

    public List<Reference> getProxyTwoAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient) {
        ArrayList<Reference> referenceAsList = new ArrayList<Reference>();
        referenceAsList.add(relationshipAsset);
        return referenceAsList;
    }

    public static IGCEntityGuid getProxyOneGuidFromRelationship(IGCRepositoryHelper igcRepositoryHelper, IGCRelationshipGuid igcRelationshipGuid) {
        if (igcRelationshipGuid == null || igcRepositoryHelper == null) {
            return null;
        }
        return igcRepositoryHelper.getEntityGuid(igcRelationshipGuid.getAssetType1(), igcRelationshipGuid.getGeneratedPrefix1(), igcRelationshipGuid.getRid1());
    }

    public static IGCEntityGuid getProxyTwoGuidFromRelationship(IGCRepositoryHelper igcRepositoryHelper, IGCRelationshipGuid igcRelationshipGuid) {
        if (igcRelationshipGuid == null || igcRepositoryHelper == null) {
            return null;
        }
        return igcRepositoryHelper.getEntityGuid(igcRelationshipGuid.getAssetType2(), igcRelationshipGuid.getGeneratedPrefix2(), igcRelationshipGuid.getRid2());
    }

    public boolean hasSubTypes() {
        return !this.subtypes.isEmpty();
    }

    void addSubType(RelationshipMapping subRelationshipMapping) {
        this.subtypes.add(subRelationshipMapping);
    }

    public List<RelationshipMapping> getSubTypes() {
        return this.subtypes;
    }

    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
    }

    public boolean includeRelationshipForIgcObjects(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference oneObject, Reference otherObject) {
        return true;
    }

    public String getOmrsRelationshipType() {
        return this.omrsRelationshipType;
    }

    void setOptimalStart(OptimalStart optimalStart) {
        this.optimalStart = optimalStart;
    }

    private OptimalStart getOptimalStart() {
        return this.optimalStart;
    }

    public List<IGCSearch> getComplexIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, SearchProperties matchProperties) throws FunctionNotSupportedException {
        if (matchProperties == null || matchProperties.getConditions() == null || matchProperties.getConditions().size() == 0) {
            return this.getSimpleIGCSearchCriteria();
        }
        return this.buildDefaultComplexSearch(matchProperties);
    }

    public List<IGCSearch> getComplexIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, String searchCriteria) throws FunctionNotSupportedException {
        if (searchCriteria == null || searchCriteria.equals("")) {
            return this.getSimpleIGCSearchCriteria();
        }
        return this.buildDefaultComplexSearch(null);
    }

    private List<IGCSearch> buildDefaultComplexSearch(SearchProperties matchProperties) {
        ArrayList<IGCSearch> searches;
        if (matchProperties == null || this.getAllNoneOrSome(matchProperties).equals((Object)InstanceMapping.SearchFilter.NONE)) {
            searches = new ArrayList();
            ProxyMapping pm = this.getProxyTwoMapping();
            IGCSearch igcSearch = new IGCSearch(pm.getIgcAssetType());
            IGCSearchConditionSet conditions = new IGCSearchConditionSet(IGCRestConstants.getConditionToForceNoSearchResults());
            igcSearch.addConditions(conditions);
            searches.add(igcSearch);
        } else {
            searches = this.getSimpleIGCSearchCriteria();
        }
        return searches;
    }

    public List<IGCSearch> getSimpleIGCSearchCriteria() {
        ArrayList<IGCSearch> searches = new ArrayList<IGCSearch>();
        ProxyMapping pm = this.getProxyTwoMapping();
        IGCSearch igcSearch = new IGCSearch(pm.getIgcAssetType());
        List<String> relationshipProperties = pm.getRealIgcRelationshipProperties();
        if (!relationshipProperties.isEmpty()) {
            igcSearch.addProperties(relationshipProperties);
            IGCSearchConditionSet conditions = new IGCSearchConditionSet();
            for (String property : relationshipProperties) {
                IGCSearchCondition condition = new IGCSearchCondition(property, "isNull", Boolean.valueOf(true));
                conditions.addCondition(condition);
            }
            conditions.setMatchAnyCondition(true);
            igcSearch.addConditions(conditions);
        }
        searches.add(igcSearch);
        return searches;
    }

    void setContainedType(ContainedType containedType) {
        this.containedType = containedType;
    }

    public ContainedType getContainedType() {
        return this.containedType;
    }

    void addAlternativePropertyFromOne(String property) {
        this.one.addAlternativeIgcRelationshipProperty(property);
    }

    void addAlternativePropertyFromTwo(String property) {
        this.two.addAlternativeIgcRelationshipProperty(property);
    }

    public boolean isSelfReferencing() {
        return this.one.isSelfReferencing() || this.two.isSelfReferencing();
    }

    public RelationshipLevelProxyMapping getRelationshipLevelProxyMapping() {
        return this.relationshipLevelPM;
    }

    public ProxyMapping getProxyOneMapping() {
        return this.one;
    }

    public ProxyMapping getProxyTwoMapping() {
        return this.two;
    }

    public boolean sameTypeOnBothEnds() {
        return this.one.getIgcAssetType().equals(this.two.getIgcAssetType());
    }

    public boolean samePropertiesOnBothEnds() {
        List<String> pOneProperties = this.one.getIgcRelationshipProperties();
        List<String> pTwoProperties = this.two.getIgcRelationshipProperties();
        return new HashSet<String>(pOneProperties).equals(new HashSet<String>(pTwoProperties));
    }

    private ProxyMapping getProxyFromType(String igcAssetType) {
        ProxyMapping same = null;
        if (igcAssetType == null) {
            log.error("No asset type provided.");
        } else {
            String simpleType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
            if (simpleType.equals(this.one.getIgcAssetType())) {
                same = this.one;
            } else if (simpleType.equals(this.two.getIgcAssetType())) {
                same = this.two;
            } else if (this.one.getIgcAssetType().equals("main_object") && !this.one.excludeIgcAssetType.contains(simpleType)) {
                same = this.one;
            } else if (this.two.getIgcAssetType().equals("main_object") && !this.two.excludeIgcAssetType.contains(simpleType)) {
                same = this.two;
            } else {
                log.error("getProxyFromType - Provided asset type does not match either proxy type (or was explicitly excluded): {}", (Object)simpleType);
            }
        }
        return same;
    }

    private ProxyMapping getOtherProxyFromType(String igcAssetType) {
        ProxyMapping other = null;
        if (igcAssetType == null) {
            log.error("No asset type provided.");
        } else {
            String simpleType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
            if (simpleType.equals(this.one.getIgcAssetType())) {
                other = this.two;
            } else if (simpleType.equals(this.two.getIgcAssetType())) {
                other = this.one;
            } else if (this.one.getIgcAssetType().equals("main_object") && !this.one.excludeIgcAssetType.contains(simpleType)) {
                other = this.two;
            } else if (this.two.getIgcAssetType().equals("main_object") && !this.two.excludeIgcAssetType.contains(simpleType)) {
                other = this.one;
            } else {
                log.error("getOtherProxyFromType - Provided asset type does not match either proxy type (or was explicitly excluded): {}", (Object)simpleType);
            }
        }
        return other;
    }

    public List<String> getIgcRelationshipPropertiesForType(String igcAssetType) {
        TreeSet<String> properties = new TreeSet<String>();
        if (igcAssetType == null) {
            log.error("No asset type provided.");
        } else {
            String simpleType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
            if (this.sameTypeOnBothEnds() && simpleType.equals(this.one.getIgcAssetType())) {
                this.addRealPropertiesToSet(this.one.getIgcRelationshipProperties(), properties);
                this.addRealPropertiesToSet(this.two.getIgcRelationshipProperties(), properties);
            } else if (simpleType.equals(this.one.getIgcAssetType())) {
                this.addRealPropertiesToSet(this.one.getIgcRelationshipProperties(), properties);
            } else if (simpleType.equals(this.two.getIgcAssetType())) {
                this.addRealPropertiesToSet(this.two.getIgcRelationshipProperties(), properties);
            } else if (this.one.getIgcAssetType().equals("main_object") && !this.one.excludeIgcAssetType.contains(simpleType)) {
                this.addRealPropertiesToSet(this.one.getIgcRelationshipProperties(), properties);
            } else if (this.two.getIgcAssetType().equals("main_object") && !this.two.excludeIgcAssetType.contains(simpleType)) {
                this.addRealPropertiesToSet(this.two.getIgcRelationshipProperties(), properties);
            } else {
                log.warn("getIgcRelationshipPropertiesForType - Provided asset type does not match either proxy type (or was explicitly excluded): {}", (Object)simpleType);
            }
        }
        return new ArrayList<String>(properties);
    }

    public List<String> getDirectRelationshipPropertiesForType(String igcAssetType) {
        TreeSet<String> properties = new TreeSet<String>();
        if (igcAssetType == null) {
            log.error("No asset type provided.");
        } else {
            String simpleType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
            if (this.getOptimalStart().equals((Object)OptimalStart.ONE) && simpleType.equals(this.one.getIgcAssetType())) {
                this.addRealPropertiesToSet(this.one.getIgcRelationshipProperties(), properties);
            } else if (this.getOptimalStart().equals((Object)OptimalStart.TWO) && simpleType.equals(this.two.getIgcAssetType())) {
                this.addRealPropertiesToSet(this.two.getIgcRelationshipProperties(), properties);
            }
        }
        return new ArrayList<String>(properties);
    }

    private void addRealPropertiesToSet(List<String> candidates, Set<String> realProperties) {
        for (String propertyName : candidates) {
            if (propertyName.equals(SELF_REFERENCE_SENTINEL) || propertyName.equals("")) continue;
            realProperties.add(propertyName);
        }
    }

    public static IGCRelationshipGuid getRelationshipGUID(IGCRepositoryHelper igcRepositoryHelper, RelationshipMapping relationshipMapping, Reference endOne, Reference endTwo, String igcPropertyName, String relationshipLevelRid) {
        return RelationshipMapping.getRelationshipGUID(igcRepositoryHelper, relationshipMapping, endOne, endTwo, igcPropertyName, relationshipLevelRid, false);
    }

    public static IGCRelationshipGuid getRelationshipGUID(IGCRepositoryHelper igcRepositoryHelper, RelationshipMapping relationshipMapping, Reference endOne, Reference endTwo, String igcPropertyName, String relationshipLevelRid, boolean proxyOrderKnown) {
        String omrsRelationshipName = relationshipMapping.getOmrsRelationshipType();
        IGCRelationshipGuid igcRelationshipGuid = null;
        if (relationshipLevelRid != null) {
            log.debug("Calculating relationship GUID for relationship-level RID {} (with mapper: {})", (Object)relationshipLevelRid, (Object)relationshipMapping.getClass().getName());
            String relationshipLevelType = relationshipMapping.getRelationshipLevelIgcAsset();
            igcRelationshipGuid = igcRepositoryHelper.getRelationshipGuid(relationshipLevelType, relationshipLevelType, null, null, relationshipLevelRid, relationshipLevelRid, omrsRelationshipName);
        } else if (endOne != null && endTwo != null) {
            String endOneType = IGCRestConstants.getAssetTypeForSearch((String)endOne.getType());
            String endTwoType = IGCRestConstants.getAssetTypeForSearch((String)endTwo.getType());
            log.debug("Calculating relationship GUID from {} to {} via {} for {} (with mapper: {})", new Object[]{endOneType, endTwoType, igcPropertyName, omrsRelationshipName, relationshipMapping.getClass().getName()});
            String relationshipLevelType = null;
            if (relationshipMapping.hasRelationshipLevelAsset()) {
                relationshipLevelType = relationshipMapping.getRelationshipLevelIgcAsset();
                if (endOneType.equals(relationshipLevelType)) {
                    relationshipLevelRid = endOne.getId();
                } else if (endTwoType.equals(relationshipLevelType)) {
                    relationshipLevelRid = endTwo.getId();
                }
            }
            ProxyMapping pmOne = relationshipMapping.getProxyOneMapping();
            ProxyMapping pmTwo = relationshipMapping.getProxyTwoMapping();
            List<String> pmOneProperties = pmOne.getIgcRelationshipProperties();
            List<String> pmTwoProperties = pmTwo.getIgcRelationshipProperties();
            String proxyOneRid = null;
            String proxyTwoRid = null;
            if (proxyOrderKnown) {
                proxyOneRid = endOne.getId();
                proxyTwoRid = endTwo.getId();
            } else if (igcPropertyName != null && igcPropertyName.equals(SELF_REFERENCE_SENTINEL)) {
                proxyOneRid = endOne.getId();
                proxyTwoRid = endTwo.getId();
                if (pmOne.getIgcRidPrefix() == null && pmTwo.getIgcRidPrefix() == null) {
                    log.warn("Self-referencing relationship expected, but no prefix found for relationship {} from {} to {} via {}", new Object[]{omrsRelationshipName, proxyOneRid, proxyTwoRid, igcPropertyName});
                }
                if (!proxyOneRid.equals(proxyTwoRid)) {
                    log.warn("Self-referencing relationship expected for {}, but RIDs of ends do not match: {} and {}", new Object[]{omrsRelationshipName, proxyOneRid, proxyTwoRid});
                }
            } else if (relationshipMapping.sameTypeOnBothEnds() && pmOne.matchesAssetType(endOneType)) {
                if (relationshipMapping.samePropertiesOnBothEnds()) {
                    String endOneRid = endOne.getId();
                    String endTwoRid = endTwo.getId();
                    log.debug(" ... same types, same properties: alphabetically sorting RIDs.");
                    if (endOneRid.compareTo(endTwoRid) > 0) {
                        proxyOneRid = endOneRid;
                        proxyTwoRid = endTwoRid;
                    } else {
                        proxyOneRid = endTwoRid;
                        proxyTwoRid = endOneRid;
                    }
                } else if (relationshipMapping.getOptimalStart().equals((Object)OptimalStart.OPPOSITE)) {
                    if (pmOneProperties.contains(igcPropertyName)) {
                        log.debug(" ... same types, opposite lookup, property matches one: reversing RIDs.");
                        proxyOneRid = endTwo.getId();
                        proxyTwoRid = endOne.getId();
                    } else if (pmTwoProperties.contains(igcPropertyName)) {
                        log.debug(" ... same types, opposite lookup, property matches two: keeping RID direction.");
                        proxyOneRid = endOne.getId();
                        proxyTwoRid = endTwo.getId();
                    }
                } else if (pmOneProperties.contains(igcPropertyName)) {
                    log.debug(" ... same types, direct lookup, property matches one: keeping RID direction.");
                    proxyOneRid = endOne.getId();
                    proxyTwoRid = endTwo.getId();
                } else if (pmTwoProperties.contains(igcPropertyName)) {
                    log.debug(" ... same types, direct lookup, property matches two: reversing RIDs.");
                    proxyOneRid = endTwo.getId();
                    proxyTwoRid = endOne.getId();
                }
            } else if (pmOne.matchesAssetType(endOneType) && (pmOneProperties.contains(igcPropertyName) || pmTwoProperties.contains(igcPropertyName)) && pmTwo.matchesAssetType(endTwoType)) {
                log.debug(" ... one matches one, two matches two: keeping RID direction.");
                proxyOneRid = endOne.getId();
                proxyTwoRid = endTwo.getId();
            } else if (pmTwo.matchesAssetType(endOneType) && (pmOneProperties.contains(igcPropertyName) || pmTwoProperties.contains(igcPropertyName)) && pmOne.matchesAssetType(endTwoType)) {
                log.debug(" ... two matches one, one matches two: reversing RIDs.");
                proxyOneRid = endTwo.getId();
                proxyTwoRid = endOne.getId();
                String tempType = endOneType;
                endOneType = endTwoType;
                endTwoType = tempType;
            } else if (relationshipLevelRid == null) {
                log.error("Unable to find matching ends for relationship {} from {} to {} via {}", new Object[]{omrsRelationshipName, endOne.getId(), endTwo.getId(), igcPropertyName});
            }
            String proxyOnePrefix = pmOne.getIgcRidPrefix();
            String proxyTwoPrefix = pmTwo.getIgcRidPrefix();
            igcRelationshipGuid = relationshipLevelRid != null ? igcRepositoryHelper.getRelationshipGuid(relationshipLevelType, relationshipLevelType, null, null, relationshipLevelRid, relationshipLevelRid, omrsRelationshipName) : igcRepositoryHelper.getRelationshipGuid(endOneType, endTwoType, proxyOnePrefix, proxyTwoPrefix, proxyOneRid, proxyTwoRid, omrsRelationshipName);
        }
        return igcRelationshipGuid;
    }

    private static EntityProxy getEntityProxyForObject(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, Reference igcObj, String userId, String ridPrefix) {
        EntityProxy entityProxy;
        block10: {
            String methodName = "getEntityProxyForObject";
            IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
            String igcType = igcObj.getType();
            entityProxy = null;
            if (igcType != null) {
                IGCOMRSMetadataCollection igcomrsMetadataCollection;
                try {
                    igcomrsMetadataCollection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
                }
                catch (RepositoryErrorException e) {
                    throw new OMRSRuntimeException(IGCOMRSErrorCode.REST_CLIENT_FAILURE.getMessageDefinition(igcomrsRepositoryConnector.getServerName()), RelationshipMapping.class.getName(), "getEntityProxyForObject", (Throwable)e);
                }
                IGCRepositoryHelper igcRepositoryHelper = igcomrsMetadataCollection.getIgcRepositoryHelper();
                EntityMappingInstance entityMap = igcRepositoryHelper.getMappingInstanceForParameters(igcObj.getType(), igcObj.getId(), ridPrefix, userId);
                if (entityMap != null) {
                    String identity = igcObj.getIdentity(igcRestClient).toString();
                    if (ridPrefix != null) {
                        identity = IGCRepositoryHelper.getQualifiedNameForGeneratedEntity(ridPrefix, identity);
                    }
                    InstanceProperties uniqueProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), null, "qualifiedName", identity, "getEntityProxyForObject");
                    try {
                        entityProxy = igcomrsRepositoryConnector.getRepositoryHelper().getNewEntityProxy(igcomrsRepositoryConnector.getRepositoryName(), igcomrsRepositoryConnector.getMetadataCollectionId(), InstanceProvenanceType.LOCAL_COHORT, userId, entityMap.getMapping().getOmrsTypeDefName(), uniqueProperties, null);
                        IGCEntityGuid igcEntityGuid = ridPrefix != null ? igcRepositoryHelper.getEntityGuid(igcObj.getType(), ridPrefix, igcObj.getId()) : igcRepositoryHelper.getEntityGuid(igcObj.getType(), null, igcObj.getId());
                        entityProxy.setGUID(igcEntityGuid.toString());
                        if (!igcRestClient.hasModificationDetails(igcObj.getType())) break block10;
                        Reference withModDetails = igcRestClient.getModificationDetails(igcObj);
                        entityProxy.setCreatedBy(withModDetails.getCreatedBy());
                        entityProxy.setCreateTime(withModDetails.getCreatedOn());
                        entityProxy.setUpdatedBy(withModDetails.getModifiedBy());
                        entityProxy.setUpdateTime(withModDetails.getModifiedOn());
                        if (entityProxy.getUpdateTime() != null) {
                            entityProxy.setVersion(entityProxy.getUpdateTime().getTime());
                        }
                    }
                    catch (TypeErrorException e) {
                        log.error("Unable to create new EntityProxy.", (Throwable)e);
                    }
                } else {
                    log.error("Unable to find mapper for IGC object type '{}' with prefix '{}', cannot setup EntityProxy for {}", new Object[]{igcType, ridPrefix, igcObj.getId()});
                }
            } else {
                log.error("Unable to find type for provided IGC object: {}", (Object)igcObj);
            }
        }
        return entityProxy;
    }

    public static void getMappedRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, List<RelationshipMapping> mappings, String relationshipTypeGUID, Reference fromIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
        RelationshipMapping.getMappedRelationships(igcomrsRepositoryConnector, relationships, mappings, relationshipTypeGUID, fromIgcObject, null, fromRelationshipElement, sequencingOrder, pageSize, userId);
    }

    public static void getMappedRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, List<RelationshipMapping> mappings, String relationshipTypeGUID, Reference fromIgcObject, Reference toIgcObject, String userId) {
        RelationshipMapping.getMappedRelationships(igcomrsRepositoryConnector, relationships, mappings, relationshipTypeGUID, fromIgcObject, toIgcObject, 0, null, 100, userId);
    }

    public static void getMappedRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, List<RelationshipMapping> mappings, String relationshipTypeGUID, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
        for (RelationshipMapping mapping : mappings) {
            RelationshipDef omrsRelationshipDef = (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), mapping.getOmrsRelationshipType());
            if (relationshipTypeGUID != null && !relationshipTypeGUID.equals(omrsRelationshipDef.getGUID())) continue;
            OptimalStart optimalStart = mapping.getOptimalStart();
            String fromAssetType = fromIgcObject.getType();
            ProxyMapping pmOne = mapping.getProxyOneMapping();
            ProxyMapping pmTwo = mapping.getProxyTwoMapping();
            if (mapping.isSelfReferencing()) {
                if (mapping.includeRelationshipForIgcObjects(igcomrsRepositoryConnector, fromIgcObject, fromIgcObject)) {
                    RelationshipMapping.addSelfReferencingRelationship(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, userId);
                }
            } else if (!optimalStart.equals((Object)OptimalStart.CUSTOM)) {
                if (fromIgcObject.isFullyRetrieved() || optimalStart.equals((Object)OptimalStart.ONE) && pmOne.matchesAssetType(fromAssetType) || optimalStart.equals((Object)OptimalStart.TWO) && pmTwo.matchesAssetType(fromAssetType)) {
                    RelationshipMapping.addDirectRelationship(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, toIgcObject, fromRelationshipElement, sequencingOrder, pageSize, userId);
                } else if (optimalStart.equals((Object)OptimalStart.OPPOSITE) || optimalStart.equals((Object)OptimalStart.TWO) && pmOne.matchesAssetType(fromAssetType) || optimalStart.equals((Object)OptimalStart.ONE) && pmTwo.matchesAssetType(fromAssetType)) {
                    RelationshipMapping.addInvertedRelationship(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, toIgcObject, fromRelationshipElement, sequencingOrder, pageSize, userId);
                } else {
                    log.warn("Ran out of options for finding the relationship: {}", (Object)omrsRelationshipDef.getName());
                }
            }
            mapping.addMappedOMRSRelationships(igcomrsRepositoryConnector, relationships, fromIgcObject, toIgcObject, fromRelationshipElement, sequencingOrder, pageSize, userId);
        }
    }

    private static void addSelfReferencingRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, String userId) {
        try {
            Relationship relationship = RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, mapping, fromIgcObject, fromIgcObject, SELF_REFERENCE_SENTINEL, userId);
            log.debug("addSelfReferencingRelationship - adding relationship: {}", (Object)relationship.getGUID());
            relationships.add(relationship);
        }
        catch (RepositoryErrorException e) {
            log.error("Unable to add self-referencing relationship for: {} of type {}", new Object[]{fromIgcObject.getName(), fromIgcObject.getType(), e});
        }
    }

    private static void addDirectRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        if (toIgcObject != null) {
            RelationshipMapping.addSingleMappedRelationshipWithKnownOrder(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, toIgcObject, userId);
        } else {
            for (String igcRelationshipName : mapping.getIgcRelationshipPropertiesForType(fromIgcObject.getType())) {
                Object directRelationships = igcRestClient.getPropertyByName(fromIgcObject, igcRelationshipName);
                if (directRelationships instanceof Reference) {
                    Reference singleRelationship = (Reference)directRelationships;
                    if (!mapping.includeRelationshipForIgcObjects(igcomrsRepositoryConnector, fromIgcObject, singleRelationship)) continue;
                    RelationshipMapping.addSingleMappedRelationship(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, singleRelationship, igcRelationshipName, userId);
                    continue;
                }
                if (directRelationships instanceof ItemList) {
                    ItemList allRelationships = (ItemList)directRelationships;
                    List allPages = igcomrsRepositoryConnector.getIGCRestClient().getAllPages(igcRelationshipName, allRelationships);
                    allRelationships.setAllPages(allPages);
                    if (sequencingOrder != null) {
                        switch (sequencingOrder) {
                            case GUID: {
                                allRelationships.getItems().sort(Comparator.comparing(Reference::getId));
                                break;
                            }
                            case CREATION_DATE_OLDEST: {
                                allRelationships.getItems().sort(Comparator.comparing(Reference::getCreatedOn));
                                break;
                            }
                            case CREATION_DATE_RECENT: {
                                allRelationships.getItems().sort(Comparator.comparing(Reference::getCreatedOn).reversed());
                                break;
                            }
                            case LAST_UPDATE_OLDEST: {
                                allRelationships.getItems().sort(Comparator.comparing(Reference::getModifiedOn));
                                break;
                            }
                            case LAST_UPDATE_RECENT: {
                                allRelationships.getItems().sort(Comparator.comparing(Reference::getModifiedOn).reversed());
                                break;
                            }
                            default: {
                                log.warn("Sorting not implemented for the requested ordering: {}", (Object)sequencingOrder);
                            }
                        }
                    }
                    RelationshipMapping.addListOfMappedRelationships(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, (ItemList<Reference>)allRelationships, igcRelationshipName, fromRelationshipElement, pageSize, userId);
                    continue;
                }
                log.debug(" ... skipping relationship {}, either empty or neither reference or list: {}", (Object)igcRelationshipName, directRelationships);
            }
        }
    }

    private static void addInvertedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
        String assetType = fromIgcObject.getType();
        log.debug("Adding inverted relationship for mapping: {}", (Object)mapping.getClass().getCanonicalName());
        if (toIgcObject != null) {
            RelationshipMapping.addSingleMappedRelationshipWithKnownOrder(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, toIgcObject, userId);
        } else if (mapping.sameTypeOnBothEnds()) {
            List<String> igcProperties = mapping.getIgcRelationshipPropertiesForType(assetType);
            for (String igcRelationshipName : igcProperties) {
                IGCSearchCondition condition = new IGCSearchCondition(igcRelationshipName, "=", fromIgcObject.getId());
                IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(condition);
                RelationshipMapping.addSearchResultsToRelationships(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, igcSearchConditionSet, assetType, igcRelationshipName, fromRelationshipElement, sequencingOrder, pageSize, userId);
            }
        } else {
            ProxyMapping otherSide = mapping.getOtherProxyFromType(assetType);
            log.debug(" ... found other proxy: {} with prefix {}", (Object)(otherSide == null ? "(null)" : otherSide.getIgcAssetType()), (Object)(otherSide == null ? "(null)" : otherSide.getIgcRidPrefix()));
            ProxyMapping thisSide = mapping.getProxyFromType(assetType);
            log.debug(" ... found this proxy: {} with prefix {}", (Object)(thisSide == null ? "(null)" : thisSide.getIgcAssetType()), (Object)(thisSide == null ? "(null)" : thisSide.getIgcRidPrefix()));
            String anIgcRelationshipProperty = null;
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
            igcSearchConditionSet.setMatchAnyCondition(true);
            if (otherSide != null) {
                for (String igcRelationshipName : otherSide.getIgcRelationshipProperties()) {
                    IGCSearchCondition condition = new IGCSearchCondition(igcRelationshipName, "=", fromIgcObject.getId());
                    igcSearchConditionSet.addCondition(condition);
                    anIgcRelationshipProperty = igcRelationshipName;
                }
                String sourceAssetType = otherSide.getIgcAssetType();
                RelationshipMapping.addSearchResultsToRelationships(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, igcSearchConditionSet, sourceAssetType, anIgcRelationshipProperty, fromRelationshipElement, sequencingOrder, pageSize, userId);
            } else {
                log.error("Unable to determine other side of relationship -- cannot process inverted relationship.");
            }
        }
    }

    private static void addSearchResultsToRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, IGCSearchConditionSet igcSearchConditionSet, String assetType, String igcPropertyName, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) {
        IGCSearchSorting sorting;
        IGCSearch igcSearch = new IGCSearch(assetType, igcSearchConditionSet);
        if (!assetType.equals("main_object") && igcomrsRepositoryConnector.getIGCRestClient().hasModificationDetails(assetType)) {
            igcSearch.addProperties(IGCRestConstants.getModificationProperties());
        }
        if ((sorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder)) != null) {
            igcSearch.addSortingCriteria(sorting);
        }
        ItemList foundRelationships = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        RelationshipMapping.addListOfMappedRelationships(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, (ItemList<Reference>)foundRelationships, igcPropertyName, fromRelationshipElement, pageSize, userId);
    }

    private static void addListOfMappedRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, ItemList<Reference> igcRelationships, String igcPropertyName, int fromRelationshipElement, int pageSize, String userId) {
        log.debug(" ... list of references: {}", (Object)mapping.getOmrsRelationshipType());
        ArrayList<Relationship> localPage = new ArrayList<Relationship>();
        int totalPotentialResults = fromRelationshipElement + pageSize;
        if (pageSize == 0) {
            totalPotentialResults = igcRelationships.getPaging().getNumTotal();
        }
        for (Reference relation : igcRelationships.getItems()) {
            if (localPage.size() >= totalPotentialResults || !mapping.includeRelationshipForIgcObjects(igcomrsRepositoryConnector, fromIgcObject, relation)) continue;
            RelationshipMapping.addSingleMappedRelationship(igcomrsRepositoryConnector, mapping, localPage, fromIgcObject, relation, igcPropertyName, userId);
        }
        relationships.addAll(localPage);
        if (igcRelationships.hasMorePages() && localPage.size() < totalPotentialResults) {
            ItemList nextPage = igcomrsRepositoryConnector.getIGCRestClient().getNextPage(igcPropertyName, igcRelationships);
            RelationshipMapping.addListOfMappedRelationships(igcomrsRepositoryConnector, mapping, relationships, fromIgcObject, (ItemList<Reference>)nextPage, igcPropertyName, fromRelationshipElement, pageSize, userId);
        }
    }

    private static void addSingleMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference fromIgcObject, Reference igcRelationship, String igcPropertyName, String userId) {
        log.debug(" ... single reference: {} of type {}", (Object)igcRelationship.getName(), (Object)igcRelationship.getType());
        if (igcRelationship != null && igcRelationship.getType() != null && !igcRelationship.getType().equals("null")) {
            try {
                Relationship omrsRelationship = RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, mapping, fromIgcObject, igcRelationship, igcPropertyName, userId);
                log.debug("addSingleMappedRelationship - adding relationship: {}", (Object)omrsRelationship.getGUID());
                relationships.add(omrsRelationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to add relationship {} for object {}", new Object[]{mapping.getOmrsRelationshipType(), igcRelationship, e});
            }
        }
    }

    private static void addSingleMappedRelationshipWithKnownOrder(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, Reference proxyOne, Reference proxyTwo, String userId) {
        log.debug(" ... single reference: {} of type {}", (Object)proxyTwo.getName(), (Object)proxyTwo.getType());
        if (proxyTwo != null && proxyTwo.getType() != null && !proxyTwo.getType().equals("null")) {
            try {
                RelationshipDef omrsRelationshipDef = (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), mapping.getOmrsRelationshipType());
                Relationship omrsRelationship = RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, mapping, omrsRelationshipDef, proxyOne, proxyTwo, null, userId, null, true);
                log.debug("addSingleMappedRelationshipWithKnownOrder - adding relationship: {}", (Object)omrsRelationship.getGUID());
                relationships.add(omrsRelationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to add relationship {} for object {}", new Object[]{mapping.getOmrsRelationshipType(), proxyTwo, e});
            }
        }
    }

    private static Relationship getMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, Reference fromIgcObject, Reference relation, String igcPropertyName, String userId) throws RepositoryErrorException {
        RelationshipDef omrsRelationshipDef = (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), mapping.getOmrsRelationshipType());
        return RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, mapping, omrsRelationshipDef, fromIgcObject, relation, igcPropertyName, userId);
    }

    protected static Relationship getMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping relationshipMapping, RelationshipDef omrsRelationshipDef, Reference proxyOne, Reference proxyTwo, String igcPropertyName, String userId) throws RepositoryErrorException {
        return RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, relationshipMapping, omrsRelationshipDef, proxyOne, proxyTwo, igcPropertyName, userId, null);
    }

    public static Relationship getMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping relationshipMapping, RelationshipDef omrsRelationshipDef, Reference proxyOne, Reference proxyTwo, String igcPropertyName, String userId, String relationshipLevelRid) throws RepositoryErrorException {
        return RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, relationshipMapping, omrsRelationshipDef, proxyOne, proxyTwo, igcPropertyName, userId, relationshipLevelRid, false);
    }

    public static Relationship getMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping relationshipMapping, RelationshipDef omrsRelationshipDef, Reference proxyOne, Reference proxyTwo, String igcPropertyName, String userId, String relationshipLevelRid, boolean proxyOrderKnown) throws RepositoryErrorException {
        String methodName = "getMappedRelationship";
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCOMRSMetadataCollection igcomrsMetadataCollection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
        IGCRepositoryHelper igcRepositoryHelper = igcomrsMetadataCollection.getIgcRepositoryHelper();
        OMRSRepositoryHelper omrsRepositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String omrsRelationshipName = omrsRelationshipDef.getName();
        Relationship relationship = new Relationship();
        try {
            InstanceType instanceType = igcomrsRepositoryConnector.getRepositoryHelper().getNewInstanceType(igcomrsRepositoryConnector.getRepositoryName(), (TypeDefSummary)omrsRelationshipDef);
            relationship.setType(instanceType);
        }
        catch (TypeErrorException e) {
            log.error("Unable to construct and set InstanceType -- skipping relationship: {}", (Object)omrsRelationshipName);
            RelationshipMapping.raiseRepositoryErrorException(OMRSErrorCode.INVALID_INSTANCE, "getMappedRelationship", "getMappedRelationship", omrsRelationshipDef.getName());
        }
        IGCRelationshipGuid igcRelationshipGuid = RelationshipMapping.getRelationshipGUID(igcRepositoryHelper, relationshipMapping, proxyOne, proxyTwo, igcPropertyName, relationshipLevelRid, proxyOrderKnown);
        if (igcRelationshipGuid != null) {
            log.debug("Mapping relationship with GUID: {}", (Object)igcRelationshipGuid);
            relationship.setGUID(igcRelationshipGuid.toString());
            relationship.setMetadataCollectionId(igcomrsRepositoryConnector.getMetadataCollectionId());
            relationship.setStatus(InstanceStatus.ACTIVE);
            relationship.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
            String ridForEP1 = igcRelationshipGuid.getRid1();
            String ridForEP2 = igcRelationshipGuid.getRid2();
            EntityProxy ep1 = null;
            EntityProxy ep2 = null;
            if (relationshipLevelRid != null || ridForEP1.equals(proxyOne.getId()) && ridForEP2.equals(proxyTwo.getId())) {
                ep1 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, proxyOne, userId, relationshipMapping.getProxyOneMapping().getIgcRidPrefix());
                ep2 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, proxyTwo, userId, relationshipMapping.getProxyTwoMapping().getIgcRidPrefix());
            } else if (ridForEP2.equals(proxyOne.getId()) && ridForEP1.equals(proxyTwo.getId())) {
                ep1 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, proxyTwo, userId, relationshipMapping.getProxyOneMapping().getIgcRidPrefix());
                ep2 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, proxyOne, userId, relationshipMapping.getProxyTwoMapping().getIgcRidPrefix());
            } else {
                log.error("Unable to determine both ends of the relationship {} from {} to {}", new Object[]{omrsRelationshipName, proxyOne.getId(), proxyTwo.getId()});
                String omrsEndOneProperty = omrsRelationshipDef.getEndDef1().getAttributeName();
                String omrsEndTwoProperty = omrsRelationshipDef.getEndDef2().getAttributeName();
                RelationshipMapping.raiseRepositoryErrorException(OMRSErrorCode.INVALID_RELATIONSHIP_ENDS, "getMappedRelationship", "getMappedRelationship", repositoryName, omrsRelationshipName, omrsEndOneProperty, omrsEndTwoProperty);
            }
            if (ep1 != null && ep1.getUpdateTime() != null) {
                relationship.setVersion(ep1.getUpdateTime().getTime());
                relationship.setCreateTime(ep1.getUpdateTime());
                relationship.setCreatedBy(ep1.getCreatedBy());
                relationship.setUpdatedBy(ep1.getUpdatedBy());
                relationship.setUpdateTime(ep1.getUpdateTime());
            } else if (ep2 != null && ep2.getUpdateTime() != null) {
                relationship.setVersion(ep2.getUpdateTime().getTime());
                relationship.setCreateTime(ep2.getUpdateTime());
                relationship.setCreatedBy(ep2.getCreatedBy());
                relationship.setUpdatedBy(ep2.getUpdatedBy());
                relationship.setUpdateTime(ep2.getUpdateTime());
            }
            if (ep1 != null && ep2 != null) {
                relationship.setEntityOneProxy(ep1);
                relationship.setEntityTwoProxy(ep2);
            }
            Map<String, TypeDefAttribute> omrsAttributeMap = igcomrsMetadataCollection.getTypeDefAttributesForType(omrsRelationshipName);
            InstanceProperties relationshipProperties = new InstanceProperties();
            for (String omrsPropertyName : relationshipMapping.getLiteralPropertyMappings()) {
                Object value;
                if (!omrsAttributeMap.containsKey(omrsPropertyName) || (value = relationshipMapping.getOmrsPropertyLiteralValue(omrsPropertyName)) == null) continue;
                TypeDefAttribute typeDefAttribute = omrsAttributeMap.get(omrsPropertyName);
                AttributeTypeDefCategory attributeTypeDefCategory = typeDefAttribute.getAttributeType().getCategory();
                if (attributeTypeDefCategory == AttributeTypeDefCategory.PRIMITIVE) {
                    relationshipProperties = AttributeMapping.addPrimitivePropertyToInstance(omrsRepositoryHelper, repositoryName, relationshipProperties, typeDefAttribute, value, "getMappedRelationship");
                    continue;
                }
                relationshipProperties.setProperty(omrsPropertyName, (InstancePropertyValue)value);
            }
            relationship.setProperties(relationshipProperties);
        } else {
            log.error("Unable to construct relationship GUID -- skipping relationship: {}", (Object)omrsRelationshipName);
            String omrsEndOneProperty = omrsRelationshipDef.getEndDef1().getAttributeName();
            String omrsEndTwoProperty = omrsRelationshipDef.getEndDef2().getAttributeName();
            RelationshipMapping.raiseRepositoryErrorException(OMRSErrorCode.INVALID_RELATIONSHIP_ENDS, "getMappedRelationship", "getMappedRelationship", repositoryName, omrsRelationshipName, omrsEndOneProperty, omrsEndTwoProperty);
        }
        return relationship;
    }

    private static void raiseRepositoryErrorException(OMRSErrorCode errorCode, String methodName, String ... params) throws RepositoryErrorException {
        throw new RepositoryErrorException(errorCode.getMessageDefinition(params), RelationshipMapping.class.getName(), methodName);
    }

    public class RelationshipLevelProxyMapping {
        private String igcAssetType;
        private String igcRelationshipPropertyToEndOne;
        private String igcRelationshipPropertyToEndTwo;

        RelationshipLevelProxyMapping(String igcAssetType, String igcRelationshipPropertyToEndOne, String igcRelationshipPropertyToEndTwo) {
            this.igcAssetType = igcAssetType;
            this.igcRelationshipPropertyToEndOne = igcRelationshipPropertyToEndOne;
            this.igcRelationshipPropertyToEndTwo = igcRelationshipPropertyToEndTwo;
        }

        public String getIgcAssetType() {
            return this.igcAssetType;
        }

        public String getIgcRelationshipPropertyToEndOne() {
            return this.igcRelationshipPropertyToEndOne;
        }

        public String getIgcRelationshipPropertyToEndTwo() {
            return this.igcRelationshipPropertyToEndTwo;
        }
    }

    public class ProxyMapping {
        private String igcAssetType;
        private Set<String> igcRelationshipProperties;
        private String omrsRelationshipProperty;
        private String igcRidPrefix;
        private Set<String> excludeIgcAssetType;

        ProxyMapping(String igcAssetType, String igcRelationshipProperty, String omrsRelationshipProperty, String igcRidPrefix) {
            this.igcAssetType = igcAssetType;
            this.igcRelationshipProperties = new TreeSet<String>();
            if (igcRelationshipProperty != null) {
                this.igcRelationshipProperties.add(igcRelationshipProperty);
            }
            this.omrsRelationshipProperty = omrsRelationshipProperty;
            this.igcRidPrefix = igcRidPrefix;
            this.excludeIgcAssetType = new HashSet<String>();
        }

        public String getIgcAssetType() {
            return this.igcAssetType;
        }

        public List<String> getIgcRelationshipProperties() {
            return new ArrayList<String>(this.igcRelationshipProperties);
        }

        public List<String> getRealIgcRelationshipProperties() {
            ArrayList<String> realProperties = new ArrayList<String>();
            for (String property : this.getIgcRelationshipProperties()) {
                if (property.equals(RelationshipMapping.SELF_REFERENCE_SENTINEL)) continue;
                realProperties.add(property);
            }
            return realProperties;
        }

        void addAlternativeIgcRelationshipProperty(String igcRelationshipProperty) {
            if (igcRelationshipProperty != null) {
                this.igcRelationshipProperties.add(igcRelationshipProperty);
            } else {
                log.warn("Attempted to add null property to mapping -- IGC.");
            }
        }

        public String getIgcRidPrefix() {
            return this.igcRidPrefix;
        }

        boolean isSelfReferencing() {
            return this.igcRelationshipProperties.contains(RelationshipMapping.SELF_REFERENCE_SENTINEL);
        }

        void addExcludedIgcAssetType(String igcAssetType) {
            if (igcAssetType != null) {
                this.excludeIgcAssetType.add(igcAssetType);
            } else {
                log.warn("Attempted to add null type to mapping -- IGC.");
            }
        }

        public boolean matchesAssetType(String igcAssetType) {
            String simplifiedType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
            return this.igcAssetType.equals(simplifiedType) || this.igcAssetType.equals("main_object") && !this.excludeIgcAssetType.contains(simplifiedType) || RelationshipMapping.this.hasLinkingAsset() && simplifiedType.equals(RelationshipMapping.this.getLinkingAssetType());
        }

        public String toString() {
            return "igcAssetType=" + this.igcAssetType + ", omrsRelationshipProperty=" + this.omrsRelationshipProperty + ", igcRidPrefix=" + this.igcRidPrefix + ", igcRelationshipProperties=" + this.igcRelationshipProperties;
        }
    }

    public static enum ContainedType {
        ONE,
        TWO,
        NONE;

    }

    public static enum OptimalStart {
        ONE,
        TWO,
        OPPOSITE,
        CUSTOM;

    }
}

