/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes;

import java.util.HashMap;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.AttributeMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumMapping
extends AttributeMapping {
    private static final Logger log = LoggerFactory.getLogger(EnumMapping.class);
    private HashMap<String, EnumElementDef> enumDefByIgcValue = new HashMap();
    private HashMap<String, String> mapSymbolicNameToIgcValue = new HashMap();
    private EnumElementDef defaultEnum;

    public EnumMapping(String omrsAttributeTypeDefName) {
        super(omrsAttributeTypeDefName);
    }

    public void addDefaultEnumMapping(int omrsOrdinal, String omrsSymbolicName, String description) {
        this.defaultEnum = new EnumElementDef();
        this.defaultEnum.setOrdinal(omrsOrdinal);
        this.defaultEnum.setValue(omrsSymbolicName);
        this.defaultEnum.setDescription(description);
    }

    public void addEnumMapping(String igcValue, int omrsOrdinal, String omrsSymbolicName, String description) {
        EnumElementDef enumElementDef = new EnumElementDef();
        enumElementDef.setOrdinal(omrsOrdinal);
        enumElementDef.setValue(omrsSymbolicName);
        enumElementDef.setDescription(description);
        this.enumDefByIgcValue.put(igcValue, enumElementDef);
        this.mapSymbolicNameToIgcValue.put(omrsSymbolicName, igcValue);
    }

    public EnumPropertyValue getEnumMappingByIgcValue(String igcValue) {
        EnumPropertyValue value = new EnumPropertyValue();
        if (this.enumDefByIgcValue.containsKey(igcValue)) {
            EnumElementDef element = this.enumDefByIgcValue.get(igcValue);
            value.setOrdinal(element.getOrdinal());
            value.setSymbolicName(element.getValue());
            value.setDescription(element.getDescription());
        } else {
            value = this.getDefaultEnumValue();
        }
        return value;
    }

    public String getIgcValueForSymbolicName(String symbolicName) {
        return this.mapSymbolicNameToIgcValue.getOrDefault(symbolicName, null);
    }

    public EnumPropertyValue getDefaultEnumValue() {
        EnumPropertyValue value = new EnumPropertyValue();
        if (this.defaultEnum != null) {
            value.setOrdinal(this.defaultEnum.getOrdinal());
            value.setSymbolicName(this.defaultEnum.getValue());
            value.setDescription(this.defaultEnum.getDescription());
        } else {
            log.error("Could not find default enum value for {}.", (Object)this.getOmrsAttributeTypeDefName());
        }
        return value;
    }
}

