/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class GovernanceDefinitionMapper
extends ReferenceableMapper {
    public static GovernanceDefinitionMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected GovernanceDefinitionMapper(String igcAssetTypeName, String igcAssetTypeDisplayName, String omrsEntityTypeName) {
        super(igcAssetTypeName, igcAssetTypeDisplayName, omrsEntityTypeName);
        this.addSimplePropertyMapping("name", "title");
        this.addSimplePropertyMapping("short_description", "summary");
        this.addSimplePropertyMapping("long_description", "description");
        this.addComplexIgcProperty("parent_policy");
        this.addComplexOmrsProperty("domain");
        this.addLiteralPropertyMapping("scope", null);
        this.addLiteralPropertyMapping("priority", null);
        this.addLiteralPropertyMapping("implications", null);
        this.addLiteralPropertyMapping("outcomes", null);
        this.addLiteralPropertyMapping("results", null);
    }

    @Override
    protected InstanceProperties complexPropertyMappings(ObjectCache cache, EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        instanceProperties = super.complexPropertyMappings(cache, entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        Reference igcEntity = entityMap.getIgcEntity();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        Reference parentPolicy = (Reference)igcRestClient.getPropertyByName(igcEntity, "parent_policy");
        if (parentPolicy != null) {
            instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "domain", parentPolicy.getName(), "complexPropertyMappings");
        }
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, PropertyComparisonOperator operator, InstancePropertyValue value) throws FunctionNotSupportedException {
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, operator, value);
        String methodName = "addComplexPropertySearchCriteria";
        if (omrsPropertyName.equals("domain") && value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE)) {
            String domain = value.valueAsString();
            IGCSearchCondition condition = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", "parent_policy.name", operator, domain);
            igcSearchConditionSet.addCondition(condition);
        }
    }

    private static class Singleton {
        private static final GovernanceDefinitionMapper INSTANCE = new GovernanceDefinitionMapper("__SUPERTYPE_WITH_NO_DIRECT_MAPPING__", "__SUPERTYPE_WITH_NO_DIRECT_MAPPING__", "GovernanceDefinition");

        private Singleton() {
        }
    }
}

