/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.InstanceMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.AttachedNoteLogEntryMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class NoteEntryMapper
extends ReferenceableMapper {
    public static NoteEntryMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected NoteEntryMapper() {
        super("note", "Note", "NoteEntry", null, false, false);
        this.addSimplePropertyMapping("subject", "title");
        this.addSimplePropertyMapping("note", "text");
        this.addLiteralPropertyMapping("isPublic", true);
        this.addRelationshipMapper(AttachedNoteLogEntryMapper.getInstance(null));
    }

    @Override
    protected InstanceProperties complexPropertyMappings(ObjectCache cache, EntityMappingInstance entityMap, InstanceProperties instanceProperties) {
        instanceProperties = super.complexPropertyMappings(cache, entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        String qualifiedName = entityMap.getIgcEntityRid();
        instanceProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), instanceProperties, "qualifiedName", qualifiedName, "complexPropertyMappings");
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, PropertyComparisonOperator operator, InstancePropertyValue value) {
        igcSearchConditionSet.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
    }

    @Override
    public void addComplexStringSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String searchCriteria) throws FunctionNotSupportedException {
        igcSearchConditionSet.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
    }

    @Override
    public InstanceMapping.SearchFilter getAllNoneOrSome(IGCOMRSRepositoryConnector repositoryConnector, SearchProperties matchProperties) {
        return InstanceMapping.SearchFilter.NONE;
    }

    private static class Singleton {
        private static final NoteEntryMapper INSTANCE = new NoteEntryMapper();

        private Singleton() {
        }
    }
}

