/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.eventmapper.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonDiff;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCConnectivityException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCIOException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCParsingException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.OMRSStub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSet {
    private static final Logger log = LoggerFactory.getLogger(ChangeSet.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private IGCRestClient igcRestClient;
    private JsonNode patch;
    private HashMap<String, List<Change>> changesByProperty = new HashMap();

    public ChangeSet(IGCRestClient igcRestClient, Reference asset, OMRSStub stub) throws IGCConnectivityException, IGCParsingException, IGCIOException {
        this.igcRestClient = igcRestClient;
        boolean bNoStub = false;
        if (stub == null) {
            stub = new OMRSStub();
            stub.setPayload("{}");
            bNoStub = true;
        }
        try {
            JsonNode stubPayload = this.objectMapper.readTree(stub.getPayload());
            if (bNoStub) {
                log.debug("No existing stub -- calculating differences.");
                this.calculateDelta(asset, stubPayload);
            } else {
                long stubModified = stubPayload.path("modified_on").asLong(0L);
                if (stubModified == 0L) {
                    log.debug("No timestamp inside stub -- calculating differences.");
                    this.calculateDelta(asset, stubPayload);
                } else {
                    Date assetModified = (Date)this.igcRestClient.getPropertyByName(asset, "modified_on");
                    if (assetModified == null) {
                        log.debug("No timestamp inside asset -- calculating differences.");
                        this.calculateDelta(asset, stubPayload);
                    } else if (stubModified != assetModified.getTime()) {
                        log.debug("Modification timestamp of stub ({}) does not match asset ({}) -- calculating differences.", (Object)stubModified, (Object)assetModified.getTime());
                        this.calculateDelta(asset, stubPayload);
                    } else if (this.igcRestClient.getPagedRelationshipPropertiesForType(asset.getType()).contains("detected_classifications")) {
                        log.debug("Modification timestamps matched, but may be classifications -- calculating differences.");
                        this.calculateDelta(asset, stubPayload);
                    } else {
                        log.debug("Modification timestamps between stub and asset matched -- skipping change calculation.");
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Unable to parse JSON for diff operation: {}, {}", new Object[]{asset, stub, e});
        }
    }

    private void calculateDelta(Reference asset, JsonNode stubPayload) throws IOException, IGCParsingException {
        Object flags = DiffFlags.dontNormalizeOpIntoMoveAndCopy().clone();
        JsonNode currentAsset = this.objectMapper.readTree(this.igcRestClient.getValueAsJSON(asset));
        this.patch = JsonDiff.asJson((JsonNode)stubPayload, (JsonNode)currentAsset, (EnumSet)flags);
        log.debug("Found the following changes: {}", (Object)this.patch);
        ArrayNode changes = (ArrayNode)this.patch;
        for (int i = 0; i < changes.size(); ++i) {
            JsonNode consolidatedChange;
            JsonNode change = changes.get(i);
            String changePath = change.path("path").asText();
            Change theChange = null;
            if (changePath.contains("/items/")) {
                if (change.path("value").getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                    theChange = new Change(change, stubPayload);
                } else if (changePath.endsWith("_id")) {
                    consolidatedChange = this.consolidateChangedObject(change, changePath, currentAsset);
                    theChange = new Change(consolidatedChange, stubPayload);
                }
            } else if (!changePath.contains("/paging/")) {
                if (changePath.endsWith("/_id") && !changePath.equals("/_id")) {
                    log.debug("Found an exclusive relationship change: {}", (Object)change);
                    consolidatedChange = this.consolidateChangedObject(change, changePath, currentAsset);
                    log.debug(" ... consolidated to: {}", (Object)consolidatedChange);
                    theChange = new Change(consolidatedChange, stubPayload);
                } else {
                    theChange = new Change(change, stubPayload);
                }
            }
            if (theChange == null) continue;
            String igcProperty = theChange.getIgcPropertyName();
            if (!this.changesByProperty.containsKey(igcProperty)) {
                this.changesByProperty.put(igcProperty, new ArrayList());
            }
            this.changesByProperty.get(igcProperty).add(theChange);
        }
    }

    public Set<String> getChangedProperties() {
        return new TreeSet<String>(this.changesByProperty.keySet());
    }

    public List<Change> getChangesForProperty(String property) {
        return this.changesByProperty.get(property);
    }

    private JsonNode getObjectFromIndex(String objectPath, JsonNode asset) {
        log.debug(" ... retrieving object from index at path: {}", (Object)objectPath);
        if (objectPath.contains("/items")) {
            String arrayIndex = objectPath.substring(objectPath.lastIndexOf(47) + 1);
            String listPath = objectPath.substring(1, objectPath.indexOf("/items"));
            try {
                int idx = Integer.parseInt(arrayIndex);
                ArrayNode references = (ArrayNode)asset.path(listPath).path("items");
                return references.get(idx);
            }
            catch (NumberFormatException e) {
                log.warn("Unable to parse the numeric index from value -- returning null: {}", (Object)arrayIndex, (Object)e);
                return null;
            }
        }
        String relationshipPath = objectPath.substring(1);
        log.debug(" ... returning object: {}", (Object)asset.path(relationshipPath));
        return asset.path(relationshipPath);
    }

    private JsonNode consolidateChangedObject(JsonNode change, String changePath, JsonNode currentAsset) {
        ObjectNode consolidatedChange = (ObjectNode)change;
        String indexPath = changePath.substring(0, changePath.indexOf("/_id"));
        consolidatedChange.put("path", indexPath);
        JsonNode relatedAsset = this.getObjectFromIndex(indexPath, currentAsset);
        consolidatedChange.set("value", relatedAsset);
        return consolidatedChange;
    }

    public class Change {
        private JsonNode from;
        private String op;
        private String path;
        private JsonNode value;

        public Change(JsonNode patch, JsonNode from) {
            this.from = from;
            this.op = patch.get("op").asText();
            this.path = patch.get("path").asText();
            this.value = patch.get("value");
        }

        public String getOp() {
            return this.op;
        }

        public String getIgcPropertyName() {
            String[] aTokens = this.path.split("/");
            if (aTokens.length > 1) {
                return aTokens[1];
            }
            log.error("Unable to find any property in path: {}", (Object)this.path);
            return null;
        }

        public String getIgcPropertyPath() {
            return this.path;
        }

        public Object getNewValue(List<String> referenceListProperties) throws IGCParsingException {
            return this.getValueFromJSON(this.value, referenceListProperties, this.getIgcPropertyPath());
        }

        public Object getOldValue(List<String> referenceListProperties) throws IGCParsingException {
            Object oldValue = null;
            if (!this.getOp().equals("add")) {
                String propertyPath = this.getIgcPropertyPath();
                if (propertyPath.contains("/items/")) {
                    JsonNode obj = ChangeSet.this.getObjectFromIndex(propertyPath, this.from);
                    oldValue = this.getValueFromJSON(obj, referenceListProperties, propertyPath);
                } else {
                    String candidatePath = propertyPath;
                    if (candidatePath.startsWith("/")) {
                        candidatePath = candidatePath.substring(1);
                    }
                    oldValue = this.getValueFromJSON(this.from.path(candidatePath), referenceListProperties, propertyPath);
                }
            }
            return oldValue;
        }

        private Object getValueFromJSON(JsonNode node, List<String> referenceListProperties, String path) throws IGCParsingException {
            Object propertyValue = null;
            JsonNodeType jsonType = node.getNodeType();
            switch (jsonType) {
                case BOOLEAN: {
                    propertyValue = node.asBoolean();
                    break;
                }
                case NUMBER: {
                    propertyValue = node.asDouble();
                    break;
                }
                case OBJECT: {
                    if (referenceListProperties.contains(this.getIgcPropertyName()) && !path.contains("/items/")) {
                        propertyValue = ChangeSet.this.igcRestClient.readJSONIntoItemList(node.toString());
                        break;
                    }
                    propertyValue = ChangeSet.this.igcRestClient.readJSONIntoPOJO(node.toString());
                    break;
                }
                case STRING: {
                    propertyValue = node.asText();
                    break;
                }
                default: {
                    log.warn("Unhandled value type '{}': {}", (Object)jsonType, (Object)node);
                }
            }
            return propertyValue;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Change: {");
            sb.append(" op=");
            sb.append(this.op);
            sb.append(", path=");
            sb.append(this.path);
            sb.append(", value=");
            sb.append(this.value.toString());
            sb.append("}");
            return sb.toString();
        }
    }
}

