/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSAuditCode;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCConnectivityException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;

public class IGCOMRSRepositoryConnector
extends OMRSRepositoryConnector {
    protected IGCRestClient igcRestClient;
    protected IGCVersionEnum igcVersion;
    protected List<String> defaultZones = new ArrayList<String>();
    protected boolean ignoreUnmappedInstances = false;

    public OMRSMetadataCollection getMetadataCollection() throws RepositoryErrorException {
        String methodName = "getMetadataCollection";
        if (this.metadataCollection == null) {
            try {
                this.connectToIGC("getMetadataCollection");
            }
            catch (ConnectorCheckedException e) {
                this.raiseRepositoryErrorException(IGCOMRSErrorCode.REST_CLIENT_FAILURE, "getMetadataCollection", e, this.getServerName());
            }
        }
        return super.getMetadataCollection();
    }

    public synchronized void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.auditLog.logMessage("start", IGCOMRSAuditCode.REPOSITORY_SERVICE_STARTING.getMessageDefinition());
        if (this.metadataCollection == null) {
            this.connectToIGC("start");
        }
        this.auditLog.logMessage("start", IGCOMRSAuditCode.REPOSITORY_SERVICE_STARTED.getMessageDefinition(this.getServerName(), this.getIGCVersion().getVersionString()));
    }

    public IGCVersionEnum getIGCVersion() {
        return this.igcVersion;
    }

    public synchronized void disconnect() {
        block3: {
            String methodName = "disconnect";
            try {
                this.igcRestClient.disconnect();
            }
            catch (IGCConnectivityException e) {
                if (this.auditLog == null) break block3;
                this.auditLog.logException("disconnect", IGCOMRSAuditCode.FAILED_DISCONNECT.getMessageDefinition(), (Throwable)e);
            }
        }
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", IGCOMRSAuditCode.REPOSITORY_SERVICE_SHUTDOWN.getMessageDefinition(this.getServerName()));
        }
    }

    public IGCRestClient getIGCRestClient() {
        return this.igcRestClient;
    }

    public List<String> getDefaultZones() {
        return this.defaultZones;
    }

    public boolean ignoreUnmappedInstances() {
        return this.ignoreUnmappedInstances;
    }

    protected void connectToIGC(String methodName) throws ConnectorCheckedException {
        EndpointProperties endpointProperties = this.connectionProperties.getEndpoint();
        if (endpointProperties == null) {
            this.raiseConnectorCheckedException(IGCOMRSErrorCode.REST_CLIENT_FAILURE, methodName, null, "<null>");
        } else {
            String address = endpointProperties.getProtocol() + "://" + endpointProperties.getAddress();
            String igcUser = this.connectionProperties.getUserId();
            String igcPass = this.connectionProperties.getClearPassword();
            Map proxyProperties = this.connectionBean.getConfigurationProperties();
            if (proxyProperties != null) {
                Object ignore;
                Object zones = proxyProperties.get("defaultZones");
                if (zones instanceof List) {
                    for (Object zone : (List)zones) {
                        if (!(zone instanceof String)) continue;
                        this.defaultZones.add((String)zone);
                    }
                }
                if ((ignore = proxyProperties.get("ignoreUnmappedInstances")) instanceof Boolean) {
                    this.ignoreUnmappedInstances = (Boolean)ignore;
                }
            }
            boolean successfulInit = false;
            this.auditLog.logMessage(methodName, IGCOMRSAuditCode.CONNECTING_TO_IGC.getMessageDefinition(address));
            try {
                this.igcRestClient = new IGCRestClient(address, igcUser, igcPass);
                if (this.igcRestClient.start()) {
                    if (this.getMaxPageSize() > 0) {
                        this.igcRestClient.setDefaultPageSize(this.getMaxPageSize());
                    }
                    this.igcVersion = this.igcRestClient.getIgcVersion();
                    successfulInit = true;
                }
            }
            catch (Exception e) {
                this.raiseConnectorCheckedException(IGCOMRSErrorCode.REST_CLIENT_FAILURE, methodName, e, "<null>");
            }
            if (!successfulInit) {
                this.raiseConnectorCheckedException(IGCOMRSErrorCode.REST_CLIENT_FAILURE, methodName, null, "<null>");
            }
            this.auditLog.logMessage(methodName, IGCOMRSAuditCode.CONNECTED_TO_IGC.getMessageDefinition(address));
            this.metadataCollection = new IGCOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, this.metadataCollectionId);
        }
    }

    public boolean upsertOMRSBundleZip() throws RepositoryErrorException {
        String methodName = "upsertOMRSBundleZip";
        ClassPathResource bundleResource = new ClassPathResource("OMRS.zip");
        try {
            boolean success = this.igcRestClient.upsertOpenIgcBundle("OMRS", (AbstractResource)bundleResource);
            if (!success) {
                this.raiseRepositoryErrorException(IGCOMRSErrorCode.OMRS_BUNDLE_FAILURE, "upsertOMRSBundleZip", null, "open");
            }
            return success;
        }
        catch (IGCException e) {
            this.raiseRepositoryErrorException(IGCOMRSErrorCode.OMRS_BUNDLE_FAILURE, "upsertOMRSBundleZip", e, "open");
            return false;
        }
    }

    protected void raiseConnectorCheckedException(IGCOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws ConnectorCheckedException {
        if (cause == null) {
            throw new ConnectorCheckedException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new ConnectorCheckedException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName, cause);
    }

    protected void raiseRepositoryErrorException(IGCOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RepositoryErrorException {
        if (cause == null) {
            throw new RepositoryErrorException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new RepositoryErrorException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName, cause);
    }
}

