/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.Collections;
import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Category;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Term;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaMapper.class);

    public static SubjectAreaMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected SubjectAreaMapper() {
        super("category", "assigned_to_terms", "Referenceable", "SubjectArea");
        this.addMappedOmrsProperty("name");
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, ObjectCache cache, Reference fromIgcObject, String userId) throws RepositoryErrorException {
        ItemList assignedToTerms;
        String methodName = "addMappedOMRSClassifications";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        if (fromIgcObject instanceof Category && (assignedToTerms = ((Category)fromIgcObject).getAssignedToTerms()) != null) {
            List allAssignedToTerms = Collections.emptyList();
            try {
                allAssignedToTerms = igcRestClient.getAllPages("assigned_to_terms", assignedToTerms);
            }
            catch (IGCException e) {
                SubjectAreaMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "addMappedOMRSClassifications", (Exception)((Object)e), new String[0]);
            }
            log.debug("Looking for SubjectArea mapping within {} candidate terms.", (Object)allAssignedToTerms.size());
            boolean isSubjectArea = false;
            for (Term termCandidate : allAssignedToTerms) {
                if (!termCandidate.getName().equals(this.getOmrsClassificationType())) continue;
                isSubjectArea = true;
                break;
            }
            if (isSubjectArea) {
                log.debug(" ... found SubjectArea classification.");
                InstanceProperties classificationProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), null, "name", fromIgcObject.getName(), "addMappedOMRSClassifications");
                Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, classificationProperties, fromIgcObject, userId);
                classifications.add(classification);
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, SearchProperties matchProperties) throws FunctionNotSupportedException {
        String methodName = "getIGCSearchCriteria";
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("assigned_to_terms.name", "=", this.getOmrsClassificationType());
        IGCSearchConditionSet subjectArea = new IGCSearchConditionSet(igcSearchCondition);
        IGCSearchConditionSet byName = new IGCSearchConditionSet();
        if (matchProperties != null) {
            byName = this.getConditionsForProperties(matchProperties, repositoryHelper, repositoryName, "getIGCSearchCriteria");
        }
        if (byName.size() > 0) {
            igcSearchConditionSet.addNestedConditionSet(subjectArea);
            igcSearchConditionSet.addNestedConditionSet(byName);
            igcSearchConditionSet.setMatchAnyCondition(false);
            return igcSearchConditionSet;
        }
        return subjectArea;
    }

    private IGCSearchConditionSet getConditionsForProperties(SearchProperties matchProperties, OMRSRepositoryHelper repositoryHelper, String repositoryName, String methodName) throws FunctionNotSupportedException {
        IGCSearchConditionSet set = new IGCSearchConditionSet();
        List propertyConditions = matchProperties.getConditions();
        for (PropertyCondition condition : propertyConditions) {
            SearchProperties nestedProperties = condition.getNestedConditions();
            if (nestedProperties != null) {
                IGCSearchConditionSet nestedSet = this.getConditionsForProperties(nestedProperties, repositoryHelper, repositoryName, methodName);
                IGCRepositoryHelper.setConditionsFromMatchCriteria(nestedSet, nestedProperties.getMatchCriteria());
                set.addNestedConditionSet(nestedSet);
                continue;
            }
            String propertyName = condition.getProperty();
            PropertyComparisonOperator operator = condition.getOperator();
            if (propertyName.equals("name")) {
                if (!operator.equals((Object)PropertyComparisonOperator.LIKE) && !operator.equals((Object)PropertyComparisonOperator.EQ)) continue;
                IGCSearchCondition byName = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, methodName, "name", condition.getValue().valueAsString());
                set.addCondition(byName);
                continue;
            }
            set.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
        }
        IGCRepositoryHelper.setConditionsFromMatchCriteria(set, matchProperties.getMatchCriteria());
        return set;
    }

    private static class Singleton {
        private static final SubjectAreaMapper INSTANCE = new SubjectAreaMapper();

        private Singleton() {
        }
    }
}

