/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.SubjectAreaMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.CategoryAnchorMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.CategoryHierarchyLinkMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.SemanticAssignmentMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.TermCategorizationMapper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class GlossaryCategoryMapper
extends ReferenceableMapper {
    public static GlossaryCategoryMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected GlossaryCategoryMapper() {
        super("category", "Category", "GlossaryCategory");
        this.addSimplePropertyMapping("name", "displayName");
        this.addSimplePropertyMapping("short_description", "description");
        this.addRelationshipMapper(SemanticAssignmentMapper.getInstance(null));
        this.addRelationshipMapper(CategoryAnchorMapper.getInstance(null));
        this.addRelationshipMapper(CategoryHierarchyLinkMapper.getInstance(null));
        this.addRelationshipMapper(TermCategorizationMapper.getInstance(null));
        this.addClassificationMapper(SubjectAreaMapper.getInstance(null));
    }

    @Override
    public boolean isOmrsType(IGCRestClient igcRestClient, ObjectCache cache, Reference igcObject) throws RepositoryErrorException {
        String methodName = "isOmrsType";
        String assetType = IGCRestConstants.getAssetTypeForSearch((String)igcObject.getType());
        if (assetType.equals("category")) {
            try {
                Identity catIdentity = igcObject.getIdentity(igcRestClient, cache);
                Identity parentIdentity = catIdentity.getParentIdentity();
                if (parentIdentity != null) {
                    Identity ultimate = catIdentity.getUltimateParentIdentity();
                    return !ultimate.getName().equals("Classifications");
                }
            }
            catch (IGCException e) {
                GlossaryCategoryMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "isOmrsType", (Exception)((Object)e), new String[0]);
            }
        }
        return false;
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria() {
        IGCSearchCondition notRootLevel = new IGCSearchCondition("parent_category", "isNull", Boolean.valueOf(true));
        IGCSearchCondition notClassification = new IGCSearchCondition("category_path.name", "=", "Classifications", Boolean.valueOf(true));
        IGCSearchConditionSet conditions = new IGCSearchConditionSet(notRootLevel);
        conditions.addCondition(notClassification);
        conditions.setMatchAnyCondition(false);
        return conditions;
    }

    private static class Singleton {
        private static final GlossaryCategoryMapper INSTANCE = new GlossaryCategoryMapper();

        private Singleton() {
        }
    }
}

