/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.InstanceMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.AttributeMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCRelationshipGuid;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationshipMapping
extends InstanceMapping {
    private static final Logger log = LoggerFactory.getLogger(RelationshipMapping.class);
    public static final String SELF_REFERENCE_SENTINEL = "__SELF__";
    private ProxyMapping one;
    private ProxyMapping two;
    private RelationshipLevelProxyMapping relationshipLevelPM = null;
    private String omrsRelationshipType;
    private OptimalStart optimalStart;
    private ContainedType containedType;
    private List<RelationshipMapping> subtypes;
    private String linkingAssetType;
    private Set<String> mappedOmrsPropertyNames;

    public String toString() {
        return "RelationshipMapping: omrsRelationshipType=" + this.omrsRelationshipType + ", one={ " + this.one + " }, two={ " + this.two + " }";
    }

    protected RelationshipMapping(String igcAssetTypeProxyOne, String igcAssetTypeProxyTwo, String igcRelationshipPropertyFromOne, String igcRelationshipPropertyFromTwo, String omrsRelationshipType, String omrsRelationshipProxyOneProperty, String omrsRelationshipProxyTwoProperty) {
        this(igcAssetTypeProxyOne, igcAssetTypeProxyTwo, igcRelationshipPropertyFromOne, igcRelationshipPropertyFromTwo, omrsRelationshipType, omrsRelationshipProxyOneProperty, omrsRelationshipProxyTwoProperty, null, null);
    }

    protected RelationshipMapping(String igcAssetTypeProxyOne, String igcAssetTypeProxyTwo, String igcRelationshipPropertyFromOne, String igcRelationshipPropertyFromTwo, String omrsRelationshipType, String omrsRelationshipProxyOneProperty, String omrsRelationshipProxyTwoProperty, String igcProxyOneRidPrefix, String igcProxyTwoRidPrefix) {
        this.one = new ProxyMapping(igcAssetTypeProxyOne, igcRelationshipPropertyFromOne, omrsRelationshipProxyOneProperty, igcProxyOneRidPrefix);
        this.two = new ProxyMapping(igcAssetTypeProxyTwo, igcRelationshipPropertyFromTwo, omrsRelationshipProxyTwoProperty, igcProxyTwoRidPrefix);
        this.omrsRelationshipType = omrsRelationshipType;
        this.optimalStart = OptimalStart.OPPOSITE;
        this.containedType = ContainedType.NONE;
        this.subtypes = new ArrayList<RelationshipMapping>();
        this.mappedOmrsPropertyNames = new HashSet<String>();
    }

    void addMappedOmrsProperty(String name) {
        if (name != null) {
            this.mappedOmrsPropertyNames.add(name);
        } else {
            log.warn("Attempted to add null property to mapping -- OMRS.");
        }
    }

    @Override
    public Set<String> getMappedOmrsPropertyNames() {
        HashSet<String> omrsProperties = new HashSet<String>();
        if (this.mappedOmrsPropertyNames != null) {
            omrsProperties.addAll(this.mappedOmrsPropertyNames);
        }
        omrsProperties.addAll(this.getLiteralPropertyMappings());
        return omrsProperties;
    }

    void setRelationshipLevelIgcAsset(String igcAssetType, String igcPropertyToOne, String igcPropertyToTwo) {
        this.relationshipLevelPM = new RelationshipLevelProxyMapping(igcAssetType, igcPropertyToOne, igcPropertyToTwo);
    }

    public boolean hasRelationshipLevelAsset() {
        return this.relationshipLevelPM != null;
    }

    public String getRelationshipLevelIgcAsset() {
        if (this.hasRelationshipLevelAsset()) {
            return this.relationshipLevelPM.getIgcAssetType();
        }
        return null;
    }

    void setLinkingAssetType(String igcAssetType) {
        this.linkingAssetType = igcAssetType;
    }

    public boolean hasLinkingAsset() {
        return this.linkingAssetType != null;
    }

    public String getLinkingAssetType() {
        return this.linkingAssetType;
    }

    public List<Reference> getProxyOneAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient, ObjectCache cache) throws RepositoryErrorException {
        ArrayList<Reference> referenceAsList = new ArrayList<Reference>();
        referenceAsList.add(relationshipAsset);
        return referenceAsList;
    }

    public List<Reference> getProxyTwoAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient, ObjectCache cache) throws RepositoryErrorException {
        ArrayList<Reference> referenceAsList = new ArrayList<Reference>();
        referenceAsList.add(relationshipAsset);
        return referenceAsList;
    }

    public static IGCEntityGuid getProxyOneGuidFromRelationship(IGCRepositoryHelper igcRepositoryHelper, IGCRelationshipGuid igcRelationshipGuid) {
        if (igcRelationshipGuid == null || igcRepositoryHelper == null) {
            return null;
        }
        return igcRepositoryHelper.getEntityGuid(igcRelationshipGuid.getAssetType1(), igcRelationshipGuid.getGeneratedPrefix1(), igcRelationshipGuid.getRid1());
    }

    public static IGCEntityGuid getProxyTwoGuidFromRelationship(IGCRepositoryHelper igcRepositoryHelper, IGCRelationshipGuid igcRelationshipGuid) {
        if (igcRelationshipGuid == null || igcRepositoryHelper == null) {
            return null;
        }
        return igcRepositoryHelper.getEntityGuid(igcRelationshipGuid.getAssetType2(), igcRelationshipGuid.getGeneratedPrefix2(), igcRelationshipGuid.getRid2());
    }

    public boolean hasSubTypes() {
        return !this.subtypes.isEmpty();
    }

    void addSubType(RelationshipMapping subRelationshipMapping) {
        this.subtypes.add(subRelationshipMapping);
    }

    public List<RelationshipMapping> getSubTypes() {
        return this.subtypes;
    }

    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, ObjectCache cache, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) throws RepositoryErrorException {
    }

    public boolean includeRelationshipForIgcObjects(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, ObjectCache cache, Reference oneObject, Reference otherObject) throws RepositoryErrorException {
        return true;
    }

    public String getOmrsRelationshipType() {
        return this.omrsRelationshipType;
    }

    void setOptimalStart(OptimalStart optimalStart) {
        this.optimalStart = optimalStart;
    }

    private OptimalStart getOptimalStart() {
        return this.optimalStart;
    }

    public List<IGCSearch> getComplexIGCSearchCriteria(IGCOMRSRepositoryConnector repositoryConnector, SearchProperties matchProperties) throws FunctionNotSupportedException, RepositoryErrorException {
        if (matchProperties == null || matchProperties.getConditions() == null || matchProperties.getConditions().size() == 0) {
            return this.getSimpleIGCSearchCriteria();
        }
        return this.buildDefaultComplexSearch(repositoryConnector, matchProperties);
    }

    public List<IGCSearch> getComplexIGCSearchCriteria(IGCOMRSRepositoryConnector repositoryConnector, String searchCriteria) throws FunctionNotSupportedException {
        if (searchCriteria == null || searchCriteria.length() == 0) {
            return this.getSimpleIGCSearchCriteria();
        }
        return this.buildDefaultComplexSearch(repositoryConnector, null);
    }

    private List<IGCSearch> buildDefaultComplexSearch(IGCOMRSRepositoryConnector repositoryConnector, SearchProperties matchProperties) {
        ArrayList<IGCSearch> searches;
        if (matchProperties == null || this.getAllNoneOrSome(repositoryConnector, matchProperties).equals((Object)InstanceMapping.SearchFilter.NONE)) {
            searches = new ArrayList();
            ProxyMapping pm = this.getProxyTwoMapping();
            IGCSearch igcSearch = new IGCSearch(pm.getAllPossibleAssetTypes());
            IGCSearchConditionSet conditions = new IGCSearchConditionSet(IGCRestConstants.getConditionToForceNoSearchResults());
            igcSearch.addConditions(conditions);
            searches.add(igcSearch);
        } else {
            searches = this.getSimpleIGCSearchCriteria();
        }
        return searches;
    }

    public List<IGCSearch> getSimpleIGCSearchCriteria() {
        ArrayList<IGCSearch> searches = new ArrayList<IGCSearch>();
        ProxyMapping pm = this.getProxyTwoMapping();
        IGCSearch igcSearch = new IGCSearch(pm.getAllPossibleAssetTypes());
        List<String> relationshipProperties = pm.getRealIgcRelationshipProperties();
        if (!relationshipProperties.isEmpty()) {
            igcSearch.addProperties(relationshipProperties);
            IGCSearchConditionSet conditions = new IGCSearchConditionSet();
            for (String property : relationshipProperties) {
                IGCSearchCondition condition = new IGCSearchCondition(property, "isNull", Boolean.valueOf(true));
                conditions.addCondition(condition);
            }
            conditions.setMatchAnyCondition(true);
            igcSearch.addConditions(conditions);
        }
        searches.add(igcSearch);
        return searches;
    }

    void setContainedType(ContainedType containedType) {
        this.containedType = containedType;
    }

    public ContainedType getContainedType() {
        return this.containedType;
    }

    void addAlternativePropertyFromOne(String property) {
        this.one.addAlternativeIgcRelationshipProperty(property);
    }

    void addAlternativePropertyFromTwo(String property) {
        this.two.addAlternativeIgcRelationshipProperty(property);
    }

    public boolean isSelfReferencing() {
        return this.one.isSelfReferencing() || this.two.isSelfReferencing();
    }

    public RelationshipLevelProxyMapping getRelationshipLevelProxyMapping() {
        return this.relationshipLevelPM;
    }

    public ProxyMapping getProxyOneMapping() {
        return this.one;
    }

    public ProxyMapping getProxyTwoMapping() {
        return this.two;
    }

    public boolean sameTypeOnBothEnds() {
        return this.one.getAllPossibleAssetTypes().equals(this.two.getAllPossibleAssetTypes());
    }

    public boolean samePropertiesOnBothEnds() {
        List<String> pOneProperties = this.one.getIgcRelationshipProperties();
        List<String> pTwoProperties = this.two.getIgcRelationshipProperties();
        return new HashSet<String>(pOneProperties).equals(new HashSet<String>(pTwoProperties));
    }

    private ProxyMapping getProxyFromType(String igcAssetType) {
        ProxyMapping same = null;
        if (igcAssetType == null) {
            log.error("No asset type provided.");
        } else {
            String simpleType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
            if (this.one.matchesAssetType(simpleType)) {
                same = this.one;
            } else if (this.two.matchesAssetType(simpleType)) {
                same = this.two;
            } else {
                log.error("getProxyFromType - Provided asset type does not match either proxy type (or was explicitly excluded): {}", (Object)simpleType);
            }
        }
        return same;
    }

    private ProxyMapping getOtherProxyFromType(String igcAssetType) {
        ProxyMapping other = null;
        if (igcAssetType == null) {
            log.error("No asset type provided.");
        } else {
            String simpleType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
            if (this.one.matchesAssetType(simpleType)) {
                other = this.two;
            } else if (this.two.matchesAssetType(simpleType)) {
                other = this.one;
            } else {
                log.error("getOtherProxyFromType - Provided asset type does not match either proxy type (or was explicitly excluded): {}", (Object)simpleType);
            }
        }
        return other;
    }

    public List<String> getIgcRelationshipPropertiesForType(String igcAssetType) {
        TreeSet<String> properties = new TreeSet<String>();
        if (igcAssetType == null) {
            log.error("No asset type provided.");
        } else {
            String simpleType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
            if (this.sameTypeOnBothEnds() && this.one.matchesAssetType(simpleType)) {
                this.addRealPropertiesToSet(this.one.getIgcRelationshipProperties(), properties);
                this.addRealPropertiesToSet(this.two.getIgcRelationshipProperties(), properties);
            } else if (this.one.matchesAssetType(simpleType)) {
                this.addRealPropertiesToSet(this.one.getIgcRelationshipProperties(), properties);
            } else if (this.two.matchesAssetType(simpleType)) {
                this.addRealPropertiesToSet(this.two.getIgcRelationshipProperties(), properties);
            } else {
                log.warn("getIgcRelationshipPropertiesForType - Provided asset type does not match either proxy type (or was explicitly excluded): {}", (Object)simpleType);
            }
        }
        return new ArrayList<String>(properties);
    }

    public List<String> getDirectRelationshipPropertiesForType(String igcAssetType) {
        TreeSet<String> properties = new TreeSet<String>();
        if (igcAssetType == null) {
            log.error("No asset type provided.");
        } else {
            String simpleType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
            if (this.getOptimalStart().equals((Object)OptimalStart.ONE) && this.one.matchesAssetType(simpleType)) {
                this.addRealPropertiesToSet(this.one.getIgcRelationshipProperties(), properties);
            } else if (this.getOptimalStart().equals((Object)OptimalStart.TWO) && this.two.matchesAssetType(simpleType)) {
                this.addRealPropertiesToSet(this.two.getIgcRelationshipProperties(), properties);
            }
        }
        return new ArrayList<String>(properties);
    }

    private void addRealPropertiesToSet(List<String> candidates, Set<String> realProperties) {
        for (String propertyName : candidates) {
            if (propertyName.equals(SELF_REFERENCE_SENTINEL) || propertyName.length() == 0) continue;
            realProperties.add(propertyName);
        }
    }

    public static IGCRelationshipGuid getRelationshipGUID(IGCRepositoryHelper igcRepositoryHelper, RelationshipMapping relationshipMapping, Reference endOne, Reference endTwo, String igcPropertyName, String relationshipLevelRid) {
        return RelationshipMapping.getRelationshipGUID(igcRepositoryHelper, relationshipMapping, endOne, endTwo, igcPropertyName, relationshipLevelRid, false);
    }

    public static IGCRelationshipGuid getRelationshipGUID(IGCRepositoryHelper igcRepositoryHelper, RelationshipMapping relationshipMapping, Reference endOne, Reference endTwo, String igcPropertyName, String relationshipLevelRid, boolean proxyOrderKnown) {
        String omrsRelationshipName = relationshipMapping.getOmrsRelationshipType();
        IGCRelationshipGuid igcRelationshipGuid = null;
        if (relationshipLevelRid != null) {
            log.debug("Calculating relationship GUID for relationship-level RID {} (with mapper: {})", (Object)relationshipLevelRid, (Object)relationshipMapping.getClass().getName());
            String relationshipLevelType = relationshipMapping.getRelationshipLevelIgcAsset();
            igcRelationshipGuid = igcRepositoryHelper.getRelationshipGuid(relationshipLevelType, relationshipLevelType, null, null, relationshipLevelRid, relationshipLevelRid, omrsRelationshipName);
        } else if (endOne != null && endTwo != null) {
            String endOneType = IGCRestConstants.getAssetTypeForSearch((String)endOne.getType());
            String endTwoType = IGCRestConstants.getAssetTypeForSearch((String)endTwo.getType());
            log.debug("Calculating relationship GUID from {} to {} via {} for {} (with mapper: {})", new Object[]{endOneType, endTwoType, igcPropertyName, omrsRelationshipName, relationshipMapping.getClass().getName()});
            String relationshipLevelType = null;
            if (relationshipMapping.hasRelationshipLevelAsset()) {
                relationshipLevelType = relationshipMapping.getRelationshipLevelIgcAsset();
                if (endOneType.equals(relationshipLevelType)) {
                    relationshipLevelRid = endOne.getId();
                } else if (endTwoType.equals(relationshipLevelType)) {
                    relationshipLevelRid = endTwo.getId();
                }
            }
            ProxyMapping pmOne = relationshipMapping.getProxyOneMapping();
            ProxyMapping pmTwo = relationshipMapping.getProxyTwoMapping();
            List<String> pmOneProperties = pmOne.getIgcRelationshipProperties();
            List<String> pmTwoProperties = pmTwo.getIgcRelationshipProperties();
            String proxyOneRid = null;
            String proxyTwoRid = null;
            if (proxyOrderKnown) {
                proxyOneRid = endOne.getId();
                proxyTwoRid = endTwo.getId();
            } else if (igcPropertyName != null && igcPropertyName.equals(SELF_REFERENCE_SENTINEL)) {
                proxyOneRid = endOne.getId();
                proxyTwoRid = endTwo.getId();
                if (pmOne.getIgcRidPrefix() == null && pmTwo.getIgcRidPrefix() == null) {
                    log.warn("Self-referencing relationship expected, but no prefix found for relationship {} from {} to {} via {}", new Object[]{omrsRelationshipName, proxyOneRid, proxyTwoRid, igcPropertyName});
                }
                if (!proxyOneRid.equals(proxyTwoRid)) {
                    log.warn("Self-referencing relationship expected for {}, but RIDs of ends do not match: {} and {}", new Object[]{omrsRelationshipName, proxyOneRid, proxyTwoRid});
                }
            } else if (relationshipMapping.sameTypeOnBothEnds() && pmOne.matchesAssetType(endOneType)) {
                if (relationshipMapping.samePropertiesOnBothEnds()) {
                    String endOneRid = endOne.getId();
                    String endTwoRid = endTwo.getId();
                    log.debug(" ... same types, same properties: alphabetically sorting RIDs.");
                    if (endOneRid.compareTo(endTwoRid) > 0) {
                        proxyOneRid = endOneRid;
                        proxyTwoRid = endTwoRid;
                    } else {
                        proxyOneRid = endTwoRid;
                        proxyTwoRid = endOneRid;
                    }
                } else if (relationshipMapping.getOptimalStart().equals((Object)OptimalStart.OPPOSITE)) {
                    if (pmOneProperties.contains(igcPropertyName)) {
                        log.debug(" ... same types, opposite lookup, property matches one: reversing RIDs.");
                        proxyOneRid = endTwo.getId();
                        proxyTwoRid = endOne.getId();
                    } else if (pmTwoProperties.contains(igcPropertyName)) {
                        log.debug(" ... same types, opposite lookup, property matches two: keeping RID direction.");
                        proxyOneRid = endOne.getId();
                        proxyTwoRid = endTwo.getId();
                    }
                } else if (pmOneProperties.contains(igcPropertyName)) {
                    log.debug(" ... same types, direct lookup, property matches one: keeping RID direction.");
                    proxyOneRid = endOne.getId();
                    proxyTwoRid = endTwo.getId();
                } else if (pmTwoProperties.contains(igcPropertyName)) {
                    log.debug(" ... same types, direct lookup, property matches two: reversing RIDs.");
                    proxyOneRid = endTwo.getId();
                    proxyTwoRid = endOne.getId();
                }
            } else if (pmOne.matchesAssetType(endOneType) && (pmOneProperties.contains(igcPropertyName) || pmTwoProperties.contains(igcPropertyName)) && pmTwo.matchesAssetType(endTwoType)) {
                log.debug(" ... one matches one, two matches two: keeping RID direction.");
                proxyOneRid = endOne.getId();
                proxyTwoRid = endTwo.getId();
            } else if (pmTwo.matchesAssetType(endOneType) && (pmOneProperties.contains(igcPropertyName) || pmTwoProperties.contains(igcPropertyName)) && pmOne.matchesAssetType(endTwoType)) {
                log.debug(" ... two matches one, one matches two: reversing RIDs.");
                proxyOneRid = endTwo.getId();
                proxyTwoRid = endOne.getId();
                String tempType = endOneType;
                endOneType = endTwoType;
                endTwoType = tempType;
            } else if (relationshipLevelRid == null) {
                log.error("Unable to find matching ends for relationship {} from {} to {} via {}", new Object[]{omrsRelationshipName, endOne.getId(), endTwo.getId(), igcPropertyName});
            }
            String proxyOnePrefix = pmOne.getIgcRidPrefix();
            String proxyTwoPrefix = pmTwo.getIgcRidPrefix();
            if (relationshipLevelRid != null) {
                igcRelationshipGuid = igcRepositoryHelper.getRelationshipGuid(relationshipLevelType, relationshipLevelType, null, null, relationshipLevelRid, relationshipLevelRid, omrsRelationshipName);
            } else if (proxyOneRid != null && proxyTwoRid != null) {
                igcRelationshipGuid = igcRepositoryHelper.getRelationshipGuid(endOneType, endTwoType, proxyOnePrefix, proxyTwoPrefix, proxyOneRid, proxyTwoRid, omrsRelationshipName);
            } else {
                log.error("One or both ends of the relationship {} between {} and {} cannot be resolved -- skipping the relationship.", new Object[]{omrsRelationshipName, endOneType, endTwoType});
            }
        }
        return igcRelationshipGuid;
    }

    private static EntityProxy getEntityProxyForObject(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, ObjectCache cache, Reference igcObj, String userId, String ridPrefix) throws RepositoryErrorException {
        String methodName = "getEntityProxyForObject";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        String igcType = igcObj.getType();
        EntityProxy entityProxy = null;
        if (igcType != null) {
            IGCOMRSMetadataCollection igcomrsMetadataCollection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
            IGCRepositoryHelper igcRepositoryHelper = igcomrsMetadataCollection.getIgcRepositoryHelper();
            EntityMappingInstance entityMap = igcRepositoryHelper.getMappingInstanceForParameters(cache, igcObj.getType(), igcObj.getId(), ridPrefix, userId);
            if (entityMap != null) {
                try {
                    String identity = igcObj.getIdentity(igcRestClient, cache).toString();
                    if (ridPrefix != null) {
                        identity = IGCRepositoryHelper.getQualifiedNameForGeneratedEntity(ridPrefix, identity);
                    }
                    InstanceProperties uniqueProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), null, "qualifiedName", identity, "getEntityProxyForObject");
                    entityProxy = igcomrsRepositoryConnector.getRepositoryHelper().getNewEntityProxy(igcomrsRepositoryConnector.getRepositoryName(), igcomrsRepositoryConnector.getMetadataCollectionId(), InstanceProvenanceType.LOCAL_COHORT, userId, entityMap.getMapping().getOmrsTypeDefName(), uniqueProperties, null);
                    IGCEntityGuid igcEntityGuid = ridPrefix != null ? igcRepositoryHelper.getEntityGuid(igcObj.getType(), ridPrefix, igcObj.getId()) : igcRepositoryHelper.getEntityGuid(igcObj.getType(), null, igcObj.getId());
                    entityProxy.setGUID(igcEntityGuid.toString());
                    if (igcRestClient.hasModificationDetails(igcObj.getType())) {
                        Reference withModDetails = igcRestClient.getModificationDetails(igcObj, cache);
                        InstanceMapping.setupInstanceModDetails((InstanceAuditHeader)entityProxy, withModDetails.getCreatedBy(), withModDetails.getCreatedOn(), withModDetails.getModifiedBy(), withModDetails.getModifiedOn());
                    }
                }
                catch (TypeErrorException e) {
                    log.error("Unable to create new EntityProxy.", (Throwable)e);
                }
                catch (IGCException e) {
                    RelationshipMapping.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "getEntityProxyForObject", (Exception)((Object)e), new String[0]);
                }
            } else {
                log.error("Unable to find mapper for IGC object type '{}' with prefix '{}', cannot setup EntityProxy for {}", new Object[]{igcType, ridPrefix, igcObj.getId()});
            }
        } else {
            log.error("Unable to find type for provided IGC object: {}", (Object)igcObj);
        }
        return entityProxy;
    }

    public static void getMappedRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, List<RelationshipMapping> mappings, ObjectCache cache, String relationshipTypeGUID, Reference fromIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) throws RepositoryErrorException {
        RelationshipMapping.getMappedRelationships(igcomrsRepositoryConnector, relationships, mappings, cache, relationshipTypeGUID, fromIgcObject, null, fromRelationshipElement, sequencingOrder, pageSize, userId);
    }

    public static void getMappedRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, List<RelationshipMapping> mappings, ObjectCache cache, String relationshipTypeGUID, Reference fromIgcObject, Reference toIgcObject, String userId) throws RepositoryErrorException {
        RelationshipMapping.getMappedRelationships(igcomrsRepositoryConnector, relationships, mappings, cache, relationshipTypeGUID, fromIgcObject, toIgcObject, 0, null, 100, userId);
    }

    public static void getMappedRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, List<RelationshipMapping> mappings, ObjectCache cache, String relationshipTypeGUID, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) throws RepositoryErrorException {
        for (RelationshipMapping mapping : mappings) {
            RelationshipDef omrsRelationshipDef = (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), mapping.getOmrsRelationshipType());
            if (relationshipTypeGUID != null && !relationshipTypeGUID.equals(omrsRelationshipDef.getGUID())) continue;
            OptimalStart optimalStart = mapping.getOptimalStart();
            String fromAssetType = fromIgcObject.getType();
            ProxyMapping pmOne = mapping.getProxyOneMapping();
            ProxyMapping pmTwo = mapping.getProxyTwoMapping();
            if (mapping.isSelfReferencing()) {
                if (mapping.includeRelationshipForIgcObjects(igcomrsRepositoryConnector, cache, fromIgcObject, fromIgcObject)) {
                    RelationshipMapping.addSelfReferencingRelationship(igcomrsRepositoryConnector, mapping, relationships, cache, fromIgcObject, userId);
                }
            } else if (!optimalStart.equals((Object)OptimalStart.CUSTOM)) {
                if (fromIgcObject.isFullyRetrieved() || optimalStart.equals((Object)OptimalStart.ONE) && pmOne.matchesAssetType(fromAssetType) || optimalStart.equals((Object)OptimalStart.TWO) && pmTwo.matchesAssetType(fromAssetType)) {
                    RelationshipMapping.addDirectRelationship(igcomrsRepositoryConnector, mapping, relationships, cache, fromIgcObject, toIgcObject, fromRelationshipElement, sequencingOrder, pageSize, userId);
                } else if (optimalStart.equals((Object)OptimalStart.OPPOSITE) || optimalStart.equals((Object)OptimalStart.TWO) && pmOne.matchesAssetType(fromAssetType) || optimalStart.equals((Object)OptimalStart.ONE) && pmTwo.matchesAssetType(fromAssetType)) {
                    RelationshipMapping.addInvertedRelationship(igcomrsRepositoryConnector, mapping, relationships, cache, fromIgcObject, toIgcObject, fromRelationshipElement, sequencingOrder, pageSize, userId);
                } else {
                    log.warn("Ran out of options for finding the relationship: {}", (Object)omrsRelationshipDef.getName());
                }
            }
            mapping.addMappedOMRSRelationships(igcomrsRepositoryConnector, relationships, cache, fromIgcObject, toIgcObject, fromRelationshipElement, sequencingOrder, pageSize, userId);
        }
    }

    private static void addSelfReferencingRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, ObjectCache cache, Reference fromIgcObject, String userId) {
        try {
            Relationship relationship = RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, mapping, cache, fromIgcObject, fromIgcObject, SELF_REFERENCE_SENTINEL, userId);
            log.debug("addSelfReferencingRelationship - adding relationship: {}", (Object)relationship.getGUID());
            relationships.add(relationship);
        }
        catch (RepositoryErrorException e) {
            log.error("Unable to add self-referencing relationship for: {} of type {}", new Object[]{fromIgcObject.getName(), fromIgcObject.getType(), e});
        }
    }

    private static void addDirectRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, ObjectCache cache, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) throws RepositoryErrorException {
        String methodName = "addDirectRelationship";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        if (toIgcObject != null) {
            RelationshipMapping.addSingleMappedRelationshipWithKnownOrder(igcomrsRepositoryConnector, mapping, relationships, cache, fromIgcObject, toIgcObject, userId);
        } else {
            for (String igcRelationshipName : mapping.getIgcRelationshipPropertiesForType(fromIgcObject.getType())) {
                try {
                    Object directRelationships = igcRestClient.getPropertyByName(fromIgcObject, igcRelationshipName);
                    if (directRelationships instanceof Reference) {
                        Reference singleRelationship = (Reference)directRelationships;
                        if (!mapping.includeRelationshipForIgcObjects(igcomrsRepositoryConnector, cache, fromIgcObject, singleRelationship)) continue;
                        RelationshipMapping.addSingleMappedRelationship(igcomrsRepositoryConnector, mapping, relationships, cache, fromIgcObject, singleRelationship, igcRelationshipName, userId);
                        continue;
                    }
                    if (directRelationships instanceof ItemList) {
                        ItemList allRelationships = (ItemList)directRelationships;
                        List allPages = igcomrsRepositoryConnector.getIGCRestClient().getAllPages(igcRelationshipName, allRelationships);
                        allRelationships.setAllPages(allPages);
                        if (sequencingOrder != null) {
                            switch (sequencingOrder) {
                                case GUID: {
                                    allRelationships.getItems().sort(Comparator.comparing(Reference::getId));
                                    break;
                                }
                                case CREATION_DATE_OLDEST: {
                                    allRelationships.getItems().sort(Comparator.comparing(Reference::getCreatedOn));
                                    break;
                                }
                                case CREATION_DATE_RECENT: {
                                    allRelationships.getItems().sort(Comparator.comparing(Reference::getCreatedOn).reversed());
                                    break;
                                }
                                case LAST_UPDATE_OLDEST: {
                                    allRelationships.getItems().sort(Comparator.comparing(Reference::getModifiedOn));
                                    break;
                                }
                                case LAST_UPDATE_RECENT: {
                                    allRelationships.getItems().sort(Comparator.comparing(Reference::getModifiedOn).reversed());
                                    break;
                                }
                                default: {
                                    log.warn("Sorting not implemented for the requested ordering: {}", (Object)sequencingOrder);
                                }
                            }
                        }
                        RelationshipMapping.addListOfMappedRelationships(igcomrsRepositoryConnector, mapping, relationships, cache, fromIgcObject, (ItemList<Reference>)allRelationships, igcRelationshipName, fromRelationshipElement, pageSize, userId);
                        continue;
                    }
                    log.debug(" ... skipping relationship {}, either empty or neither reference or list: {}", (Object)igcRelationshipName, directRelationships);
                }
                catch (IGCException e) {
                    RelationshipMapping.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "addDirectRelationship", (Exception)((Object)e), new String[0]);
                }
            }
        }
    }

    private static void addInvertedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, ObjectCache cache, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) throws RepositoryErrorException {
        String assetType = fromIgcObject.getType();
        log.debug("Adding inverted relationship for mapping: {}", (Object)mapping.getClass().getCanonicalName());
        if (toIgcObject != null) {
            RelationshipMapping.addSingleMappedRelationshipWithKnownOrder(igcomrsRepositoryConnector, mapping, relationships, cache, fromIgcObject, toIgcObject, userId);
        } else if (mapping.sameTypeOnBothEnds()) {
            List<String> igcProperties = mapping.getIgcRelationshipPropertiesForType(assetType);
            for (String igcRelationshipName : igcProperties) {
                IGCSearchCondition condition = new IGCSearchCondition(igcRelationshipName, "=", fromIgcObject.getId());
                IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(condition);
                ArrayList<String> typesList = new ArrayList<String>();
                typesList.add(assetType);
                RelationshipMapping.addSearchResultsToRelationships(igcomrsRepositoryConnector, mapping, relationships, cache, fromIgcObject, igcSearchConditionSet, typesList, igcRelationshipName, fromRelationshipElement, sequencingOrder, pageSize, userId);
            }
        } else {
            ProxyMapping otherSide = mapping.getOtherProxyFromType(assetType);
            log.debug(" ... found other proxy: {} with prefix {}", otherSide == null ? "(null)" : otherSide.getAllPossibleAssetTypes(), (Object)(otherSide == null ? "(null)" : otherSide.getIgcRidPrefix()));
            ProxyMapping thisSide = mapping.getProxyFromType(assetType);
            log.debug(" ... found this proxy: {} with prefix {}", thisSide == null ? "(null)" : thisSide.getAllPossibleAssetTypes(), (Object)(thisSide == null ? "(null)" : thisSide.getIgcRidPrefix()));
            String anIgcRelationshipProperty = null;
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
            igcSearchConditionSet.setMatchAnyCondition(true);
            if (otherSide != null) {
                for (String igcRelationshipName : otherSide.getIgcRelationshipProperties()) {
                    IGCSearchCondition condition = new IGCSearchCondition(igcRelationshipName, "=", fromIgcObject.getId());
                    igcSearchConditionSet.addCondition(condition);
                    anIgcRelationshipProperty = igcRelationshipName;
                }
                List<String> sourceAssetTypes = otherSide.getAllPossibleAssetTypes();
                RelationshipMapping.addSearchResultsToRelationships(igcomrsRepositoryConnector, mapping, relationships, cache, fromIgcObject, igcSearchConditionSet, sourceAssetTypes, anIgcRelationshipProperty, fromRelationshipElement, sequencingOrder, pageSize, userId);
            } else {
                log.error("Unable to determine other side of relationship -- cannot process inverted relationship.");
            }
        }
    }

    private static void addSearchResultsToRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, ObjectCache cache, Reference fromIgcObject, IGCSearchConditionSet igcSearchConditionSet, List<String> assetTypes, String igcPropertyName, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) throws RepositoryErrorException {
        String methodName = "addSearchResultsToRelationships";
        IGCSearch igcSearch = new IGCSearch(assetTypes, igcSearchConditionSet);
        try {
            IGCSearchSorting sorting;
            boolean allHaveModDetails = true;
            for (String assetType : assetTypes) {
                allHaveModDetails = igcomrsRepositoryConnector.getIGCRestClient().hasModificationDetails(assetType);
                if (allHaveModDetails) continue;
                break;
            }
            if (allHaveModDetails) {
                igcSearch.addProperties(IGCRestConstants.getModificationProperties());
            }
            if ((sorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder)) != null) {
                igcSearch.addSortingCriteria(sorting);
            }
            ItemList foundRelationships = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
            RelationshipMapping.addListOfMappedRelationships(igcomrsRepositoryConnector, mapping, relationships, cache, fromIgcObject, (ItemList<Reference>)foundRelationships, igcPropertyName, fromRelationshipElement, pageSize, userId);
        }
        catch (IGCException e) {
            RelationshipMapping.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "addSearchResultsToRelationships", (Exception)((Object)e), new String[0]);
        }
    }

    private static void addListOfMappedRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, ObjectCache cache, Reference fromIgcObject, ItemList<Reference> igcRelationships, String igcPropertyName, int fromRelationshipElement, int pageSize, String userId) throws RepositoryErrorException {
        String methodName = "addListOfMappedRelationships";
        log.debug(" ... list of references: {}", (Object)mapping.getOmrsRelationshipType());
        ArrayList<Relationship> localPage = new ArrayList<Relationship>();
        int totalPotentialResults = fromRelationshipElement + pageSize;
        if (pageSize == 0) {
            totalPotentialResults = igcRelationships.getPaging().getNumTotal();
        }
        for (Reference relation : igcRelationships.getItems()) {
            if (localPage.size() >= totalPotentialResults || !mapping.includeRelationshipForIgcObjects(igcomrsRepositoryConnector, cache, fromIgcObject, relation)) continue;
            RelationshipMapping.addSingleMappedRelationship(igcomrsRepositoryConnector, mapping, localPage, cache, fromIgcObject, relation, igcPropertyName, userId);
        }
        relationships.addAll(localPage);
        if (igcRelationships.hasMorePages() && localPage.size() < totalPotentialResults) {
            try {
                ItemList nextPage = igcomrsRepositoryConnector.getIGCRestClient().getNextPage(igcPropertyName, igcRelationships);
                RelationshipMapping.addListOfMappedRelationships(igcomrsRepositoryConnector, mapping, relationships, cache, fromIgcObject, (ItemList<Reference>)nextPage, igcPropertyName, fromRelationshipElement, pageSize, userId);
            }
            catch (IGCException e) {
                RelationshipMapping.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "addListOfMappedRelationships", (Exception)((Object)e), new String[0]);
            }
        }
    }

    private static void addSingleMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, ObjectCache cache, Reference fromIgcObject, Reference igcRelationship, String igcPropertyName, String userId) {
        if (igcRelationship != null && igcRelationship.getType() != null && !igcRelationship.getType().equals("null")) {
            log.debug(" ... single reference: {} of type {}", (Object)igcRelationship.getName(), (Object)igcRelationship.getType());
            try {
                Relationship omrsRelationship = RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, mapping, cache, fromIgcObject, igcRelationship, igcPropertyName, userId);
                log.debug("addSingleMappedRelationship - adding relationship: {}", (Object)omrsRelationship.getGUID());
                relationships.add(omrsRelationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to add relationship {} for object {}", new Object[]{mapping.getOmrsRelationshipType(), igcRelationship, e});
            }
        } else {
            log.debug(" ... skipping null relationship.");
        }
    }

    private static void addSingleMappedRelationshipWithKnownOrder(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, List<Relationship> relationships, ObjectCache cache, Reference proxyOne, Reference proxyTwo, String userId) {
        if (proxyTwo != null && proxyTwo.getType() != null && !proxyTwo.getType().equals("null")) {
            log.debug(" ... single reference: {} of type {}", (Object)proxyTwo.getName(), (Object)proxyTwo.getType());
            try {
                RelationshipDef omrsRelationshipDef = (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), mapping.getOmrsRelationshipType());
                Relationship omrsRelationship = RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, mapping, omrsRelationshipDef, cache, proxyOne, proxyTwo, null, userId, null, true);
                log.debug("addSingleMappedRelationshipWithKnownOrder - adding relationship: {}", (Object)omrsRelationship.getGUID());
                relationships.add(omrsRelationship);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to add relationship {} for object {}", new Object[]{mapping.getOmrsRelationshipType(), proxyTwo, e});
            }
        } else {
            log.debug(" ... skipping null relationship.");
        }
    }

    private static Relationship getMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping mapping, ObjectCache cache, Reference fromIgcObject, Reference relation, String igcPropertyName, String userId) throws RepositoryErrorException {
        RelationshipDef omrsRelationshipDef = (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), mapping.getOmrsRelationshipType());
        return RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, mapping, omrsRelationshipDef, cache, fromIgcObject, relation, igcPropertyName, userId);
    }

    protected static Relationship getMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping relationshipMapping, RelationshipDef omrsRelationshipDef, ObjectCache cache, Reference proxyOne, Reference proxyTwo, String igcPropertyName, String userId) throws RepositoryErrorException {
        return RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, relationshipMapping, omrsRelationshipDef, cache, proxyOne, proxyTwo, igcPropertyName, userId, null);
    }

    public static Relationship getMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping relationshipMapping, RelationshipDef omrsRelationshipDef, ObjectCache cache, Reference proxyOne, Reference proxyTwo, String igcPropertyName, String userId, String relationshipLevelRid) throws RepositoryErrorException {
        return RelationshipMapping.getMappedRelationship(igcomrsRepositoryConnector, relationshipMapping, omrsRelationshipDef, cache, proxyOne, proxyTwo, igcPropertyName, userId, relationshipLevelRid, false);
    }

    public static Relationship getMappedRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, RelationshipMapping relationshipMapping, RelationshipDef omrsRelationshipDef, ObjectCache cache, Reference proxyOne, Reference proxyTwo, String igcPropertyName, String userId, String relationshipLevelRid, boolean proxyOrderKnown) throws RepositoryErrorException {
        String methodName = "getMappedRelationship";
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCOMRSMetadataCollection igcomrsMetadataCollection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
        IGCRepositoryHelper igcRepositoryHelper = igcomrsMetadataCollection.getIgcRepositoryHelper();
        OMRSRepositoryHelper omrsRepositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String omrsRelationshipName = omrsRelationshipDef.getName();
        Relationship relationship = new Relationship();
        try {
            InstanceType instanceType = igcomrsRepositoryConnector.getRepositoryHelper().getNewInstanceType(igcomrsRepositoryConnector.getRepositoryName(), (TypeDefSummary)omrsRelationshipDef);
            relationship.setType(instanceType);
        }
        catch (TypeErrorException e) {
            log.error("Unable to construct and set InstanceType -- skipping relationship: {}", (Object)omrsRelationshipName);
            RelationshipMapping.raiseRepositoryErrorException(IGCOMRSErrorCode.INVALID_INSTANCE, "getMappedRelationship", "getMappedRelationship", omrsRelationshipDef.getName());
        }
        IGCRelationshipGuid igcRelationshipGuid = RelationshipMapping.getRelationshipGUID(igcRepositoryHelper, relationshipMapping, proxyOne, proxyTwo, igcPropertyName, relationshipLevelRid, proxyOrderKnown);
        if (igcRelationshipGuid != null) {
            log.debug("Mapping relationship with GUID: {}", (Object)igcRelationshipGuid);
            relationship.setGUID(igcRelationshipGuid.toString());
            relationship.setMetadataCollectionId(igcomrsRepositoryConnector.getMetadataCollectionId());
            relationship.setStatus(InstanceStatus.ACTIVE);
            relationship.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
            String ridForEP1 = igcRelationshipGuid.getRid1();
            String ridForEP2 = igcRelationshipGuid.getRid2();
            EntityProxy ep1 = null;
            EntityProxy ep2 = null;
            if (relationshipLevelRid != null || ridForEP1.equals(proxyOne.getId()) && ridForEP2.equals(proxyTwo.getId())) {
                ep1 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, cache, proxyOne, userId, relationshipMapping.getProxyOneMapping().getIgcRidPrefix());
                ep2 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, cache, proxyTwo, userId, relationshipMapping.getProxyTwoMapping().getIgcRidPrefix());
            } else if (ridForEP2.equals(proxyOne.getId()) && ridForEP1.equals(proxyTwo.getId())) {
                ep1 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, cache, proxyTwo, userId, relationshipMapping.getProxyOneMapping().getIgcRidPrefix());
                ep2 = RelationshipMapping.getEntityProxyForObject(igcomrsRepositoryConnector, cache, proxyOne, userId, relationshipMapping.getProxyTwoMapping().getIgcRidPrefix());
            } else {
                log.error("Unable to determine both ends of the relationship {} from {} to {}", new Object[]{omrsRelationshipName, proxyOne.getId(), proxyTwo.getId()});
                String omrsEndOneProperty = omrsRelationshipDef.getEndDef1().getAttributeName();
                String omrsEndTwoProperty = omrsRelationshipDef.getEndDef2().getAttributeName();
                RelationshipMapping.raiseRepositoryErrorException(IGCOMRSErrorCode.INVALID_RELATIONSHIP_ENDS, "getMappedRelationship", "getMappedRelationship", repositoryName, omrsRelationshipName, omrsEndOneProperty, omrsEndTwoProperty);
            }
            if (ep1 != null && ep1.getUpdateTime() != null) {
                InstanceMapping.setupInstanceModDetails((InstanceAuditHeader)relationship, ep1.getCreatedBy(), ep1.getCreateTime(), ep1.getUpdatedBy(), ep1.getUpdateTime());
            } else if (ep2 != null && ep2.getUpdateTime() != null) {
                InstanceMapping.setupInstanceModDetails((InstanceAuditHeader)relationship, ep2.getCreatedBy(), ep2.getCreateTime(), ep2.getUpdatedBy(), ep2.getUpdateTime());
            }
            if (ep1 != null && ep2 != null) {
                relationship.setEntityOneProxy(ep1);
                relationship.setEntityTwoProxy(ep2);
                Map<String, TypeDefAttribute> omrsAttributeMap = igcomrsMetadataCollection.getTypeDefAttributesForType(omrsRelationshipName);
                InstanceProperties relationshipProperties = new InstanceProperties();
                for (String omrsPropertyName : relationshipMapping.getLiteralPropertyMappings()) {
                    Object value;
                    if (!omrsAttributeMap.containsKey(omrsPropertyName) || (value = relationshipMapping.getOmrsPropertyLiteralValue(omrsPropertyName)) == null) continue;
                    TypeDefAttribute typeDefAttribute = omrsAttributeMap.get(omrsPropertyName);
                    AttributeTypeDefCategory attributeTypeDefCategory = typeDefAttribute.getAttributeType().getCategory();
                    if (attributeTypeDefCategory == AttributeTypeDefCategory.PRIMITIVE) {
                        relationshipProperties = AttributeMapping.addPrimitivePropertyToInstance(omrsRepositoryHelper, repositoryName, relationshipProperties, typeDefAttribute, value, "getMappedRelationship");
                        continue;
                    }
                    relationshipProperties.setProperty(omrsPropertyName, (InstancePropertyValue)value);
                }
                relationship.setProperties(relationshipProperties);
            } else if (igcomrsRepositoryConnector.ignoreUnmappedInstances()) {
                log.warn("Unable to construct proxies for both ends of relationship -- skipping: {} between {} and {}", new Object[]{omrsRelationshipName, proxyOne.getType(), proxyTwo.getType()});
            } else {
                log.error("Unable to construct proxies for both ends of relationship -- skipping: {} between {} and {}", new Object[]{omrsRelationshipName, proxyOne.getType(), proxyTwo.getType()});
                RelationshipMapping.raiseRepositoryErrorException(IGCOMRSErrorCode.UNMAPPED_RELATIONSHIP_ENDS, "getMappedRelationship", omrsRelationshipName, proxyOne.getType(), proxyTwo.getType());
            }
        } else {
            log.error("Unable to construct relationship GUID -- skipping relationship: {}", (Object)omrsRelationshipName);
            String omrsEndOneProperty = omrsRelationshipDef.getEndDef1().getAttributeName();
            String omrsEndTwoProperty = omrsRelationshipDef.getEndDef2().getAttributeName();
            RelationshipMapping.raiseRepositoryErrorException(IGCOMRSErrorCode.INVALID_RELATIONSHIP_ENDS, "getMappedRelationship", "getMappedRelationship", repositoryName, omrsRelationshipName, omrsEndOneProperty, omrsEndTwoProperty);
        }
        return relationship;
    }

    private static void raiseRepositoryErrorException(IGCOMRSErrorCode errorCode, String methodName, String ... params) throws RepositoryErrorException {
        throw new RepositoryErrorException(errorCode.getMessageDefinition(params), RelationshipMapping.class.getName(), methodName);
    }

    public class RelationshipLevelProxyMapping {
        private String igcAssetType;
        private String igcRelationshipPropertyToEndOne;
        private String igcRelationshipPropertyToEndTwo;

        RelationshipLevelProxyMapping(String igcAssetType, String igcRelationshipPropertyToEndOne, String igcRelationshipPropertyToEndTwo) {
            this.igcAssetType = igcAssetType;
            this.igcRelationshipPropertyToEndOne = igcRelationshipPropertyToEndOne;
            this.igcRelationshipPropertyToEndTwo = igcRelationshipPropertyToEndTwo;
        }

        public String getIgcAssetType() {
            return this.igcAssetType;
        }

        public String getIgcRelationshipPropertyToEndOne() {
            return this.igcRelationshipPropertyToEndOne;
        }

        public String getIgcRelationshipPropertyToEndTwo() {
            return this.igcRelationshipPropertyToEndTwo;
        }
    }

    public class ProxyMapping {
        private String igcAssetType;
        private Set<String> igcRelationshipProperties;
        private String omrsRelationshipProperty;
        private String igcRidPrefix;
        private Set<String> excludeIgcAssetType;
        private Set<String> allAssetTypes;

        ProxyMapping(String igcAssetType, String igcRelationshipProperty, String omrsRelationshipProperty, String igcRidPrefix) {
            this.igcAssetType = igcAssetType;
            this.igcRelationshipProperties = new TreeSet<String>();
            if (igcRelationshipProperty != null) {
                this.igcRelationshipProperties.add(igcRelationshipProperty);
            }
            this.omrsRelationshipProperty = omrsRelationshipProperty;
            this.igcRidPrefix = igcRidPrefix;
            this.excludeIgcAssetType = new HashSet<String>();
            this.allAssetTypes = new TreeSet<String>();
            this.allAssetTypes.add(igcAssetType);
        }

        public List<String> getAllPossibleAssetTypes() {
            return new ArrayList<String>(this.allAssetTypes);
        }

        public List<String> getIgcRelationshipProperties() {
            return new ArrayList<String>(this.igcRelationshipProperties);
        }

        public List<String> getRealIgcRelationshipProperties() {
            ArrayList<String> realProperties = new ArrayList<String>();
            for (String property : this.getIgcRelationshipProperties()) {
                if (property.equals(RelationshipMapping.SELF_REFERENCE_SENTINEL)) continue;
                realProperties.add(property);
            }
            return realProperties;
        }

        void addAlternativeIgcRelationshipProperty(String igcRelationshipProperty) {
            if (igcRelationshipProperty != null) {
                this.igcRelationshipProperties.add(igcRelationshipProperty);
            } else {
                log.warn("Attempted to add null property to mapping -- IGC.");
            }
        }

        public String getIgcRidPrefix() {
            return this.igcRidPrefix;
        }

        boolean isSelfReferencing() {
            return this.igcRelationshipProperties.contains(RelationshipMapping.SELF_REFERENCE_SENTINEL);
        }

        void addAdditionalAssetType(String igcAssetType) {
            if (igcAssetType != null) {
                this.allAssetTypes.add(igcAssetType);
            } else {
                log.warn("Attempted to add null type to mapping -- IGC.");
            }
        }

        void addExcludedIgcAssetType(String igcAssetType) {
            if (igcAssetType != null) {
                this.excludeIgcAssetType.add(igcAssetType);
            } else {
                log.warn("Attempted to add null type to mapping -- IGC.");
            }
        }

        public boolean matchesAssetType(String igcAssetType) {
            String simplifiedType = IGCRestConstants.getAssetTypeForSearch((String)igcAssetType);
            return this.allAssetTypes.contains(simplifiedType) || this.igcAssetType.equals("main_object") && !this.excludeIgcAssetType.contains(simplifiedType) || RelationshipMapping.this.hasLinkingAsset() && simplifiedType.equals(RelationshipMapping.this.getLinkingAssetType());
        }

        public String toString() {
            return "igcAssetTypes=" + this.allAssetTypes + ", omrsRelationshipProperty=" + this.omrsRelationshipProperty + ", igcRidPrefix=" + this.igcRidPrefix + ", igcRelationshipProperties=" + this.igcRelationshipProperties;
        }
    }

    public static enum ContainedType {
        ONE,
        TWO,
        NONE;

    }

    public static enum OptimalStart {
        ONE,
        TWO,
        OPPOSITE,
        CUSTOM;

    }
}

