/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.AttributeMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeMappingStore {
    private static final Logger log = LoggerFactory.getLogger(AttributeMappingStore.class);
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private Map<String, AttributeTypeDef> omrsGuidToAttributeTypeDef = new HashMap<String, AttributeTypeDef>();
    private Map<String, String> omrsNameToGuid = new HashMap<String, String>();
    private Map<String, List<String>> omrsTypeDefCategoryToGuids = new HashMap<String, List<String>>();
    private Map<String, AttributeTypeDef> unimplementedAttributeTypeDefs = new HashMap<String, AttributeTypeDef>();

    public AttributeMappingStore(IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        this.igcomrsRepositoryConnector = igcomrsRepositoryConnector;
    }

    public boolean addMapping(AttributeTypeDef omrsTypeDef) {
        AttributeTypeDefCategory category = omrsTypeDef.getCategory();
        if (category.equals((Object)AttributeTypeDefCategory.COLLECTION) || category.equals((Object)AttributeTypeDefCategory.PRIMITIVE)) {
            String guid = omrsTypeDef.getGUID();
            this.omrsGuidToAttributeTypeDef.put(guid, omrsTypeDef);
            this.omrsNameToGuid.put(omrsTypeDef.getName(), guid);
            this.addGuidToCategory(category.getName(), guid);
            return true;
        }
        return false;
    }

    public boolean addMapping(AttributeTypeDef omrsTypeDef, Class<?> mappingClass) {
        AttributeMapping mapping = this.getAttributeMapper(mappingClass);
        if (mapping != null) {
            String guid = omrsTypeDef.getGUID();
            this.omrsGuidToAttributeTypeDef.put(guid, omrsTypeDef);
            this.omrsNameToGuid.put(omrsTypeDef.getName(), guid);
            this.addGuidToCategory(omrsTypeDef.getCategory().getName(), guid);
        }
        return mapping != null;
    }

    public void addUnimplementedAttributeTypeDef(AttributeTypeDef attributeTypeDef) {
        String guid = attributeTypeDef.getGUID();
        this.unimplementedAttributeTypeDefs.put(guid, attributeTypeDef);
    }

    private void addGuidToCategory(String categoryName, String guid) {
        if (!this.omrsTypeDefCategoryToGuids.containsKey(categoryName)) {
            this.omrsTypeDefCategoryToGuids.put(categoryName, new ArrayList());
        }
        this.omrsTypeDefCategoryToGuids.get(categoryName).add(guid);
    }

    public AttributeTypeDef getUnimplementedAttributeTypeDefByGUID(String guid) {
        return this.getUnimplementedAttributeTypeDefByGUID(guid, true);
    }

    public AttributeTypeDef getUnimplementedAttributeTypeDefByGUID(String guid, boolean logOnNotFound) {
        if (this.unimplementedAttributeTypeDefs.containsKey(guid)) {
            return this.unimplementedAttributeTypeDefs.get(guid);
        }
        if (logOnNotFound) {
            log.warn("Unable to find unimplemented OMRS AttributeTypeDef: {}", (Object)guid);
        }
        return null;
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String guid) {
        return this.getAttributeTypeDefByGUID(guid, true);
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String guid, boolean logOnNotFound) {
        if (this.omrsGuidToAttributeTypeDef.containsKey(guid)) {
            return this.omrsGuidToAttributeTypeDef.get(guid);
        }
        if (logOnNotFound) {
            log.warn("Unable to find OMRS AttributeTypeDef: {}", (Object)guid);
        }
        return null;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String name) {
        if (this.omrsNameToGuid.containsKey(name)) {
            String guid = this.omrsNameToGuid.get(name);
            return this.getAttributeTypeDefByGUID(guid);
        }
        log.warn("Unable to find OMRS AttributeTypeDef: {}", (Object)name);
        return null;
    }

    public List<AttributeTypeDef> getAttributeTypeDefsByCategory(AttributeTypeDefCategory category) {
        String categoryName = category.getName();
        ArrayList<AttributeTypeDef> results = new ArrayList<AttributeTypeDef>();
        if (this.omrsTypeDefCategoryToGuids.containsKey(categoryName)) {
            for (String guid : this.omrsTypeDefCategoryToGuids.get(categoryName)) {
                results.add(this.getAttributeTypeDefByGUID(guid));
            }
        } else {
            log.warn("Unable to find OMRS AttributeTypeDefCategory: {}", (Object)categoryName);
        }
        return results;
    }

    public List<AttributeTypeDef> getAllAttributeTypeDefs() {
        return new ArrayList<AttributeTypeDef>(this.omrsGuidToAttributeTypeDef.values());
    }

    private AttributeMapping getAttributeMapper(Class<?> mappingClass) {
        AttributeMapping attributeMapper = null;
        try {
            Method getInstance = mappingClass.getMethod("getInstance", IGCVersionEnum.class);
            attributeMapper = (AttributeMapping)getInstance.invoke(null, this.igcomrsRepositoryConnector.getIGCVersion());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to find or instantiate AttributeMapping class: {}", mappingClass, (Object)e);
        }
        return attributeMapper;
    }
}

