/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.stores.MappingStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationMappingStore
extends MappingStore {
    private static final Logger log = LoggerFactory.getLogger(ClassificationMappingStore.class);
    private Map<String, ClassificationMapping> omrsGuidToMapping = new HashMap<String, ClassificationMapping>();

    public ClassificationMappingStore(IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        super(igcomrsRepositoryConnector);
    }

    public boolean addMapping(TypeDef omrsTypeDef, Class<?> mappingClass) {
        ClassificationMapping mapping = this.getClassificationMapper(mappingClass);
        if (mapping != null) {
            String guid = omrsTypeDef.getGUID();
            this.addTypeDef(omrsTypeDef);
            this.omrsGuidToMapping.put(guid, mapping);
        }
        return mapping != null;
    }

    public ClassificationMapping getMappingByOmrsTypeGUID(String guid) {
        if (this.omrsGuidToMapping.containsKey(guid)) {
            return this.omrsGuidToMapping.get(guid);
        }
        log.warn("Unable to find mapping for OMRS type: {}", (Object)guid);
        return null;
    }

    public ClassificationMapping getMappingByOmrsTypeName(String name) {
        String guid = this.getGuidForName(name);
        if (guid == null) {
            log.warn("Unable to find mapping for OMRS type: {}", (Object)name);
            return null;
        }
        return this.getMappingByOmrsTypeGUID(guid);
    }

    public ClassificationMapping getMappingByTypes(String omrsClassificationType, String igcAssetType) {
        ClassificationMapping found = null;
        ClassificationMapping candidate = this.getMappingByOmrsTypeName(omrsClassificationType);
        String candidateIgcType = candidate.getIgcAssetType();
        Set<String> excludedIgcTypes = candidate.getExcludedIgcAssetTypes();
        if (!excludedIgcTypes.contains(igcAssetType)) {
            if (candidateIgcType.equals(igcAssetType) || candidateIgcType.equals("main_object")) {
                found = candidate;
            } else if (candidate.hasSubTypes()) {
                for (ClassificationMapping subMapping : candidate.getSubTypes()) {
                    candidateIgcType = candidate.getIgcAssetType();
                    if (!candidateIgcType.equals(igcAssetType) && !candidateIgcType.equals("main_object")) continue;
                    found = subMapping;
                    break;
                }
            }
        }
        return found;
    }

    private ClassificationMapping getClassificationMapper(Class<?> mappingClass) {
        ClassificationMapping classificationMapper = null;
        try {
            Method getInstance = mappingClass.getMethod("getInstance", IGCVersionEnum.class);
            classificationMapper = (ClassificationMapping)getInstance.invoke(null, this.igcomrsRepositoryConnector.getIGCVersion());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to find or instantiate ClassificationMapping class: {}", mappingClass, (Object)e);
        }
        return classificationMapper;
    }
}

