/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.MainObject;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Term;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.GovernanceClassificationStatusMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfidentialityMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(ConfidentialityMapper.class);

    public static ConfidentialityMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected ConfidentialityMapper() {
        super("main_object", "assigned_to_terms", "Referenceable", "Confidentiality");
        this.addLiteralPropertyMapping("status", GovernanceClassificationStatusMapper.getInstance(null).getEnumMappingByIgcValue(""));
        this.addLiteralPropertyMapping("confidence", 100);
        this.addLiteralPropertyMapping("steward", null);
        this.addLiteralPropertyMapping("source", null);
        this.addLiteralPropertyMapping("notes", null);
        this.addLiteralPropertyMapping("confidentialityLevel", null);
        this.addLiteralPropertyMapping("level", null);
        this.addMappedOmrsProperty("levelIdentifier");
        this.addExcludedIgcAssetType("connector");
        this.addExcludedIgcAssetType("data_connection");
        this.addExcludedIgcAssetType("group");
        this.addExcludedIgcAssetType("information_governance_policy");
        this.addExcludedIgcAssetType("label");
        this.addExcludedIgcAssetType("user");
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, ObjectCache cache, Reference fromIgcObject, String userId) throws RepositoryErrorException {
        ItemList assignedToTerms;
        String methodName = "addMappedOMRSClassification";
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        if (fromIgcObject instanceof MainObject && (assignedToTerms = ((MainObject)fromIgcObject).getAssignedToTerms()) != null) {
            try {
                List allAssignedTerms = igcRestClient.getAllPages("assigned_to_terms", assignedToTerms);
                for (Term assignedTerm : allAssignedTerms) {
                    Identity termIdentity = assignedTerm.getIdentity(igcRestClient, cache);
                    Identity catIdentity = termIdentity.getParentIdentity();
                    if (!catIdentity.toString().endsWith("Confidentiality")) continue;
                    InstanceProperties classificationProperties = new InstanceProperties();
                    String confidentialityName = assignedTerm.getName();
                    int spaceIndex = confidentialityName.indexOf(" ");
                    if (spaceIndex > 0) {
                        String level = confidentialityName.substring(0, spaceIndex);
                        int parsedLevel = Integer.parseInt(level);
                        classificationProperties = igcomrsRepositoryConnector.getRepositoryHelper().addIntPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), classificationProperties, "levelIdentifier", parsedLevel, "addMappedOMRSClassification");
                        Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, classificationProperties, fromIgcObject, userId);
                        classifications.add(classification);
                        continue;
                    }
                    log.error("Unable to detect a level in the Confidentiality classification: {}", (Object)confidentialityName);
                }
            }
            catch (NumberFormatException | IGCException e) {
                ConfidentialityMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "addMappedOMRSClassification", (Exception)e, new String[0]);
            }
        }
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, SearchProperties matchProperties) throws FunctionNotSupportedException {
        IGCSearchConditionSet byProperties;
        String methodName = "getIGCSearchCriteria";
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("assigned_to_terms.parent_category.name", "=", "Confidentiality");
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        if (matchProperties != null && (byProperties = this.getConditionsForProperties(matchProperties, repositoryHelper, repositoryName, "getIGCSearchCriteria")).size() > 0) {
            igcSearchConditionSet.addNestedConditionSet(byProperties);
            igcSearchConditionSet.setMatchAnyCondition(false);
        }
        return igcSearchConditionSet;
    }

    private IGCSearchConditionSet getConditionsForProperties(SearchProperties matchProperties, OMRSRepositoryHelper repositoryHelper, String repositoryName, String methodName) throws FunctionNotSupportedException {
        IGCSearchConditionSet set = new IGCSearchConditionSet();
        List propertyConditions = matchProperties.getConditions();
        block14: for (PropertyCondition condition : propertyConditions) {
            SearchProperties nestedProperties = condition.getNestedConditions();
            if (nestedProperties != null) {
                IGCSearchConditionSet nestedSet = this.getConditionsForProperties(nestedProperties, repositoryHelper, repositoryName, methodName);
                IGCRepositoryHelper.setConditionsFromMatchCriteria(nestedSet, nestedProperties.getMatchCriteria());
                set.addNestedConditionSet(nestedSet);
                continue;
            }
            String propertyName = condition.getProperty();
            PropertyComparisonOperator operator = condition.getOperator();
            InstancePropertyValue value = condition.getValue();
            switch (propertyName) {
                case "status": {
                    if (value instanceof EnumPropertyValue) {
                        EnumPropertyValue enumValue = (EnumPropertyValue)value;
                        if (enumValue.getOrdinal() == 99) continue block14;
                        set.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                        break;
                    }
                    if (value == null) {
                        if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) continue block14;
                        set.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                        break;
                    }
                    throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_ENUMERATION.getMessageDefinition(propertyName), this.getClass().getName(), methodName);
                }
                case "confidence": {
                    Integer level;
                    PrimitivePropertyValue levelValue;
                    if (value instanceof PrimitivePropertyValue) {
                        levelValue = (PrimitivePropertyValue)value;
                        if (levelValue.getPrimitiveDefCategory().equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT)) {
                            level = (Integer)levelValue.getPrimitiveValue();
                            boolean includeResults = level == null && operator.equals((Object)PropertyComparisonOperator.NOT_NULL) || level != null && (level == 100 && (operator.equals((Object)PropertyComparisonOperator.EQ) || operator.equals((Object)PropertyComparisonOperator.GTE) || operator.equals((Object)PropertyComparisonOperator.LTE)) || level < 100 && (operator.equals((Object)PropertyComparisonOperator.GT) || operator.equals((Object)PropertyComparisonOperator.GTE)) || level > 100 && (operator.equals((Object)PropertyComparisonOperator.LT) || operator.equals((Object)PropertyComparisonOperator.LTE)));
                            if (includeResults) continue block14;
                            set.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                            break;
                        }
                        throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_PRIMITIVE.getMessageDefinition(propertyName, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName()), this.getClass().getName(), methodName);
                    }
                    throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_PRIMITIVE.getMessageDefinition(propertyName, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName()), this.getClass().getName(), methodName);
                }
                case "steward": 
                case "source": 
                case "notes": {
                    if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) continue block14;
                    set.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                    break;
                }
                case "levelIdentifier": {
                    Integer level;
                    PrimitivePropertyValue levelValue;
                    if (value instanceof PrimitivePropertyValue) {
                        levelValue = (PrimitivePropertyValue)value;
                        if (levelValue.getPrimitiveDefCategory().equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT)) {
                            level = (Integer)levelValue.getPrimitiveValue();
                            String levelAsString = level.toString() + " ";
                            IGCSearchCondition propertyCondition = new IGCSearchCondition("assigned_to_terms.name", "like {0}%", levelAsString);
                            set.addCondition(propertyCondition);
                            break;
                        }
                        throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_PRIMITIVE.getMessageDefinition(propertyName, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName()), this.getClass().getName(), methodName);
                    }
                    throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_PRIMITIVE.getMessageDefinition(propertyName, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName()), this.getClass().getName(), methodName);
                }
                default: {
                    set.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                }
            }
        }
        IGCRepositoryHelper.setConditionsFromMatchCriteria(set, matchProperties.getMatchCriteria());
        return set;
    }

    private static class Singleton {
        private static final ConfidentialityMapper INSTANCE = new ConfidentialityMapper();

        private Singleton() {
        }
    }
}

